//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armappplatform_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/appplatform/armappplatform/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/appplatform/resource-manager/Microsoft.AppPlatform/preview/2023-01-01-preview/examples/Apps_Get.json
func ExampleAppsClient_Get_appsGet() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappplatform.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAppsClient().Get(ctx, "myResourceGroup", "myservice", "myapp", &armappplatform.AppsClientGetOptions{SyncStatus: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AppResource = armappplatform.AppResource{
	// 	Name: to.Ptr("myapp"),
	// 	Type: to.Ptr("Microsoft.AppPlatform/Spring/apps"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/apps/myapp"),
	// 	SystemData: &armappplatform.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-11T03:16:03.944Z"); return t}()),
	// 		CreatedBy: to.Ptr("sample-user"),
	// 		CreatedByType: to.Ptr(armappplatform.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-11T03:17:03.944Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("sample-user"),
	// 		LastModifiedByType: to.Ptr(armappplatform.LastModifiedByTypeUser),
	// 	},
	// 	Identity: &armappplatform.ManagedIdentityProperties{
	// 		Type: to.Ptr(armappplatform.ManagedIdentityTypeSystemAssignedUserAssigned),
	// 		PrincipalID: to.Ptr("principalid"),
	// 		TenantID: to.Ptr("tenantid"),
	// 		UserAssignedIdentities: map[string]*armappplatform.UserAssignedManagedIdentity{
	// 			"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/samplegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1": &armappplatform.UserAssignedManagedIdentity{
	// 				ClientID: to.Ptr("clientId1"),
	// 				PrincipalID: to.Ptr("principalId1"),
	// 			},
	// 			"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/samplegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id2": &armappplatform.UserAssignedManagedIdentity{
	// 				ClientID: to.Ptr("clientId2"),
	// 				PrincipalID: to.Ptr("principalId2"),
	// 			},
	// 		},
	// 	},
	// 	Location: to.Ptr("eastus"),
	// 	Properties: &armappplatform.AppResourceProperties{
	// 		CustomPersistentDisks: []*armappplatform.CustomPersistentDiskResource{
	// 			{
	// 				CustomPersistentDiskProperties: &armappplatform.AzureFileVolume{
	// 					Type: to.Ptr(armappplatform.TypeAzureFileVolume),
	// 					MountOptions: []*string{
	// 						to.Ptr("uid=0"),
	// 						to.Ptr("gid=0"),
	// 						to.Ptr("dir_mode=0777"),
	// 						to.Ptr("file_mode=0777")},
	// 						MountPath: to.Ptr("/mypath1/mypath2"),
	// 						ShareName: to.Ptr("myFileShare"),
	// 					},
	// 					StorageID: to.Ptr("myASCStorageID"),
	// 			}},
	// 			EnableEndToEndTLS: to.Ptr(false),
	// 			Fqdn: to.Ptr("myapp.mydomain.com"),
	// 			HTTPSOnly: to.Ptr(false),
	// 			LoadedCertificates: []*armappplatform.LoadedCertificate{
	// 				{
	// 					LoadTrustStore: to.Ptr(false),
	// 					ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/certificates/mycert1"),
	// 				},
	// 				{
	// 					LoadTrustStore: to.Ptr(true),
	// 					ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/certificates/mycert2"),
	// 			}},
	// 			PersistentDisk: &armappplatform.PersistentDisk{
	// 				MountPath: to.Ptr("/mypersistentdisk"),
	// 				SizeInGB: to.Ptr[int32](2),
	// 				UsedInGB: to.Ptr[int32](1),
	// 			},
	// 			ProvisioningState: to.Ptr(armappplatform.AppResourceProvisioningStateSucceeded),
	// 			Public: to.Ptr(true),
	// 			TemporaryDisk: &armappplatform.TemporaryDisk{
	// 				MountPath: to.Ptr("/mytemporarydisk"),
	// 				SizeInGB: to.Ptr[int32](2),
	// 			},
	// 			URL: to.Ptr("myapp.myservice.azuremicroservices.io"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/appplatform/resource-manager/Microsoft.AppPlatform/preview/2023-01-01-preview/examples/Apps_Get_VNetInjection.json
func ExampleAppsClient_Get_appsGetVNetInjection() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappplatform.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAppsClient().Get(ctx, "myResourceGroup", "myservice", "myapp", &armappplatform.AppsClientGetOptions{SyncStatus: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AppResource = armappplatform.AppResource{
	// 	Name: to.Ptr("myapp"),
	// 	Type: to.Ptr("Microsoft.AppPlatform/Spring/apps"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/apps/myapp"),
	// 	SystemData: &armappplatform.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-11T03:16:03.944Z"); return t}()),
	// 		CreatedBy: to.Ptr("sample-user"),
	// 		CreatedByType: to.Ptr(armappplatform.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-11T03:17:03.944Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("sample-user"),
	// 		LastModifiedByType: to.Ptr(armappplatform.LastModifiedByTypeUser),
	// 	},
	// 	Identity: &armappplatform.ManagedIdentityProperties{
	// 		Type: to.Ptr(armappplatform.ManagedIdentityTypeSystemAssignedUserAssigned),
	// 		PrincipalID: to.Ptr("principalid"),
	// 		TenantID: to.Ptr("tenantid"),
	// 		UserAssignedIdentities: map[string]*armappplatform.UserAssignedManagedIdentity{
	// 			"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/samplegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1": &armappplatform.UserAssignedManagedIdentity{
	// 				ClientID: to.Ptr("clientId1"),
	// 				PrincipalID: to.Ptr("principalId1"),
	// 			},
	// 			"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/samplegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id2": &armappplatform.UserAssignedManagedIdentity{
	// 				ClientID: to.Ptr("clientId2"),
	// 				PrincipalID: to.Ptr("principalId2"),
	// 			},
	// 		},
	// 	},
	// 	Location: to.Ptr("eastus"),
	// 	Properties: &armappplatform.AppResourceProperties{
	// 		CustomPersistentDisks: []*armappplatform.CustomPersistentDiskResource{
	// 			{
	// 				CustomPersistentDiskProperties: &armappplatform.AzureFileVolume{
	// 					Type: to.Ptr(armappplatform.TypeAzureFileVolume),
	// 					MountOptions: []*string{
	// 						to.Ptr("uid=0"),
	// 						to.Ptr("gid=0"),
	// 						to.Ptr("dir_mode=0777"),
	// 						to.Ptr("file_mode=0777")},
	// 						MountPath: to.Ptr("/mypath1/mypath2"),
	// 						ShareName: to.Ptr("myFileShare"),
	// 					},
	// 					StorageID: to.Ptr("myASCStorageID"),
	// 			}},
	// 			EnableEndToEndTLS: to.Ptr(false),
	// 			Fqdn: to.Ptr("myapp.private.mydomain.com"),
	// 			HTTPSOnly: to.Ptr(false),
	// 			LoadedCertificates: []*armappplatform.LoadedCertificate{
	// 				{
	// 					LoadTrustStore: to.Ptr(false),
	// 					ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/certificates/mycert1"),
	// 				},
	// 				{
	// 					LoadTrustStore: to.Ptr(true),
	// 					ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/certificates/mycert2"),
	// 			}},
	// 			PersistentDisk: &armappplatform.PersistentDisk{
	// 				MountPath: to.Ptr("/mypersistentdisk"),
	// 				SizeInGB: to.Ptr[int32](2),
	// 				UsedInGB: to.Ptr[int32](1),
	// 			},
	// 			ProvisioningState: to.Ptr(armappplatform.AppResourceProvisioningStateSucceeded),
	// 			Public: to.Ptr(true),
	// 			TemporaryDisk: &armappplatform.TemporaryDisk{
	// 				MountPath: to.Ptr("/mytemporarydisk"),
	// 				SizeInGB: to.Ptr[int32](2),
	// 			},
	// 			URL: to.Ptr("myapp.myservice.private.azuremicroservices.io"),
	// 			VnetAddons: &armappplatform.AppVNetAddons{
	// 				PublicEndpoint: to.Ptr(true),
	// 				PublicEndpointURL: to.Ptr("myapp.myservice.azuremicroservices.io"),
	// 			},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/appplatform/resource-manager/Microsoft.AppPlatform/preview/2023-01-01-preview/examples/Apps_CreateOrUpdate.json
func ExampleAppsClient_BeginCreateOrUpdate_appsCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappplatform.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAppsClient().BeginCreateOrUpdate(ctx, "myResourceGroup", "myservice", "myapp", armappplatform.AppResource{
		Identity: &armappplatform.ManagedIdentityProperties{
			Type: to.Ptr(armappplatform.ManagedIdentityTypeSystemAssignedUserAssigned),
			UserAssignedIdentities: map[string]*armappplatform.UserAssignedManagedIdentity{
				"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/samplegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1": {},
				"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/samplegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id2": {},
			},
		},
		Location: to.Ptr("eastus"),
		Properties: &armappplatform.AppResourceProperties{
			AddonConfigs: map[string]any{
				"ApplicationConfigurationService": map[string]any{
					"resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/configurationServices/myacs",
				},
				"ServiceRegistry": map[string]any{
					"resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/serviceRegistries/myServiceRegistry",
				},
			},
			CustomPersistentDisks: []*armappplatform.CustomPersistentDiskResource{
				{
					CustomPersistentDiskProperties: &armappplatform.AzureFileVolume{
						Type:          to.Ptr(armappplatform.TypeAzureFileVolume),
						EnableSubPath: to.Ptr(true),
						MountOptions: []*string{
							to.Ptr("uid=0"),
							to.Ptr("gid=0"),
							to.Ptr("dir_mode=0777"),
							to.Ptr("file_mode=0777")},
						MountPath: to.Ptr("/mypath1/mypath2"),
						ShareName: to.Ptr("myFileShare"),
					},
					StorageID: to.Ptr("myASCStorageID"),
				}},
			EnableEndToEndTLS: to.Ptr(false),
			HTTPSOnly:         to.Ptr(false),
			LoadedCertificates: []*armappplatform.LoadedCertificate{
				{
					LoadTrustStore: to.Ptr(false),
					ResourceID:     to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/certificates/mycert1"),
				},
				{
					LoadTrustStore: to.Ptr(true),
					ResourceID:     to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/certificates/mycert2"),
				}},
			PersistentDisk: &armappplatform.PersistentDisk{
				MountPath: to.Ptr("/mypersistentdisk"),
				SizeInGB:  to.Ptr[int32](2),
			},
			Public: to.Ptr(true),
			TemporaryDisk: &armappplatform.TemporaryDisk{
				MountPath: to.Ptr("/mytemporarydisk"),
				SizeInGB:  to.Ptr[int32](2),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AppResource = armappplatform.AppResource{
	// 	Name: to.Ptr("myapp"),
	// 	Type: to.Ptr("Microsoft.AppPlatform/Spring/apps"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/apps/myapp"),
	// 	SystemData: &armappplatform.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-11T03:16:03.944Z"); return t}()),
	// 		CreatedBy: to.Ptr("sample-user"),
	// 		CreatedByType: to.Ptr(armappplatform.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-11T03:17:03.944Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("sample-user"),
	// 		LastModifiedByType: to.Ptr(armappplatform.LastModifiedByTypeUser),
	// 	},
	// 	Identity: &armappplatform.ManagedIdentityProperties{
	// 		Type: to.Ptr(armappplatform.ManagedIdentityTypeSystemAssignedUserAssigned),
	// 		PrincipalID: to.Ptr("principalid"),
	// 		TenantID: to.Ptr("tenantid"),
	// 		UserAssignedIdentities: map[string]*armappplatform.UserAssignedManagedIdentity{
	// 			"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/samplegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1": &armappplatform.UserAssignedManagedIdentity{
	// 				ClientID: to.Ptr("clientId1"),
	// 				PrincipalID: to.Ptr("principalId1"),
	// 			},
	// 			"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/samplegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id2": &armappplatform.UserAssignedManagedIdentity{
	// 				ClientID: to.Ptr("clientId2"),
	// 				PrincipalID: to.Ptr("principalId2"),
	// 			},
	// 		},
	// 	},
	// 	Location: to.Ptr("eastus"),
	// 	Properties: &armappplatform.AppResourceProperties{
	// 		AddonConfigs: map[string]any{
	// 			"ApplicationConfigurationService": map[string]any{
	// 				"resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/configurationServices/myacs",
	// 			},
	// 			"ServiceRegistry": map[string]any{
	// 				"resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/serviceRegistries/myServiceRegistry",
	// 			},
	// 		},
	// 		CustomPersistentDisks: []*armappplatform.CustomPersistentDiskResource{
	// 			{
	// 				CustomPersistentDiskProperties: &armappplatform.AzureFileVolume{
	// 					Type: to.Ptr(armappplatform.TypeAzureFileVolume),
	// 					EnableSubPath: to.Ptr(true),
	// 					MountOptions: []*string{
	// 						to.Ptr("uid=0"),
	// 						to.Ptr("gid=0"),
	// 						to.Ptr("dir_mode=0777"),
	// 						to.Ptr("file_mode=0777")},
	// 						MountPath: to.Ptr("/mypath1/mypath2"),
	// 						ShareName: to.Ptr("myFileShare"),
	// 					},
	// 					StorageID: to.Ptr("myASCStorageID"),
	// 			}},
	// 			EnableEndToEndTLS: to.Ptr(false),
	// 			Fqdn: to.Ptr("myapp.mydomain.com"),
	// 			HTTPSOnly: to.Ptr(false),
	// 			PersistentDisk: &armappplatform.PersistentDisk{
	// 				MountPath: to.Ptr("/mypersistentdisk"),
	// 				SizeInGB: to.Ptr[int32](2),
	// 				UsedInGB: to.Ptr[int32](1),
	// 			},
	// 			ProvisioningState: to.Ptr(armappplatform.AppResourceProvisioningStateSucceeded),
	// 			Public: to.Ptr(true),
	// 			TemporaryDisk: &armappplatform.TemporaryDisk{
	// 				MountPath: to.Ptr("/mytemporarydisk"),
	// 				SizeInGB: to.Ptr[int32](2),
	// 			},
	// 			URL: to.Ptr("myapp.myservice.azuremicroservices.io"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/appplatform/resource-manager/Microsoft.AppPlatform/preview/2023-01-01-preview/examples/Apps_CreateOrUpdate_VNetInjection.json
func ExampleAppsClient_BeginCreateOrUpdate_appsCreateOrUpdateVNetInjection() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappplatform.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAppsClient().BeginCreateOrUpdate(ctx, "myResourceGroup", "myservice", "myapp", armappplatform.AppResource{
		Identity: &armappplatform.ManagedIdentityProperties{
			Type: to.Ptr(armappplatform.ManagedIdentityTypeSystemAssignedUserAssigned),
			UserAssignedIdentities: map[string]*armappplatform.UserAssignedManagedIdentity{
				"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/samplegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1": {},
				"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/samplegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id2": {},
			},
		},
		Location: to.Ptr("eastus"),
		Properties: &armappplatform.AppResourceProperties{
			AddonConfigs: map[string]any{
				"ApplicationConfigurationService": map[string]any{
					"resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/configurationServices/myacs",
				},
				"ServiceRegistry": map[string]any{
					"resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/serviceRegistries/myServiceRegistry",
				},
			},
			CustomPersistentDisks: []*armappplatform.CustomPersistentDiskResource{
				{
					CustomPersistentDiskProperties: &armappplatform.AzureFileVolume{
						Type: to.Ptr(armappplatform.TypeAzureFileVolume),
						MountOptions: []*string{
							to.Ptr("uid=0"),
							to.Ptr("gid=0"),
							to.Ptr("dir_mode=0777"),
							to.Ptr("file_mode=0777")},
						MountPath: to.Ptr("/mypath1/mypath2"),
						ShareName: to.Ptr("myFileShare"),
					},
					StorageID: to.Ptr("myASCStorageID"),
				}},
			EnableEndToEndTLS: to.Ptr(false),
			HTTPSOnly:         to.Ptr(false),
			LoadedCertificates: []*armappplatform.LoadedCertificate{
				{
					LoadTrustStore: to.Ptr(false),
					ResourceID:     to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/certificates/mycert1"),
				},
				{
					LoadTrustStore: to.Ptr(true),
					ResourceID:     to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/certificates/mycert2"),
				}},
			PersistentDisk: &armappplatform.PersistentDisk{
				MountPath: to.Ptr("/mypersistentdisk"),
				SizeInGB:  to.Ptr[int32](2),
			},
			Public: to.Ptr(true),
			TemporaryDisk: &armappplatform.TemporaryDisk{
				MountPath: to.Ptr("/mytemporarydisk"),
				SizeInGB:  to.Ptr[int32](2),
			},
			VnetAddons: &armappplatform.AppVNetAddons{
				PublicEndpoint: to.Ptr(true),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AppResource = armappplatform.AppResource{
	// 	Name: to.Ptr("myapp"),
	// 	Type: to.Ptr("Microsoft.AppPlatform/Spring/apps"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/apps/myapp"),
	// 	SystemData: &armappplatform.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-11T03:16:03.944Z"); return t}()),
	// 		CreatedBy: to.Ptr("sample-user"),
	// 		CreatedByType: to.Ptr(armappplatform.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-11T03:17:03.944Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("sample-user"),
	// 		LastModifiedByType: to.Ptr(armappplatform.LastModifiedByTypeUser),
	// 	},
	// 	Identity: &armappplatform.ManagedIdentityProperties{
	// 		Type: to.Ptr(armappplatform.ManagedIdentityTypeSystemAssignedUserAssigned),
	// 		PrincipalID: to.Ptr("principalid"),
	// 		TenantID: to.Ptr("tenantid"),
	// 		UserAssignedIdentities: map[string]*armappplatform.UserAssignedManagedIdentity{
	// 			"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/samplegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1": &armappplatform.UserAssignedManagedIdentity{
	// 				ClientID: to.Ptr("clientId1"),
	// 				PrincipalID: to.Ptr("principalId1"),
	// 			},
	// 			"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/samplegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id2": &armappplatform.UserAssignedManagedIdentity{
	// 				ClientID: to.Ptr("clientId2"),
	// 				PrincipalID: to.Ptr("principalId2"),
	// 			},
	// 		},
	// 	},
	// 	Location: to.Ptr("eastus"),
	// 	Properties: &armappplatform.AppResourceProperties{
	// 		AddonConfigs: map[string]any{
	// 			"ApplicationConfigurationService": map[string]any{
	// 				"resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/configurationServices/myacs",
	// 			},
	// 			"ServiceRegistry": map[string]any{
	// 				"resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/serviceRegistries/myServiceRegistry",
	// 			},
	// 		},
	// 		CustomPersistentDisks: []*armappplatform.CustomPersistentDiskResource{
	// 			{
	// 				CustomPersistentDiskProperties: &armappplatform.AzureFileVolume{
	// 					Type: to.Ptr(armappplatform.TypeAzureFileVolume),
	// 					MountOptions: []*string{
	// 						to.Ptr("uid=0"),
	// 						to.Ptr("gid=0"),
	// 						to.Ptr("dir_mode=0777"),
	// 						to.Ptr("file_mode=0777")},
	// 						MountPath: to.Ptr("/mypath1/mypath2"),
	// 						ShareName: to.Ptr("myFileShare"),
	// 					},
	// 					StorageID: to.Ptr("myASCStorageID"),
	// 			}},
	// 			EnableEndToEndTLS: to.Ptr(false),
	// 			Fqdn: to.Ptr("myapp.private.mydomain.com"),
	// 			HTTPSOnly: to.Ptr(false),
	// 			PersistentDisk: &armappplatform.PersistentDisk{
	// 				MountPath: to.Ptr("/mypersistentdisk"),
	// 				SizeInGB: to.Ptr[int32](2),
	// 				UsedInGB: to.Ptr[int32](1),
	// 			},
	// 			ProvisioningState: to.Ptr(armappplatform.AppResourceProvisioningStateSucceeded),
	// 			Public: to.Ptr(true),
	// 			TemporaryDisk: &armappplatform.TemporaryDisk{
	// 				MountPath: to.Ptr("/mytemporarydisk"),
	// 				SizeInGB: to.Ptr[int32](2),
	// 			},
	// 			URL: to.Ptr("myapp.myservice.private.azuremicroservices.io"),
	// 			VnetAddons: &armappplatform.AppVNetAddons{
	// 				PublicEndpoint: to.Ptr(true),
	// 				PublicEndpointURL: to.Ptr("myapp.myservice.azuremicroservices.io"),
	// 			},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/appplatform/resource-manager/Microsoft.AppPlatform/preview/2023-01-01-preview/examples/Apps_Delete.json
func ExampleAppsClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappplatform.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAppsClient().BeginDelete(ctx, "myResourceGroup", "myservice", "myapp", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/appplatform/resource-manager/Microsoft.AppPlatform/preview/2023-01-01-preview/examples/Apps_Update.json
func ExampleAppsClient_BeginUpdate_appsUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappplatform.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAppsClient().BeginUpdate(ctx, "myResourceGroup", "myservice", "myapp", armappplatform.AppResource{
		Identity: &armappplatform.ManagedIdentityProperties{
			Type: to.Ptr(armappplatform.ManagedIdentityTypeSystemAssignedUserAssigned),
			UserAssignedIdentities: map[string]*armappplatform.UserAssignedManagedIdentity{
				"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/samplegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1": {},
				"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/samplegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id2": {},
			},
		},
		Location: to.Ptr("eastus"),
		Properties: &armappplatform.AppResourceProperties{
			CustomPersistentDisks: []*armappplatform.CustomPersistentDiskResource{
				{
					CustomPersistentDiskProperties: &armappplatform.AzureFileVolume{
						Type:         to.Ptr(armappplatform.TypeAzureFileVolume),
						MountOptions: []*string{},
						MountPath:    to.Ptr("/mypath1/mypath2"),
						ShareName:    to.Ptr("myFileShare"),
					},
					StorageID: to.Ptr("myASCStorageID"),
				}},
			EnableEndToEndTLS: to.Ptr(false),
			HTTPSOnly:         to.Ptr(false),
			PersistentDisk: &armappplatform.PersistentDisk{
				MountPath: to.Ptr("/mypersistentdisk"),
				SizeInGB:  to.Ptr[int32](2),
			},
			Public: to.Ptr(true),
			TemporaryDisk: &armappplatform.TemporaryDisk{
				MountPath: to.Ptr("/mytemporarydisk"),
				SizeInGB:  to.Ptr[int32](2),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AppResource = armappplatform.AppResource{
	// 	Name: to.Ptr("myapp"),
	// 	Type: to.Ptr("Microsoft.AppPlatform/Spring/apps"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/apps/myapp"),
	// 	SystemData: &armappplatform.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-11T03:16:03.944Z"); return t}()),
	// 		CreatedBy: to.Ptr("sample-user"),
	// 		CreatedByType: to.Ptr(armappplatform.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-11T03:17:03.944Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("sample-user"),
	// 		LastModifiedByType: to.Ptr(armappplatform.LastModifiedByTypeUser),
	// 	},
	// 	Identity: &armappplatform.ManagedIdentityProperties{
	// 		Type: to.Ptr(armappplatform.ManagedIdentityTypeSystemAssignedUserAssigned),
	// 		PrincipalID: to.Ptr("principalid"),
	// 		TenantID: to.Ptr("tenantid"),
	// 		UserAssignedIdentities: map[string]*armappplatform.UserAssignedManagedIdentity{
	// 			"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/samplegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1": &armappplatform.UserAssignedManagedIdentity{
	// 				ClientID: to.Ptr("clientId1"),
	// 				PrincipalID: to.Ptr("principalId1"),
	// 			},
	// 			"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/samplegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id2": &armappplatform.UserAssignedManagedIdentity{
	// 				ClientID: to.Ptr("clientId2"),
	// 				PrincipalID: to.Ptr("principalId2"),
	// 			},
	// 		},
	// 	},
	// 	Location: to.Ptr("eastus"),
	// 	Properties: &armappplatform.AppResourceProperties{
	// 		CustomPersistentDisks: []*armappplatform.CustomPersistentDiskResource{
	// 			{
	// 				CustomPersistentDiskProperties: &armappplatform.AzureFileVolume{
	// 					Type: to.Ptr(armappplatform.TypeAzureFileVolume),
	// 					MountOptions: []*string{
	// 					},
	// 					MountPath: to.Ptr("/mypath1/mypath2"),
	// 					ShareName: to.Ptr("myFileShare"),
	// 				},
	// 				StorageID: to.Ptr("myASCStorageID"),
	// 		}},
	// 		EnableEndToEndTLS: to.Ptr(false),
	// 		Fqdn: to.Ptr("myapp.mydomain.com"),
	// 		HTTPSOnly: to.Ptr(false),
	// 		PersistentDisk: &armappplatform.PersistentDisk{
	// 			MountPath: to.Ptr("/mypersistentdisk"),
	// 			SizeInGB: to.Ptr[int32](2),
	// 			UsedInGB: to.Ptr[int32](1),
	// 		},
	// 		ProvisioningState: to.Ptr(armappplatform.AppResourceProvisioningStateSucceeded),
	// 		Public: to.Ptr(true),
	// 		TemporaryDisk: &armappplatform.TemporaryDisk{
	// 			MountPath: to.Ptr("/mytemporarydisk"),
	// 			SizeInGB: to.Ptr[int32](2),
	// 		},
	// 		URL: to.Ptr("myapp.myservice.azuremicroservices.io"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/appplatform/resource-manager/Microsoft.AppPlatform/preview/2023-01-01-preview/examples/Apps_Update_VNetInjection.json
func ExampleAppsClient_BeginUpdate_appsUpdateVNetInjection() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappplatform.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAppsClient().BeginUpdate(ctx, "myResourceGroup", "myservice", "myapp", armappplatform.AppResource{
		Identity: &armappplatform.ManagedIdentityProperties{
			Type: to.Ptr(armappplatform.ManagedIdentityTypeSystemAssignedUserAssigned),
			UserAssignedIdentities: map[string]*armappplatform.UserAssignedManagedIdentity{
				"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/samplegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1": {},
				"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/samplegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id2": {},
			},
		},
		Location: to.Ptr("eastus"),
		Properties: &armappplatform.AppResourceProperties{
			CustomPersistentDisks: []*armappplatform.CustomPersistentDiskResource{
				{
					CustomPersistentDiskProperties: &armappplatform.AzureFileVolume{
						Type:         to.Ptr(armappplatform.TypeAzureFileVolume),
						MountOptions: []*string{},
						MountPath:    to.Ptr("/mypath1/mypath2"),
						ShareName:    to.Ptr("myFileShare"),
					},
					StorageID: to.Ptr("myASCStorageID"),
				}},
			EnableEndToEndTLS: to.Ptr(false),
			HTTPSOnly:         to.Ptr(false),
			PersistentDisk: &armappplatform.PersistentDisk{
				MountPath: to.Ptr("/mypersistentdisk"),
				SizeInGB:  to.Ptr[int32](2),
			},
			Public: to.Ptr(true),
			TemporaryDisk: &armappplatform.TemporaryDisk{
				MountPath: to.Ptr("/mytemporarydisk"),
				SizeInGB:  to.Ptr[int32](2),
			},
			VnetAddons: &armappplatform.AppVNetAddons{
				PublicEndpoint: to.Ptr(true),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AppResource = armappplatform.AppResource{
	// 	Name: to.Ptr("myapp"),
	// 	Type: to.Ptr("Microsoft.AppPlatform/Spring/apps"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/apps/myapp"),
	// 	SystemData: &armappplatform.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-11T03:16:03.944Z"); return t}()),
	// 		CreatedBy: to.Ptr("sample-user"),
	// 		CreatedByType: to.Ptr(armappplatform.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-11T03:17:03.944Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("sample-user"),
	// 		LastModifiedByType: to.Ptr(armappplatform.LastModifiedByTypeUser),
	// 	},
	// 	Identity: &armappplatform.ManagedIdentityProperties{
	// 		Type: to.Ptr(armappplatform.ManagedIdentityTypeSystemAssignedUserAssigned),
	// 		PrincipalID: to.Ptr("principalid"),
	// 		TenantID: to.Ptr("tenantid"),
	// 		UserAssignedIdentities: map[string]*armappplatform.UserAssignedManagedIdentity{
	// 			"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/samplegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1": &armappplatform.UserAssignedManagedIdentity{
	// 				ClientID: to.Ptr("clientId1"),
	// 				PrincipalID: to.Ptr("principalId1"),
	// 			},
	// 			"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/samplegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id2": &armappplatform.UserAssignedManagedIdentity{
	// 				ClientID: to.Ptr("clientId2"),
	// 				PrincipalID: to.Ptr("principalId2"),
	// 			},
	// 		},
	// 	},
	// 	Location: to.Ptr("eastus"),
	// 	Properties: &armappplatform.AppResourceProperties{
	// 		CustomPersistentDisks: []*armappplatform.CustomPersistentDiskResource{
	// 			{
	// 				CustomPersistentDiskProperties: &armappplatform.AzureFileVolume{
	// 					Type: to.Ptr(armappplatform.TypeAzureFileVolume),
	// 					MountOptions: []*string{
	// 					},
	// 					MountPath: to.Ptr("/mypath1/mypath2"),
	// 					ShareName: to.Ptr("myFileShare"),
	// 				},
	// 				StorageID: to.Ptr("myASCStorageID"),
	// 		}},
	// 		EnableEndToEndTLS: to.Ptr(false),
	// 		Fqdn: to.Ptr("myapp.private.mydomain.com"),
	// 		HTTPSOnly: to.Ptr(false),
	// 		PersistentDisk: &armappplatform.PersistentDisk{
	// 			MountPath: to.Ptr("/mypersistentdisk"),
	// 			SizeInGB: to.Ptr[int32](2),
	// 			UsedInGB: to.Ptr[int32](1),
	// 		},
	// 		ProvisioningState: to.Ptr(armappplatform.AppResourceProvisioningStateSucceeded),
	// 		Public: to.Ptr(true),
	// 		TemporaryDisk: &armappplatform.TemporaryDisk{
	// 			MountPath: to.Ptr("/mytemporarydisk"),
	// 			SizeInGB: to.Ptr[int32](2),
	// 		},
	// 		URL: to.Ptr("myapp.myservice.private.azuremicroservices.io"),
	// 		VnetAddons: &armappplatform.AppVNetAddons{
	// 			PublicEndpoint: to.Ptr(true),
	// 			PublicEndpointURL: to.Ptr("myapp.myservice.azuremicroservices.io"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/appplatform/resource-manager/Microsoft.AppPlatform/preview/2023-01-01-preview/examples/Apps_List.json
func ExampleAppsClient_NewListPager_appsList() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappplatform.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewAppsClient().NewListPager("myResourceGroup", "myservice", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.AppResourceCollection = armappplatform.AppResourceCollection{
		// 	Value: []*armappplatform.AppResource{
		// 		{
		// 			Name: to.Ptr("myapp"),
		// 			Type: to.Ptr("Microsoft.AppPlatform/Spring/apps"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/apps/myapp"),
		// 			SystemData: &armappplatform.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-11T03:16:03.944Z"); return t}()),
		// 				CreatedBy: to.Ptr("sample-user"),
		// 				CreatedByType: to.Ptr(armappplatform.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-11T03:17:03.944Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("sample-user"),
		// 				LastModifiedByType: to.Ptr(armappplatform.LastModifiedByTypeUser),
		// 			},
		// 			Identity: &armappplatform.ManagedIdentityProperties{
		// 				Type: to.Ptr(armappplatform.ManagedIdentityTypeSystemAssignedUserAssigned),
		// 				PrincipalID: to.Ptr("principalid"),
		// 				TenantID: to.Ptr("tenantid"),
		// 				UserAssignedIdentities: map[string]*armappplatform.UserAssignedManagedIdentity{
		// 					"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/samplegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1": &armappplatform.UserAssignedManagedIdentity{
		// 						ClientID: to.Ptr("clientId1"),
		// 						PrincipalID: to.Ptr("principalId1"),
		// 					},
		// 					"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/samplegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id2": &armappplatform.UserAssignedManagedIdentity{
		// 						ClientID: to.Ptr("clientId2"),
		// 						PrincipalID: to.Ptr("principalId2"),
		// 					},
		// 				},
		// 			},
		// 			Location: to.Ptr("eastus"),
		// 			Properties: &armappplatform.AppResourceProperties{
		// 				CustomPersistentDisks: []*armappplatform.CustomPersistentDiskResource{
		// 					{
		// 						CustomPersistentDiskProperties: &armappplatform.AzureFileVolume{
		// 							Type: to.Ptr(armappplatform.TypeAzureFileVolume),
		// 							MountOptions: []*string{
		// 								to.Ptr("uid=0"),
		// 								to.Ptr("gid=0"),
		// 								to.Ptr("dir_mode=0777"),
		// 								to.Ptr("file_mode=0777")},
		// 								MountPath: to.Ptr("/mypath1/mypath2"),
		// 								ShareName: to.Ptr("myFileShare"),
		// 							},
		// 							StorageID: to.Ptr("myASCStorageID"),
		// 					}},
		// 					EnableEndToEndTLS: to.Ptr(false),
		// 					Fqdn: to.Ptr("myapp.mydomain.com"),
		// 					HTTPSOnly: to.Ptr(false),
		// 					LoadedCertificates: []*armappplatform.LoadedCertificate{
		// 						{
		// 							LoadTrustStore: to.Ptr(false),
		// 							ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/certificates/mycert1"),
		// 						},
		// 						{
		// 							LoadTrustStore: to.Ptr(true),
		// 							ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/certificates/mycert2"),
		// 					}},
		// 					PersistentDisk: &armappplatform.PersistentDisk{
		// 						MountPath: to.Ptr("/mypersistentdisk"),
		// 						SizeInGB: to.Ptr[int32](2),
		// 						UsedInGB: to.Ptr[int32](1),
		// 					},
		// 					ProvisioningState: to.Ptr(armappplatform.AppResourceProvisioningStateSucceeded),
		// 					Public: to.Ptr(true),
		// 					TemporaryDisk: &armappplatform.TemporaryDisk{
		// 						MountPath: to.Ptr("/mytemporarydisk"),
		// 						SizeInGB: to.Ptr[int32](2),
		// 					},
		// 					URL: to.Ptr("myapp.myservice.azuremicroservices.io"),
		// 				},
		// 		}},
		// 	}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/appplatform/resource-manager/Microsoft.AppPlatform/preview/2023-01-01-preview/examples/Apps_List_VNetInjection.json
func ExampleAppsClient_NewListPager_appsListVNetInjection() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappplatform.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewAppsClient().NewListPager("myResourceGroup", "myservice", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.AppResourceCollection = armappplatform.AppResourceCollection{
		// 	Value: []*armappplatform.AppResource{
		// 		{
		// 			Name: to.Ptr("myapp"),
		// 			Type: to.Ptr("Microsoft.AppPlatform/Spring/apps"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/apps/myapp"),
		// 			SystemData: &armappplatform.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-11T03:16:03.944Z"); return t}()),
		// 				CreatedBy: to.Ptr("sample-user"),
		// 				CreatedByType: to.Ptr(armappplatform.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-11T03:17:03.944Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("sample-user"),
		// 				LastModifiedByType: to.Ptr(armappplatform.LastModifiedByTypeUser),
		// 			},
		// 			Identity: &armappplatform.ManagedIdentityProperties{
		// 				Type: to.Ptr(armappplatform.ManagedIdentityTypeSystemAssignedUserAssigned),
		// 				PrincipalID: to.Ptr("principalid"),
		// 				TenantID: to.Ptr("tenantid"),
		// 				UserAssignedIdentities: map[string]*armappplatform.UserAssignedManagedIdentity{
		// 					"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/samplegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1": &armappplatform.UserAssignedManagedIdentity{
		// 						ClientID: to.Ptr("clientId1"),
		// 						PrincipalID: to.Ptr("principalId1"),
		// 					},
		// 					"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/samplegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id2": &armappplatform.UserAssignedManagedIdentity{
		// 						ClientID: to.Ptr("clientId2"),
		// 						PrincipalID: to.Ptr("principalId2"),
		// 					},
		// 				},
		// 			},
		// 			Location: to.Ptr("eastus"),
		// 			Properties: &armappplatform.AppResourceProperties{
		// 				CustomPersistentDisks: []*armappplatform.CustomPersistentDiskResource{
		// 					{
		// 						CustomPersistentDiskProperties: &armappplatform.AzureFileVolume{
		// 							Type: to.Ptr(armappplatform.TypeAzureFileVolume),
		// 							MountOptions: []*string{
		// 								to.Ptr("uid=0"),
		// 								to.Ptr("gid=0"),
		// 								to.Ptr("dir_mode=0777"),
		// 								to.Ptr("file_mode=0777")},
		// 								MountPath: to.Ptr("/mypath1/mypath2"),
		// 								ShareName: to.Ptr("myFileShare"),
		// 							},
		// 							StorageID: to.Ptr("myASCStorageID"),
		// 					}},
		// 					EnableEndToEndTLS: to.Ptr(false),
		// 					Fqdn: to.Ptr("myapp.mydomain.com"),
		// 					HTTPSOnly: to.Ptr(false),
		// 					LoadedCertificates: []*armappplatform.LoadedCertificate{
		// 						{
		// 							LoadTrustStore: to.Ptr(false),
		// 							ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/certificates/mycert1"),
		// 						},
		// 						{
		// 							LoadTrustStore: to.Ptr(true),
		// 							ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/certificates/mycert2"),
		// 					}},
		// 					PersistentDisk: &armappplatform.PersistentDisk{
		// 						MountPath: to.Ptr("/mypersistentdisk"),
		// 						SizeInGB: to.Ptr[int32](2),
		// 						UsedInGB: to.Ptr[int32](1),
		// 					},
		// 					ProvisioningState: to.Ptr(armappplatform.AppResourceProvisioningStateSucceeded),
		// 					Public: to.Ptr(true),
		// 					TemporaryDisk: &armappplatform.TemporaryDisk{
		// 						MountPath: to.Ptr("/mytemporarydisk"),
		// 						SizeInGB: to.Ptr[int32](2),
		// 					},
		// 					URL: to.Ptr("myapp.myservice.private.azuremicroservices.io"),
		// 					VnetAddons: &armappplatform.AppVNetAddons{
		// 						PublicEndpoint: to.Ptr(true),
		// 						PublicEndpointURL: to.Ptr("myapp.myservice.azuremicroservices.io"),
		// 					},
		// 				},
		// 		}},
		// 	}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/appplatform/resource-manager/Microsoft.AppPlatform/preview/2023-01-01-preview/examples/Apps_GetResourceUploadUrl.json
func ExampleAppsClient_GetResourceUploadURL() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappplatform.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAppsClient().GetResourceUploadURL(ctx, "myResourceGroup", "myservice", "myapp", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ResourceUploadDefinition = armappplatform.ResourceUploadDefinition{
	// 	RelativePath: to.Ptr("e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855-20190801-3ed9f4a2-986b-4bbd-b833-a42dccb2f777"),
	// 	UploadURL: to.Ptr("https://springcloudstorageaccount.file.core.windows.net/bd172614181f42e2853f6fd90029cda8/e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855-20190801-3ed9f4a2-986b-4bbd-b833-a42dccb2f777?sv=2018-03-28&sr=f&sig=SampleSignature&se=2019-08-01T10%3A42%3A21Z&sp=w"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/appplatform/resource-manager/Microsoft.AppPlatform/preview/2023-01-01-preview/examples/Apps_SetActiveDeployments.json
func ExampleAppsClient_BeginSetActiveDeployments() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappplatform.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAppsClient().BeginSetActiveDeployments(ctx, "myResourceGroup", "myservice", "myapp", armappplatform.ActiveDeploymentCollection{
		ActiveDeploymentNames: []*string{
			to.Ptr("default")},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AppResource = armappplatform.AppResource{
	// 	Name: to.Ptr("myapp"),
	// 	Type: to.Ptr("Microsoft.AppPlatform/Spring/apps"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/apps/myapp"),
	// 	SystemData: &armappplatform.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-11T03:16:03.944Z"); return t}()),
	// 		CreatedBy: to.Ptr("sample-user"),
	// 		CreatedByType: to.Ptr(armappplatform.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-11T03:17:03.944Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("sample-user"),
	// 		LastModifiedByType: to.Ptr(armappplatform.LastModifiedByTypeUser),
	// 	},
	// 	Identity: &armappplatform.ManagedIdentityProperties{
	// 		Type: to.Ptr(armappplatform.ManagedIdentityTypeSystemAssignedUserAssigned),
	// 		PrincipalID: to.Ptr("principalid"),
	// 		TenantID: to.Ptr("tenantid"),
	// 		UserAssignedIdentities: map[string]*armappplatform.UserAssignedManagedIdentity{
	// 			"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/samplegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1": &armappplatform.UserAssignedManagedIdentity{
	// 				ClientID: to.Ptr("clientId1"),
	// 				PrincipalID: to.Ptr("principalId1"),
	// 			},
	// 			"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/samplegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id2": &armappplatform.UserAssignedManagedIdentity{
	// 				ClientID: to.Ptr("clientId2"),
	// 				PrincipalID: to.Ptr("principalId2"),
	// 			},
	// 		},
	// 	},
	// 	Location: to.Ptr("eastus"),
	// 	Properties: &armappplatform.AppResourceProperties{
	// 		CustomPersistentDisks: []*armappplatform.CustomPersistentDiskResource{
	// 			{
	// 				CustomPersistentDiskProperties: &armappplatform.AzureFileVolume{
	// 					Type: to.Ptr(armappplatform.TypeAzureFileVolume),
	// 					MountOptions: []*string{
	// 					},
	// 					MountPath: to.Ptr("/mypath1/mypath2"),
	// 					ShareName: to.Ptr("myFileShare"),
	// 				},
	// 				StorageID: to.Ptr("myASCStorageID"),
	// 		}},
	// 		EnableEndToEndTLS: to.Ptr(false),
	// 		Fqdn: to.Ptr("myapp.mydomain.com"),
	// 		HTTPSOnly: to.Ptr(false),
	// 		PersistentDisk: &armappplatform.PersistentDisk{
	// 			MountPath: to.Ptr("/mypersistentdisk"),
	// 			SizeInGB: to.Ptr[int32](2),
	// 			UsedInGB: to.Ptr[int32](1),
	// 		},
	// 		ProvisioningState: to.Ptr(armappplatform.AppResourceProvisioningStateSucceeded),
	// 		Public: to.Ptr(true),
	// 		TemporaryDisk: &armappplatform.TemporaryDisk{
	// 			MountPath: to.Ptr("/mytemporarydisk"),
	// 			SizeInGB: to.Ptr[int32](2),
	// 		},
	// 		URL: to.Ptr("myapp.myservice.azuremicroservices.io"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/appplatform/resource-manager/Microsoft.AppPlatform/preview/2023-01-01-preview/examples/Apps_ValidateDomain.json
func ExampleAppsClient_ValidateDomain() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappplatform.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAppsClient().ValidateDomain(ctx, "myResourceGroup", "myservice", "myapp", armappplatform.CustomDomainValidatePayload{
		Name: to.Ptr("mydomain.io"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CustomDomainValidateResult = armappplatform.CustomDomainValidateResult{
	// 	IsValid: to.Ptr(false),
	// 	Message: to.Ptr("Certificate is invalid, please check if it is a self signed cert or if it contains a suitable dns name"),
	// }
}
