//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/billing/armbilling"
	"net/http"
	"net/url"
	"regexp"
)

// InvoicesServer is a fake server for instances of the armbilling.InvoicesClient type.
type InvoicesServer struct {
	// BeginDownloadBillingSubscriptionInvoice is the fake for method InvoicesClient.BeginDownloadBillingSubscriptionInvoice
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginDownloadBillingSubscriptionInvoice func(ctx context.Context, invoiceName string, downloadToken string, options *armbilling.InvoicesClientBeginDownloadBillingSubscriptionInvoiceOptions) (resp azfake.PollerResponder[armbilling.InvoicesClientDownloadBillingSubscriptionInvoiceResponse], errResp azfake.ErrorResponder)

	// BeginDownloadInvoice is the fake for method InvoicesClient.BeginDownloadInvoice
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginDownloadInvoice func(ctx context.Context, billingAccountName string, invoiceName string, downloadToken string, options *armbilling.InvoicesClientBeginDownloadInvoiceOptions) (resp azfake.PollerResponder[armbilling.InvoicesClientDownloadInvoiceResponse], errResp azfake.ErrorResponder)

	// BeginDownloadMultipleBillingProfileInvoices is the fake for method InvoicesClient.BeginDownloadMultipleBillingProfileInvoices
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginDownloadMultipleBillingProfileInvoices func(ctx context.Context, billingAccountName string, downloadUrls []*string, options *armbilling.InvoicesClientBeginDownloadMultipleBillingProfileInvoicesOptions) (resp azfake.PollerResponder[armbilling.InvoicesClientDownloadMultipleBillingProfileInvoicesResponse], errResp azfake.ErrorResponder)

	// BeginDownloadMultipleBillingSubscriptionInvoices is the fake for method InvoicesClient.BeginDownloadMultipleBillingSubscriptionInvoices
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginDownloadMultipleBillingSubscriptionInvoices func(ctx context.Context, downloadUrls []*string, options *armbilling.InvoicesClientBeginDownloadMultipleBillingSubscriptionInvoicesOptions) (resp azfake.PollerResponder[armbilling.InvoicesClientDownloadMultipleBillingSubscriptionInvoicesResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method InvoicesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, billingAccountName string, invoiceName string, options *armbilling.InvoicesClientGetOptions) (resp azfake.Responder[armbilling.InvoicesClientGetResponse], errResp azfake.ErrorResponder)

	// GetByID is the fake for method InvoicesClient.GetByID
	// HTTP status codes to indicate success: http.StatusOK
	GetByID func(ctx context.Context, invoiceName string, options *armbilling.InvoicesClientGetByIDOptions) (resp azfake.Responder[armbilling.InvoicesClientGetByIDResponse], errResp azfake.ErrorResponder)

	// GetBySubscriptionAndInvoiceID is the fake for method InvoicesClient.GetBySubscriptionAndInvoiceID
	// HTTP status codes to indicate success: http.StatusOK
	GetBySubscriptionAndInvoiceID func(ctx context.Context, invoiceName string, options *armbilling.InvoicesClientGetBySubscriptionAndInvoiceIDOptions) (resp azfake.Responder[armbilling.InvoicesClientGetBySubscriptionAndInvoiceIDResponse], errResp azfake.ErrorResponder)

	// NewListByBillingAccountPager is the fake for method InvoicesClient.NewListByBillingAccountPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByBillingAccountPager func(billingAccountName string, periodStartDate string, periodEndDate string, options *armbilling.InvoicesClientListByBillingAccountOptions) (resp azfake.PagerResponder[armbilling.InvoicesClientListByBillingAccountResponse])

	// NewListByBillingProfilePager is the fake for method InvoicesClient.NewListByBillingProfilePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByBillingProfilePager func(billingAccountName string, billingProfileName string, periodStartDate string, periodEndDate string, options *armbilling.InvoicesClientListByBillingProfileOptions) (resp azfake.PagerResponder[armbilling.InvoicesClientListByBillingProfileResponse])

	// NewListByBillingSubscriptionPager is the fake for method InvoicesClient.NewListByBillingSubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByBillingSubscriptionPager func(periodStartDate string, periodEndDate string, options *armbilling.InvoicesClientListByBillingSubscriptionOptions) (resp azfake.PagerResponder[armbilling.InvoicesClientListByBillingSubscriptionResponse])
}

// NewInvoicesServerTransport creates a new instance of InvoicesServerTransport with the provided implementation.
// The returned InvoicesServerTransport instance is connected to an instance of armbilling.InvoicesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewInvoicesServerTransport(srv *InvoicesServer) *InvoicesServerTransport {
	return &InvoicesServerTransport{
		srv:                                     srv,
		beginDownloadBillingSubscriptionInvoice: newTracker[azfake.PollerResponder[armbilling.InvoicesClientDownloadBillingSubscriptionInvoiceResponse]](),
		beginDownloadInvoice:                    newTracker[azfake.PollerResponder[armbilling.InvoicesClientDownloadInvoiceResponse]](),
		beginDownloadMultipleBillingProfileInvoices:      newTracker[azfake.PollerResponder[armbilling.InvoicesClientDownloadMultipleBillingProfileInvoicesResponse]](),
		beginDownloadMultipleBillingSubscriptionInvoices: newTracker[azfake.PollerResponder[armbilling.InvoicesClientDownloadMultipleBillingSubscriptionInvoicesResponse]](),
		newListByBillingAccountPager:                     newTracker[azfake.PagerResponder[armbilling.InvoicesClientListByBillingAccountResponse]](),
		newListByBillingProfilePager:                     newTracker[azfake.PagerResponder[armbilling.InvoicesClientListByBillingProfileResponse]](),
		newListByBillingSubscriptionPager:                newTracker[azfake.PagerResponder[armbilling.InvoicesClientListByBillingSubscriptionResponse]](),
	}
}

// InvoicesServerTransport connects instances of armbilling.InvoicesClient to instances of InvoicesServer.
// Don't use this type directly, use NewInvoicesServerTransport instead.
type InvoicesServerTransport struct {
	srv                                              *InvoicesServer
	beginDownloadBillingSubscriptionInvoice          *tracker[azfake.PollerResponder[armbilling.InvoicesClientDownloadBillingSubscriptionInvoiceResponse]]
	beginDownloadInvoice                             *tracker[azfake.PollerResponder[armbilling.InvoicesClientDownloadInvoiceResponse]]
	beginDownloadMultipleBillingProfileInvoices      *tracker[azfake.PollerResponder[armbilling.InvoicesClientDownloadMultipleBillingProfileInvoicesResponse]]
	beginDownloadMultipleBillingSubscriptionInvoices *tracker[azfake.PollerResponder[armbilling.InvoicesClientDownloadMultipleBillingSubscriptionInvoicesResponse]]
	newListByBillingAccountPager                     *tracker[azfake.PagerResponder[armbilling.InvoicesClientListByBillingAccountResponse]]
	newListByBillingProfilePager                     *tracker[azfake.PagerResponder[armbilling.InvoicesClientListByBillingProfileResponse]]
	newListByBillingSubscriptionPager                *tracker[azfake.PagerResponder[armbilling.InvoicesClientListByBillingSubscriptionResponse]]
}

// Do implements the policy.Transporter interface for InvoicesServerTransport.
func (i *InvoicesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "InvoicesClient.BeginDownloadBillingSubscriptionInvoice":
		resp, err = i.dispatchBeginDownloadBillingSubscriptionInvoice(req)
	case "InvoicesClient.BeginDownloadInvoice":
		resp, err = i.dispatchBeginDownloadInvoice(req)
	case "InvoicesClient.BeginDownloadMultipleBillingProfileInvoices":
		resp, err = i.dispatchBeginDownloadMultipleBillingProfileInvoices(req)
	case "InvoicesClient.BeginDownloadMultipleBillingSubscriptionInvoices":
		resp, err = i.dispatchBeginDownloadMultipleBillingSubscriptionInvoices(req)
	case "InvoicesClient.Get":
		resp, err = i.dispatchGet(req)
	case "InvoicesClient.GetByID":
		resp, err = i.dispatchGetByID(req)
	case "InvoicesClient.GetBySubscriptionAndInvoiceID":
		resp, err = i.dispatchGetBySubscriptionAndInvoiceID(req)
	case "InvoicesClient.NewListByBillingAccountPager":
		resp, err = i.dispatchNewListByBillingAccountPager(req)
	case "InvoicesClient.NewListByBillingProfilePager":
		resp, err = i.dispatchNewListByBillingProfilePager(req)
	case "InvoicesClient.NewListByBillingSubscriptionPager":
		resp, err = i.dispatchNewListByBillingSubscriptionPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (i *InvoicesServerTransport) dispatchBeginDownloadBillingSubscriptionInvoice(req *http.Request) (*http.Response, error) {
	if i.srv.BeginDownloadBillingSubscriptionInvoice == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDownloadBillingSubscriptionInvoice not implemented")}
	}
	beginDownloadBillingSubscriptionInvoice := i.beginDownloadBillingSubscriptionInvoice.get(req)
	if beginDownloadBillingSubscriptionInvoice == nil {
		const regexStr = `/providers/Microsoft\.Billing/billingAccounts/default/billingSubscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/invoices/(?P<invoiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/download`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		invoiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("invoiceName")])
		if err != nil {
			return nil, err
		}
		downloadTokenParam, err := url.QueryUnescape(qp.Get("downloadToken"))
		if err != nil {
			return nil, err
		}
		respr, errRespr := i.srv.BeginDownloadBillingSubscriptionInvoice(req.Context(), invoiceNameParam, downloadTokenParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDownloadBillingSubscriptionInvoice = &respr
		i.beginDownloadBillingSubscriptionInvoice.add(req, beginDownloadBillingSubscriptionInvoice)
	}

	resp, err := server.PollerResponderNext(beginDownloadBillingSubscriptionInvoice, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		i.beginDownloadBillingSubscriptionInvoice.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDownloadBillingSubscriptionInvoice) {
		i.beginDownloadBillingSubscriptionInvoice.remove(req)
	}

	return resp, nil
}

func (i *InvoicesServerTransport) dispatchBeginDownloadInvoice(req *http.Request) (*http.Response, error) {
	if i.srv.BeginDownloadInvoice == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDownloadInvoice not implemented")}
	}
	beginDownloadInvoice := i.beginDownloadInvoice.get(req)
	if beginDownloadInvoice == nil {
		const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/invoices/(?P<invoiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/download`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
		if err != nil {
			return nil, err
		}
		invoiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("invoiceName")])
		if err != nil {
			return nil, err
		}
		downloadTokenParam, err := url.QueryUnescape(qp.Get("downloadToken"))
		if err != nil {
			return nil, err
		}
		respr, errRespr := i.srv.BeginDownloadInvoice(req.Context(), billingAccountNameParam, invoiceNameParam, downloadTokenParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDownloadInvoice = &respr
		i.beginDownloadInvoice.add(req, beginDownloadInvoice)
	}

	resp, err := server.PollerResponderNext(beginDownloadInvoice, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		i.beginDownloadInvoice.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDownloadInvoice) {
		i.beginDownloadInvoice.remove(req)
	}

	return resp, nil
}

func (i *InvoicesServerTransport) dispatchBeginDownloadMultipleBillingProfileInvoices(req *http.Request) (*http.Response, error) {
	if i.srv.BeginDownloadMultipleBillingProfileInvoices == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDownloadMultipleBillingProfileInvoices not implemented")}
	}
	beginDownloadMultipleBillingProfileInvoices := i.beginDownloadMultipleBillingProfileInvoices.get(req)
	if beginDownloadMultipleBillingProfileInvoices == nil {
		const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/downloadDocuments`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[[]*string](req)
		if err != nil {
			return nil, err
		}
		billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := i.srv.BeginDownloadMultipleBillingProfileInvoices(req.Context(), billingAccountNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDownloadMultipleBillingProfileInvoices = &respr
		i.beginDownloadMultipleBillingProfileInvoices.add(req, beginDownloadMultipleBillingProfileInvoices)
	}

	resp, err := server.PollerResponderNext(beginDownloadMultipleBillingProfileInvoices, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		i.beginDownloadMultipleBillingProfileInvoices.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDownloadMultipleBillingProfileInvoices) {
		i.beginDownloadMultipleBillingProfileInvoices.remove(req)
	}

	return resp, nil
}

func (i *InvoicesServerTransport) dispatchBeginDownloadMultipleBillingSubscriptionInvoices(req *http.Request) (*http.Response, error) {
	if i.srv.BeginDownloadMultipleBillingSubscriptionInvoices == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDownloadMultipleBillingSubscriptionInvoices not implemented")}
	}
	beginDownloadMultipleBillingSubscriptionInvoices := i.beginDownloadMultipleBillingSubscriptionInvoices.get(req)
	if beginDownloadMultipleBillingSubscriptionInvoices == nil {
		const regexStr = `/providers/Microsoft\.Billing/billingAccounts/default/billingSubscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/downloadDocuments`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[[]*string](req)
		if err != nil {
			return nil, err
		}
		respr, errRespr := i.srv.BeginDownloadMultipleBillingSubscriptionInvoices(req.Context(), body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDownloadMultipleBillingSubscriptionInvoices = &respr
		i.beginDownloadMultipleBillingSubscriptionInvoices.add(req, beginDownloadMultipleBillingSubscriptionInvoices)
	}

	resp, err := server.PollerResponderNext(beginDownloadMultipleBillingSubscriptionInvoices, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		i.beginDownloadMultipleBillingSubscriptionInvoices.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDownloadMultipleBillingSubscriptionInvoices) {
		i.beginDownloadMultipleBillingSubscriptionInvoices.remove(req)
	}

	return resp, nil
}

func (i *InvoicesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if i.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/invoices/(?P<invoiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
	if err != nil {
		return nil, err
	}
	invoiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("invoiceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.Get(req.Context(), billingAccountNameParam, invoiceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Invoice, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (i *InvoicesServerTransport) dispatchGetByID(req *http.Request) (*http.Response, error) {
	if i.srv.GetByID == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetByID not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Billing/billingAccounts/default/invoices/(?P<invoiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	invoiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("invoiceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.GetByID(req.Context(), invoiceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Invoice, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (i *InvoicesServerTransport) dispatchGetBySubscriptionAndInvoiceID(req *http.Request) (*http.Response, error) {
	if i.srv.GetBySubscriptionAndInvoiceID == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetBySubscriptionAndInvoiceID not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Billing/billingAccounts/default/billingSubscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/invoices/(?P<invoiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	invoiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("invoiceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.GetBySubscriptionAndInvoiceID(req.Context(), invoiceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Invoice, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (i *InvoicesServerTransport) dispatchNewListByBillingAccountPager(req *http.Request) (*http.Response, error) {
	if i.srv.NewListByBillingAccountPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByBillingAccountPager not implemented")}
	}
	newListByBillingAccountPager := i.newListByBillingAccountPager.get(req)
	if newListByBillingAccountPager == nil {
		const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/invoices`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
		if err != nil {
			return nil, err
		}
		periodStartDateParam, err := url.QueryUnescape(qp.Get("periodStartDate"))
		if err != nil {
			return nil, err
		}
		periodEndDateParam, err := url.QueryUnescape(qp.Get("periodEndDate"))
		if err != nil {
			return nil, err
		}
		resp := i.srv.NewListByBillingAccountPager(billingAccountNameParam, periodStartDateParam, periodEndDateParam, nil)
		newListByBillingAccountPager = &resp
		i.newListByBillingAccountPager.add(req, newListByBillingAccountPager)
		server.PagerResponderInjectNextLinks(newListByBillingAccountPager, req, func(page *armbilling.InvoicesClientListByBillingAccountResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByBillingAccountPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		i.newListByBillingAccountPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByBillingAccountPager) {
		i.newListByBillingAccountPager.remove(req)
	}
	return resp, nil
}

func (i *InvoicesServerTransport) dispatchNewListByBillingProfilePager(req *http.Request) (*http.Response, error) {
	if i.srv.NewListByBillingProfilePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByBillingProfilePager not implemented")}
	}
	newListByBillingProfilePager := i.newListByBillingProfilePager.get(req)
	if newListByBillingProfilePager == nil {
		const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingProfiles/(?P<billingProfileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/invoices`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
		if err != nil {
			return nil, err
		}
		billingProfileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingProfileName")])
		if err != nil {
			return nil, err
		}
		periodStartDateParam, err := url.QueryUnescape(qp.Get("periodStartDate"))
		if err != nil {
			return nil, err
		}
		periodEndDateParam, err := url.QueryUnescape(qp.Get("periodEndDate"))
		if err != nil {
			return nil, err
		}
		resp := i.srv.NewListByBillingProfilePager(billingAccountNameParam, billingProfileNameParam, periodStartDateParam, periodEndDateParam, nil)
		newListByBillingProfilePager = &resp
		i.newListByBillingProfilePager.add(req, newListByBillingProfilePager)
		server.PagerResponderInjectNextLinks(newListByBillingProfilePager, req, func(page *armbilling.InvoicesClientListByBillingProfileResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByBillingProfilePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		i.newListByBillingProfilePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByBillingProfilePager) {
		i.newListByBillingProfilePager.remove(req)
	}
	return resp, nil
}

func (i *InvoicesServerTransport) dispatchNewListByBillingSubscriptionPager(req *http.Request) (*http.Response, error) {
	if i.srv.NewListByBillingSubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByBillingSubscriptionPager not implemented")}
	}
	newListByBillingSubscriptionPager := i.newListByBillingSubscriptionPager.get(req)
	if newListByBillingSubscriptionPager == nil {
		const regexStr = `/providers/Microsoft\.Billing/billingAccounts/default/billingSubscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/invoices`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		periodStartDateParam, err := url.QueryUnescape(qp.Get("periodStartDate"))
		if err != nil {
			return nil, err
		}
		periodEndDateParam, err := url.QueryUnescape(qp.Get("periodEndDate"))
		if err != nil {
			return nil, err
		}
		resp := i.srv.NewListByBillingSubscriptionPager(periodStartDateParam, periodEndDateParam, nil)
		newListByBillingSubscriptionPager = &resp
		i.newListByBillingSubscriptionPager.add(req, newListByBillingSubscriptionPager)
		server.PagerResponderInjectNextLinks(newListByBillingSubscriptionPager, req, func(page *armbilling.InvoicesClientListByBillingSubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByBillingSubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		i.newListByBillingSubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByBillingSubscriptionPager) {
		i.newListByBillingSubscriptionPager.remove(req)
	}
	return resp, nil
}
