//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/datashare/armdatashare"
	"net/http"
	"net/url"
	"regexp"
)

// ProviderShareSubscriptionsServer is a fake server for instances of the armdatashare.ProviderShareSubscriptionsClient type.
type ProviderShareSubscriptionsServer struct {
	// Adjust is the fake for method ProviderShareSubscriptionsClient.Adjust
	// HTTP status codes to indicate success: http.StatusOK
	Adjust func(ctx context.Context, resourceGroupName string, accountName string, shareName string, providerShareSubscriptionID string, providerShareSubscription armdatashare.ProviderShareSubscription, options *armdatashare.ProviderShareSubscriptionsClientAdjustOptions) (resp azfake.Responder[armdatashare.ProviderShareSubscriptionsClientAdjustResponse], errResp azfake.ErrorResponder)

	// GetByShare is the fake for method ProviderShareSubscriptionsClient.GetByShare
	// HTTP status codes to indicate success: http.StatusOK
	GetByShare func(ctx context.Context, resourceGroupName string, accountName string, shareName string, providerShareSubscriptionID string, options *armdatashare.ProviderShareSubscriptionsClientGetByShareOptions) (resp azfake.Responder[armdatashare.ProviderShareSubscriptionsClientGetByShareResponse], errResp azfake.ErrorResponder)

	// NewListBySharePager is the fake for method ProviderShareSubscriptionsClient.NewListBySharePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySharePager func(resourceGroupName string, accountName string, shareName string, options *armdatashare.ProviderShareSubscriptionsClientListByShareOptions) (resp azfake.PagerResponder[armdatashare.ProviderShareSubscriptionsClientListByShareResponse])

	// Reinstate is the fake for method ProviderShareSubscriptionsClient.Reinstate
	// HTTP status codes to indicate success: http.StatusOK
	Reinstate func(ctx context.Context, resourceGroupName string, accountName string, shareName string, providerShareSubscriptionID string, providerShareSubscription armdatashare.ProviderShareSubscription, options *armdatashare.ProviderShareSubscriptionsClientReinstateOptions) (resp azfake.Responder[armdatashare.ProviderShareSubscriptionsClientReinstateResponse], errResp azfake.ErrorResponder)

	// BeginRevoke is the fake for method ProviderShareSubscriptionsClient.BeginRevoke
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginRevoke func(ctx context.Context, resourceGroupName string, accountName string, shareName string, providerShareSubscriptionID string, options *armdatashare.ProviderShareSubscriptionsClientBeginRevokeOptions) (resp azfake.PollerResponder[armdatashare.ProviderShareSubscriptionsClientRevokeResponse], errResp azfake.ErrorResponder)
}

// NewProviderShareSubscriptionsServerTransport creates a new instance of ProviderShareSubscriptionsServerTransport with the provided implementation.
// The returned ProviderShareSubscriptionsServerTransport instance is connected to an instance of armdatashare.ProviderShareSubscriptionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewProviderShareSubscriptionsServerTransport(srv *ProviderShareSubscriptionsServer) *ProviderShareSubscriptionsServerTransport {
	return &ProviderShareSubscriptionsServerTransport{
		srv:                 srv,
		newListBySharePager: newTracker[azfake.PagerResponder[armdatashare.ProviderShareSubscriptionsClientListByShareResponse]](),
		beginRevoke:         newTracker[azfake.PollerResponder[armdatashare.ProviderShareSubscriptionsClientRevokeResponse]](),
	}
}

// ProviderShareSubscriptionsServerTransport connects instances of armdatashare.ProviderShareSubscriptionsClient to instances of ProviderShareSubscriptionsServer.
// Don't use this type directly, use NewProviderShareSubscriptionsServerTransport instead.
type ProviderShareSubscriptionsServerTransport struct {
	srv                 *ProviderShareSubscriptionsServer
	newListBySharePager *tracker[azfake.PagerResponder[armdatashare.ProviderShareSubscriptionsClientListByShareResponse]]
	beginRevoke         *tracker[azfake.PollerResponder[armdatashare.ProviderShareSubscriptionsClientRevokeResponse]]
}

// Do implements the policy.Transporter interface for ProviderShareSubscriptionsServerTransport.
func (p *ProviderShareSubscriptionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ProviderShareSubscriptionsClient.Adjust":
		resp, err = p.dispatchAdjust(req)
	case "ProviderShareSubscriptionsClient.GetByShare":
		resp, err = p.dispatchGetByShare(req)
	case "ProviderShareSubscriptionsClient.NewListBySharePager":
		resp, err = p.dispatchNewListBySharePager(req)
	case "ProviderShareSubscriptionsClient.Reinstate":
		resp, err = p.dispatchReinstate(req)
	case "ProviderShareSubscriptionsClient.BeginRevoke":
		resp, err = p.dispatchBeginRevoke(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *ProviderShareSubscriptionsServerTransport) dispatchAdjust(req *http.Request) (*http.Response, error) {
	if p.srv.Adjust == nil {
		return nil, &nonRetriableError{errors.New("fake for method Adjust not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataShare/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/shares/(?P<shareName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providerShareSubscriptions/(?P<providerShareSubscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/adjust`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armdatashare.ProviderShareSubscription](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	shareNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("shareName")])
	if err != nil {
		return nil, err
	}
	providerShareSubscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("providerShareSubscriptionId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Adjust(req.Context(), resourceGroupNameParam, accountNameParam, shareNameParam, providerShareSubscriptionIDParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ProviderShareSubscription, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *ProviderShareSubscriptionsServerTransport) dispatchGetByShare(req *http.Request) (*http.Response, error) {
	if p.srv.GetByShare == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetByShare not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataShare/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/shares/(?P<shareName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providerShareSubscriptions/(?P<providerShareSubscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	shareNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("shareName")])
	if err != nil {
		return nil, err
	}
	providerShareSubscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("providerShareSubscriptionId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.GetByShare(req.Context(), resourceGroupNameParam, accountNameParam, shareNameParam, providerShareSubscriptionIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ProviderShareSubscription, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *ProviderShareSubscriptionsServerTransport) dispatchNewListBySharePager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListBySharePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySharePager not implemented")}
	}
	newListBySharePager := p.newListBySharePager.get(req)
	if newListBySharePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataShare/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/shares/(?P<shareName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providerShareSubscriptions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		shareNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("shareName")])
		if err != nil {
			return nil, err
		}
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skipToken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		var options *armdatashare.ProviderShareSubscriptionsClientListByShareOptions
		if skipTokenParam != nil {
			options = &armdatashare.ProviderShareSubscriptionsClientListByShareOptions{
				SkipToken: skipTokenParam,
			}
		}
		resp := p.srv.NewListBySharePager(resourceGroupNameParam, accountNameParam, shareNameParam, options)
		newListBySharePager = &resp
		p.newListBySharePager.add(req, newListBySharePager)
		server.PagerResponderInjectNextLinks(newListBySharePager, req, func(page *armdatashare.ProviderShareSubscriptionsClientListByShareResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySharePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListBySharePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySharePager) {
		p.newListBySharePager.remove(req)
	}
	return resp, nil
}

func (p *ProviderShareSubscriptionsServerTransport) dispatchReinstate(req *http.Request) (*http.Response, error) {
	if p.srv.Reinstate == nil {
		return nil, &nonRetriableError{errors.New("fake for method Reinstate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataShare/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/shares/(?P<shareName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providerShareSubscriptions/(?P<providerShareSubscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/reinstate`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armdatashare.ProviderShareSubscription](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	shareNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("shareName")])
	if err != nil {
		return nil, err
	}
	providerShareSubscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("providerShareSubscriptionId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Reinstate(req.Context(), resourceGroupNameParam, accountNameParam, shareNameParam, providerShareSubscriptionIDParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ProviderShareSubscription, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *ProviderShareSubscriptionsServerTransport) dispatchBeginRevoke(req *http.Request) (*http.Response, error) {
	if p.srv.BeginRevoke == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRevoke not implemented")}
	}
	beginRevoke := p.beginRevoke.get(req)
	if beginRevoke == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataShare/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/shares/(?P<shareName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providerShareSubscriptions/(?P<providerShareSubscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/revoke`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		shareNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("shareName")])
		if err != nil {
			return nil, err
		}
		providerShareSubscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("providerShareSubscriptionId")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginRevoke(req.Context(), resourceGroupNameParam, accountNameParam, shareNameParam, providerShareSubscriptionIDParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRevoke = &respr
		p.beginRevoke.add(req, beginRevoke)
	}

	resp, err := server.PollerResponderNext(beginRevoke, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		p.beginRevoke.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRevoke) {
		p.beginRevoke.remove(req)
	}

	return resp, nil
}
