#!/usr/bin/perl -w

# This will allow you to add a string to all language files at once

sub usage {

    print "

add_lang_string.pl : Add a string to each locale file.

    This program will allow a developer to add a string to a lang file in each locale.

      Arguments:

	--lang-file=\"<filename>.lang\"

	--string-name=\"<string name>\"

        --string-default=\"<default string>\"

        --locale-dir=\"<locale dir>\"

      Example:

	    ./add_lang_string.pl --lang-file=spelling.lang \\
		                 --string-name=\"no_errors\" \\
				 --string-default=\"No Spelling Errors.\" \\
                                 --locale-dir=\"/home/httpd/horde/imp/locale\"

";
    exit;
}


# Parse command-line arguments
usage if($#ARGV != 3);
foreach $Argument (@ARGV) {

    if($Argument =~ /--lang-file=(.*)/) {
	$Options{"lang-file"} = $1;

    } elsif($Argument =~ /--string-name=(.*)/) {
	$Options{"string-name"} = $1;

    } elsif($Argument =~ /--string-default=(.*)/) {
	$Options{"string-default"} = $1;

    } elsif($Argument =~ /--locale-dir=(.*)/) {
	$Options{"locale-dir"} = $1;
	
    } else {
	print "Error: Bad argument: $Argument\n\n";
	usage;
    }
}

# Get the string together
$Lang_String = "\$lang->" . $Options{"string-name"} . " = \'" . $Options{"string-default"} . "\';";

opendir(LOCALE_DIR, $Options{"locale-dir"});
@Locale_Directories = readdir(LOCALE_DIR);
closedir(LOCALE_DIR);

foreach $Directory (@Locale_Directories) {

    # Get rid of all the directories we don't update
    next if($Directory eq ".");
    next if($Directory eq "..");
    next if($Directory eq "CVS");
    next if($Directory eq "local");
    next if($Directory eq "defines");

    $Filename = $Options{"locale-dir"} . "/". $Directory . "/" . $Options{"lang-file"};
    $Tempfile = $Options{"locale-dir"} . "/". $Directory . "/" . $Options{"lang-file"} . ".tmp";
    open(LOCALE_FILE, $Filename);
    open(TEMPFILE, ">$Tempfile");

    while(<LOCALE_FILE>) {

	# Print the new string if we have gotten to the end
	if($_ =~ /\?>/) {
	    print TEMPFILE $Lang_String . "\n";
	}

	print TEMPFILE;
    }
    close LOCALE_FILE;
    close TEMPFILE;
    system("mv -f $Tempfile $Filename");
}

