/********* Sample code generated by the curl command line tool **********
 * All curl_easy_setopt() options are documented at:
 * https://curl.se/libcurl/c/curl_easy_setopt.html
 ************************************************************************/
#include <curl/curl.h>

int main(int argc, char *argv[])
{
  CURLcode result;
  CURL *curl;
  struct curl_slist *slist1;
  struct curl_slist *slist2;
  struct curl_slist *slist3;

  slist1 = NULL;
  slist1 = curl_slist_append(slist1, "NOOP 1");
  slist1 = curl_slist_append(slist1, "*FAIL");
  slist2 = NULL;
  slist2 = curl_slist_append(slist2, "NOOP 3");
  slist3 = NULL;
  slist3 = curl_slist_append(slist3, "NOOP 2");
  slist3 = curl_slist_append(slist3, "*FAIL HARD");

  curl = curl_easy_init();
  curl_easy_setopt(curl, CURLOPT_VERBOSE, 1L);
  curl_easy_setopt(curl, CURLOPT_BUFFERSIZE, 102400L);
  curl_easy_setopt(curl, CURLOPT_URL, "ftp://%HOSTIP:%FTPPORT/%TESTNUMBER");
  curl_easy_setopt(curl, CURLOPT_FTP_SKIP_PASV_IP, 1L);
  curl_easy_setopt(curl, CURLOPT_QUOTE, slist1);
  curl_easy_setopt(curl, CURLOPT_POSTQUOTE, slist2);
  curl_easy_setopt(curl, CURLOPT_PREQUOTE, slist3);
  curl_easy_setopt(curl, CURLOPT_TCP_KEEPALIVE, 1L);

  /* Here is a list of options the curl code used that cannot get generated
     as source easily. You may choose to either not use them or implement
     them yourself.

  CURLOPT_DEBUGFUNCTION was set to a function pointer
  CURLOPT_DEBUGDATA was set to an object pointer
  CURLOPT_WRITEDATA was set to an object pointer
  CURLOPT_WRITEFUNCTION was set to a function pointer
  CURLOPT_READDATA was set to an object pointer
  CURLOPT_READFUNCTION was set to a function pointer
  CURLOPT_SEEKDATA was set to an object pointer
  CURLOPT_SEEKFUNCTION was set to a function pointer
  CURLOPT_HEADERFUNCTION was set to a function pointer
  CURLOPT_HEADERDATA was set to an object pointer
  CURLOPT_ERRORBUFFER was set to an object pointer
  CURLOPT_STDERR was set to an object pointer

  */

  result = curl_easy_perform(curl);

  curl_easy_cleanup(curl);
  curl = NULL;
  curl_slist_free_all(slist1);
  slist1 = NULL;
  curl_slist_free_all(slist2);
  slist2 = NULL;
  curl_slist_free_all(slist3);
  slist3 = NULL;

  return (int)result;
}
/**** End of sample code ****/
