<!-- omit in toc -->
# Contributing to `debputy`

First off, thanks for taking the time to contribute! ❤️

All types of contributions are encouraged and valued. See the [Table of Contents](#table-of-contents) for different ways to help and details about how this project handles them. Please make sure to read the relevant section before making your contribution. It will make it a lot easier for us maintainers and smooth out the experience for all involved. The community looks forward to your contributions. 🎉

> And if you like the project, but just don't have time to contribute, that's fine. There are other easy ways to support the project and show your appreciation, which we would also be very happy about:
> - Star the project
> - Sharing with others that you use the `debputy`

<!-- omit in toc -->
## Table of Contents

- [I Have a Question](#i-have-a-question)
- [I Want To Contribute](#i-want-to-contribute)
- [Reporting Bugs](#reporting-bugs)
- [Suggesting Enhancements](#suggesting-enhancements)
- [Your First Code Contribution](#your-first-code-contribution)
- [Improving The Documentation](#improving-the-documentation)
- [Improving diagnostics (lint) and formatting tooling](#improving-diagnostics-lint-and-formatting-tooling)
- [Styleguides](#styleguides)
- [Commit Messages](#commit-messages)

## I Have a Question

> If you want to ask a question, we assume that you have read the available [Documentation](README.md).

Before you ask a question, it is best to search for existing [Issues](https://salsa.debian.org/debian/debputy/-/issues/new) that might help you. In case you have found a suitable issue and still need clarification, you can write your question in this issue. It is also advisable to search the internet for answers first.

If you then still feel the need to ask a question and need clarification, we recommend the following:

- Open an [Issue](https://salsa.debian.org/debian/salsa/issues/new). If you use Debian, you are also
  welcome to use `reportbug debputy`.
- Provide as much context as you can about what you're running into.
- Provide project and platform versions (python), depending on what seems relevant.
  If you file a bug via `reportbug debputy`, the platform information will be generated for you.

We will then take care of the issue as soon as possible.

## I Want To Contribute

> ### Legal Notice <!-- omit in toc -->
> When contributing to this project, you must agree that you have authored 100% of the content, that you have the
> necessary rights to the content and that the content you contribute may be provided under the project licence.

### Reporting Bugs

<!-- omit in toc -->
#### Before Submitting a Bug Report

A good bug report shouldn't leave others needing to chase you up for more information. Therefore, we ask you to investigate carefully, collect information and describe the issue in detail in your report. Please complete the following steps in advance to help us fix any potential bug as fast as possible.

- Make sure that you are using the latest version.
- Determine if your bug is really a bug and not an error on your side e.g. using incompatible environment components/versions (Make sure that you have read the [documentation](README.md). If you are looking for support, you might want to check [this section](#i-have-a-question)).
- To see if other users have experienced (and potentially already solved) the same issue you are having, check if there
   is not already a bug report existing for your bug or error in the [salsa bug tracker](https://salsa.debian.org/debian/salsa/issues?q=label%3Abug)
  and the [Debian bug tracker](https://bugs.debian.org/src:debputy)
- Read [docs/IMPLEMENTATION-DECISIONS.md](docs/IMPLEMENTATION-DECISIONS.md) and find out if it is part of an existing
  decision. If it follows a decision, it is a not a bug. However, you can still request a enhancement to the decision.
- Also make sure to search the internet to see if users outside the GitHub community have discussed the issue.
- Collect information about the bug:
  - Stack trace (Traceback)
  - OS, Platform and Version (Windows, Linux, macOS, x86, ARM). Note: If you file the bug via `reportbug debputy`
    from a Debian system, this will be filled out for you.
- Version of the interpreter, compiler, SDK, runtime environment, package manager, depending on what seems relevant.
- Possibly your input and the output
- Can you reliably reproduce the issue? And can you also reproduce it with older versions?

<!-- omit in toc -->
#### How Do I Submit a Good Bug Report?

> You must never report security related issues, vulnerabilities or bugs including sensitive information to the issue tracker, or elsewhere in public. Instead, for sensitive bugs please see the instructions at <https://www.debian.org/security/faq#contact>. Remember to mention the issue is in `debputy` (they handle security issues for multiple projects).

We use Salsa issues to track bugs and errors. If you run into an issue with the project:

- Open an [Issue](https://salsa.debian.org/debian/salsa/issues/new) or (at your reference) via `reportbug debputy` on a Debian system.
- Explain the behavior you would expect and the actual behavior.
- Please provide as much context as possible and describe the *reproduction steps* that someone else can follow to recreate the issue on their own. This usually includes your code. For good bug reports you should isolate the problem and create a reduced test case.
- Provide the information you collected in the previous section.

Once it's filed:

- The project team will label the issue accordingly.
- A team member will try to reproduce the issue with your provided steps. If there are no reproduction steps or no obvious way to reproduce the issue, the team will ask you for those steps and mark the issue as `needs-repro`. Bugs with the `needs-repro` tag will not be addressed until they are reproduced.
- If the team is able to reproduce the issue, it will be marked `needs-fix`, as well as possibly other tags, and the issue will be left to be [implemented by someone](#your-first-code-contribution).


### Suggesting Enhancements

This section guides you through submitting an enhancement suggestion for `debputy`,
**including completely new features and minor improvements to existing functionality**.
Following these guidelines will help maintainers and the community to understand your
suggestion and find related suggestions.

<!-- omit in toc -->
#### Before Submitting an Enhancement

- Make sure that you are using the latest version.
- Read the [documentation](README.md) carefully and find out if the functionality is already covered, maybe by an individual configuration.
- Read [docs/IMPLEMENTATION-DECISIONS.md](docs/IMPLEMENTATION-DECISIONS.md) and find out if it is part of an existing
  decision. If an enhancement request affects an existing decision, the request should reflect on how it fits with
  the decision or why the change would make sense.
- Perform a [search](https://salsa.debian.org/debian/salsa/issues) to see if the enhancement has already been suggested. If it has, add a comment to the existing issue instead of opening a new one.
- Find out whether your idea fits with the scope and aims of the project. It's up to you to make a strong case to convince the project's developers of the merits of this feature. Keep in mind that we want features that will be useful to the majority of our users and not just a small subset. If you're just targeting a minority of users, consider writing an add-on/plugin library.

<!-- omit in toc -->
#### How Do I Submit a Good Enhancement Suggestion?

Enhancement suggestions are tracked as [GitHub issues](https://salsa.debian.org/debian/salsa/issues).

- Use a **clear and descriptive title** for the issue to identify the suggestion.
- Provide a **step-by-step description of the suggested enhancement** in as many details as possible.
- **Describe the current behavior** and **explain which behavior you expected to see instead** and why. At this point you can also tell which alternatives do not work for you.
- You may want to **include screenshots or screen recordings** which help you demonstrate the steps or point out the part which the suggestion is related to. You can use [LICEcap](https://www.cockos.com/licecap/) to record GIFs on macOS and Windows, and the built-in [screen recorder in GNOME](https://help.gnome.org/users/gnome-help/stable/screen-shot-record.html.en) or [SimpleScreenRecorder](https://github.com/MaartenBaert/ssr) on Linux. <!-- this should only be included if the project has a GUI -->
- **Explain why this enhancement would be useful** to most `debputy` users. You may also want to point out the other projects that solved it better and which could serve as inspiration.

<!-- You might want to create an issue template for enhancement suggestions that can be used as a guide and that defines the structure of the information to be included. If you do so, reference it here in the description. -->

### Your First Code Contribution

The development currently assumes a Debian system either testing or stable. Build dependencies are installed via
`apt-get build-dep <path/to/debputy-checkout>`. This should be sufficient to enable you to run `debputy.sh` as well
as the tests.

We are also interested in supporting some features on non-Debian platforms (such as <https://salsa.debian.org/debian/debputy/-/issues/126>).
Contributions to make it easier to install or use the project with Python `pip` is very welcome.

There are no set requirements for editor or IDE.


### Improving The Documentation

Almost all documentation primarily be one of the 4 types of documentation (<https://documentation.divio.com/>):

 * [Tutorial](https://docs.divio.com/documentation-system/tutorials/)
 * [How-to Guide](https://docs.divio.com/documentation-system/how-to-guides/)
 * [Reference guide](https://docs.divio.com/documentation-system/reference/)
 * [Explanation](https://docs.divio.com/documentation-system/explanation/)

Even when it is not, each document must have a clear audience in mind.

When starting on a new document, it is recommended to start by thinking about what is it we want to cover
with this document. Once figured out, put in a snippet like:

```markdown
# Title here

_This is [how-to guide](https://documentation.divio.com/how-to-guides/) and is primarily aimed at getting a task done._

<!-- To writers and reviewers: Check the documentation against https://documentation.divio.com/ -->
```

That should define the majority of the documentation style for that document. If a considerable part of the document
is written in a different documentation style (such as a mix of "Reference Guide" and "How-to Guide"), it can be a
sign that the given document needs to be split into two.

Picking a documentation type helps:
 * The reader figure out if it is the right kind of document for them in the situation they are in now.
 * You as a writer focus on what you want to document and stay on track.
 * The reviewer to aid you provide better phrasing or improvements to the documentation during review.


#### How to refer to `debputy` in documentation

In this project, we always refer to `debputy` as shown here. That is to say inside a literal written with all
lower-case letters as if referring to the command line program itself.

This makes it hard to start a sentence with `debputy` since sentences should start with a capital letter. Here,
most cases can always be written to start with "The `debputy` (program|framework|tool|API|...) ...".

#### Working with auto-generated reference documentation

When the documentation is about a `debputy` feature that is introspectable, such as the format of `debputy.manifest`,
we try to generate document from a template. As an example, [MANIFEST-FORMAT.md](MANIFEST-FORMAT.md) is generated
from the template [doc/MANIFEST-FORMAT.md.j2](docs/MANIFEST-FORMAT.md.j2) to keep things
[DRY](https://en.wikipedia.org/wiki/Don%27t_repeat_yourself). These templates start with a comment that describes
how to regenerate the output. The initial comments of the template should also cover where you can find most of
the documentation that is not visible inside the template.

#### Improving hover docs in the editor mode (LSP)

The vast majority of hover documentation in the editor mode comes from one of the following places:

 * src/debputy/lsp/data (for field documentation of deb822 based)
 * src/debputy/lsp/languages/lsp_*.py or src/debputy/lsp/lsp_debian_control_reference_data.py for other hover docs
   of the deb822 format.
 * `debputy`'s online docs for the manifest, same as used in [doc/MANIFEST-FORMAT.md.j2](docs/MANIFEST-FORMAT.md.j2)
   (for `debputy.manifest`)
 * src/debputy/lsp/languages/lsp_*.py for other YAML based format.

For LSP only documentation, work to move the documentation from the code to a data file is always welcome. For
documentation for `debputy.manifest`, the documentation falls under the `debputy` plugin API. If you start any
work involving the `debputy` plugin API, consider doing a small prototype and discuss it before commiting too
much work. The plugin API is important to us.

### Improving diagnostics (lint) and formatting tooling

Please have a look at [docs/DIAGNOSTICS-AND-FORMATTING.md](docs/DIAGNOSTICS-AND-FORMATTING.md). The document
covers relevant files, entities, and conventions.

## Styleguides

### Code and packaging styling

For code, we use the Python `black` style.

With packaging, we use `debputy reformat`.

### Commit Messages

The project uses `gbp dch` for generating the changelog from commit messages. By default, the first line of **each** commit will be the changelog line
and it should be written with that in mind. You can use `gbp dch -S` (`apt install git-buildpackage`) to have a snapshot of the changelog generated
for review. However, to avoid merge conflicts, please do not include it in an MR with other changes unless there is a compelling reason to do so.

For commits that are not visible to the user (such as refactoring), add `Gbp-Dch: ignore` on its own line in the commit message. This will
make `gbp dch` skip the commit. If for some reason, the first line of the commit message is insufficient or the changelog should have additional
content, you can add `Gbp-Dch: full` on its own line of the commit message. For cases where `gbp dch` will not work, feel free to provide the
intended changelog entry in the MR details and tag the commits with `Gbp-Dch; ignore`.

In all cases, the commit message is used as a suggestion for the changelog entry. The maintainers may rewrite or omit
entries at their discretion.

Some conventions for the fist line of the commit message:

 * linting or editor support changes should be prefixed with `LSP/Lint: `.
 * reformatting related changes should be prefixed with `LSP/Reformat: ` except when it only affects the CLI
   (like a new command line option), in which case `debputy reformat: ` is used.
 * The prefix `Manifest: ` is used for changes to the manifest format (such as adding a new feature or fixing
   notable bugs with the interpretation of the manifest).
 * The prefix `Plugin API: ` is used for changes to the plugin API for third-party plugins.

The prefixes are used to ensure relevant changes are grouped in the changelog, so users can quickly find the parts that
are relevant to them.

<!-- omit in toc -->
## Attribution
This guide is based on the [contributing.md](https://contributing.md/generator)!
