#pragma once


#include <memory>

#include <QDataStream>

#include "pappsomspp/export-import-config.h"
#include "massspectrumcombiner.h"

namespace pappso
{

class MassSpectrumMinusCombiner;

typedef std::shared_ptr<const MassSpectrumMinusCombiner>
  MassSpectrumMinusCombinerCstSPtr;
typedef std::shared_ptr<MassSpectrumMinusCombiner>
  MassSpectrumMinusCombinerSPtr;

class PMSPP_LIB_DECL MassSpectrumMinusCombiner: public MassSpectrumCombiner
{
  Q_OBJECT

  public:
  Q_INVOKABLE MassSpectrumMinusCombiner(QObject *parent_p = nullptr);
  Q_INVOKABLE MassSpectrumMinusCombiner(int decimal_places,
                                        QObject *parent_p = nullptr);
  MassSpectrumMinusCombiner(MassSpectrumMinusCombinerCstSPtr other,
                            QObject *parent_p = nullptr);
  MassSpectrumMinusCombiner(const MassSpectrumMinusCombiner &other,
                            QObject *parent_p = nullptr);

  virtual ~MassSpectrumMinusCombiner();

  MassSpectrumMinusCombiner &operator=(const MassSpectrumMinusCombiner &other);

  Q_INVOKABLE virtual MapTrace &combine(MapTrace &map_trace,
                                        const Trace &trace) const override;
  Q_INVOKABLE virtual MapTrace &
  combine(MapTrace &map_trace_out, const MapTrace &map_trace_in) const override;

  // # pragma message "This pragma is inside"
  static void registerJsConstructor(QJSEngine *engine);
};

PAPPSO_REGISTER_JS_CLASS(pappso, MassSpectrumMinusCombiner)


} // namespace pappso
