# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs."""

    INTERNAL = "Internal"


class ApplicationArtifactName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The managed application artifact name."""

    NOT_SPECIFIED = "NotSpecified"
    VIEW_DEFINITION = "ViewDefinition"
    AUTHORIZATIONS = "Authorizations"
    CUSTOM_ROLE_DEFINITION = "CustomRoleDefinition"


class ApplicationArtifactType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The managed application artifact type."""

    NOT_SPECIFIED = "NotSpecified"
    TEMPLATE = "Template"
    CUSTOM = "Custom"


class ApplicationDefinitionArtifactName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The managed application artifact name."""

    NOT_SPECIFIED = "NotSpecified"
    APPLICATION_RESOURCE_TEMPLATE = "ApplicationResourceTemplate"
    CREATE_UI_DEFINITION = "CreateUiDefinition"
    MAIN_TEMPLATE_PARAMETERS = "MainTemplateParameters"


class ApplicationLockLevel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The managed application lock level."""

    CAN_NOT_DELETE = "CanNotDelete"
    READ_ONLY = "ReadOnly"
    NONE = "None"


class ApplicationManagementMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The management mode."""

    NOT_SPECIFIED = "NotSpecified"
    UNMANAGED = "Unmanaged"
    MANAGED = "Managed"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class DeploymentMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The deployment mode."""

    NOT_SPECIFIED = "NotSpecified"
    INCREMENTAL = "Incremental"
    COMPLETE = "Complete"


class JitApprovalMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Jit approval mode."""

    NOT_SPECIFIED = "NotSpecified"
    AUTO_APPROVE = "AutoApprove"
    MANUAL_APPROVE = "ManualApprove"


class JitApproverType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The approver type."""

    USER = "user"
    GROUP = "group"


class JitRequestState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The JIT request state."""

    NOT_SPECIFIED = "NotSpecified"
    PENDING = "Pending"
    APPROVED = "Approved"
    DENIED = "Denied"
    FAILED = "Failed"
    CANCELED = "Canceled"
    EXPIRED = "Expired"
    TIMEOUT = "Timeout"


class JitSchedulingType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The JIT request scheduling type."""

    NOT_SPECIFIED = "NotSpecified"
    ONCE = "Once"
    RECURRING = "Recurring"


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    SYSTEM = "system"
    USER_SYSTEM = "user,system"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning status of the managed application."""

    NOT_SPECIFIED = "NotSpecified"
    ACCEPTED = "Accepted"
    RUNNING = "Running"
    DELETING = "Deleting"
    DELETED = "Deleted"
    CANCELED = "Canceled"
    FAILED = "Failed"
    SUCCEEDED = "Succeeded"
    UPDATING = "Updating"


class ResourceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The identity type."""

    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned, UserAssigned"
    NONE = "None"


class Status(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The JIT status."""

    NOT_SPECIFIED = "NotSpecified"
    ELEVATE = "Elevate"
    REMOVE = "Remove"


class Substatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The sub status."""

    NOT_SPECIFIED = "NotSpecified"
    APPROVED = "Approved"
    DENIED = "Denied"
    FAILED = "Failed"
    EXPIRED = "Expired"
    TIMEOUT = "Timeout"
