import OCP.VrmlAPI
from typing import *
from typing import Iterable as iterable
from typing import Iterator as iterator
from numpy import float64
_Shape = Tuple[int, ...]
import OCP.TCollection
import io
import OCP.Quantity
import OCP.gp
import OCP.TopoDS
import OCP.TColStd
import OCP.Message
import OCP.TDocStd
import OCP.Standard
import OCP.Interface
import OCP.RWMesh
import OCP.Vrml
__all__  = [
"VrmlAPI",
"VrmlAPI_CafReader",
"VrmlAPI_RepresentationOfShape",
"VrmlAPI_Writer",
"VrmlAPI_BothRepresentation",
"VrmlAPI_ShadedRepresentation",
"VrmlAPI_WireFrameRepresentation"
]
class VrmlAPI():
    """
    API for writing to VRML 1.0
    """
    @staticmethod
    def Write_s(aShape : OCP.TopoDS.TopoDS_Shape,aFileName : str,aVersion : int=2) -> bool: 
        """
        With help of this class user can change parameters of writing. Converts the shape aShape to VRML format of the passed version and writes it to the file identified by aFileName using default parameters.
        """
    def __init__(self) -> None: ...
    pass
class VrmlAPI_CafReader(OCP.RWMesh.RWMesh_CafReader, OCP.Standard.Standard_Transient):
    """
    The Vrml mesh reader into XDE document.
    """
    def CoordinateSystemConverter(self) -> OCP.RWMesh.RWMesh_CoordinateSystemConverter: 
        """
        Return coordinate system converter.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def Document(self) -> OCP.TDocStd.TDocStd_Document: 
        """
        Return target document.
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def ExternalFiles(self) -> OCP.Interface.Interface_IndexedMapOfAsciiString: 
        """
        Return the list of complementary files - external references (textures, data, etc.).
        """
    def ExtraStatus(self) -> int: 
        """
        Return extended status flags.
        """
    def FileCoordinateSystem(self) -> OCP.gp.gp_Ax3: 
        """
        Return file origin coordinate system; can be UNDEFINED, which means no conversion will be done.
        """
    def FileLengthUnit(self) -> float: 
        """
        Return the length unit to convert from while reading the file, defined as scale factor for m (meters). Can be undefined (-1.0) if file format is unitless.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HasFileCoordinateSystem(self) -> bool: 
        """
        Return TRUE if file origin coordinate system has been defined.
        """
    def HasSystemCoordinateSystem(self) -> bool: 
        """
        Return TRUE if system coordinate system has been defined; FALSE by default.
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def MemoryLimitMiB(self) -> int: 
        """
        Return memory usage limit in MiB, -1 by default which means no limit.
        """
    def Metadata(self) -> OCP.TColStd.TColStd_IndexedDataMapOfStringString: 
        """
        Return metadata map.
        """
    @overload
    def Perform(self,theFile : OCP.TCollection.TCollection_AsciiString,theProgress : OCP.Message.Message_ProgressRange) -> bool: 
        """
        Open stream and pass it to Perform method. The Document instance should be set beforehand.

        Read the data from specified file.
        """
    @overload
    def Perform(self,theStream : io.BytesIO,theProgress : OCP.Message.Message_ProgressRange,theFile : OCP.TCollection.TCollection_AsciiString=OCP.TCollection.TCollection_AsciiString) -> bool: ...
    @overload
    def ProbeHeader(self,theFile : OCP.TCollection.TCollection_AsciiString,theProgress : OCP.Message.Message_ProgressRange=OCP.Message.Message_ProgressRange) -> bool: 
        """
        Open stream and pass it to ProbeHeader method.

        Read the header data from specified file without reading entire model. The main purpose is collecting metadata and external references - for copying model into a new location, for example. Can be NOT implemented (unsupported by format / reader).
        """
    @overload
    def ProbeHeader(self,theStream : io.BytesIO,theFile : OCP.TCollection.TCollection_AsciiString=OCP.TCollection.TCollection_AsciiString,theProgress : OCP.Message.Message_ProgressRange=OCP.Message.Message_ProgressRange) -> bool: ...
    def RootPrefix(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Return prefix for generating root labels names.
        """
    def SetCoordinateSystemConverter(self,theConverter : OCP.RWMesh.RWMesh_CoordinateSystemConverter) -> None: 
        """
        Set coordinate system converter.
        """
    def SetDocument(self,theDoc : OCP.TDocStd.TDocStd_Document) -> None: 
        """
        Set target document. Set system length unit according to the units of the document
        """
    @overload
    def SetFileCoordinateSystem(self,theCS : OCP.gp.gp_Ax3) -> None: ...
    @overload
    def SetFileCoordinateSystem(self,theCS : OCP.RWMesh.RWMesh_CoordinateSystem) -> None: ...
    def SetFileLengthUnit(self,theUnits : float) -> None: ...
    def SetFillIncompleteDocument(self,theToFillIncomplete : bool) -> None: 
        """
        Set flag allowing partially read file content to be put into the XDE document.
        """
    def SetMemoryLimitMiB(self,theLimitMiB : int) -> None: 
        """
        Set memory usage limit in MiB; can be ignored by reader implementation!
        """
    def SetRootPrefix(self,theRootPrefix : OCP.TCollection.TCollection_AsciiString) -> None: 
        """
        Set prefix for generating root labels names
        """
    @overload
    def SetSystemCoordinateSystem(self,theCS : OCP.gp.gp_Ax3) -> None: 
        """
        Set system origin coordinate system to perform conversion into during read.

        Set system origin coordinate system to perform conversion into during read.
        """
    @overload
    def SetSystemCoordinateSystem(self,theCS : OCP.RWMesh.RWMesh_CoordinateSystem) -> None: ...
    def SetSystemLengthUnit(self,theUnits : float) -> None: 
        """
        Set system length units to convert into while reading the file, defined as scale factor for m (meters).
        """
    def SingleShape(self) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Return result as a single shape.
        """
    def SystemCoordinateSystem(self) -> OCP.gp.gp_Ax3: 
        """
        Return system coordinate system; UNDEFINED by default, which means that no conversion will be done.
        """
    def SystemLengthUnit(self) -> float: 
        """
        Return the length unit to convert into while reading the file, defined as scale factor for m (meters); -1.0 by default, which means that NO conversion will be applied.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def ToFillIncompleteDocument(self) -> bool: 
        """
        Flag indicating if partially read file content should be put into the XDE document, TRUE by default.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class VrmlAPI_RepresentationOfShape():
    """
    Identifies the representation of the shape written to a VRML file. The available options are : - VrmlAPI_ShadedRepresentation : the shape is translated with a shaded representation. - VrmlAPI_WireFrameRepresentation : the shape is translated with a wireframe representation. - VrmlAPI_BothRepresentation : the shape is translated to VRML format with both representations : shaded and wireframe. This is the default option.

    Members:

      VrmlAPI_ShadedRepresentation

      VrmlAPI_WireFrameRepresentation

      VrmlAPI_BothRepresentation
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    VrmlAPI_BothRepresentation: OCP.VrmlAPI.VrmlAPI_RepresentationOfShape # value = <VrmlAPI_RepresentationOfShape.VrmlAPI_BothRepresentation: 2>
    VrmlAPI_ShadedRepresentation: OCP.VrmlAPI.VrmlAPI_RepresentationOfShape # value = <VrmlAPI_RepresentationOfShape.VrmlAPI_ShadedRepresentation: 0>
    VrmlAPI_WireFrameRepresentation: OCP.VrmlAPI.VrmlAPI_RepresentationOfShape # value = <VrmlAPI_RepresentationOfShape.VrmlAPI_WireFrameRepresentation: 1>
    __entries: dict # value = {'VrmlAPI_ShadedRepresentation': (<VrmlAPI_RepresentationOfShape.VrmlAPI_ShadedRepresentation: 0>, None), 'VrmlAPI_WireFrameRepresentation': (<VrmlAPI_RepresentationOfShape.VrmlAPI_WireFrameRepresentation: 1>, None), 'VrmlAPI_BothRepresentation': (<VrmlAPI_RepresentationOfShape.VrmlAPI_BothRepresentation: 2>, None)}
    __members__: dict # value = {'VrmlAPI_ShadedRepresentation': <VrmlAPI_RepresentationOfShape.VrmlAPI_ShadedRepresentation: 0>, 'VrmlAPI_WireFrameRepresentation': <VrmlAPI_RepresentationOfShape.VrmlAPI_WireFrameRepresentation: 1>, 'VrmlAPI_BothRepresentation': <VrmlAPI_RepresentationOfShape.VrmlAPI_BothRepresentation: 2>}
    pass
class VrmlAPI_Writer():
    """
    Creates and writes VRML files from Open CASCADE shapes. A VRML file can be written to an existing VRML file or to a new one.
    """
    def Drawer(self) -> VrmlConverter_Drawer: 
        """
        Returns drawer object
        """
    def GetFreeBoundsMaterial(self) -> OCP.Vrml.Vrml_Material: ...
    def GetFrontMaterial(self) -> OCP.Vrml.Vrml_Material: ...
    def GetLineMaterial(self) -> OCP.Vrml.Vrml_Material: ...
    def GetPointsMaterial(self) -> OCP.Vrml.Vrml_Material: ...
    def GetRepresentation(self) -> VrmlAPI_RepresentationOfShape: 
        """
        Returns the representation of the shape which is written to the VRML file. Types of representation are set through the VrmlAPI_RepresentationOfShape enumeration.
        """
    def GetUisoMaterial(self) -> OCP.Vrml.Vrml_Material: ...
    def GetUnfreeBoundsMaterial(self) -> OCP.Vrml.Vrml_Material: ...
    def GetVisoMaterial(self) -> OCP.Vrml.Vrml_Material: ...
    def GetWireMaterial(self) -> OCP.Vrml.Vrml_Material: ...
    def ResetToDefaults(self) -> None: 
        """
        Resets all parameters (representation, deflection) to their default values..
        """
    def SetAmbientColorToMaterial(self,aMaterial : OCP.Vrml.Vrml_Material,Color : OCP.Quantity.Quantity_HArray1OfColor) -> Any: ...
    def SetDeflection(self,aDef : float) -> None: 
        """
        Sets the deflection aDef of the mesh algorithm which is used to compute the shaded representation of the translated shape. The default value is -1. When the deflection value is less than 0, the deflection is calculated from the relative size of the shaped.
        """
    def SetDiffuseColorToMaterial(self,aMaterial : OCP.Vrml.Vrml_Material,Color : OCP.Quantity.Quantity_HArray1OfColor) -> Any: ...
    def SetEmissiveColorToMaterial(self,aMaterial : OCP.Vrml.Vrml_Material,Color : OCP.Quantity.Quantity_HArray1OfColor) -> Any: ...
    def SetRepresentation(self,aRep : VrmlAPI_RepresentationOfShape) -> None: 
        """
        Sets the representation of the shape aRep which is written to the VRML file. The three options are : - shaded - wireframe - both shaded and wireframe (default) defined through the VrmlAPI_RepresentationOfShape enumeration.
        """
    def SetShininessToMaterial(self,aMaterial : OCP.Vrml.Vrml_Material,aShininess : float) -> Any: ...
    def SetSpecularColorToMaterial(self,aMaterial : OCP.Vrml.Vrml_Material,Color : OCP.Quantity.Quantity_HArray1OfColor) -> Any: ...
    def SetTransparencyToMaterial(self,aMaterial : OCP.Vrml.Vrml_Material,aTransparency : float) -> Any: 
        """
        Set transparency to given material
        """
    def Write(self,aShape : OCP.TopoDS.TopoDS_Shape,aFile : str,aVersion : int=2) -> bool: 
        """
        Converts the shape aShape to VRML format of the passed version and writes it to the file identified by aFile.
        """
    def WriteDoc(self,theDoc : OCP.TDocStd.TDocStd_Document,theFile : str,theScale : float) -> bool: 
        """
        Converts the document to VRML format of the passed version and writes it to the file identified by aFile.
        """
    def __init__(self) -> None: ...
    pass
VrmlAPI_BothRepresentation: OCP.VrmlAPI.VrmlAPI_RepresentationOfShape # value = <VrmlAPI_RepresentationOfShape.VrmlAPI_BothRepresentation: 2>
VrmlAPI_ShadedRepresentation: OCP.VrmlAPI.VrmlAPI_RepresentationOfShape # value = <VrmlAPI_RepresentationOfShape.VrmlAPI_ShadedRepresentation: 0>
VrmlAPI_WireFrameRepresentation: OCP.VrmlAPI.VrmlAPI_RepresentationOfShape # value = <VrmlAPI_RepresentationOfShape.VrmlAPI_WireFrameRepresentation: 1>
