# Service: `com.robotraconteur.color`

The `com.robotraconteur.color` service provides definitions for representing colors in various formats.

### Standard Version

The standard version of this service is `0.10`.

## NamedArray: `ColorRGBA`

The `ColorRGBA` named array represents a color in RGBA format. Elements should vary between 0.0 and 1.0.

- `field double r`

    The red component of the color.

- `field double g`

    The green component of the color.

- `field double b`

    The blue component of the color.

- `field double a`

    The alpha (transparency) component of the color.

## NamedArray: `ColorRGBAf`

The `ColorRGBAf` named array represents a color in RGBA format using single-precision floating-point values.
Elements should vary between 0.0 and 1.0.

- `field single r`

    The red component of the color.

- `field single g`

    The green component of the color.

- `field single b`

    The blue component of the color.

- `field single a`

    The alpha (transparency) component of the color.

## NamedArray: `ColorRGBAu`

The `ColorRGBAu` named array represents a color in RGBA format using unsigned 8-bit integer values.

- `field uint8 r`

    The red component of the color.

- `field uint8 g`

    The green component of the color.

- `field uint8 b`

    The blue component of the color.

- `field uint8 a`

    The alpha (transparency) component of the color.

## NamedArray: `ColorRGBAh`

The `ColorRGBAh` named array represents a color in RGBA format using unsigned 16-bit integer values.

- `field uint16 r`

    The red component of the color.

- `field uint16 g`

    The green component of the color.

- `field uint16 b`

    The blue component of the color.

- `field uint16 a`

    The alpha (transparency) component of the color.

## NamedArray: `ColorRGB`

The `ColorRGB` named array represents a color in RGB format.

- `field double r`

    The red component of the color.

- `field double g`

    The green component of the color.

- `field double b`

    The blue component of the color.

## NamedArray: `ColorRGBf`

The `ColorRGBf` named array represents a color in RGB format using single-precision floating-point values between 0.0 and 1.0.

- `field single r`

    The red component of the color.

- `field single g`

    The green component of the color.

- `field single b`

    The blue component of the color.

## NamedArray: `ColorRGBu`

The `ColorRGBu` named array represents a color in RGB format using unsigned 8-bit integer values.

- `field uint8 r`

    The red component of the color.

- `field uint8 g`

    The green component of the color.

- `field uint8 b`

    The blue component of the color.

## NamedArray: `ColorRGBh`

The `ColorRGBh` named array represents a color in RGB format using unsigned 16-bit integer values.

- `field uint16 r`

    The red component of the color.

- `field uint16 g`

    The green component of the color.

- `field uint16 b`

    The blue component of the color
