# Copyright (C) 2012-2022 Apple Inc. All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
# THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
# BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
# THE POSSIBILITY OF SUCH DAMAGE.

buildProductsDirectory = ENV['BUILT_PRODUCTS_DIR'];
headersFolderPath = ENV['WK_LIBRARY_HEADERS_FOLDER_PATH'];
if buildProductsDirectory and File.exist?(buildProductsDirectory)
    $: << "#{buildProductsDirectory}#{headersFolderPath}/WebKitAdditions/Scripts"
end
sdkRootDirectory = ENV['SDKROOT'];
if sdkRootDirectory and File.exist?(sdkRootDirectory)
    $: << "#{sdkRootDirectory}#{headersFolderPath}/WebKitAdditions/Scripts"
end


$preferredCommentStartColumn = 40
$preferredDebugAnnotationColumns = 18


# Turns on dumping of the count of labels.
# For example,  the output will look like this:
#
#    ...
#    OFFLINE_ASM_LOCAL_LABEL(jsc_llint_4_functionArityCheck__continue)  // Local Label 24 .
#    ...
#    OFFLINE_ASM_GLOBAL_LABEL(llint_op_enter)  // Global Label 8 .
#    ...
#
$enableLabelCountComments = false

# Turns on dumping of source file and line numbers in the output file.
# For example,  the output will look like this:
#
#    ...
#    "\tmovq -8(%r13), %rcx\n"   // JavaScriptCore/llint/LowLevelInterpreter64.asm:185
#    "\tmovl 52(%rcx), %ecx\n"   // JavaScriptCore/llint/LowLevelInterpreter64.asm:186
#    ...
#
$enableCodeOriginComments = true

# Turns on recording and dumping of annotations in the generated output file.
# An annotations can be specified for each instruction in the source asm files.
# For example, the output will look like this:
#
#     ...
#    "\tmovq -8(%r13), %rcx\n"   // t2<CodeBlock> = cfr.CodeBlock
#    "\tmovl 52(%rcx), %ecx\n"   // t2<size_t> = t2<CodeBlock>.m_numVars
#     ...
#
$enableInstrAnnotations = false

# Turns on generation of DWARF2 debug annotions for file and line numbers.
# Allows for source level debuging of the original .asm files in a debugger.
#
def shouldEnableDebugAnnotations()
    if ENV['GCC_VERSION'] =~ /\.clang\./ and ENV['DT_TOOLCHAIN_DIR'] =~ /Xcode.app/
        clangVersionOut = %x`xcrun clang --version`
        if ($? == 0)
            # Apple clang version 800.0.12 or higher is required for debug annotations.
            versionMatch = /clang-(\d{3,})\.(\d{1,3})\.(\d{1,3})(\.(\d{1,3}))?/.match(clangVersionOut)
            if versionMatch and versionMatch.length >= 4
                totalVersion = versionMatch[1].to_i * 1000000 + versionMatch[2].to_i * 1000 + versionMatch[3].to_i
                if totalVersion >= 800000012
                    return true
                end
            end
            # For locally-built, open source clang returning "clang version 5.0.0".
            versionMatch = /clang version (\d{1,3})\.(\d{1,3})\.(\d{1,3})/.match(clangVersionOut)
            if versionMatch and versionMatch.length >= 4
                if versionMatch[1].to_i >= 5
                    return true
                end
            end
        end
    elsif ENV["CMAKE_CXX_COMPILER_ID"] == 'GNU' and
         ENV["GCC_OFFLINEASM_SOURCE_MAP"] == 'ON'
      # All GCC versions that can build JSC support debug annotations
      return true
    end

    false
end

$enableDebugAnnotations = shouldEnableDebugAnnotations()
