#include "translation/common.h"
#include "translation/translation.h"

static translation_string all_strings[] = {
    {TR_NO_PATCH_TITLE, "Patch 1.0.1.0 ist nicht installiert"},
    {TR_NO_PATCH_MESSAGE,
        "Deine Caesar 3 Installation wurde noch nicht auf Version 1.0.1.0 aktualisiert. "
        "Der Patch kann hier heruntergeladen werden:\n"
        URL_PATCHES "\n"
        "Fortfahren auf eigene Gefahr."},
    {TR_MISSING_FONTS_TITLE, "Schriftarten fehlen"},
    {TR_MISSING_FONTS_MESSAGE,
        "Deine Caesar 3 Installation benötigt zusätzliche Schriftarten. "
        "Du kannst Schriftarten für deine Sprache hier herunterladen:\n"
        URL_PATCHES},
    {TR_NO_EDITOR_TITLE, "Editor nicht installiert"},
    {TR_NO_EDITOR_MESSAGE,
        "Deiner Caesar 3 Installation fehlen die Dateien für den Editor. "
        "Du kannst die fehlenden Dateien hier herunterladen:\n"
        URL_EDITOR},
    {TR_INVALID_LANGUAGE_TITLE, "Ungültiges Sprachverzeichnis"},
    {TR_INVALID_LANGUAGE_MESSAGE,
        "Das gewählte Verzeichnis enthält kein gültiges Sprachpaket. "
        "Bitte überprüfe das Protokoll auf Fehler."},
    /* System - Spielstand */
    {TR_SAVEGAME_LARGER_VERSION_TITLE, "Inkompatible Speicherstand-Version"},
    {TR_SAVEGAME_LARGER_VERSION_MESSAGE, "Der Speicherstand, den Sie zu laden versuchen, ist für eine neuere Version von Augustus.\n Bitte aktualisieren Sie Augustus auf die neueste Version."},
    {TR_SAVEGAME_NOT_ABLE_TO_SAVE_TITLE, "Spiel kann nicht gespeichert werden"},
    {TR_SAVEGAME_NOT_ABLE_TO_SAVE_MESSAGE, "Es war nicht möglich, das Spiel zu speichern.\n"
        "Es könnte daran liegen, dass der Ordner, in dem Caesar 3 die Spielstände speichert, Administratorrechte erfordert.\n"
        "Bitte verschieben Sie entweder den Caesar-3-Ordner an einen Ort, der keinen Administrator-Zugang erfordert, oder führen Sie Augustus als Administrator aus (nicht empfohlen)."},
    {TR_SAVE_DIALOG_INVALID_FILE, "Ungültige Datei"},
	{TR_SAVE_DIALOG_INVALID_FILE_DESC, "Der Spielstand, den Sie zu laden versuchen, ist ungültig.\n\nDer Spielstand wurde möglicherweise aufgrund eines Fehlers beschädigt.\n\nWenn Sie sich sicher sind, dass dies ein gültiger Spielstand sein sollte, melden Sie den Fehler bitte an:\n\nhttps://github.com/Keriew/augustus/issues/new\n\nBitte fügen Sie auch den Spielstand als Datei hinzu."},
    {TR_SAVE_DIALOG_INCOMPATIBLE_VERSION, "Inkompatible Version" },
    {TR_SAVE_DIALOG_NEW_FILE, "Neue Datei"},
	{TR_SAVE_DIALOG_SELECT_FILE, "Eine Datei auswählen"},
    {TR_SAVE_DIALOG_FUNDS, "Gelder:"},
    {TR_SAVE_DIALOG_POPULATION, "Bevölkerung:"},
    {TR_SAVE_DIALOG_DATE, "Datum:"},
    {TR_SAVE_DIALOG_CUSTOM_SCENARIO, "Benutzerdefiniertes Szenario"},
    {TR_SAVE_DIALOG_FIRST_MISSION, "Erster Auftrag"},
    {TR_SAVE_DIALOG_MISSION, "Auftrag"},
    {TR_SAVE_DIALOG_MILITARY, "militärisch"},
    {TR_SAVE_DIALOG_PEACEFUL, "friedlich"},
    {TR_SAVE_DIALOG_FILTER, "Filter"},
    {TR_SAVE_DIALOG_SORTING_BY_NAME, "Sortierung nach Namen"},
    {TR_SAVE_DIALOG_SORTING_BY_DATE, "Sortierung nach Datum"},
    {TR_SAVE_DIALOG_OVERWRITE_FILE, "Datei überschreiben?"},
    {TR_SAVE_DIALOG_OVERWRITE_FILE_DESC, "Die Datei existiert bereits. Überschreiben?"},
    {TR_SAVE_DIALOG_OVERWRITE_FILE_DO_NOT_ASK_AGAIN, "Nicht mehr fragen"},
    /* Menüs */
    {TR_BUILDING_MENU_STATUES, "Statuen"},
    {TR_BUILDING_MENU_GOV_RES, "Gouverneursanwesen"},
    {TR_BUILDING_MENU_TREES, "Bäume"},
    {TR_BUILDING_MENU_PATHS, "Pfade"},
    {TR_BUILDING_MENU_PARKS, "Parkanlagen"},
    {TR_AUTO_CYCLE_TEMPLES, "Automatisch durchschalten"},
    {TR_BUTTON_OK, "OK"},
    {TR_BUTTON_CANCEL, "Abbrechen"},
    {TR_BUTTON_RESET_DEFAULTS, "Zurücksetzen"},
    {TR_BUTTON_CONFIGURE_HOTKEYS, "Schnelltasten"},
    {TR_BUTTON_BACK_TO_MAIN_MENU, "Zurück zum Hauptmenü"},
    {TR_BUTTON_GO_TO_SITE, "Geht zum Standort"},
    {TR_BUTTON_HALT_MONUMENT_CONSTRUCTION, "Bau stoppen"},
    {TR_BUTTON_RESUME_MONUMENT_CONSTRUCTION, "Bau wiederaufnehmen"},
    {TR_BUTTON_YEARLY_AUTOSAVE_OFF, "Jährliche automatische Speicherung AUS"},
    {TR_BUTTON_YEARLY_AUTOSAVE_ON, "Jährliche automatische Speicherung AN"},
    {TR_LABEL_PAUSE_MENU, "Pause"},
    {TR_HEADER_HOUSING, "Wohnungsberater"},
	/* Asset Vorschau */
    {TR_WINDOW_ASSET_PREVIEWER_TITLE, "Asset-Vorschau"},
    {TR_WINDOW_ASSET_PREVIEWER_GROUP, "Gruppe:"},
    {TR_WINDOW_ASSET_PREVIEWER_NO_GROUPS, "(keine Gruppen)"},
    {TR_WINDOW_ASSET_PREVIEWER_TERRAIN, "Gelände:"},
    {TR_WINDOW_ASSET_PREVIEWER_PLAY_ANIMATIONS, "Animationen abspielen"},
    {TR_WINDOW_ASSET_PREVIEWER_REFRESH, "Aktualisieren"},
    {TR_WINDOW_ASSET_PREVIEWER_QUIT, "Beenden"},
    {TR_WINDOW_ASSET_PREVIEWER_ASSET, "Asset: "},
    {TR_WINDOW_ASSET_PREVIEWER_TERRAIN_NONE, "Keine"},
    {TR_WINDOW_ASSET_PREVIEWER_TERRAIN_CENTRAL, "Zentral"},
    {TR_WINDOW_ASSET_PREVIEWER_TERRAIN_NORTHERN, "Nördlich"},
    {TR_WINDOW_ASSET_PREVIEWER_TERRAIN_DESERT, "Wüste"},
    {TR_WINDOW_ASSET_PREVIEWER_NO_ASSETS, "Keine Assets"},
    {TR_WINDOW_ASSET_PREVIEWER_UNNAMED_ASSET, "( unbenanntes Asset )"},
    {TR_WINDOW_ASSET_PREVIEWER_ANIMATION_FRAME, "( Animationsbild )"},
    {TR_WINDOW_ASSET_PREVIEWER_SHOW_ANIMATION_FRAMES, "Animationsbilder anzeigen"},
    {TR_WINDOW_ASSET_PREVIEWER_ASSETS_REFRESHED, "Assets aktualisiert"},
	/* Einstellungen */
    {TR_CONFIG_ALL_HOUSES_MERGE, "Alle Häuser verschmelzen"},
    {TR_CONFIG_ALLOW_CYCLING_TEMPLES, "Erlaube alle Tempel nacheinander zu bauen"},
    {TR_CONFIG_ALLOW_EXPORTING_FROM_GRANARIES, "Erlaube Händlern Nahrung von Silos zu exportieren"},
    {TR_CONFIG_ARE_YOU_SURE, "Auf Standard zurücksetzen?"},
    {TR_CONFIG_AUDIO, "Audio Optionen"},
    {TR_CONFIG_AUTO_KILL_ANIMALS, "Einwohner werden automatisch harmlose Tiere töten"},
    {TR_CONFIG_CITY_SOUNDS, "Stadtgeräusche einschalten"},
    {TR_CONFIG_COMPLETE_RATING_COLUMNS, "Behebe unvollständige Bewertungsspalten bei geringen Zielen"},
    {TR_CONFIG_CURSOR_SCALE, "Skalierung des Mauszeigers:"},
    {TR_CONFIG_DELIVER_ONLY_TO_ACCEPTING_GRANARIES, "Nahrung wird nicht an fordernde Silos geliefert"},
    {TR_CONFIG_DIFFICULTY, "Schwierigkeit:"},
    {TR_CONFIG_DIGIT_SEPARATOR, "Zahlen separieren"},
    {TR_CONFIG_DISABLE_MOUSE_EDGE_SCROLLING, "Verschieben der Karte am Fensterrand deaktivieren"},
    {TR_CONFIG_DISABLE_RIGHT_CLICK_MAP_DRAG, "Verschieben der Karte mit der rechten Maustaste deaktivieren"},
    {TR_CONFIG_DISPLAY_SCALE, "Skalierung der Anzeige:"},
    {TR_CONFIG_DRAW_CLOUD_SHADOWS, "Wolkenschatten"},
    {TR_CONFIG_DYNAMIC_GRANARIES, "Blockiere getrennte Straßen eines Silos"},
    {TR_CONFIG_EFFECTS, "Soundeffekte einschalten"},
    {TR_CONFIG_ENABLE_AUDIO, "Audio einschalten"},
    {TR_CONFIG_EXTRA_FORTS, "Ermögliche das Bauen 4 zusätzlicher Forts"},
    {TR_CONFIG_FARMS_DELIVER_CLOSE, "Farmen und Kais liefern nur an nahegelegene Silos"},
    {TR_CONFIG_FIX_100_YEAR_GHOSTS, "Behebe '100 Jahre alte Geister'"},
    {TR_CONFIG_FIX_EDITOR_EVENTS, "Behebe Wechsel- und Überlebenszeit des Imperators in eigenen Missionen"},
    {TR_CONFIG_FIX_IMMIGRATION_BUG, "Behebe Immigrationsfehler auf 'Sehr schwierig'"},
    {TR_CONFIG_FIXED_WORKERS, "Fester Arbeiterpool - 38 % der Bevölkerung"},
    {TR_CONFIG_FULLSCREEN, "Vollbild"},
    {TR_CONFIG_GAME_SPEED, "Spielgeschwindigkeit:"},
    {TR_CONFIG_GETTING_GRANARIES_GO_OFFROAD, "Karrenschieber fordernder Silos laufen auch abseits der Straße"},
    {TR_CONFIG_GLOBAL_LABOUR, "Aktiviere globalen Arbeiterpool"},
    {TR_CONFIG_GODS_EFFECTS, "Götterflüche/-segnungen aktivieren"},
    {TR_CONFIG_GP_CH_DISABLE_INFINITE_WOLVES_SPAWNING, "Deaktiviere unendliches Erscheinen von Wölfen"},
    {TR_CONFIG_GP_CH_MONUMENTS_BOOST_CULTURE_RATING, "Abgeschlossene Prachttempel gewähren eine Kulturbewertung von +6"},
    {TR_CONFIG_GRANARIES_GET_DOUBLE, "Doppelte Kapazität für Karrenschieber fordernder Silos"},
    {TR_CONFIG_GRANDFESTIVAL, "Große Feste ermöglichen einen zusätzlichen Segen von einem Gott"},
    {TR_CONFIG_HEADER_CITY_MANAGEMENT_CHANGES, "Stadtverwaltung"},
    {TR_CONFIG_HEADER_GAMEPLAY_CHANGES, "Schwierigkeit"},
    {TR_CONFIG_HEADER_GENERAL, "Allgemeine Einstellungen"},
    {TR_CONFIG_HEADER_UI_CHANGES, "Benutzeroberfläche"},
    {TR_CONFIG_HIGHLIGHT_LEGIONS, "Hebe Soldaten bei Berührung mit der Maus hervor"},
    {TR_CONFIG_HOUSES_DONT_EXPAND_INTO_GARDENS, "Häuser erweitern sich nicht in Gärten"},
    {TR_CONFIG_IMMEDIATELY_DELETE_BUILDINGS, "Gebäude sofort zerstören"},
    {TR_CONFIG_INFINITE, "Unendlich"},
    {TR_CONFIG_JEALOUS_GODS, "Deaktiviere Eifersucht der Götter"},
    {TR_CONFIG_LANGUAGE_DEFAULT, "(Standard)"},
    {TR_CONFIG_LANGUAGE_LABEL, "Sprache:"},
    {TR_CONFIG_MAX_GRAND_TEMPLES, "Maximale Anzahl von Prachttempeln pro Stadt: "},
    {TR_CONFIG_MORE_STOCKPILE, "Häuser horten mehr Güter von Märkten"},
    {TR_CONFIG_MULTIPLE_BARRACKS, "Erlaube das Errichten mehrerer Kasernen"},
    {TR_CONFIG_MUSIC, "Musik einschalten"},
    {TR_CONFIG_NO_SUPPLIER_DISTRIBUTION, "Einkaufende Marktfrauen verteilen keine Güter"},
    {TR_CONFIG_NOT_ACCEPTING_WAREHOUSES, "Lagerhäuser nehmen nach dem Bau nichts an"},
    {TR_CONFIG_RANDOM_COLLAPSES_TAKE_MONEY, "Einstürzende Lehmgruben und Eisenminen kosten Geld"},
    {TR_CONFIG_RETIRE_AT_60, "Erhöhe Rentenalter von 50 auf 60 Jahre"},
    {TR_CONFIG_ROAMERS_DONT_SKIP_CORNERS, "Wandernde Arbeiter kürzen an Ecken nicht ab"},
    {TR_CONFIG_ROTATE_MANUALLY, "Drehe Torhaus und Triumphbogen mit Schnelltaste"},
    {TR_CONFIG_SCHOOL_WALKERS, "Vergrößere Laufreichweite von Schülern"},
    {TR_CONFIG_SCROLL_SPEED, "Scrollgeschwindigkeit:"},
    {TR_CONFIG_SHOW_CONSTRUCTION_SIZE, "Zeige Konstruktionsgröße beim Bauen"},
    {TR_CONFIG_SHOW_INTRO_VIDEO, "Intro-Videos abspielen"},
    {TR_CONFIG_SHOW_MARKET_RANGE, "Zeige die Reichweite beim Bau von Märkten" },
    {TR_CONFIG_SHOW_MAX_POSSIBLE_PROSPERITY, "Anzeige des maximalen Wohlstands mit aktuellen Behausungen."},
    {TR_CONFIG_SHOW_MILITARY_SIDEBAR, "Zeige Legionen am rechten Bildschirmrand"},
    {TR_CONFIG_SHOW_ROAMING_PATH, "Vorschau für Wege der Wanderer" },
    {TR_CONFIG_SHOW_WATER_STRUCTURE_RANGE, "Zeige Reichweite beim Bauen von Reservoirs und Brunnen"},
    {TR_CONFIG_SHOW_WATER_STRUCTURE_RANGE_HOUSES, "Beim Bau die Reichweite von Brunnen anzeigen"},
    {TR_CONFIG_SIDEBAR_INFO, "Zusätzliche Informationen am rechten Bildschirmrand anzeigen"},
    {TR_CONFIG_SMOOTH_SCROLLING, "Sanftes Scrollen aktivieren"},
    {TR_CONFIG_SPEECH, "Sprache einschalten"},
    {TR_CONFIG_TITLE, "Augustus Einstellungen"},
    {TR_CONFIG_TOWER_SENTRIES_GO_OFFROAD, "Wachtürme brauchen keine Straßenverbindung zu einer Kaserne"},
    {TR_CONFIG_UI_ALWAYS_SHOW_ROTATION_BUTTONS, "Rotationsschaltflächen immer anzeigen"},
    {TR_CONFIG_UI_INVERSE_MAP_DRAG, "Invertiertes Ziehen der Karte mit der rechten Maustaste"},
    {TR_CONFIG_UI_MESSAGE_ALERTS, "Neue Nachrichten als Warnungen statt als Popups anzeigen"},
    {TR_CONFIG_UI_SHOW_GRID, "Zeige Bauraster"},
    {TR_CONFIG_UI_SHOW_PARTIAL_GRID_AROUND_CONSTRUCTION, "Teilraster um Gebäude anzeigen"},
    {TR_CONFIG_USE_COLOR_CURSORS, "Verwende farbige Mauszeiger"},
    {TR_CONFIG_VIDEO, "Videoauflösung"},
    {TR_CONFIG_VIDEO_SOUND, "Videoton einschalten"},
    {TR_CONFIG_VISUAL_FEEDBACK_ON_DELETE, "Das visuelle Feedback beim Planieren verbessern"},
    {TR_CONFIG_VOLUME, "Lautstärke"},
    {TR_CONFIG_WINDOWED_RESOLUTION, "Auflösung Fenstermodus:"},
    {TR_CONFIG_WINE_COUNTS_IF_OPEN_TRADE_ROUTE, "Das Öffnen einer Handelsroute stellt eine andere Weinsorte bereit"},
    {TR_CONFIG_WOLVES_BLOCK, "Blockiere Gebäude in der Nähe von Wölfen"},
    {TR_CONFIG_YOU_WILL_LOSE_YOUR_CONFIGS, "Sie verlieren all Ihre benutzerdefinierten Konfigurationen."},
    {TR_CONFIG_YOU_WILL_LOSE_YOUR_HOTKEYS, "Sie verlieren all Ihre benutzerdefinierten Schnelltasten."},
	/* Sidebar */	
	{TR_SIDEBAR_EXTRA_INVASIONS, "Invasionen"},
    {TR_SIDEBAR_EXTRA_INVASION_UNDERWAY, "Invasion im Gange"},
    {TR_SIDEBAR_EXTRA_NO_INVASIONS, "Keine Invasionen"},
    {TR_SIDEBAR_EXTRA_INVASION_IMMINENT, "Invasion steht bevor"},
    {TR_SIDEBAR_EXTRA_ENEMIES_CLOSING, "Feinde nähern sich"},
    {TR_SIDEBAR_EXTRA_ENEMIES_DISTANT, "Feinde weit entfernt"},
    {TR_SIDEBAR_EXTRA_GODS, "Götter"},
    {TR_SIDEBAR_EXTRA_REQUESTS_VIEW_ALL, "Alle anzeigen"},
    {TR_SIDEBAR_EXTRA_REQUESTS_SMALL_FORCE, "kleine Armee"},
    {TR_SIDEBAR_EXTRA_REQUESTS_AVERAGE_FORCE, "mittelgroße Armee"},
    {TR_SIDEBAR_EXTRA_REQUESTS_LARGE_FORCE, "große Armee"},
    {TR_SIDEBAR_EXTRA_REQUESTS_SEND, "Anfrage senden"},
    {TR_SIDEBAR_EXTRA_REQUESTS_STOCK, "Einlagern"},
    {TR_SIDEBAR_EXTRA_REQUESTS_UNSTOCK, "Einlagerung stoppen"},
    // Transkription von mission_exact4.wav
    {TR_PHRASE_FIGURE_MISSIONARY_EXACT_4, "\"Ich werde tun, was ich kann, um diese Barbaren zu beruhigen. Ich bin sicher, dass sie ihre Angriffe auf die Stadt einstellen werden, wenn ich einfach nur mit ihnen spreche.\""},
	/* Hotkeys/Schnelltasten */
    {TR_HOTKEY_ALTERNATIVE_LABEL, "Alternativ"},
    {TR_HOTKEY_ARROW_DOWN, "Runter"},
    {TR_HOTKEY_ARROW_LEFT, "Links"},
    {TR_HOTKEY_ARROW_RIGHT, "Rechts"},
    {TR_HOTKEY_ARROW_UP, "Hoch"},
    {TR_HOTKEY_BUILD_CLONE, "Gebäude am Mauszeiger klonen"},
    {TR_HOTKEY_BUILD_HIGHWAY, "Schnellstraße"},
    {TR_HOTKEY_BUILD_WHEAT_FARM, "Weizen Farm"},
    {TR_HOTKEY_CENTER_WINDOW, "Fenster zentrieren"},
    {TR_HOTKEY_COPY_SETTINGS, "Gebäudeeinstellungen kopieren"},
    {TR_HOTKEY_CYCLE_LEGION, "Durch Legionen schalten"},
    {TR_HOTKEY_DECREASE_GAME_SPEED, "Spielgeschwindigkeit reduzieren"},
    {TR_HOTKEY_DUPLICATE_MESSAGE, "Diese Schnelltaste ist bereits folgender Aktion zugewiesen:"},
    {TR_HOTKEY_DUPLICATE_TITLE, "Schnelltaste bereits in Verwendung"},
    {TR_HOTKEY_EDIT_TITLE, "Neue Schnelltasten"},
    {TR_HOTKEY_EDITOR_TOGGLE_BATTLE_INFO, "Kampfinfos ein-/ausblenden"},
    {TR_HOTKEY_GO_TO_BOOKMARK_1, "Gehe zu Lesezeichen 1"},
    {TR_HOTKEY_GO_TO_BOOKMARK_2, "Gehe zu Lesezeichen 2"},
    {TR_HOTKEY_GO_TO_BOOKMARK_3, "Gehe zu Lesezeichen 3"},
    {TR_HOTKEY_GO_TO_BOOKMARK_4, "Gehe zu Lesezeichen 4"},
    {TR_HOTKEY_HEADER_ADVISORS, "Berater"},
    {TR_HOTKEY_HEADER_ARROWS, "Richtungstasten"},
    {TR_HOTKEY_HEADER_BOOKMARKS, "Lesezeichen für Stadtkarten"},
    {TR_HOTKEY_HEADER_BUILD, "Schnelltasten zum Bauen"},
    {TR_HOTKEY_HEADER_CITY, "Stadt"},
    {TR_HOTKEY_HEADER_EDITOR, "Editor"},
    {TR_HOTKEY_HEADER_GLOBAL, "Globale Schnelltasten"},
    {TR_HOTKEY_HEADER_OVERLAYS, "Spezialkarten"},
    {TR_HOTKEY_INCREASE_GAME_SPEED, "Spielgeschwindigkeit erhöhen"},
    {TR_HOTKEY_LABEL, "Schnelltasten"},
    {TR_HOTKEY_LOAD_FILE, "Datei laden"},
    {TR_HOTKEY_MOTHBALL_TOGGLE, "Einmotten" },
    {TR_HOTKEY_PASTE_SETTINGS, "Gebäudeeinstellungen übertragen"},
    {TR_HOTKEY_RESET_ZOOM, "Zoom zurücksetzen"},
    {TR_HOTKEY_RESIZE_TO_1024, "Fenstergröße: 1024x768"},
    {TR_HOTKEY_RESIZE_TO_640, "Fenstergröße: 640x480"},
    {TR_HOTKEY_RESIZE_TO_800, "Fenstergröße: 800x600"},
    {TR_HOTKEY_ROTATE_BUILDING, "Gebäude drehen"},
    {TR_HOTKEY_ROTATE_BUILDING_BACK, "Vorherige Gebäudeorientierung"},
    {TR_HOTKEY_ROTATE_MAP_LEFT, "Karte nach links drehen"},
    {TR_HOTKEY_ROTATE_MAP_NORTH, "Karte nach Norden drehenh"},
    {TR_HOTKEY_ROTATE_MAP_RIGHT, "Karte nach rechts drehen"},
    {TR_HOTKEY_SAVE_CITY_SCREENSHOT, "Stadtweiten Screenshot sp."},
    {TR_HOTKEY_SAVE_FILE, "Datei speichern"},
    {TR_HOTKEY_SAVE_MINIMAP_SCREENSHOT, "Minimap Screenshot speichern"},
    {TR_HOTKEY_SAVE_SCREENSHOT, "Screenshot speichern"},
    {TR_HOTKEY_SET_BOOKMARK_1, "Setze Lesezeichen 1"},
    {TR_HOTKEY_SET_BOOKMARK_2, "Setze Lesezeichen 2"},
    {TR_HOTKEY_SET_BOOKMARK_3, "Setze Lesezeichen 3"},
    {TR_HOTKEY_SET_BOOKMARK_4, "Setze Lesezeichen 4"},
    {TR_HOTKEY_SHOW_ADVISOR_CHIEF, "Hauptberater"},
    {TR_HOTKEY_SHOW_ADVISOR_EDUCATION, "Bildungsbearter"},
    {TR_HOTKEY_SHOW_ADVISOR_ENTERTAINMENT, "Unterhaltungsberater"},
    {TR_HOTKEY_SHOW_ADVISOR_FINANCIAL, "Finanzberater"},
    {TR_HOTKEY_SHOW_ADVISOR_HEALTH, "Gesundheitsberater"},
    {TR_HOTKEY_SHOW_ADVISOR_HOUSING, "Wohnraumberater"},
    {TR_HOTKEY_SHOW_ADVISOR_IMPERIAL, "Imperiumsberater"},
    {TR_HOTKEY_SHOW_ADVISOR_LABOR, "Arbeitsberater"},
    {TR_HOTKEY_SHOW_ADVISOR_MILITARY, "Militärberater"},
    {TR_HOTKEY_SHOW_ADVISOR_POPULATION, "Bevölkerungsberater"},
    {TR_HOTKEY_SHOW_ADVISOR_RATINGS, "Wertungsberater"},
    {TR_HOTKEY_SHOW_ADVISOR_RELIGION, "Religionsberater"},
    {TR_HOTKEY_SHOW_ADVISOR_TRADE, "Handelsberater"},
    {TR_HOTKEY_SHOW_EMPIRE_MAP, "Zeige Imperiumskarte"},
    {TR_HOTKEY_SHOW_MESSAGES, "Zeige Nachrichten"},
    {TR_HOTKEY_SHOW_OVERLAY_ACADEMY, "Akademienkarte"},
    {TR_HOTKEY_SHOW_OVERLAY_BARBER, "Barbierkarte"},
    {TR_HOTKEY_SHOW_OVERLAY_BATHHOUSE, "Badehäuserkarte"},
    {TR_HOTKEY_SHOW_OVERLAY_CLINIC, "Klinikenkarte"},
    {TR_HOTKEY_SHOW_OVERLAY_CRIME, "Kriminalitätskarte"},
    {TR_HOTKEY_SHOW_OVERLAY_DAMAGE, "Schadenskarte"},
    {TR_HOTKEY_SHOW_OVERLAY_DESIRABILITY, "Attraktivitätskarte"},
    {TR_HOTKEY_SHOW_OVERLAY_EDUCATION, "Bildungskarte"},
    {TR_HOTKEY_SHOW_OVERLAY_EFFICIENCY, "Effizientskarte" },
    {TR_HOTKEY_SHOW_OVERLAY_ENTERTAINMENT, "Unterhaltungskarte"},
    {TR_HOTKEY_SHOW_OVERLAY_FIRE, "Feuerkarte"},
    {TR_HOTKEY_SHOW_OVERLAY_FOOD_STOCKS, "Nahrungsvorrätekarte"},
    {TR_HOTKEY_SHOW_OVERLAY_HOSPITAL, "Krankenhauskarte"},
    {TR_HOTKEY_SHOW_OVERLAY_LEVY, "Abgabenkarte"},
    {TR_HOTKEY_SHOW_OVERLAY_LIBRARY, "Bibliothekenkarte"},
    {TR_HOTKEY_SHOW_OVERLAY_MOTHBALL, "Eingemottet-Karte"},
    {TR_HOTKEY_SHOW_OVERLAY_PROBLEMS, "Problemkarte"},
    {TR_HOTKEY_SHOW_OVERLAY_RELATIVE, "Zeige relative Spezialkarte"},
    {TR_HOTKEY_SHOW_OVERLAY_RELIGION, "Religionskarte"},
    {TR_HOTKEY_SHOW_OVERLAY_RISKS_NATIVE, "Eingeborenenkarte"},
    {TR_HOTKEY_SHOW_OVERLAY_ROADS, "Straßenkarte"},
    {TR_HOTKEY_SHOW_OVERLAY_SCHOOL, "Schulenkarte"},
    {TR_HOTKEY_SHOW_OVERLAY_SENTIMENT, "Stimmungskarte"},
    {TR_HOTKEY_SHOW_OVERLAY_SICKNESS, "Krankheitenkarte"},
    {TR_HOTKEY_SHOW_OVERLAY_TAX_INCOME, "Steuernkarte"},
    {TR_HOTKEY_SHOW_OVERLAY_WATER, "Wasserkarte"},
    {TR_HOTKEY_SPECIAL_ORDERS, "Öffne Besondere Befehle" },
    {TR_HOTKEY_TITLE, "Augustus Schnelltasten"},
    {TR_HOTKEY_TOGGLE_FULLSCREEN, "Vollbild ein-/ausschalten"},
    {TR_HOTKEY_TOGGLE_OVERLAY, "Akt. Spezialkarte umschalten"},
    {TR_HOTKEY_TOGGLE_PAUSE, "Spiel pausieren"},
    {TR_HOTKEY_ZOOM_IN, "Reinzoomen"},
    {TR_HOTKEY_ZOOM_OUT, "Rauszoomen"},
	/* Cheats */
    {TR_CHEAT_ADDED_MONEY, "Geld hinzugefügt"},
    {TR_CHEAT_STARTED_INVASION, "Invasion gestartet"},
    {TR_CHEAT_YEAR_ADVANCED, "Jahr fortgeschritten"},
    {TR_CHEAT_CASTED_BLESSING, "Segen gesprochen"},
    {TR_CHEAT_TOGGLE_TOOLTIPS, "Tooltip anzeigen umgeschaltet"},
    {TR_CHEAT_KILLED_ALL_WALKERS, "Alle Wanderer getötet"},
    {TR_CHEAT_FINISHED_MONUMENTS, "Monumente vollendet"},
    {TR_CHEAT_UPDATED_MONUMENTS, "Monumente aktualisiert"},
    {TR_CHEAT_UNLOCKED_ALL_BUILDINGS, "Alle Gebäude freigeschaltet"},
    {TR_CHEAT_INCITED_RIOT, "Aufstand angezettelt"},
	/* Spezialkarten */
    {TR_OVERLAY_ARENA_COL, "Arena"},
    {TR_OVERLAY_EFFICIENCY, "Effizienz" },
    {TR_OVERLAY_ENEMY, "Feinde"},
    {TR_OVERLAY_LEVY, "Abgaben"},
    {TR_OVERLAY_MOTHBALL, "Eingemottet"},
    {TR_OVERLAY_ROADS, "Straßen"},
    {TR_OVERLAY_SENTIMENT, "Stimmung"},
    {TR_OVERLAY_SICKNESS, "Krankheit"},
    {TR_OVERLAY_TAVERN, "Taverne"},
    {TR_OVERLAY_WAREHOUSES, "Lagerhäuser"},
	/* Warnungen */
    {TR_CITY_WARNING_BUILD_GOLD_MINE, "Baue eine Goldmine" },
    {TR_CITY_WARNING_BUILD_SAND_PIT, "Baue eine Sandgrube"},
    {TR_CITY_WARNING_BUILD_SENATE, "Baue einen Senat" },
    {TR_CITY_WARNING_BUILD_STONE_QUARRY, "Baue einen Steinbruch."},
    {TR_CITY_WARNING_GOLD_NEEDED, "Das Gebäude braucht Gold." },
    {TR_CITY_WARNING_SAND_NEEDED, "Das Gebäude braucht Sand."},
    {TR_CITY_WARNING_SENATE_NEEDED, "Dieses Gebäude braucht einen funktionierenden Senat" },
    {TR_CITY_WARNING_STONE_NEEDED, "Das Gebäude braucht Stein."},
    {TR_CITY_WARNING_DATA_COPY_SUCCESS, "Einstellungen kopiert"},
    {TR_CITY_WARNING_DATA_COPY_NOT_SUPPORTED, "Von diesem Gebäude kann nicht kopiert werden"},
    {TR_CITY_WARNING_DATA_PASTE_SUCCESS, "Einstellungen eingefügt"},
    {TR_CITY_WARNING_DATA_PASTE_NOT_SUPPORTED, "Kann nicht eingefügt werden"},
    {TR_CITY_WARNING_DATA_MOTHBALL_ON, "Gebäude stillgelegt" },
    {TR_CITY_WARNING_DATA_MOTHBALL_OFF, "Gebäude wieder aktiv" },
    {TR_CITY_WARNING_SECESSION, "Plebejer verweigern die Arbeit!"},
    {TR_CITY_WARNING_WAREHOUSE_BREAKIN, "Ein Lagerhaus wurde geplündert!"},
    {TR_CITY_WARNING_GRANARY_BREAKIN, "Ein Silo wurde geplündert!"},
    {TR_CITY_WARNING_THEFT, "Gelder wurden aus einem Forum oder dem Senat gestohlen!"},
    {TR_WARNING_MAX_GRAND_TEMPLES, "In einer Stadt können nur zwei Prachttempel gebaut werden."},
    {TR_WARNING_NO_MESS_HALL, "Ihr müsst zunächst einen Versorgungsposten bauen, um Ihre Soldaten zu ernähren."},
    {TR_WARNING_SCREENSHOT_SAVED, "Screenshot gespeichert: "},
    {TR_WARNING_RESOURCES_NOT_AVAILABLE, "Ihr könnt die benötigten Waren nicht erhalten."},
    {TR_WARNING_WATER_NEEDED_FOR_BUILDING, "Leuchtturm muss nah am Wasser platziert werden."},
    {TR_WARNING_NEARBY_WOLF, "Kann nicht gebaut werden, wenn Wölfe in der Nähe sind"},
    {TR_WARNING_VARIANT_TOGGLE, "Für Gebäudevarianten die Rotationstasten drücken"},
    /* Asset-Warnung */
	{TR_NO_EXTRA_ASSETS_TITLE, " Extra Assets wurden nicht geladen"},
    {TR_NO_EXTRA_ASSETS_MESSAGE,
        "Extra Augustus Assets wurden nicht geladen.\n"
        "Das kann durch ein fehlendes oder veraltetes Assetverzeichnis passieren.\n"
        "Bitte stellen Sie sicher, dass die das aktuellste Assetverzeichnis haben, welches durch Github bereitgestellt wird."},
	/* Stadt-Nachrichten */
    {TR_CITY_MESSAGE_SQUALOR, "Verwahrloste Wohnungen und Slums sind ein Problem"},
    {TR_CITY_MESSAGE_TEXT_ANIMAL_GAMES_ENDING, "Die letzten der wilden Tiere liegen erschlagen im Sand des Kolosseums, ihr Blut vermischt sich mit dem der Verurteilten. Die Tierhetzen haben ein Ende."},
    {TR_CITY_MESSAGE_TEXT_ANIMAL_GAMES_PLANNING, "Seltsame Fracht beginnt in Ihrer Stadt aufzutauchen, als Händler aus den Weiten der Erde schreckliche Bestien in die Käfige unter dem Kolossum liefern. Bald wird ein grausiges Spektakel Ihr Volk begeistern."},
    {TR_CITY_MESSAGE_TEXT_ANIMAL_GAMES_STARTING, "Verurteilte Verbrecher und Gladiatoren auf der Suche nach dem ultimativen Ruhm stellen sich dem Tod in Form von Zähnen und Klauen. Mit einem Trompetenstoß haben die Tierhetzen begonnen!"},
    {TR_CITY_MESSAGE_TEXT_COLOSSEUM_COMPLETE, "Das Kolosseum ist fertig! Last die Spiele beginnen!"},
    {TR_CITY_MESSAGE_TEXT_COLOSSEUM_WORKING, "Die Einweihungsspiele für Ihr Kolosseum haben begonnen. Auf Ihren Befehl hin wird dieses Monument mit dem Blut der Tapferen geweiht!"},
    {TR_CITY_MESSAGE_TEXT_EMPERORS_WRATH, "Ihr seid in Cäsars Gunst gefallen und er hat deshalb Eure Verhaftung angeordnet. Wenn Sie Ihre Gunst beim Kaiser nicht wiederherstellen, werden Elite-Legionäre bald in Ihre Stadt einfallen."},
    {TR_CITY_MESSAGE_TEXT_ENEMIES_LEAVING, "Hmpf! Eure mickrige Stadt hat nichts, was sich zu zerstören lohnt. Wir werden jetzt gehen, aber seid gewarnt, wir können jederzeit wiederkommen!"},
    {TR_CITY_MESSAGE_TEXT_GRAND_TEMPLE_COMPLETE, "Priester und Verehrer der Gottheit sammeln sich für die Riten der Tempelweihe in Scharen am neuen Prachttempel. Ihre Einwohner bewundern das majestätische Bauwerk und die Gottheit überhäuft Sie mit ihrer Gunst."},
    {TR_CITY_MESSAGE_TEXT_HIPPODROME_COMPLETE, "Das Hippodrom ist fertiggestellt. Die Bürger warten sehnsüchtig auf Ihren Befehl die Rennen zu beginnen!"},
    {TR_CITY_MESSAGE_TEXT_HIPPODROME_WORKING, "Die Stadt leert sich, als die Menschen zum Hippodrom strömen, um die ersten Wagenrennen zu sehen. Ein ohrenbetäubender Jubel erfüllt die Luft, als sich die Tore öffnen!"},
    {TR_CITY_MESSAGE_TEXT_IMPERIAL_GAMES_ENDING, "Der letzte Tag der Römischen Spiele neigt sich dem Ende zu. Voller Aufregung und mit vollen Mägen hat jeder Bürger die Herrlichkeit des römischen Lebens gekostet. Ruhm für die Sieger der Spiele und Ruhm für den Statthalter!"},
    {TR_CITY_MESSAGE_TEXT_IMPERIAL_GAMES_PLANNING, "Mit der Ankündigung der Römischen Spiele strömen Menschen aus den entlegensten Winkeln des Imperiums in Ihre Stadt, viele in der Hoffnung, die bevorstehenden Wettbewerbe zu gewinnen. Es wird nicht weniger als ein ganzes Jahr dauern, um jede mögliche Vorbereitung abgeschlossen zu sehen."},
    {TR_CITY_MESSAGE_TEXT_IMPERIAL_GAMES_STARTING, "Die feierliche Prozession beginnt, und mit ihr die Römischen Spiele. Möge Jupiter selbst über die Besten der heutigen Wettkämpfer bei Rennen, Kämpfen und anderen Leistungsprüfungen richten. Das Kolosseum ist bis zum Rand mit Bürgern gefüllt, die auf die Spiele und die üblichen Geschenke von Getreide und Olivenöl warten. Mögen die Spiele beginnen!"},
    {TR_CITY_MESSAGE_TEXT_KALENDS_GAMES_ENDING, "Auguren vermuten, dass die Götter über unsere großen Spiele und die ihnen dargebrachten Opfer und Ehrerbietungen sehr erfreut waren. Wir können ein sehr profitables Jahr erwarten!"},
    {TR_CITY_MESSAGE_TEXT_KALENDS_GAMES_PLANNING, "Wir begrüßen das neue Jahr mit einem glorreichen Spiel zu Ehren der Götter. Im Gegenzug bitten wir um Glück, Wohlstand und Segen in Sachen Handel."},
    {TR_CITY_MESSAGE_TEXT_KALENDS_GAMES_STARTING, "Die Spiele beginnen bei Sonnenaufgang an den Kalenden des Ianuarius. Priester führen Tieropfer durch, während Gladiatoren ihre Arme gürten, um auf der Suche nach der Gunst des Göttlichen zu sterben."},
    {TR_CITY_MESSAGE_TEXT_LIGHTHOUSE_COMPLETE, "Der fertige Leuchtturm, ein mächtiger Turm aus Stein, der über den Horizont ragt. Möge sein Leuchtfeuer Seefahrer bis zum Ende der Zeit nach Hause leiten."},
    {TR_CITY_MESSAGE_TEXT_LOOTING, "Ein Lagerhaus oder Getreidespeicher wurde von aufgebrachten Bürgern geplündert und Waren gestohlen! Schlechte Stimmung macht diese Vorfälle wahrscheinlicher."},
    {TR_CITY_MESSAGE_TEXT_MARS_MINOR_CURSE_PREVENTED, "Mars ist wütend! In einem so friedlichen Land haben wir wenig zu befürchten, aber seien Sie sicher, dass dieser Frieden nicht ewig anhalten wird!"},
    {TR_CITY_MESSAGE_TEXT_MERCURY_BLESSING, "Hocherfreut von Ihrer Hingabe, hat Merkur die Industrie der Stadt gesegnet und Ihre Lagerhäuser mit Rohmaterialien gefüllt."},
    {TR_CITY_MESSAGE_TEXT_MESS_HALL_MISSING, "Ihre Stadt hat den Versorgungsposten verloren und die Soldaten hungern! Baut umgehend einen neuen!"},
    {TR_CITY_MESSAGE_TEXT_MESS_HALL_NEEDS_FOOD, "In Ihrem Versorgungsposten befindet sich sehr wenig Nahrung und die Moral der Truppen schwindet. Stellt sicher, der Versorgungsposten Zugang zu einem gut gefüllten Silo hat."},
    {TR_CITY_MESSAGE_TEXT_NAVAL_GAMES_ENDING, "Für das Kolosseum beginnt ein langer Aufräumprozess, denn es wird trockengelegt und für die normale Nutzung vorbereitet. Ihr Volk wird noch jahrelang über dieses nasse Spektakel sprechen."},
    {TR_CITY_MESSAGE_TEXT_NAVAL_GAMES_PLANNING, "Wasser aus den Reservoirs der Stadt füllt langsam das Kolosseum. Zimmerleute beginnen, lebensechte Kriegsschiffe zu montieren, während Gladiatoren den Kampf auf dem Wasser trainieren. Bald beginnen die Seeschlachten!"},
    {TR_CITY_MESSAGE_TEXT_NAVAL_GAMES_STARTING, "Das Kolosseum ist zu einem künstlichen See geworden, in dem Gladiatoren große römische Siege zu Wasser nachspielen. Blut und Wasser vermischen sich, während die Menge ihre Zustimmung brüllt. Die Naumachien - die Seeschlachten - haben begonnen.!"},
    {TR_CITY_MESSAGE_TEXT_NEPTUNE_BLESSING, "Neptun belohnt die Hingabe Ihrer Einwohner und garantiert Seefahrern eine sichere Überfahrt für 12 Monate, während derer Ihre Exporte 50 % mehr einbringen."},
    {TR_CITY_MESSAGE_TEXT_OLYMPIC_GAMES_ENDING, "Die heilige Flamme ist erloschen, und Reisende und Bürger strömen in müdem Jubel nach Hause. Ewiger Ruhm gebührt Ihnen für die erfolgreiche Ausrichtung dieser uralten und heiligen Feier der sterblichen Stärke und Ehre."},
    {TR_CITY_MESSAGE_TEXT_OLYMPIC_GAMES_PLANNING, "Alle Augen werden auf Ihre Stadt gerichtet sein, wenn die Olympischen Spiele Reisende, Wettkämpfer und römische Würdenträger aus aller Welt anlocken. Es wird nicht weniger als ein ganzes Jahr dauern, bis alle möglichen Vorbereitungen getroffen sind."},
    {TR_CITY_MESSAGE_TEXT_OLYMPIC_GAMES_STARTING, "Endlich ist der Tag gekommen. Die heilige Flamme wird entzündet, und die Straßen der Stadt sind menschenleer, während die Bürger in das große Hippodrom strömen. Lasst die Rennen beginnen!"},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_COMPLETE, "Das Pantheon ist fertiggestellt. Unerreicht steht es als Monument für die großartige Macht der Götter und des Volkes von Roms."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_CERES, "Die Gläubigen strömen zu Tempeln, um Cerealia zu Ehren von Ceres zu feiern. Landwirte bringen Opfer für reiche Ernten in den kommenden Jahren."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_MARS, "Die Bürger versammeln sich außerhalb der Stadt zur Feier von Equirria, um die Gunst des Mars zu ersuchen. Die Luft ist erfüllt vom Donner der Hufe und dem Knarren der Streitwagen, wenn Gläubige Rennen zu Ehren ihres Gottes veranstalten."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_MERCURY, "Händler und Kaufleute feiern in Scharen Mercuralia. In der Hoffnung auf göttlichen Schutz durch den Gott Merkur wird heiliges Wasser auf Schiffe und Lagerhäuser gespritzt."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_NEPTUNE, "Heute ist das Fest von Neptunalia zu Ehren des Neptun. Die Gläubigen bauen Hütten aus Ästen und Blattwerk und feiern fröhlich unter der lodernden Hitze der Mittsommersonne."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_VENUS, "Die Gläubigen versammeln sich zur Feier von Veneralia, einem Tag, der der Venus heilig ist. Ihre Bürger bitten sie um Glück in Herzensangelegenheiten."},
    {TR_CITY_MESSAGE_TEXT_ROAD_TO_ROME_WARNING, "Die Straße nach Rom ist blockiert. Wenn wir nicht sofort den Zugang zum Imperium wiederherstellen, werden die Ingenieure aus Rom gezwungen sein, Maßnahmen zu ergreifen." },
    {TR_CITY_MESSAGE_TEXT_SICKNESS, "In der Stadt ist die Pest ausgebrochen! Ein Gebäude steht unter Quarantäne, und es wurden Ärzte oder Chirurgen angefordert, um es zu dekontaminieren."},
    {TR_CITY_MESSAGE_TEXT_VENUS_BLESSING, "Erfreut über die Ehrfurcht, die ihr entgegengebracht wird, verleiht Venus Ihrem Volk Jugendlichkeit, Gesundheit und Glück und erhöht so die Größe Ihrer arbeitenden Bevölkerung."},
    {TR_CITY_MESSAGE_TITLE_COLOSSEUM_WORKING, "Einweihungsspiele"},
    {TR_CITY_MESSAGE_TITLE_EMPERORS_WRATH, "Der Zorn des Kaisers"},
    {TR_CITY_MESSAGE_TITLE_ENEMIES_LEAVING, "Feinde auf dem Rückzug"},
    {TR_CITY_MESSAGE_TITLE_GRAND_TEMPLE_COMPLETE, "Prachttempel fertiggestellt"},
    {TR_CITY_MESSAGE_TITLE_GREAT_GAMES, "Die Großen Spiele"},
    {TR_CITY_MESSAGE_TITLE_HIPPODROME_WORKING, "Die Rennen beginnen"},
    {TR_CITY_MESSAGE_TITLE_LOOTING, "Plünderungen in der Stadt!"},
    {TR_CITY_MESSAGE_TITLE_MARS_MINOR_CURSE_PREVENTED, "Der Zorn des Mars"},
    {TR_CITY_MESSAGE_TITLE_MERCURY_BLESSING, "Eine Segnung des Merkur"},
    {TR_CITY_MESSAGE_TITLE_MESS_HALL_NEEDS_FOOD, "Hungrige Soldaten"},
    {TR_CITY_MESSAGE_TITLE_MONUMENT_COMPLETE, "Monument fertiggestellt"},
    {TR_CITY_MESSAGE_TITLE_NEPTUNE_BLESSING, "Eine Segnung von Neptun"},
    {TR_CITY_MESSAGE_TITLE_PANTHEON_FESTIVAL, "Ein jährliches Fest"},
    {TR_CITY_MESSAGE_TITLE_ROAD_TO_ROME_WARNING, "Stadt Unerreichbar" },
    {TR_CITY_MESSAGE_TITLE_SICKNESS, "Pest in der Stadt"},
    {TR_CITY_MESSAGE_TITLE_VENUS_BLESSING, "Eine Segnung von Venus"},
	/* Berater */
    {TR_ADVISOR_HOUSING_ROOM, "In der Stadt gibt es noch Platz für"},
    {TR_ADVISOR_HOUSING_NO_ROOM, "In der Stadt gibt es keinen Wohnraum mehr."},
    {TR_ADVISOR_RESIDENCES_USING_POTTERY, "Bevölkerungsnachfrage an Einheiten Geschirr"},
    {TR_ADVISOR_RESIDENCES_USING_FURNITURE, "Bevölkerungsnachfrage an Einheiten Möbeln"},
    {TR_ADVISOR_RESIDENCES_USING_OIL, "Bevölkerungsnachfrage an Einheiten Öl"},
    {TR_ADVISOR_RESIDENCES_USING_WINE, "Bevölkerungsnachfrage an Einheiten Wein"},
    {TR_ADVISOR_TOTAL_NUM_HOUSES, "Wohnhäuser insg.:"},
    {TR_ADVISOR_AVAILABLE_HOUSING_CAPACITY, "Verf. Kapazität:"},
    {TR_ADVISOR_TOTAL_HOUSING_CAPACITY, "Kapazität insg.:"},
    {TR_ADVISOR_ADVISOR_HEADER_HOUSING, "Bevölkerung - Wohnraum"},
    {TR_ADVISOR_BUTTON_GRAPHS, "Diagramme"},
    {TR_ADVISOR_HOUSING_PROSPERITY_RATING, "Der Wohnungswohlstand beträgt"},
    {TR_ADVISOR_PERCENTAGE_IN_VILLAS_PALACES, "Die Bevölkerungszahl in Villen und Palästen beträgt"},
    {TR_ADVISOR_PERCENTAGE_IN_TENTS_SHACKS, "Die Bevölkerungszahl in Zelten und Baracken beträgt"},
    {TR_ADVISOR_AVERAGE_TAX, "Durchschnittl. Steuereinnahmen pro Wohnhaus betragen"},
    {TR_ADVISOR_AVERAGE_AGE, "Das durchschnittliche Alter der Bevölkerung beträgt"},
    {TR_ADVISOR_PERCENT_IN_WORKFORCE, "Die Bevölkerungszahl in der Arbeiterschaft beträgt"},
    {TR_ADVISOR_BIRTHS_LAST_YEAR, "Geburten im vergangen Jahr:"},
    {TR_ADVISOR_DEATHS_LAST_YEAR, "Tode im vergangen Jahr:"},
    {TR_ADVISOR_TOTAL_POPULATION, "Einwohner"},
    {TR_ADVISOR_IN_STORAGE, "im Lager"},
    {TR_ADVISOR_FROM_GRANARIES, "von Silos"},
    {TR_ADVISOR_DISPATCHING_FOOD_FROM_GRANARIES_TITLE, "Auslieferung von Nahrung aus Silos"},
    {TR_ADVISOR_DISPATCHING_FOOD_FROM_GRANARIES_TEXT, "Seid Ihr sicher?"},
    {TR_ADVISOR_KEEP_STOCKPILING, "Ressource weiter hamstern"},
    {TR_ADVISOR_MAX_ATTAINABLE_PROSPERITY_IS, "Der maximale Wohlstand für die aktuelle Behausungsstufe ist"},
    {TR_ADVISOR_POPULATION_AGE, "Alter"},
    {TR_ADVISOR_POPULATION_RESIDENTS, "Einwohner"},
    {TR_ADVISOR_POPULATION_DWELLERS, "Bewohner"},	
    {TR_ADVISOR_FINANCE_LEVIES, "Gebäudekosten"},
    {TR_ADVISOR_TRADE_MAX, "Max"},
    {TR_ADVISOR_TRADE_NO_LIMIT, "Keine Begrenzung"},
    {TR_ADVISOR_TRADE_IMPORTABLE, "Importierbar"},
    {TR_ADVISOR_TRADE_EXPORTABLE, "Exportierbar"},
    {TR_ADVISOR_TRADE_NO_BUYERS, "Niemand kauft diese Ressource."},
    {TR_ADVISOR_TRADE_NO_SELLERS, "Niemand verkauft diese Ressource."},
    {TR_ADVISOR_TRADE_NOT_IMPORTING, "kein Import"},
    {TR_ADVISOR_TRADE_NOT_EXPORTING, "kein Export"},	
    {TR_ADVISOR_TRADE_RESOURCE_NOT_STORABLE, "Kann nicht gelagert werden."},
    {TR_ADVISOR_TRADE_RESOURCE_NOT_STORABLE_OR_TRADABLE, "Ressource kann nicht gelagert oder gehandelt werden."},
    {TR_ADVISOR_OPEN_TO_IMPORT, "Öffnet Handelsroute für Import"},
    {TR_ADVISOR_OPEN_TO_EXPORT, "Öffnet Handelsroute für Export"},
    {TR_ADVISOR_LEGION_FOOD_SATISFIED, "Ihre Soldaten haben ausreichend Nahrung."},
    {TR_ADVISOR_LEGION_FOOD_NEEDED, "Ihre Soldaten benötigen mehr Nahrung."},
    {TR_ADVISOR_LEGION_FOOD_CRITICAL, "Ihre Soldaten verhungern!"},
    {TR_ADVISOR_LEGION_MONTHS_FOOD_STORED, "Gelagerter Nahrung im Versorgungsposten in Monaten:"},
    {TR_ADVISOR_NO_ACTIVE_COLOSSEUM, "Kein aktives Kolosseum in der Stadt"},
    {TR_ADVISOR_ACTIVE_COLOSSEUM, "Die Stadt verfügt über ein Kolosseum"},
    {TR_ADVISOR_NO_ACTIVE_HIPPODROME, "Kein aktives Hippodrom in der Stadt"},
    {TR_ADVISOR_ACTIVE_HIPPODROME, "Die Stadt verfügt über ein Hippodrom"},
    {TR_ADVISOR_SICKNESS_LEVEL_LOW, "Krankheiten treten in der Stadt nur selten auf. Der hohe Standard der medizinischen Versorgung der Einwohner verhindert wirksam, dass sich Epidemien aus anderen Regionen hierher ausbreiten."},
    {TR_ADVISOR_SICKNESS_LEVEL_MEDIUM, "Einige Infektionskrankheiten sind in der Stadt aufgetreten, aber die Situation ist unter Kontrolle. Ein ausreichend hohes Niveau der Gesundheitsversorgung wird die Auswirkungen von Epidemien in der Stadt abmildern."},
    {TR_ADVISOR_SICKNESS_LEVEL_HIGH, "Ansteckende Krankheiten verbreiten sich in verschiedenen Teilen der Stadt. Wenn hier nicht bald Abhilfe geschaffen wird, könnten einige Gebäude unter Quarantäne gestellt werden. Ein besserer Zugang zur Gesundheitsversorgung würde die Ausbreitung von Epidemien in der Stadt wirksam eindämmen."},
    {TR_ADVISOR_SICKNESS_LEVEL_PLAGUE, "Die Pest ist in die Stadt gekommen! Viele Einwohner erkranken und einige Gebäude wurden unter Quarantäne gestellt oder niedergebrannt, um eine weitere Ausbreitung zu verhindern. Die wenigen Ärzte und Chirurgen, die zur Verfügung stehen, wurden angefordert, um die am stärksten betroffenen Orte zu dekontaminieren. Es muss gehandelt werden!"},
    {TR_ADVISOR_CHIEF_NO_IMMIGRATION_SQUALOR, "Schlechte Wohnbedingungen verhindern Zuwanderung"},
	/* Tooltips */
    {TR_TOOLTIP_ADVISOR_ENTERTAINMENT_GAMES_BUTTON, "Informationen zu Spielen"},
    {TR_TOOLTIP_ADVISOR_HOUSING_GRAPH_BUTTON, "Zu den Bevölkerungsdiagrammen"},
    {TR_TOOLTIP_ADVISOR_POPULATION_HOUSING_BUTTON, "Besucht den Wohnraumberater"},
    {TR_TOOLTIP_ADVISOR_TRADE_LAND_POLICY, "Wählen Sie eine Landhandelspolitik"},
    {TR_TOOLTIP_ADVISOR_TRADE_LAND_POLICY_REQUIRED, "Eine Karawanserei wird in Ihrer Stadt benötigt, um eine Landhandelspolitik zu wählen"},
    {TR_TOOLTIP_ADVISOR_TRADE_SEA_POLICY, "Wählen Sie eine Seehandelspolitik"},
    {TR_TOOLTIP_ADVISOR_TRADE_SEA_POLICY_REQUIRED, "Ein Leuchtturm wird in Ihrer Stadt benötigt, um eine Seehandelspolitik zu wählen"},
    {TR_TOOLTIP_BUTTON_ACCEPT_MARKET_LADIES, "Erlaube Marktfrauen von hier Waren zu holen"},
    {TR_TOOLTIP_BUTTON_ACCEPT_QUARTERMASTER, "Erlaube Quartiermeister von hier Nahrung zu holen"},
    {TR_TOOLTIP_BUTTON_ACCEPT_TRADE_CARAVAN, "Erlaube Karawanen hier Handel zu treiben"},
    {TR_TOOLTIP_BUTTON_ACCEPT_TRADE_SHIPS, "Erlaube Handelsschiffen hier Handel zu treiben"},
    {TR_TOOLTIP_BUTTON_ACCEPT_WORKERS, "Halte Ressourcen für Werkstätten oder Getreidespeicher"},
    {TR_TOOLTIP_BUTTON_CENTER_CAMERA, "Kamera auf Gebäude zentrieren"},
    {TR_TOOLTIP_BUTTON_DELETE_READ_MESSAGES, "Gelesene Nachrichten löschen"},
    {TR_TOOLTIP_BUTTON_MOTHBALL_OFF, "Gebäude aktivieren"},
    {TR_TOOLTIP_BUTTON_MOTHBALL_ON, "Gebäude deaktivieren"},
    {TR_TOOLTIP_BUTTON_REJECT_WORKERS, "Ressourcenzufuhr fortsetzen"},
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_EDUCATION, "Durchlass für Bildungswesen umschalten"},
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_ENTERTAINER, "Durchlass für Unterhaltungswesen umschalten"},
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_LABOR_SEEKER, "Durchlass für Arbeitssuchende umschalten"},
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MAINTENANCE, "Durchlass für Präfekten und Ingenieure umschalten"},
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MARKET, "Durchlass für Marktfrauen umschalten"},
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MEDICINE, "Durchlass für Gesundheitswesen umschalten"},
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MISSIONARY, "Durchlass für Missionare umschalten"},
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_PRIEST, "Durchlass für Priester umschalten"},
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_TAX_COLLECTOR, "Durchlass für Steuereintreiber umschalten"},
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_WATCHMAN, "Durchlass für Wächter umschalten"},
    {TR_TOOLTIP_BUTTON_STOCKPILING_OFF, "Vorratshaltung deaktivieren"},
    {TR_TOOLTIP_BUTTON_STOCKPILING_ON, "Ermöglicht das Einlagern in ein Lagerhaus"},
    {TR_TOOLTIP_HOLD_GAME, "Spiele abhalten"},
    {TR_TOOLTIP_MONUMENT_PHASE, " Phase. "},
    {TR_TOOLTIP_MONUMENT_PHASES, " Phasen. "},
    {TR_TOOLTIP_MONUMENT_RESOURCE_REQUIREMENTS, "Ressourcenbedarf:\n"},
    {TR_TOOLTIP_NO_GAME, "Spiele nicht abhalten"},
    {TR_TOOLTIP_OVERLAY_ARENA_COL_1, "Dieses Haus hat keinen Zugang zu einer Arena oder dem Kolosseum."},
    {TR_TOOLTIP_OVERLAY_ARENA_COL_2, "Dieses Haus hat Zugang zu einer Arena mit einer Vorstellung."},
    {TR_TOOLTIP_OVERLAY_ARENA_COL_3, "Dieses Haus hat Zugang zu einer Arena mit zwei Vorstellungen."},
    {TR_TOOLTIP_OVERLAY_ARENA_COL_4, "Dieses Haus hat Zugang zum Kolosseum, mit einer Vorstellung."},
    {TR_TOOLTIP_OVERLAY_ARENA_COL_5, "Dieses Haus hat Zugang zum Kolosseum, mit zwei Vorstellungen."},
    {TR_TOOLTIP_OVERLAY_EFFICIENCY_0, "Niemand kann sich daran erinnern, wann dieses Gebäude irgendetwas produziert hat." },
    {TR_TOOLTIP_OVERLAY_EFFICIENCY_1, "Dieses Gebäude produziert fast nichts." },
    {TR_TOOLTIP_OVERLAY_EFFICIENCY_2, "Hier könnte mehr produziert werden, wenn die Effizients höher wäre." },
    {TR_TOOLTIP_OVERLAY_EFFICIENCY_3, "Hier wird die Arbeit oft gestoppt, weil die Effizients gering ist." },
    {TR_TOOLTIP_OVERLAY_EFFICIENCY_4, "Dieses Gebäude ist effizent und es gibt wenig Stillstand." },
    {TR_TOOLTIP_OVERLAY_EFFICIENCY_5, "Dieses Gebäude arbeitet mit maximaler Effizents." },
    {TR_TOOLTIP_OVERLAY_LEVY, " Monatliche Abgaben in Denare."},
    {TR_TOOLTIP_OVERLAY_PANTHEON_ACCESS, "Dieses Haus hat durch das Pantheon Zugang zu allen fünf Göttern."},
    {TR_TOOLTIP_OVERLAY_PROBLEMS_CARTPUSHER, "Warten auf den Karrenschieber"},
    {TR_TOOLTIP_OVERLAY_PROBLEMS_MOTHBALLED, "Gebäude stillgelegt"},
    {TR_TOOLTIP_OVERLAY_PROBLEMS_NO_LABOR, "Keine Angestellten"},
    {TR_TOOLTIP_OVERLAY_PROBLEMS_NO_RESOURCES, "Keine Ressourcen verfügbar"},
    {TR_TOOLTIP_OVERLAY_PROBLEMS_NO_WATER_ACCESS, "Kein Wasserzugang"},
    {TR_TOOLTIP_OVERLAY_PROBLEMS_PLAGUE, "Gebäude hat die Pest"},
    {TR_TOOLTIP_OVERLAY_PROBLEMS_STRIKE, "Die Arbeiter streiken"},
    {TR_TOOLTIP_OVERLAY_SICKNESS_HIGH, "Viele Infektionskrankheiten verbreiten sich"},
    {TR_TOOLTIP_OVERLAY_SICKNESS_LOW, "Sehr wenige Krankheiten"},
    {TR_TOOLTIP_OVERLAY_SICKNESS_MEDIUM, "Einige Infektionskrankheiten"},
    {TR_TOOLTIP_OVERLAY_SICKNESS_NONE, "Keine Krankheiten"},
    {TR_TOOLTIP_OVERLAY_SICKNESS_PLAGUE, "Die Pest sucht das Land heim"},
    {TR_TOOLTIP_OVERLAY_TAVERN_1, "Dieses Haus hat keinen Zugang zu einer Taverne oder die Taverne hat keinen Wein mehr."},
    {TR_TOOLTIP_OVERLAY_TAVERN_2, "Keine Gastwirtin kam in letzter Zeit vorbei. Dieses Haus wird bald den Zugang zur Taverne verlieren."},
    {TR_TOOLTIP_OVERLAY_TAVERN_3, "Dieses Haus wurde von einer Gastwirtin mit Wein versorgt."},
    {TR_TOOLTIP_OVERLAY_TAVERN_4, "Dieses Haus wurde von einer Gastwirtin mit Wein und Fleisch versorgt."},
    {TR_TOOLTIP_OVERLAY_TAVERN_5, "Dieses Haus wurde kürzlich von einer Gastwirtin mit Wein versorgt."},
    {TR_TOOLTIP_OVERLAY_TAVERN_6, "Dieses Haus wurde kürzlich von einer Gastwirtin mit Wein und Fleisch versorgt. Hoch die Gläser!"},
    {TR_ZOOM, "Zoom:"},
	/* Besondere Befehle */	
    {TR_MARKET_SPECIAL_ORDERS_HEADER, "Zu sammelnde Waren"},
    {TR_DOCK_SPECIAL_ORDERS_HEADER, "Anweisungen für Dock"},
    {TR_TEMPLE_SPECIAL_ORDERS_HEADER, "Anweisungen für Tempel"},
    {TR_MESS_HALL_SPECIAL_ORDERS_HEADER, "Anweisungen für Posten"},
    {TR_CARAVANSERAI_SPECIAL_ORDERS_HEADER, "Anweisungen für Karavanserei"}, //vielleicht zu lang
    {TR_TAVERN_SPECIAL_ORDERS_HEADER, "Anweisungen für Taverne"},
	/* Gebäude - Altare */
    {TR_BUILDING_SHRINE_DESC, "Altäre werden nicht nur von ihren Nachbarn, sondern auch von ihren jeweiligen Göttern geschätzt."},
    {TR_BUILDING_SHRINE_CERES, "Ceres"},
    {TR_BUILDING_SHRINE_MARS, "Mars"},
    {TR_BUILDING_SHRINE_MERCURY, "Merkur"},
    {TR_BUILDING_SHRINE_NEPTUNE, "Neptun"},
    {TR_BUILDING_SHRINE_VENUS, "Venus"},
    {TR_BUILDING_MENU_SHRINES, "Altar" },
	/* Gebäude - Arbeiterlager */
    {TR_BUILDING_WORK_CAMP, "Arbeiterlager"},
    {TR_BUILDING_WORK_CAMP_DESC, "Arbeiter versammeln sich hier, um Materialien an Baustellen zu liefern."},
    /* Gebäude - Arena */
	{TR_BUILDING_ARENA, "Arena"},
    {TR_WINDOW_BUILDING_ARENA_CLOSED, "Die Arena ist geschlossen. Vögel bauen Nester auf den leeren Plätzen."},
    {TR_WINDOW_BUILDING_ARENA_NO_SHOWS, "Diese Arena beherbergt weder Löwen noch Gladiatoren, und bietet wenig Unterhaltung."},
    {TR_WINDOW_BUILDING_ARENA_BOTH_SHOWS, "In dieser Arena finden Gladiatorenkämpfe und Tierhetzen statt, zur Freude der Einheimischen."},
    {TR_WINDOW_BUILDING_ARENA_NEEDS_LIONS, "Regelmäßige Vorstellungen von Gladiatoren unterhalten den Mob, aber Löwen würden das Spektakel aufwerten."},
    {TR_WINDOW_BUILDING_ARENA_NEEDS_GLADIATORS, "Hungrige Bestien streifen durch die Arena auf der Suche nach Beute, aber ein Mangel an trainierten Gladiatoren sorgt für kurze Vorstellungen."},
	/* Gebäude - Baumeistergilde */
    {TR_BUILDING_ARCHITECT_GUILD, "Baumeistergilde"},
    {TR_BUILDING_ARCHITECT_GUILD_DESC, "Die Baumeister arbeiten unermüdlich an der Konstruktion von Monumenten für den Ruhm und die Pracht Roms."},
	/* Gebäude - Betonwerk */
    {TR_BUILDING_CONCRETE_MAKER, "Betonwerk"},
    {TR_BUILDING_CONCRETE_MAKER_DESC, "Hier wird Sand für den Bau von Monumenten zu Beton gemischt."},
    {TR_BUILDING_CONCRETE_MAKER_PRODUCTION, "Produktion ist"},
    {TR_BUILDING_CONCRETE_MAKER_COMPLETE, "abgeschlossen."},
    {TR_BUILDING_CONCRETE_MAKER_HALTED, "Ihr Handelsberater hat einen Stopp der Betonproduktion angeordnet."},
    {TR_BUILDING_CONCRETE_MAKER_NO_EMPLOYEES, "Diese Werkstatt hat keine Arbeiter. Die Produktion wurde eingestellt."},
    {TR_BUILDING_CONCRETE_MAKER_FULL_EMPLOYEES, "Diese Werkstatt hat alle Arbeiter, die sie braucht, und arbeitet mit Hochdruck an der Herstellung von Beton."},
    {TR_BUILDING_CONCRETE_MAKER_MANY_EMPLOYEES, "Diese Werkstatt arbeitet unter ihrer maximalen Kapazität. Die Betonproduktion wäre mit mehr Arbeitern effizienter."},
    {TR_BUILDING_CONCRETE_MAKER_HALF_EMPLOYEES, "Diese Werkstatt ist unterbesetzt. Die Betonproduktion dauert länger als geplant."},
    {TR_BUILDING_CONCRETE_MAKER_SOME_EMPLOYEES, "In dieser Werkstatt arbeiten nur sehr wenige Menschen. Die Betonproduktion ist dementsprechend langsam."},
    {TR_BUILDING_CONCRETE_MAKER_FEW_EMPLOYEES, "Da es hier kaum Arbeiter gibt, ist die Produktion fast zum Erliegen gekommen. Im kommenden Jahr wird hier nur wenig Beton produziert."},
    {TR_BUILDING_CONCRETE_MAKER_NO_RESOURCES, "Diese Werkstatt benötigt Wasser aus einem Reservoir oder Brunnen sowie Sand, der aus einem Lagerhaus oder einer Sandgrube angeliefert wird, um Beton zu mischen."},
    {TR_BUILDING_CONCRETE_MAKER_STORED_SAND, "Gelagerter Sand,"},
    {TR_BUILDING_CONCRETE_MAKER_NO_TARGETS, "Es gibt keine Gebäude, die Beton benötigen. Die Produktion wurde eingestellt."},
    {TR_BUILDING_CONCRETE_MAKER_IMPROVE_WATER_ACCESS, "Diese Werkstatt hat nur Zugang zu einem Brunnen oder einer Fontäne. Die Leistung könnte verbessert werden, wenn ein direkter Zugang zum Reservoir vorhanden wäre.."},
	/* Gebäude - Dekorationen */
    {TR_BUILDING_PINE_TREE, "Tanne"},
    {TR_BUILDING_FIR_TREE, "Kiefer"},
    {TR_BUILDING_OAK_TREE, "Eiche"},
    {TR_BUILDING_ELM_TREE, "Ulme"},
    {TR_BUILDING_FIG_TREE, "Feige"},
    {TR_BUILDING_PLUM_TREE, "Pflaume"},
    {TR_BUILDING_PALM_TREE, "Palme"},
    {TR_BUILDING_DATE_TREE, "Dattel"},
    {TR_BUILDING_PINE_PATH, "Tannenpfad"},
    {TR_BUILDING_FIR_PATH, "Kiefernpfad"},
    {TR_BUILDING_OAK_PATH, "Eichenpfad"},
    {TR_BUILDING_ELM_PATH, "Ulmenpfad"},
    {TR_BUILDING_FIG_PATH, "Feigenpfad"},
    {TR_BUILDING_PLUM_PATH, "Pflaumenpfad"},
    {TR_BUILDING_PALM_PATH, "Palmenpfad"},
    {TR_BUILDING_DATE_PATH, "Dattelpfad"},
    {TR_BUILDING_BLUE_PAVILION, "farbige Pavillons"}, //Ehemals blauer Pavillon jetzt aber mit Farbrotation.
    {TR_BUILDING_RED_PAVILION, "roter Pavillon"}, //inaktiv
    {TR_BUILDING_ORANGE_PAVILION, "oranger Pavillon"}, //inaktiv
    {TR_BUILDING_YELLOW_PAVILION, "gelber Pavillon"}, //inaktiv
    {TR_BUILDING_GREEN_PAVILION, "grüner Pavillon"}, //inaktiv
    {TR_BUILDING_SMALL_STATUE_ALT, "Göttinnen Statue"},
    {TR_BUILDING_SMALL_STATUE_ALT_B, "Senatoren Statue"},
    {TR_BUILDING_OBELISK, "Obelisk"},
    {TR_BUILDING_OBELISK_DESC, "Ein prestigeträchtiges Monument, einem antiken Pharaoh gewidmet. Die Ägypter hatten keine Verwendung mehr dafür."},
    {TR_BUILDING_SMALL_POND, "Kleiner Teich"},
    {TR_BUILDING_LARGE_POND, "Großer Teich"},
    {TR_BUILDING_POND_DESC, "Teiche füllen sich aus Reservoirs und versorgen Pflanzen und Tiere mit Wasser. Als Oase der Natur dienen sie Einwohnern zur Entspannung. Alle Bewohner würden liebend gerne in der Nähe eines Teiches wohnen."},
    {TR_BUILDING_WINDOW_POND, "Teich"},
    {TR_BUILDING_PANELLED_GARDEN_WALL, "Verkleidete Gartenmauer"},
    {TR_BUILDING_LOOPED_GARDEN_WALL_GATE, "Gewölbtes Gartentor"},
    {TR_BUILDING_LOOPED_GARDEN_WALL_GATE_DESC, "Dieses kleine Tor kontrolliert den Personenverkehr in und aus den abgelegensten Winkeln Ihrer Stadt." },
    {TR_BUILDING_PANELLED_GARDEN_WALL_GATE, "Verkleidetes Gartenmauertor" },
    {TR_BUILDING_PANELLED_GARDEN_WALL_GATE_DESC, "Dieses kleine Tor kontrolliert den Personenverkehr in und aus den abgelegensten Winkeln Ihrer Stadt." },
    {TR_BUILDING_GLADIATOR_STATUE, "Gladiatoren Statue"},
    {TR_BUILDING_HORSE_STATUE, "Reiter Statue"},
    {TR_BUILDING_DOLPHIN_FOUNTAIN, "Delphinbrunnen"},
    {TR_BUILDING_HEDGE_DARK, "dunkle Hecke"},
    {TR_BUILDING_HEDGE_LIGHT, "helle Hecke"},
    {TR_BUILDING_GARDEN_WALL, "Gartenmauer"},
    {TR_BUILDING_LEGION_STATUE, "Legionärs Statue"},
    {TR_BUILDING_DECORATIVE_COLUMN, "Marmorsäule"},
    {TR_BUILDING_COLONNADE, "Kolonnade"},
    {TR_BUILDING_GARDEN_PATH, "Gartenpfad"},
    {TR_BUILDING_ROOFED_GARDEN_WALL, "Überdachte Gartenmauer"},
    {TR_BUILDING_GARDEN_WALL_GATE, "Gartentor"},
    {TR_BUILDING_GARDEN_WALL_GATE_DESC, "Dieses kleine Tor kontrolliert den Personenverkehr in und aus den abgelegensten Winkeln Ihrer Stadt."},
    {TR_BUILDING_FORMAL_GARDENS, "Gepflegte Gärten" },
    {TR_BUILDING_OVERGROWN_GARDENS, "Wilde Gärten" },
	/* Gebäude - Dock */
    {TR_BUILDING_DOCK_CITIES_CONFIG_DESC, "Städte mit eröffneter Seeroute:"},
    {TR_BUILDING_DOCK_CITIES_NO_ROUTES, "Es wurden keine Seerouten eröffnet."},
    /* Gebäude - Goldmine */
	{TR_BUILDING_GOLD_MINE, "Goldmine" },
    {TR_BUILDING_GOLD_MINE_COMPLETE, "Fertiggestellt." },
    {TR_BUILDING_GOLD_MINE_DESC, "Baue Gold für den Handel ab oder um die lokale Münze zu versorgen und um Denare zu prägen." },
    {TR_BUILDING_GOLD_MINE_FULL_EMPLOYEES, "Diese Mine hat alle Arbeiter die sie benötigt und die Produktion ist stabil." },
    {TR_BUILDING_GOLD_MINE_MANY_EMPLOYEES, "Diese Mine arbeitet unter ihrer maximalen Auslastung. Mit mehr Arbeitern wäre sie effizienter." },
    {TR_BUILDING_GOLD_MINE_HALF_EMPLOYEES, "Diese Mine ist unterbesetzt. Die Goldproduktion dauert länger als geplant ." },
    {TR_BUILDING_GOLD_MINE_SOME_EMPLOYEES, "Sehr wenige Leute arbeiten in dieser Mine. Die Goldförderung ist daher langsam." },
    {TR_BUILDING_GOLD_MINE_FEW_EMPLOYEES, "Mit fast keinen Bergleuten wird fast nichts abgebaut. Nur wenig Gold wird dieses Jahr abgebaut werden." },
    {TR_BUILDING_GOLD_MINE_NO_EMPLOYEES, "Die Mine hat keinen Arbeiter. Die Produktion steht still." },
    {TR_BUILDING_GOLD_MINE_HALTED, "Euer Handelsberater stoppte das Prägen von Münzen" },
    {TR_BUILDING_GOLD_MINE_PRODUCTION, "Förderleistung" },
    /* Gebäude - Hippodrom */
    {TR_BUILDING_HIPPODROME_PHASE_1, "(Rennbahn)"},
    {TR_BUILDING_HIPPODROME_PHASE_2, "(Fundament)"},
    {TR_BUILDING_HIPPODROME_PHASE_3, "(Tribüne)"},
    {TR_BUILDING_HIPPODROME_PHASE_4, "(Fassade)"},
    {TR_BUILDING_HIPPODROME_PHASE_1_TEXT, "Das riesige Gelände wird derzeit akribisch vermessen und für ein Projekt von noch nie dagewesenem Ausmaß gerodet."},
    {TR_BUILDING_HIPPODROME_PHASE_2_TEXT, "Zufahrten und Stützkonstruktionen werden um die Strecke herum gebaut."},
    {TR_BUILDING_HIPPODROME_PHASE_3_TEXT, "Steinmetze meißeln Sitzgelegenheiten für Zehntausende."},
    {TR_BUILDING_HIPPODROME_PHASE_4_TEXT, "Mehr als eine bloße Rennstrecke: Handwerker erschaffen ein Monument, das den Göttern und dem Volk von Rom würdig ist."},
	/* Gebäude - Karavanserei */
    {TR_BUILDING_CARAVANSERAI, "Karavanserei"},
    {TR_BUILDING_CARAVANSERAI_DESC, "Handelskarawanen finden hier Unterschlupf, um zu rasten und ihre Tiere zu versorgen. Unterbrechungen des Landhandels dauern halb so lange."},
    {TR_BUILDING_CARAVANSERAI_PHASE_1, "(Fundament)"},
    {TR_BUILDING_CARAVANSERAI_PHASE_1_TEXT, "Arbeiter legen das Fundament des zukünftigen Rastplatzes."},
    {TR_BUILDING_CARAVANSERAI_PHASE_2, "(Kolonnade)"},
    {TR_BUILDING_CARAVANSERAI_PHASE_2_TEXT, "Baumeister errichten eine rechteckige Kolonnade. Im Inneren werden Unterstände für Händler und ihre Tiere entstehen."},
    {TR_BUILDING_CARAVANSERAI_POLICY_TITLE, "Landhandelspolitik"},
    {TR_BUILDING_CARAVANSERAI_NO_POLICY, "Keine Landhandelspolitik."},
    {TR_BUILDING_CARAVANSERAI_POLICY_TEXT, "Wählen Sie die Handelspolitik in Ihrer Stadt. Sie können sie jederzeit kostenpflichtig ändern."},
    {TR_BUILDING_CARAVANSERAI_POLICY_1_TITLE, "Consilium Venditor Terrae"},
    {TR_BUILDING_CARAVANSERAI_POLICY_1, "Verkaufspolitik: Landexporte verdienen 20 % mehr, aber Landimporte sind 10 % teurer."},
    {TR_BUILDING_CARAVANSERAI_POLICY_2_TITLE, "Consilium Emptor Terrae"},
    {TR_BUILDING_CARAVANSERAI_POLICY_2, "Einkaufspolitik: Landimporte sind 20 % billiger, aber Landexporte verdienen 10 % weniger."},
    {TR_BUILDING_CARAVANSERAI_POLICY_3_TITLE, "Consilium Quantitas Terrae"},
    {TR_BUILDING_CARAVANSERAI_POLICY_3, "Mengenpolitik: Handelskarawanen tragen 4 zusätzliche Waren, aber die Karawanserei verbraucht 20 % mehr Nahrung."},
	/* Gebäude - Karrendepot */	
    {TR_BUILDING_DEPOT, "Karren-Depot"},
    {TR_BUILDING_CAT_DEPOT, "Katzen-Depot"},
    {TR_BUILDING_DEPOT_DESC, "Das Karren-Depot sendet Karren aus, um die Waren je nach Auftrag zwischen Lagerhäusern und Silos umzuschlagen. Karren müssen nach jeder Lieferung zum Depot zurückkehren."},
    {TR_BUILDING_INFO_DEPOT_SELECT_SOURCE, "Wählen Sie eine Quelle"},
    {TR_BUILDING_INFO_DEPOT_SELECT_DESTINATION, "Wählen Sie einen Zielort"},
    {TR_BUILDING_INFO_DEPOT_ONE_BUILDING_FOR_RESOURCE, "Nur ein Gebäude verfügbar"},
    {TR_BUILDING_INFO_DEPOT_NO_SOURCE_AVAILABLE, "Keine Quelle verfügbar"},
    {TR_BUILDING_INFO_DEPOT_NO_DESTINATION_AVAILABLE, "Kein Zielort verfügbar"},
    {TR_BUILDING_INFO_DEPOT_DELIVER, "Liefern" },
    {TR_BUILDING_INFO_DEPOT_CONDITION, "Wenn" },
    {TR_BUILDING_INFO_DEPOT_SOURCE, "Quelle" },
    {TR_BUILDING_INFO_DEPOT_DESTINATION, "Zielort" },
    {TR_BUILDING_INFO_DEPOT_SELECT_SOURCE_TITLE, "Quellen-Speicher auswählen" },
    {TR_BUILDING_INFO_DEPOT_SELECT_DESTINATION_TITLE, "Zielort-Speicher auswählen" },
    {TR_BUILDING_INFO_DEPOT_SELECT_RESOURCE_TITLE, "Ressource auswählen" },
    {TR_BUILDING_DEPOT_NO_EMPLOYEES, "Dieses Depot hat keine Arbeiter. Katzen schlafen in den leeren Karren." },
    {TR_BUILDING_DEPOT_FEW_EMPLOYEES, "Da es hier kaum Arbeiter gibt, kann sich niemand daran erinnern, wann dieses Depot seinen letzten Karrenschieber losgeschickt hat." },
    {TR_BUILDING_DEPOT_SOME_EMPLOYEES, "Dieses Depot hat nur wenige Arbeiter. Es dauert eine Weile, bis die Waren umgeschlagen werden." },
    {TR_BUILDING_DEPOT_HALF_EMPLOYEES, "Dieses Depot ist personell unterbesetzt. Die Waren werden daher nur langsam umgeschlagen." },
    {TR_BUILDING_DEPOT_MANY_EMPLOYEES, "Dieses Depot arbeitet unter seiner maximalen Kapazität. Mehr Arbeitern würden den Warenumschlag beschleunigen." },
    {TR_BUILDING_INFO_MOTHBALL_WARNING, "Dieses Gebäude ist eingemottet." },
    {TR_BUILDING_INFO_CARTLOAD, "Karrenladung." },
    {TR_BUILDING_INFO_CARTLOADS, "Karrenladungen." },
    {TR_FIGURE_INFO_DEPOT_RECALL, "Rückruf" },
    {TR_FIGURE_INFO_DEPOT_RETURNING, "Rücksendung" },
    {TR_FIGURE_INFO_DEPOT_DELIVER, "Lieferung" },
    {TR_FIGURE_INFO_DEPOT_FROM, "Von " },
    {TR_FIGURE_INFO_DEPOT_TO, " zu " },
    {TR_ORDER_CONDITION_NEVER, "Nie" },
    {TR_ORDER_CONDITION_ALWAYS, "Immer" },
    {TR_ORDER_CONDITION_SOURCE_HAS_MORE_THAN, "Quelle hat mehr als" },
    {TR_ORDER_CONDITION_DESTINATION_HAS_LESS_THAN, "Zielort hat weniger als" },
	/* Gebäude - Kolosseum */
    {TR_BUILDING_COLOSSEUM_PHASE_1, "(Hypogäum)"},
    {TR_BUILDING_COLOSSEUM_PHASE_2, "(Fundament)"},
    {TR_BUILDING_COLOSSEUM_PHASE_3, "(Arkaden)"},
    {TR_BUILDING_COLOSSEUM_PHASE_4, "(Gallerie)"},
    {TR_BUILDING_COLOSSEUM_PHASE_1_TEXT, "Arbeiter graben im Untergrund das Hypogäum, Tunnel und konstruieren die Maschinen aus den die großen Spektakel entspringen."},
    {TR_BUILDING_COLOSSEUM_PHASE_2_TEXT, "Die Mauern des Kolosseums nehmen Gestalt an, während Sitzreihen für Bürgerliche und Kaiser angelegt werden."},
    {TR_BUILDING_COLOSSEUM_PHASE_3_TEXT, "Anmutige Bögen ragen in den Himmel, um das mächtige Kolosseum in die Höhe zu halten."},
    {TR_BUILDING_COLOSSEUM_PHASE_4_TEXT, "Das Kolosseum ragt in den Himmel, seine Wände sind mit schimmerndem Marmor und Statuen verkleidet."},
    {TR_WINDOW_BUILDING_GAMES_REMAINING_DURATION, "Die Großen Spiele werden fortgesetzt für weitere"}, // ...XX Days, 
    {TR_WINDOW_GAMES_OPTION_1, "Naumachie abhalten"},
    {TR_WINDOW_GAMES_OPTION_2, "Tierhetze abhalten"},
    {TR_WINDOW_GAMES_OPTION_3, "Kalendae des Januarius abhalten"},
    {TR_WINDOW_GAMES_OPTION_4, "Olympische Spiele abhalten"},
    {TR_WINDOW_GAMES_OPTION_5, "Römische Spiele abhalten"},
    {TR_WINDOW_GAMES_OPTION_1_DESC, "Das Kolosseum wird geflutet, um eine große Seeschlacht nachzuspielen. Die Bewegungsgeschwindigkeit Ihrer Truppen und ihre Stärke in entfernten Schlachten werden für das nächste Jahr erhöht."},
    {TR_WINDOW_GAMES_OPTION_2_DESC, "Das Kolosseum wird Schauplatz grausamer Tierhetzen und Hinrichtungen durch wilde Bestien, die die plebejischen Klassen erfreuen. Verbrechen, Aufruhr und Revolten werden für das nächste Jahr unterdrückt. Löwenbändiger werden helfen, die Stadt vor der nächsten Invasion zu verteidigen."},
    {TR_WINDOW_GAMES_OPTION_3_DESC, "Im Kolosseum finden am ersten Tag des nächsten Jahres Spiele zu Ehren der Götter statt, bei denen Glück und Wohlstand erbeten werden. Die Handelsquoten werden im nächsten Jahr verdoppelt."},
    {TR_WINDOW_GAMES_OPTION_4_DESC, "Das Hippodrom wird Ort der Olympischen Spiele sein. Ihre Stadt wird Scharen von Besuchern beherbergen, und wenn die Athleten Ihre Stadt gut ehren, werdet Ihr einen dauerhaften Anstieg des Tourismus und der Gunst gewinnen."},
    {TR_WINDOW_GAMES_OPTION_5_DESC, "Im Kolosseum finden die Römischen Spiele statt, zu denen Menschen aus dem ganzen Reich in Ihre Stadt reisen, um sich zu messen. Ein solch großes Spektakel wird Ihnen sicherlich die Gunst des Kaisers und des einfachen Volkes für das nächste Jahr einbringen."},
    {TR_WINDOW_GAMES_COST, "Kosten:"},
    {TR_WINDOW_GAMES_PERSONAL_FUNDS, "(Sparguthaben)"},
    {TR_WINDOW_GAMES_NOT_ENOUGH_FUNDS, "Nicht genügend Sparguthaben."},
    {TR_WINDOW_GAMES_NOT_ENOUGH_RESOURCES, "Nicht genügend Ressourcen gelagert."}, 	
    {TR_WINDOW_GAMES_NO_VENUE, "Anlage nicht gebaut oder hat keine Arbeiter."},
    {TR_WINDOW_GAMES_NO_WATER_ACCESS, "Die Anlage hat keinen Zugang zu einem Reservoir."},
    /* Gebäude - Lararium und Mausoleen */
    {TR_BUILDING_LARARIUM, "Lararium"},
    {TR_WINDOW_BUILDING_LARARIUM_DESC, "Dieser kleine Schrein ist den Laren, den Ahnengeistern des römischen Volkes, gewidmet. Hier können kleine Opfer und Gebete dargebracht werden."},
    {TR_BUILDING_NYMPHAEUM, "Nymphäum"},
    {TR_BUILDING_NYMPHAEUM_DESC, "Dieser große Tempel ist den Wassernymphen gewidmet - kleineren Gottheiten der Quellen, der Flüsse und der See. Er verspricht dem umliegenden Land Schönheit und Überfluss und der Stadt die Gunst des Göttlichen."},
    {TR_BUILDING_SMALL_MAUSOLEUM, "Kleines Mausoleum"},
    {TR_BUILDING_SMALL_MAUSOLEUM_DESC, "Dieses Gebäude ist die letzte Ruhestätte vieler vergangener Generationen der stolzen Familien Ihrer Stadt, und der Neid vieler unter den Lebenden."},
    {TR_BUILDING_LARGE_MAUSOLEUM, "Großes Mausoleum"},
    {TR_BUILDING_LARGE_MAUSOLEUM_DESC, "Die polierten Marmorwände und schimmernden Statuen dieses prächtigen Bauwerks spiegeln die großen Taten der bedeutendsten Patrizier wider, die sich das Privileg verdient haben, hier zu ruhen."},
    {TR_BUILDING_LARGE_MAUSOLEUM_PHASE_1, "Gewölbe" },
    {TR_BUILDING_LARGE_MAUSOLEUM_PHASE_2, "Fassade" },
    {TR_BUILDING_LARGE_MAUSOLEUM_PHASE_1_TEXT, "Baumeister verlegen Schichten von präzise gearbeiteten Steinen, um das zentrale Gewölbe dieses Mausoleums zu bilden." },
    {TR_BUILDING_LARGE_MAUSOLEUM_PHASE_2_TEXT, "Geschickte Handwerker bereiten die Fassade dieses Mausoleums vor und meißeln glänzende Marmorstatuen zum Gedenken an diejenigen, die hier ruhen werden." },
    {TR_BUILDING_LARGE_MAUSOLEUM_CONSTRUCTION_DESC, "Der Bau dieses Mausoleums benötigt in einem Lagerhaus gelagerte Materialien, Arbeiter eines Arbeitslagers und Baumeister einer Baumeistergilde." },
    /* Gebäude - Leuchtturm */
	{TR_BUILDING_LIGHTHOUSE, "Leuchtturm"},
    {TR_BUILDING_LIGHTHOUSE_PHASE_1, "(Fundament)"},
    {TR_BUILDING_LIGHTHOUSE_PHASE_2, "(Sockel)"},
    {TR_BUILDING_LIGHTHOUSE_PHASE_3, "(Turm)"},
    {TR_BUILDING_LIGHTHOUSE_PHASE_4, "(First)"},
    {TR_BUILDING_LIGHTHOUSE_PHASE_1_TEXT, "Bauarbeiter legen ein starkes Fundament, um das Gewicht eines großen steinernen Turms zu tragen."},
    {TR_BUILDING_LIGHTHOUSE_PHASE_2_TEXT, "Baumeister konstruieren den Sockel, der die Flamme des Leuchtturms weit über den Hoizont erheben wird."},
    {TR_BUILDING_LIGHTHOUSE_PHASE_3_TEXT, "Der Leuchtturm wächst jeden Tag etwas höher, während die Bauarbeiter ihre Arbeit verrichten."},
    {TR_BUILDING_LIGHTHOUSE_PHASE_4_TEXT, "Baumeister geben dem Leuchtturm den letzten Schliff. Bald schon wird er kilometerweit leuchten und Schiffen den Weg weisen."},
    {TR_BUILDING_LIGHTHOUSE_CONSTRUCTION_DESC, "Der Bau des Leuchtturms benötigt gelagerte Materialien aus einem Lagerhaus, Bauarbeiter eines Arbeiterlagers und Baumeister einer Baumeistergilde."},
    {TR_BUILDING_LIGHTHOUSE_BONUS_DESC, "Fischerboote bewegen sich 10 % schneller und eine stürmische See beruhigt sich doppelt so schnell."},
    {TR_BUILDING_LIGHTHOUSE_POLICY_TITLE, "Seehandelspolitik"},
    {TR_BUILDING_LIGHTHOUSE_NO_POLICY, "Keine Seehandelspolitik."},
    {TR_BUILDING_LIGHTHOUSE_POLICY_TEXT, "Wählen Sie eine Seehandelspolitik für Ihre Stadt. Sie können sie jederzeit kostenpflichtig ändern."},
    {TR_BUILDING_LIGHTHOUSE_POLICY_1_TITLE, "Consilium venditor maritimae"},
    {TR_BUILDING_LIGHTHOUSE_POLICY_1, "Maritime Verkaufspolitik: See-Exporte bringen 20 % mehr Gewinn, aber See-Importe sind 10 % teurer."},
    {TR_BUILDING_LIGHTHOUSE_POLICY_2_TITLE, "Consilium emptor maritimae"},
    {TR_BUILDING_LIGHTHOUSE_POLICY_2, "Maritime Einkaufspolitik: See-Importe sind 20 % billiger, aber See-Exporte bringen 10 % weniger Gewinn."},
    {TR_BUILDING_LIGHTHOUSE_POLICY_3_TITLE, "Consilium quantitas maritimae"},
    {TR_BUILDING_LIGHTHOUSE_POLICY_3, "Maritime Mengenpolitik: Handelsschiffe transportieren 4 zusätzliche Waren, aber der Leuchtturm verbraucht 20 % mehr Holz."},
    /* Gebäude - Münze */
    {TR_BUILDING_CITY_MINT, "Münze" },
    {TR_BUILDING_CITY_MINT_DESC, "Hier wird Gold zu Denaren geprägt, diese füllen die städtische Schatzkammer." },
    {TR_BUILDING_CITY_MINT_DESC_ALTERNATIVE, "Hier werden die Denare in Gold eingeschmolzen, das für den Bau von Denkmälern verwendet werden kann."},
    {TR_BUILDING_CITY_MINT_DESC_NO_PALACE, "Baut euer Anwesen, damit die Münze auch euch persönlich bereichert." },
    {TR_BUILDING_CITY_MINT_DESC_PALACE, "Da ihr ein Anwesen habt, bekommt ihr extra Denare für euren Geldbeutel." },
    {TR_BUILDING_CITY_MINT_FULL_EMPLOYEES, "Die Münze hat alle Arbeiter die benötigt werden. Sie arbeitet auf hochtouren, um neue Denare zu prägen." },
    {TR_BUILDING_CITY_MINT_MANY_EMPLOYEES, "Die Münze arbeitet nicht auf ihrer maximalen Auslastung. Das Prägen von Denaren ist daher weniger effizient." },
    {TR_BUILDING_CITY_MINT_HALF_EMPLOYEES, "Die Münze is unterbesetzt. Das Prägen von Denaren dauert länger als geplant." },
    {TR_BUILDING_CITY_MINT_SOME_EMPLOYEES, "Es gibt nur wenige Arbeiter. Das Prägen von Denaren ist deswegen sehr langsam." },
    {TR_BUILDING_CITY_MINT_FEW_EMPLOYEES, "Mit einem Minimum an Arbeitern kommt das Prägen zum Erliegen. Diese Jahr werden fast keine Denare geprägt." },
    {TR_BUILDING_CITY_MINT_NO_EMPLOYEES, "Die lokale Münze hat keine Arbeiter. Die Münzprägung ist gestoppt." },
    {TR_BUILDING_CITY_MINT_NO_GOLD, "Dieses Gebäude braucht Gold, entweder von einem Lagerhaus oder der Goldmine, um zu arbeiten." },
    {TR_BUILDING_CITY_MINT_STORED_GOLD, "Gelagertes Gold," },
    {TR_BUILDING_CITY_MINT_NO_SENATE, "Dieses Gebäude braucht einen aktiven Senat. Ohne den Senat können keine Denare geprägt werden." },
    {TR_BUILDING_CITY_MINT_PHASE_1, "(Fundament)" },
    {TR_BUILDING_CITY_MINT_PHASE_1_TEXT, "Die Baumeister arbeiten an dem Fundament." },
    {TR_BUILDING_CITY_MINT_CONVERT, "Konvertieren:"},
    {TR_BUILDING_CITY_MINT_GOLD_TO_DN, "Eine Wagenladung Gold zu 500 Denaren"},
    {TR_BUILDING_CITY_MINT_DN_TO_GOLD, "600 Denare für eine Wagenladung Gold"},
    {TR_BUILDING_CITY_MINT_CHANGE_PRODUCTION, "Veränderung der städtischen Münzproduktion?"},
    {TR_BUILDING_CITY_MINT_PROGRESS_WILL_BE_LOST, "Der aktuelle Produktionsfortschritt geht verloren."},
	/* Gebäude - Palisaden */
    {TR_BUILDING_PALISADE, "Palisade"},
    {TR_BUILDING_PALISADE_DESC, "Dieser Erdwall, der von einer hohen Mauer aus angespitzten Holzpflöcken gekrönt wird, schützt Ihre Stadt vor Eindringlingen und gefährlichen Tieren."},
    {TR_BUILDING_PALISADE_GATE, "Palisadentor"},
    {TR_BUILDING_PALISADE_GATE_DESC, "Dieses schmale hölzerne Tor kontrolliert den Personenverkehr innerhalb und außerhalb der Verteidigungsanlagen Ihrer Stadt."},
	/* Gebäude - Prachttempel & Pantheon */
    {TR_BUILDING_GRAND_TEMPLE_MENU, "Prachttempel"},
    {TR_BUILDING_GRAND_TEMPLE_NEEDS_WORKERS, "Ohne einen vollen Stab von Priestern und Dienern kann dieser Tempel nicht alle heiligen Riten und Feiern durchführen. Solange sich das nicht ändert, sollten Sie keine göttliche Gunst erwarten."},
    {TR_BUILDING_GRAND_TEMPLE_ADD_MODULE, "Tempel eine Widmung geben"},
    {TR_BUILDING_GRAND_TEMPLE_CERES, "Ceres' Prachttempel"},
    {TR_BUILDING_GRAND_TEMPLE_CERES_BONUS_DESC, "Ceres inspiriert die Wagenschieber von den Farmen Ihrer Stadt, sich 50 % schneller zu bewegen."},
    {TR_BUILDING_GRAND_TEMPLE_CERES_DESC, "Prachttempel der Ceres"},
    {TR_BUILDING_GRAND_TEMPLE_CERES_DESC_MODULE_1, "Templum Ceres Fecunda"},
    {TR_BUILDING_GRAND_TEMPLE_CERES_DESC_MODULE_2, "Templum Ceres Frugifera"},
    {TR_BUILDING_GRAND_TEMPLE_CERES_MODULE_1_DESC, "Priester reduzieren Nahrungsverbrauch um 20 % in Häusern mit Zugang zu einem Tempel der Ceres."},
    {TR_BUILDING_GRAND_TEMPLE_CERES_MODULE_2_DESC, "Tempel der Ceres agieren als Märkte. Sie sammeln und verteilen ein lokal produziertes Nahrungsmittel und Öl."},
    {TR_BUILDING_CERES_TEMPLE_MODULE_DESC, "Die Priester des Prachttempels der Ceres unterstützen die Versorgung hungriger Einwohner mit Nahrung und Öl."},
    {TR_BUILDING_CERES_TEMPLE_QUOTE, "Ceres teilte zuerst mit gebogenem Pfluge die Schollen,\nGab Feldfrüchte den Ländern zuerst\n und mildere Nahrung,\nOrdnete Sitten zuerst; ja, alles ist Gabe der Ceres.\nCeres gebührt mein Sang.\n-Ovid, die Metamorphose; Ceres und Proserpina"},
    {TR_BUILDING_GRAND_TEMPLE_MARS, "Mars' Prachttempel"},
    {TR_BUILDING_GRAND_TEMPLE_MARS_BONUS_DESC, "Mars fordert Ihre Bürger auf, sich zu melden, schickt Rekruten von seinem Tempel zu den Forts Ihrer Stadt und erlaubt den Bau von vier weiteren Forts."},
    {TR_BUILDING_GRAND_TEMPLE_MARS_DESC, "Prachttempel des Mars"},
    {TR_BUILDING_GRAND_TEMPLE_MARS_DESC_MODULE_1, "Templum Mars Ultor"},
    {TR_BUILDING_GRAND_TEMPLE_MARS_DESC_MODULE_2, "Templum Mars Quirinus"},
    {TR_BUILDING_GRAND_TEMPLE_MARS_MODULE_1_DESC, "Priester des Mars erzeugen Nahrung, in einer Menge, die sich nach der Anzahl der Häuser richtet, die sie abdecken, und liefern sie an den Versorgungsposten. Gebäudekosten von Forts werden um 25 % reduziert."},
    {TR_BUILDING_GRAND_TEMPLE_MARS_MODULE_2_DESC, "Priester reduzieren den Verbrauch aller Waren um 10 % in Häusern mit Zugang zu einem Tempel des Mars."},
    {TR_BUILDING_MARS_TEMPLE_MODULE_DESC, "Die Priester des Prachttempels des Mars sammeln Lebensmittelspenden für Ihre Truppen, um diese an den Versorgungsposten zu liefern."},
    {TR_BUILDING_MARS_TEMPLE_QUOTE, "Andere schufen für Mars ein Fahrzeug\nmit fliegenden Rädern, wie er es braucht,\num Menschen und Städte aufs Schlachtfeld zu hetzen.\n-Virgil, die Aeneis; achter Gesang"},
    {TR_BUILDING_GRAND_TEMPLE_MERCURY, "Merkurs Prachttempel"},
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_BONUS_DESC, "Merkur segnet Ihre Händler zu Lande und zu Wasser mit einer zusätzlichen Kapazität von 50 % und inspiriert Landhändler, sich 25 % schneller zu bewegen."},
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_DESC, "Prachttempel des Merkur"},
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_DESC_MODULE_1, "Templum Mercurius Fortunus"},
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_DESC_MODULE_2, "Templum Mercurius Mercator"},
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_MODULE_1_DESC, "Priester des Merkur reduzieren Geschirr- und Möbelverbrauch um 20 % in Häusern mit Zugang zu einem Tempel des Merkur."},
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_MODULE_2_DESC, "Priester reduzieren Öl- und Weinkonsum um 20 % in Häusern mit Zugang zu einem Tempel des Merkur."},
    {TR_BUILDING_MERCURY_TEMPLE_QUOTE, "Beutet man doch im Kriege gemästete Rinder und Schafe,\nUnd gewinnt Dreifüß' und braungemähnete Rosse;\nAber des Menschen Geist kehrt niemals,\nweder erbeutet, noch erlangt, \nnachdem er des Sterbenden Lippen entflohn ist.\n-Homer, Die Ilias; 9. Gesang"},
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE, "Neptuns Prachttempel"},
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_BONUS_DESC, "Neptun gewährt eine zusätzliche Reichweite von +1 für Brunnen und Ziehbrunnen sowie +2 für Reservoirs. Der Arbeitsaufwand für die Wasserversorgung wird außerdem um 50 % reduziert und Handelsschiffe fahren 25 % schneller. Die Zunahme von Krankheiten in Häusern wird stark eingeschränkt."},
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_DESC, "Prachttempel des Neptun"},
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_DESC_MODULE_1, "Templum Neptunus Equester"},
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_DESC_MODULE_2, "Templum Neptunus Adiutor"},
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_MODULE_1_DESC, "Tempel des Neptun produzieren Wagenlenker für das Hippodrom."},
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_MODULE_2_DESC, "Priester erhöhen das Limit an Bewohnern um 5 % für Häuser mit Zugang zu Tempeln des Neptun. Der Prachttempel des Neptun dient als gefülltes Reservoir ohne Zugang zu Gewässern zu benötigen."},
    {TR_BUILDING_NEPTUNE_TEMPLE_QUOTE, "Nicht bleibt zürnend die See. Hinlegend die zackige Waffe\nGlättet die Flut der Beherrscher des Meers,\nUnd den bläulichen Triton rufet er,\nDer an der Schulter bedeckt von haftenden Schnecken\nÜber der Tiefe sich hebt und heißt in die tönende Muschel.\n-Ovid, die Metamorphose; Deukalion und Pyrrha"},
    {TR_BUILDING_GRAND_TEMPLE_VENUS, "Venus' Prachttempel"},
    {TR_BUILDING_GRAND_TEMPLE_VENUS_BONUS_DESC, "Venus lässt die Gärten, Statuen und Tempel Ihrer Stadt in Schönheit erstrahlen und macht sie dadurch attraktiver. Häuser fassen auch mehr Güter und bleiben auch ohne Dienste und Waren länger bestehen."},
    {TR_BUILDING_GRAND_TEMPLE_VENUS_DESC, "Prachttempel der Venus"},
    {TR_BUILDING_GRAND_TEMPLE_VENUS_DESC_MODULE_1, "Templum Venus Verticordia"},
    {TR_BUILDING_GRAND_TEMPLE_VENUS_DESC_MODULE_2, "Templum Venus Genetrix"},
    {TR_BUILDING_GRAND_TEMPLE_VENUS_MODULE_1_DESC, "Der Prachttempel produziert Wein im Verhältnis zur Bevölkerung mit Zugang zu Tempeln der Venus. Priester verteilen ihn an die Häuser."},
    {TR_BUILDING_GRAND_TEMPLE_VENUS_MODULE_2_DESC, "Priester bieten Unterhaltung und verschönern Häuser, dies steigert die Attraktivität der Nachbarschaft ohne weitere Dekorationen."},
    {TR_BUILDING_VENUS_TEMPLE_MODULE_DESC, "Der Prachttempel der Venus ermöglicht Ihren Priestern, die Bevölkerung mit gesegnetem Wein zu versorgen."},
    {TR_BUILDING_VENUS_TEMPLE_QUOTE, "Venus du holde mitsamt dem beflügelten Sohne Cupido,\nOh, was empfand ich für Lust!\n Wie deutlich gefühltes Entzücken nahm mich dahin!\nWie lag ich gelöst im innersten Marke!\n-Ovid, Die Metamorphose; Byblis"},
    {TR_BUILDING_PANTHEON, "Pantheon"},
    {TR_BUILDING_PANTHEON_BONUS_DESC, "Das Pantheon bietet Ihren Bürgern die Möglichkeit, alle Götter anzubeten. Hier finden auch jährliche Feste statt und die Abgaben für religiöse und kulturelle Gebäude werden um 25 % reduziert."},
    {TR_BUILDING_PANTHEON_DESC, "Pantheon"},
    {TR_BUILDING_PANTHEON_DESC_MODULE_1, "Pantheum Ara Maxima"},
    {TR_BUILDING_PANTHEON_DESC_MODULE_2, "Pantheum Roma Aeterna"},
    {TR_BUILDING_PANTHEON_MODULE_1_DESC, "Alle Tempel der Stadt senden Priester zum Pantheon. Diese Priester verbreiten den Glauben und Segen ihrer Götter!"},
    {TR_BUILDING_PANTHEON_MODULE_2_DESC, "Häuser mit Zugang zum Pantheon können sich eine Stufe weiterentwickeln."},
    {TR_BUILDING_PANTHEON_QUOTE, "Weit auf tut sich indes des Olymps allmächtiges Haus,\nes Ruft zur Versammlung der Vater der Götter\nund König der Menschen.\nIn dem gestirnumstrahlten Palast,\nvon wo er auf alle Länder, der Dardaner Burg\nund Latiums Völker hinabschaut.\n-Virgil, Die Aeneis; Zehnter Gesang"},
    {TR_CONSTRUCTION_PHASE, "Konstruktionsphase:"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_1, "(Podium)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_1_TEXT, "Bauarbeiter errichten das Podium, welches den Tempel emporheben und als solides Fundament dienen wird, um die Zeit zu überdauern."},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_2, "(Portico)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_2_TEXT, "Handwerker fertigen den Portico, in welchem sich der Opferaltar des Tempels befindet."},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_3, "(Cella)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_3_TEXT, "Baumeister errichten die Cella. In diesem innersten Raum des Tempels steht die Statue der Gottheit. Die Cella gilt als heiliger Ort der Gottheit. "},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_4, "(Praecinctum)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_4_TEXT, "Die Arbeit am Praecinctum hat begonnen, wo Gläubige sich für öffentliche Zeremonien versammeln."},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_5, "(Dedicatio)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_5_TEXT, "Mit dem Tempel beinahe fertiggestellt, sammeln sich Priester um die Rieten der Tempelweihe durchzuführen. "},
    {TR_BUILDING_GRAND_TEMPLE_CONSTRUCTION_DESC, "Der Bau eines Prachttempels benötigt in einem Lagerhaus gelagerte Waren, Arbeiter von einem Arbeiterlager und Baumeister von einer Baumeistergilde."},
    {TR_BUILDING_TEMPLE_MODULE_CONSTRUCTED, "Widmung zugewiesen."},
    {TR_REQUIRED_RESOURCES, "Gelieferte Ressourcen für aktuelle Phase:"},
    {TR_ADD_MODULE, "Tempel umwidmen?"},
    {TR_SELECT_EPITHET_PROMPT_HEADER, "Widmung auswählen"},
    {TR_SELECT_EPITHET_PROMPT_TEXT, "Die Widmung wird den Tempel unwiderruflich und dauerhaft spezialisieren und die Priester mit göttlicher Macht erfüllen."},
    {TR_BUILDING_MONUMENT_CONSTRUCTION_DESC, "Der Bau des Monuments benötigt in einem Lagerhaus gelagerte Materialien, Arbeiter eines Arbeitslagers und Baumeister einer Baumeistergilde."},
    {TR_BUILDING_MONUMENT_CONSTRUCTION_HALTED, "Bau gestoppt."},
    {TR_CONFIRM_DELETE_MONUMENT, "Dieses Monument abreißen?"},
    /* Gebäude - Sandgrube */
	{TR_BUILDING_SAND_PIT, "Sandgrube"},
    {TR_BUILDING_SAND_PIT_DESC, "Sand für den Monumentbau."},
    {TR_BUILDING_SAND_PIT_PRODUCTION, "Produktion ist"},
    {TR_BUILDING_SAND_PIT_COMPLETE, "abgeschlossen."},
    {TR_BUILDING_SAND_PIT_HALTED, "Ihr Handelsberater ordnete einen Stopp der Sandförderung an."},
    {TR_BUILDING_SAND_PIT_NO_EMPLOYEES, "Diese Grube hat keine Arbeiter. Die Produktion wurde eingestellt."},
    {TR_BUILDING_SAND_PIT_FULL_EMPLOYEES, "Diese Grube hat alle Arbeiter, die sie braucht, und arbeitet mit Hochdruck an der Sandförderung."},
    {TR_BUILDING_SAND_PIT_MANY_EMPLOYEES, "Diese Grube arbeitet unter ihrer maximalen Kapazität. Die Sandförderung wäre mit mehr Arbeitern effizienter."},
    {TR_BUILDING_SAND_PIT_HALF_EMPLOYEES, "Diese Grube ist unterbesetzt. Die Sandförderung dauert länger als geplant."},
    {TR_BUILDING_SAND_PIT_SOME_EMPLOYEES, "In dieser Grube arbeiten nur sehr wenige Menschen. Die Sandproduktion ist daher langsam."},
    {TR_BUILDING_SAND_PIT_FEW_EMPLOYEES, "Da es hier kaum noch Arbeiter gibt, ist die Produktion fast zum Erliegen gekommen. Sie wird im kommenden Jahr nur wenig Sand produzieren."},
    {TR_BUILDING_GRANARY_NO_FOOD, "In diesem Silo wird keine Nahrung gelagert." },
    {TR_BUILDING_WAREHOUSE_NO_GOODS, "In diesem Warenhaus werden keine Güter gelagert." },
	/* Gebäude - Schnellstraße */
	{TR_BUILDING_HIGHWAY, "Schnellstraße" },
    {TR_BUILDING_HIGHWAY_DESC, "Schnellstraße ermöglichen es den Bürgern, ihr Ziel schneller zu erreichen." },
    /* Gebäude - Steinbruch */
	{TR_BUILDING_STONE_QUARRY, "Steinbruch"},
    {TR_BUILDING_STONE_QUARRY_DESC, "Steine für den Monumentbau."},
    {TR_BUILDING_STONE_QUARRY_PRODUCTION, "Produktion ist"},
    {TR_BUILDING_STONE_QUARRY_COMPLETE, "abgeschlossen."},
    {TR_BUILDING_STONE_QUARRY_HALTED, "Ihr Handelsberater ordnete einen Stopp des Steinabbaus an."},
    {TR_BUILDING_STONE_QUARRY_NO_EMPLOYEES, "Dieser Steinbruch hat keine Arbeiter. Die Produktion wurde eingestellt."},
    {TR_BUILDING_STONE_QUARRY_FULL_EMPLOYEES, "Dieser Steinbruch hat alle Arbeiter, die er braucht, und arbeitet mit Hochdruck an der Steinproduktion." },
    {TR_BUILDING_STONE_QUARRY_MANY_EMPLOYEES, "Dieser Steinbruch arbeitet unter seiner maximalen Kapazität. Der Steinabbau könnte mit mehr Arbeitern etwas effizienter sein." },
    {TR_BUILDING_STONE_QUARRY_HALF_EMPLOYEES, "Dieser Steinbruch ist unterbesetzt. Es dauert länger, Stein zu produzieren, als es sollte." },
    {TR_BUILDING_STONE_QUARRY_SOME_EMPLOYEES, "In diesem Steinbruch arbeiten nur sehr wenige Menschen. Die Steinproduktion ist dementsprechend langsam." },
    {TR_BUILDING_STONE_QUARRY_FEW_EMPLOYEES, "Da es hier kaum Arbeiter gibt, ist die Produktion fast zum Erliegen gekommen. Er wird im kommenden Jahr nur wenig Stein produzieren."},
	/* Gebäude - Straßensperre */
    {TR_BUILDING_ROADBLOCK, "Straßensperre"},
    {TR_BUILDING_ROADBLOCK_DESC, "Straßensperren verhindern das unkontrollierte Umherwandern von Einwohnern."},
	/* Gebäude - Taverne */
    {TR_BUILDING_TAVERN, "Taverne"},
    {TR_BUILDING_GRAND_GARDEN, "Großer Garten"},
    {TR_BUILDING_TAVERN_DESC_1, "Diese Taverne hat keine Arbeiter und kann das Geschäft nicht eröffnen."},
    {TR_BUILDING_TAVERN_DESC_2, "Diese Taverne hat keinen Wein und kann das Geschäft nicht eröffnen."},
    {TR_BUILDING_TAVERN_DESC_3, "Diese Taverne bietet Unterhaltung solange der Wein fließt. Eine Versorgung mit Fleisch würde ihre Attraktivität erhöhen."},
    {TR_BUILDING_TAVERN_DESC_4, "Reichlich Wein und der Geruch von gebratenem Fleisch locken ein lebhaftes Publikum in diese Taverne zu Glücksspiel, Musik und Fröhlichkeit."},
    {TR_TAVERN_FETCHING, "holend" },
    {TR_TAVERN_NOT_FETCHING, "nicht holend" },
    {TR_BUILDING_TAVERN_DESC_5, "Die Bürger besuchen dieses Lokal in ihrer Freizeit gerne, um sich bei gutem Essen und Wein zu unterhalten."},
	/* Gebäude - Tempel */
	{TR_BUILDING_SMALL_TEMPLE_CERES_NAME, "Tempel der Ceres"},
    {TR_BUILDING_SMALL_TEMPLE_NEPTUNE_NAME, "Tempel des Neptun"},
    {TR_BUILDING_SMALL_TEMPLE_MERCURY_NAME, "Tempel des Merkur"},
    {TR_BUILDING_SMALL_TEMPLE_MARS_NAME, "Tempel des Mars"},
    {TR_BUILDING_SMALL_TEMPLE_VENUS_NAME, "Tempel der Venus"},
    {TR_BUILDING_SMALL_TEMPLE_PHASE_1, "(Konstruktion)"},
    {TR_BUILDING_SMALL_TEMPLE_PHASE_1_TEXT, "Steinmetze und Baumeister bauen sorgfältig dieses heilige Bauwerk aus schimmerndem Marmor."},
    {TR_BUILDING_SMALL_TEMPLE_CONSTRUCTION_DESC, "Für den Bau dieses Tempels werden Material aus einem Lagerhaus, Arbeiter aus einem Arbeitslager und Baumeister aus einer Baumeistergilde benötigt."},
    /* Gebäude - Versorgungsposten */
    {TR_BUILDING_INFO_MONTHLY_LEVY, "/ Monat"},
    {TR_BUILDING_MESS_HALL, "Versorgungsposten"},
    {TR_BUILDING_MESS_HALL_DESC, "Der Versorgungsposten sammelt Nahrung aus Silos, um die Soldaten der Stadt zu versorgen. Ein schlecht versorgter Posten verlangsamt die Ausbildung neuer Soldaten und verringert die Moral der Truppen."},
    {TR_BUILDING_MESS_HALL_FULFILLMENT, "Versorgung des letzten Monats:"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER, "Soldaten sind: "},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_1, "gut genährt"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_2, "satt"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_3, "hungrig"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_4, "sehr hungrig"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_5, "am Verhungern"},
    {TR_BUILDING_MESS_HALL_FOOD_TYPES_BONUS_1, "Die abwechslungsreiche Ernährung verbessert die Moral Ihrer Soldaten."},
    {TR_BUILDING_MESS_HALL_FOOD_TYPES_BONUS_2, "Ihre Soldaten genießen das vielfältige und reichhaltige Nahrungsangebot. Ihre Moral steigt enorm."},
    {TR_BUILDING_MESS_HALL_NO_SOLDIERS, "Ihr habt keine Soldaten zu ernähren."},
    {TR_BUILDING_MESS_HALL_MONTHS_FOOD_STORED, "Gelagerte Nahrung in Monaten:"},
    {TR_BUILDING_BARRACKS_FOOD_WARNING, "Nahrungsknappheit im Versorgungsposten verlangsamt die Ausbildung neuer Soldaten."},
    {TR_BUILDING_BARRACKS_FOOD_WARNING_2, "Kritische Nahrungsknappheiten an deinen Versorgungsposten verlangsamen die Sodatenrekrutierung."},
    {TR_BUILDING_LEGION_FOOD_WARNING_1, "Kürzliche Nahrungsknappheit verringert die Moral."},
    {TR_BUILDING_LEGION_FOOD_WARNING_2, "Moral durch Nahrungsknappheit enorm verringert."},
    {TR_BUILDING_LEGION_STARVING, "Schwach vor Hunger"},
    {TR_BUILDING_LEGION_FOOD_BONUS, "Reichhaltiges Nahrungsangebot steigert die Moral"},
    {TR_BUILDING_LEGION_FOOD_STATUS, "Versorgungsstatus"},
    /* Gebäude - Wachturm */	
	{TR_BUILDING_WATCHTOWER, "Wachturm"},
    {TR_BUILDING_WATCHTOWER_DESC, "Bogenschützen auf den Zinnen dieses Turms halten wachsam Ausschau nach jedem Anzeichen von Eindringlingen, während Wächter unten auf den Straßen patrouillieren."},
    {TR_BUILDING_WATCHTOWER_DESC_NO_SOLDIERS, "Dieser Wachturm braucht einen Wächter aus der Kaserne, bevor er unsere Stadt schützen kann."},
    /* Gebäude - Ziegelei */
	{TR_BUILDING_BRICKWORKS, "Ziegelei"},
    {TR_BUILDING_BRICKWORKS_DESC, "Hier werden Sand und Ton zu Ziegeln für den Monumentbau verarbeitet."},
    {TR_BUILDING_BRICKWORKS_PRODUCTION, "Produktion ist"},
    {TR_BUILDING_BRICKWORKS_COMPLETE, "abgeschlossen."},
    {TR_BUILDING_BRICKWORKS_HALTED, "Ihr Handelsberater ordnete einen Stopp der Ziegelproduktion an."},
    {TR_BUILDING_BRICKWORKS_NO_EMPLOYEES, "Diese Werkstatt hat keine Arbeiter. Die Produktion wurde eingestellt."},
    {TR_BUILDING_BRICKWORKS_FULL_EMPLOYEES, "Diese Werkstatt hat alle Arbeiter, die sie braucht, und arbeitet mit Hochdruck an der Herstellung von Ziegeln."},
    {TR_BUILDING_BRICKWORKS_MANY_EMPLOYEES, "Diese Werkstatt arbeitet unter ihrer maximalen Kapazität. Die Ziegelproduktion könnte mit mehr Arbeitern etwas effizienter sein."},
    {TR_BUILDING_BRICKWORKS_HALF_EMPLOYEES, "Diese Werkstatt ist unterbesetzt. Die Produktion von Ziegeln dauert länger, als sie sollte."},
    {TR_BUILDING_BRICKWORKS_SOME_EMPLOYEES, "In dieser Werkstatt arbeiten nur sehr wenige Menschen. Die Ziegelproduktion ist daher langsam."},
    {TR_BUILDING_BRICKWORKS_FEW_EMPLOYEES, "Da es hier kaum Arbeiter gibt, ist die Produktion fast zum Erliegen gekommen. Sie wird im kommenden Jahr nur wenige Ziegel produzieren."},
    {TR_BUILDING_BRICKWORKS_NO_RESOURCES, "Diese Werkstatt benötigt Ton und Sand, die aus einem Lagerhaus oder einer Sand- und Tongrube angeliefert werden, um Ziegel herzustellen."},
    {TR_BUILDING_BRICKWORKS_STORED_SAND, "Gelagerter Sand,"},
    {TR_BUILDING_BRICKWORKS_STORED_CLAY, "Gelagerter Ton,"},
    /* Gebäude - Info */
    {TR_BUILDING_INFO_TOTAL_FOOD, "Nahrung insgesamt:" },
    /* Neue Figuren_Typen */
    {TR_FIGURE_TYPE_BARKEEP, "Gastwirtin"},
    {TR_FIGURE_TYPE_BARKEEP_SUPPLIER, "Tavernen-Lieferant"},
    {TR_FIGURE_TYPE_CARAVANSERAI_COLLECTOR, "Karavanserei Laufbursche"},
    {TR_FIGURE_TYPE_CARAVANSERAI_SUPPLIER, "Karavanserei-Lieferant"},
    {TR_FIGURE_TYPE_LIGHTHOUSE_SUPPLIER, "Leuchtturmwärter"},
    {TR_FIGURE_TYPE_LOOTER, "Plünderer"},
    {TR_FIGURE_TYPE_MESS_HALL_COLLECTOR, "Lagerarbeiter"},
    {TR_FIGURE_TYPE_MESS_HALL_SUPPLIER, "Quartiermeister"},
    {TR_FIGURE_TYPE_PRIEST_SUPPLIER, "Priester"},
    {TR_FIGURE_TYPE_ROBBER, "Räuber"},
    {TR_FIGURE_TYPE_TOURIST,  "Reisender"},
    {TR_FIGURE_TYPE_WATCHMAN, "Wächter"},
    {TR_FIGURE_TYPE_WORK_CAMP_ARCHITECT, "Baumeister"},
    {TR_FIGURE_TYPE_WORK_CAMP_SLAVE, "Träger"},
    {TR_FIGURE_TYPE_WORK_CAMP_WORKER, "Vorarbeiter"},
    {TR_FIGURES_CARTPUSHER_GOING_TO_ROME, "Lieferung der Forderung an Rom"},
    /* Neue Ressourcen */
    {TR_RESOURCE_FISH, "Fisch"},
    {TR_RESOURCE_GOLD, "Gold" },
    {TR_RESOURCE_STONE, "Stein"},
    {TR_RESOURCE_SAND, "Sand"},
    {TR_RESOURCE_BRICKS, "Ziegel"},
    {TR_RESOURCE_CONCRETE, "Beton"},
	/* System - Bildung */
    {TR_WINDOW_ADVISOR_EDUCATION_MISSION_POSTS, "Missionsposten"},
    {TR_BUILDING_ACADEMY_UPGRADE_DESC, "Diese Akademie ist in Betrieb. Die lokale Entwicklung hat es Ihren Bürgern ermöglicht, das Gebäude auszubauen und mehr Platz für Vorträge und Forschung zu schaffen."},
    {TR_BUILDING_SCHOOL_UPGRADE_DESC, "Diese Schule ist in Betrieb. Lokale Entwicklungen ermöglichten es Ihren Bürgern, das Gebäude zu erweitern, so dass mehr Kinder zur gleichen Zeit lernen können."},
    {TR_BUILDING_THEATRE_UPGRADE_DESC, "Dieses Theater ist in Betrieb. Lokale Entwicklungen ermöglichten es Ihren Bürgern, das Gebäude zu erweitern, so dass mehr Menschen die Vorstellungen sehen können."},
    {TR_BUILDING_LIBRARY_UPGRADE_DESC, "Diese Bibliothek ist in Betrieb. Lokale Entwicklungen ermöglichten es Ihren Bürgern, das Gebäude zu erweitern, wodurch zusätzliche Regale mit Schriftrollen für mehr Menschen zur Verfügung stehen."},
    /* System - Effizienz */
    {TR_BUILDING_WINDOW_INDUSTRY_EFFICIENCY, "Effizienz:"},
    {TR_BUILDING_WINDOW_INDUSTRY_EFFICIENCY_TOOLTIP, "Die Effizienz ist das Verhältnis zwischen der Menge, die das Gebäude in einem Jahr produzieren kann, und der Menge, die es im vergangenen Jahr produziert hat."},
    {TR_BUILDING_WINDOW_INDUSTRY_LOW_EFFICIENCY_RAW_MATERIALS, "Dieses Gebäude hat eine geringe Effizienz. Dies könnte darauf zurückzuführen sein, dass es keinen nahen Bestimmungsort für die Endprodukte gibt."},
    {TR_BUILDING_WINDOW_INDUSTRY_LOW_EFFICIENCY_WORKSHOPS, "Dieses Gebäude hat eine geringe Effizienz. Dies könnte darauf zurückzuführen sein, dass es an einer konstanten Versorgung mit Rohstoffen oder an einem nahe gelegenen Bestimmungsort für die Endprodukte fehlt."},
    {TR_BUILDING_WINDOW_INDUSTRY_WHARF_AVERAGE_CATCH, "Durchschnittlicher monatlicher Fang:"},
    {TR_BUILDING_WINDOW_INDUSTRY_NEEDED, " benötigt)" },
    /* System - Gesundheit und Plagen */
    {TR_BUILDING_DOCK_PLAGUE_DESC, "Die Pest wurde von einem Handelsschiff hierher gebracht. Dieses Dock steht unter Quarantäne, während ein Arzt oder Chirurg das Gebiet dekontaminiert."},
    {TR_BUILDING_GRANARY_PLAGUE_DESC, "Die Pest wurde von einem kontaminierten Arbeiter hierher gebracht. Dieses Silo steht unter Quarantäne, während ein Arzt oder Chirurg den Bereich dekontaminiert."},
    {TR_BUILDING_WAREHOUSE_PLAGUE_DESC, "Die Pest wurde von einem kontaminierten Arbeiter hierher gebracht. Dieses Lagerhaus steht unter Quarantäne, während ein Arzt oder Chirurg den Bereich dekontaminiert."},
    {TR_BUILDING_HOUSE_DISEASE_DESC, "Die Pestilenz hat zugeschlagen! Durch mangelnde medizinische Versorgung sind die Bewohner des Hauses gestorben. Das Haus steht unter Quarantäne, während ein Arzt oder Chirurg das Gebiet dekontaminiert."},
    {TR_BUILDING_FUMIGATION_DESC, "Das Gebäude wird dekontaminiert. Die Ausräucherung sollte ein paar Tage dauern."},
    /* System - Stimmung */
	{TR_BUILDING_WINDOW_HOUSE_SENTIMENT_1, "Die Bewohner verabscheuen Ihren Namen."},
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_2, "Die Bewohner sind sehr sauer auf Sie."},
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_3, "Die Bewohner sind sauer auf Sie."},
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_4, "Die Bewohner sind sehr verärgert von Ihnen."},
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_5, "Die Bewohner sind verärgert von Ihnen."},
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_6, "Die Bewohner sind genervt von Ihnen."},
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_7, "Die Bewohner sind gleichgültig gegenüber Ihnen."},
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_8, "Die Bewohner sind zufrieden mit Ihnen."},
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_9, "Die Bewohner sind sehr zufrieden mit Ihnen."},
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_10, "Die Bewohner sind extrem zufrieden mit Ihnen."},
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_11, "Die Bewohner lieben Sie."},
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_12, "Die Bewohner vergöttern Sie wie einen Gott."},
    {TR_BUILDING_WINDOW_HOUSE_UPSET_HIGH_TAXES, "Die Bewohner sind verärgert über hohe Steuern."},
    {TR_BUILDING_WINDOW_HOUSE_UPSET_LOW_WAGES, "Die Bewohner sind verärgert über niedrige Bezahlung."},
    {TR_BUILDING_WINDOW_HOUSE_UPSET_UNEMPLOYMENT, "Die Bewohner sind verärgert über fehlende Arbeitsplätze."},
    {TR_BUILDING_WINDOW_HOUSE_UPSET_SQUALOR, "Die Bewohner sind verzweifelt über ihre schlechte Unterbringung."},
    {TR_BUILDING_WINDOW_HOUSE_SUGGEST_ENTERTAINMENT, "Die Bewohner würden mehr Unterhaltung schätzen."},
    {TR_BUILDING_WINDOW_HOUSE_SUGGEST_FOOD, "Die Bewohner würden eine abwechslungsreiche Ernährung schätzen."},
    {TR_BUILDING_WINDOW_HOUSE_SUGGEST_DESIRABILITY, "Die Bewohner würden mehr Attraktivität schätzen."},
    {TR_BUILDING_WINDOW_HOUSE_RECENT_EVENT_POSITIVE, "Die Stimmung der Bewohner wird durch ein kürzlich stattgefundenes Ereignis gehoben."},
    {TR_BUILDING_WINDOW_HOUSE_RECENT_EVENT_NEGATIVE, "Die Bewohner sind durch ein aktuelles Ereignis entmutigt."},
    {TR_WINDOW_BUILDING_WORKSHOP_STRIKING, "Aufgrund der schlechten Stimmung in der Stadt haben die Plebejer dieser Werkstatt einen Streik ausgerufen und verweigern die Arbeit!"},
	/* System - Unterhaltung */
    {TR_BUILDING_INFO_TOURISM, "(Reisende)"},
    {TR_WINDOW_ADVISOR_TOURISM, "Sonstiges"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_NO_COVERAGE, "Niemand"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_FULL_COVERAGE, "Alle"},
    {TR_WINDOW_FIGURE_TOURIST, "Dieser Reisende hat:"},
    {TR_WINDOW_BUILDING_TOURISM_DISABLED, "Zu viele Gebäude dieses Typs - Reisende meiden diesen Ort."},
    {TR_WINDOW_BUILDING_TOURISM_ANNUAL, "Einnahmen von Reisenden in diesem Jahr:"},
	/* System - Unterhaltung - Gladiatorenspiele */
    {TR_SELECT_GAMES_HEADER, "Spiele"},
    {TR_SELECT_GAMES_TEXT, "Die Spiele werden im Kolosseum ausgetragen und kosten persönliches Sparguthaben und Ressourcen Ihrer Stadt."},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_ARENA_COVERAGE, "Arenen"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_TAVERN_COVERAGE, "Tavernen"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_HEADER, "Spiele"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_DESC, "Sponsern Sie große Spiele in Ihrem Kolosseum, welche persönliches Sparguthaben und Ressourcen Ihrer Stadt kosten."},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_BUTTON, "Spiele abhalten"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_PREPARING, "Die Großen Spiele werden vorbereitet."},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_COOLDOWN, "Monate, bis neue Spiele abgehalten werden können:"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_NG, "Monate bis zur Naumachie:"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_NG, "Die Seeschlacht ist in vollem Gange. Das Rauschen des Wassers, das Knarren der Balken und die Kampfschreie der Gladiatoren mischen sich mit dem Gebrüll der Menge."},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_AG, "Monate bis zur Tierhetze:"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_AG, "Die Tierhetzen sind in vollem Gange. Schulter an Schulter schreit sich der Mob heiser, während die wilden Bestien ihre menschliche Beute jagen."},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_KG, "Monate bis zu den Kalendae des Ianuarius:"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_KG, "Die Kalendae des Ianuarius sind in vollem Gange. Der Geruch von Tieropfern und Weihrauch überwältigt sogar das stechende Blut und den Schweiß der Arena."},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_OG, "Monate bis zu den Olympischen Spielen:"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_OG, "Die Olympischen Spiele sind in vollem Gange. Das heilige Feuer brennt Tag und Nacht, während die Athleten um unsterblichen Ruhm wettstreiten."},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_IG, "Monate bis zu den Römischen Spielen:"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_IG, "Die Römischen Spiele sind in vollem Gange. Jeder Teilnehmer setzt sein Blut, seinen Schweiß und seine Tränen ein, um sich als der beste Römer zu beweisen."},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_COOLDOWN_TEXT, "Die Großen Spiele wurden kürzlich abgehalten."},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_UNDERWAY, "Die Großen Spiele sind im Gange! Ihre Stadt wimmelt von Reisenden und Feiernden."},
    /* System - Unterhaltung - Pferdewetten */
	{TR_WINDOW_RACE_YOUR_BET, "Ihre Wette"},
    {TR_WINDOW_RACE_BET_BUTTON, "Wette platzieren"},
    {TR_WINDOW_IN_PROGRESS_BET_BUTTON, "Laufendes Rennen..."},
    {TR_WINDOW_RACE_BET_TITLE, "Auf Pferderennen wetten"},
    {TR_WINDOW_RACE_BET_AMOUNT, "Betrag"},
    {TR_WINDOW_RACE_BET_DESCRIPTION, "Setzen Sie einen Betrag aus Ihrem persönlichen Vermögen auf ein Wagengespann Ihrer Wahl und verdoppeln Sie Ihren Einsatz, wenn Ihr Pferd gewinnt. Während der Kolosseum-Spiele wird Ihr Gewinn sogar vervierfacht!"},
    {TR_WARNING_BET_VICTORY, "Dein Pferd hat das Rennen im Hippodrom deiner Stadt gewonnen."},
    {TR_WARNING_BET_DEFEAT, "Ihr Pferd hat das Rennen im Hippodrom Ihrer Stadt verloren."},
    {TR_PERSONAL_SAVINGS, "Ersparnisse: "},
    {TR_WINDOW_RACE_BET_BLUE_HORSE, "Setze auf das blaue Pferd"},
    {TR_WINDOW_RACE_BET_RED_HORSE, "Setze auf das rote Pferd"},
    {TR_WINDOW_RACE_BET_WHITE_HORSE, "Setze auf das weiße Pferd"},
    {TR_WINDOW_RACE_BET_GREEN_HORSE, "Setze auf das grüne Pferd"},
    {TR_WINDOW_RACE_BLUE_HORSE_DESCRIPTION, "Das blaue Team - die Lieblinge des Neptun. Es sind die vielversprechendsten jungen Wagenlenker Roms, die sich beweisen wollen."},
    {TR_WINDOW_RACE_RED_HORSE_DESCRIPTION, "Die rote Mannschaft - bekannt als die Mannschaft des erfolgreichsten Wagenlenkers in der Geschichte Roms - ein ehemaliger Ruderer und Retter eines römischen Konsuls."},
    {TR_WINDOW_RACE_WHITE_HORSE_DESCRIPTION, "Das weiße Team - gegründet von ehemaligen Gladiatoren. Sie haben den Kampf im Blut, und auch als freie Männer leben sie für die Herausforderung."},
    {TR_WINDOW_RACE_GREEN_HORSE_DESCRIPTION, "Das grüne Team - Nachfahren der \"Celeres\"-Reiter aus der Zeit des römischen Königreichs. Sie behaupten immer noch, die Besten der Besten zu sein."},
	/* UNSORTIERT */
    {TR_WINDOW_BUILDING_WHARF_MOTHBALLED, "Ihr Handelsberater hat einen Stopp der Fischproduktion angeordnet."},
    {TR_WINDOW_ADVISOR_FINANCE_INTEREST_TRIBUTE, "Tribut/Zins"},
    {TR_BUILDING_MARS_TEMPLE_MODULE_DESC_NO_MESS, "Dieser Tempel wird Essen für deinen Versorgungsposten, sobald er gebaut wurde."},
    {TR_WINDOW_BUILDING_INFO_WARNING_NO_MONUMENT_ROAD_ACCESS, "Diese Monumentbaustelle hat keinen Straßenzugang und kann keine Materialien aufnehmen. Verbinden Sie eine Straße mit einer der mittleren Flächen."},
    {TR_BUILDING_MONUMENT_CONSTRUCTION_ARCHITECT_NEEDED, "Dieses Denkmal verfügt über alle Materialien, die für diese Phase benötigt werden. Die Arbeiter warten auf einen qualifizierten Baumeister aus einer Baumeistergilde, der den weiteren Bau überwacht."},
    {TR_WINDOW_BUILDING_GOVERNMENT_LARGE_STATUE_WATER_WARNING, "Diese Statue würde noch großartiger aussehen, wenn der Springbrunnen aktiv wäre. Sorgen Sie für einen Zugang zum Wasser."},
    {TR_OPTION_MENU_APPLY, "Anwenden"},
    {TR_OPTION_MENU_COST, "Die Kosten betragen"},
    {TR_MARKET_TRADING, "Handel"},
    {TR_MARKET_NOT_TRADING, "kein Handel"},
    {TR_TEMPLE_DISTRIBUTING, "Verteilung"},
    {TR_TEMPLE_NOT_DISTRIBUTING, "keine Verteilung"},
    {TR_WINDOW_ADVISOR_RELIGION_LARARIUMS, "Lararia in der Stadt"},
    {TR_BUILDING_COLOSSEUM_NEEDS_WORKERS, "Das Kolosseum ist unterbesetzt. Es werden mehr Arbeiter benötigt, damit alle Ihre Bürger die Spiele genießen können."},
    {TR_BUILDING_HIPPODROME_NEEDS_WORKERS, "Das Hippodrom ist unterbesetzt. Es werden mehr Arbeiter benötigt, um allen Ihren Bürgern spektakuläre Unterhaltung zu bieten."},
    {TR_BUILDING_LIGHTHOUSE_NEEDS_WORKERS, "Der Leuchtturm ist unterbesetzt und kann das Feuer nicht am Laufen halten. Schiffe haben Mühe, den Weg zu den Docks Ihrer Stadt zu finden."},
    {TR_BUILDING_CARAVANSERAI_NEEDS_WORKERS, "Die Karawanserei ist unterbesetzt und kann nicht alle ankommenden Karawanen versorgen."},
    {TR_WINDOW_BUILDING_DISTRIBUTION_CART_PUSHER_GETTING, "Der Wagenschieber ist auf dem Weg, um Waren aus einem anderen Lagerhaus zu holen."},
    {TR_WINDOW_BUILDING_DISTRIBUTION_GRANARY_CART_PUSHER_GETTING, "Der Wagenschieber ist auf dem Weg, um Lebensmittel aus einem anderen Silo zu holen."},
    {TR_WINDOW_BUILDING_DISTRIBUTION_CART_PUSHER_RETURNING_WITH, "Der Wagenschieber kommt mit einer Lieferung zurück."},
    {TR_RETURN_ALL_TO_FORT, "Alle"},
    {TR_TOGGLE_GRID, "Bauraster anzeigen"},
    {TR_OUT_OF_MONEY, "Kein Geld vorhanden"},
	/* Übersetzen */
    {TR_ACTION_TYPE_SHOW_CUSTOM_MESSAGE, "Benutzerdefinierte Nachricht anzeigen"},
    {TR_ACTION_TYPE_TAX_RATE_SET, "Steuersatz festlegen"},
    {TR_ACTION_TYPE_CHANGE_CUSTOM_VARIABLE, "Wert der benutzerdefinierten Variablen ändern"},
    {TR_ACTION_TYPE_TRADE_ADJUST_ROUTE_OPEN_PRICE, "ändere Handelsrouten Kosten"},
    {TR_ACTION_TYPE_A_MESSAGE, "Eine Nachricht"},
    {TR_ACTION_TYPE_CHANGE_CITY_RATING, "Stadtbewertung ändern"},
    {TR_ACTION_TYPE_CHANGE_RESOURCE_STOCKPILES, "Ressourcenbestände ändern"},
    {TR_ACTION_TYPE_TRADE_ROUTE_SET_OPEN, "Handelsroute öffnen"},
    {TR_ACTION_TYPE_TRADE_ROUTE_ADD_NEW_RESOURCE, "Handelsroute: neue Ressource hinzufügen"},
    {TR_ACTION_TYPE_TRADE_SET_BUY_PRICE_ONLY, "Handel: nur Kaufpreis festlegen"},
    {TR_ACTION_TYPE_TRADE_SET_SELL_PRICE_ONLY, "Handel: nur Verkaufspreis festlegen"},
    {TR_ACTION_TYPE_BUILDING_FORCE_COLLAPSE, "Gebäude Einsturz erzwingen"},
    {TR_ACTION_TYPE_INVASION_IMMEDIATE, "Invasion beginnt sofort"},
    {TR_CONDITION_TYPE_BUILDING_COUNT_ANY, "Anzahl der Gebäudetypen"},
    {TR_CONDITION_TYPE_CUSTOM_VARIABLE_CHECK, "Benutzerdefinierter Variablenwert"},
    {TR_CONDITION_TYPE_TRADE_ROUTE_OPEN, "Handelsroute ist offen"},
    {TR_CONDITION_TYPE_TRADE_ROUTE_PRICE, "Handelsroute Preis"},
    {TR_CONDITION_TYPE_RESOURCE_STORED_COUNT, "Anzahl delagerter Ressource"},
    {TR_CONDITION_TYPE_RESOURCE_STORAGE_AVAILABLE, "freier Lagerplatz für Ressource"},
    {TR_CONDITION_TYPE_BUILDING_COUNT_AREA, "Gebäude in Umgebung"},
    {TR_CONDITION_TYPE_TAX_RATE, "Steuersatz"},
    {TR_PARAMETER_ADD_AS_BUYING, "Als kaufend hinzufügen?"},
    {TR_EDITOR_CUSTOM_MESSAGES_TITLE, "Benutzerdef. Nachrichten" },
    {TR_EDITOR_CUSTOM_MESSAGES_COUNT, "Nachrichten gesamt" },
    {TR_EDITOR_CUSTOM_MESSAGES_CLEAR, "Botschaften leeren" },
    {TR_EDITOR_CUSTOM_MESSAGES_IMPORT_FULL, "Benutzerdefinierte Nachrichten importieren" },
    {TR_EDITOR_CUSTOM_MESSAGES_EXPORT_FULL, "Benutzerdefinierte Nachrichten exportieren" },
    {TR_EDITOR_UNABLE_TO_LOAD_CUSTOM_MESSAGES_TITLE, "Unfähig benutzerdefinierte Nachrichten zu laden"},
    {TR_EDITOR_SCENARIO_SELECT_INTRO, "Szenario-Intro auswählen"},
    {TR_EDITOR_SCENARIO_DESELECT_INTRO, "Szenario-Intro abwählen"},
    {TR_EDITOR_CUSTOM_VARIABLES_TITLE, "Benutzerdefinierte Variablen" },
    {TR_EDITOR_CUSTOM_VARIABLES_COUNT, "Maximal mögliche Variablen" },
    {TR_EDITOR_GRID_OFFSET, " Versatz" },
    {TR_EDITOR_SCENARIO_EVENT_STATE_UNDEFINED, "Undefiniert"},
    {TR_EDITOR_SCENARIO_EVENT_STATE_DISABLED, "Deaktiviert"},
    {TR_EDITOR_SCENARIO_EVENT_STATE_ACTIVE, "Aktiv"},
    {TR_EDITOR_SCENARIO_EVENT_STATE_PAUSED, "Pausiert"},
    {TR_EDITOR_SCENARIO_EVENT_EXECUTION_COUNT, "Ausführungsanzahl: "},
    {TR_EDITOR_SCENARIO_EVENT_MONTHS_UNTIL_ACTIVE, "Monate bis aktiv: "},
    {TR_CITY_MESSAGE_TITLE_TRADE_ROUTE_PRICE_CHANGE, "Preis der Handelsroute" },
    {TR_CITY_MESSAGE_TEXT_TRADE_ROUTE_PRICE_CHANGE, "Der Preis für die Eröffnung einer Handelsroute hat sich geändert." },
    {TR_OVERLAY_STORAGES, "Lagerräume" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_ARENA_COVERAGE_PLURAL, "Arenen" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_TAVERN_COVERAGE_PLURAL, "Tavernen" },
    {TR_BUILDING_CARAVANSERAI_NO_FOOD, "Diese Karawanserei hat Angestellte, die jedoch derzeit auf der Suche nach einer verfügbaren Nahrungsquelle sind." },
    {TR_BUILDING_MESS_HALL_NO_FOOD, "Dieser Versorgungsposten hat Angestellte, aber sie suchen derzeit nach einer verfügbaren Nahrungsquelle." },
    {TR_CONFIG_ASK_CONFIRMATION_ON_FILE_OVERWRITE, "Beim Überschreiben einer Datei nach einer Bestätigung fragen"},
    {TR_CONFIG_GATES_DEFAULT_TO_PASS_ALL_WALKERS, "Nicht-militärische Tore lassen standardmäßig alle Fußgänger zu"},
	/* Übersetzen - Ende */
	/* Missions-Editor */
    {TR_MAP_EDITOR_OPTIONS, "Szenario Einstellungen"},
    {TR_EDITOR_ALLOWED_BUILDINGS_MONUMENTS, "Monumente"},
    {TR_EDITOR_CHOOSE_CUSTOM_EMPIRE, "Benutzerdefiniertes Imperium wählen"},
    {TR_EDITOR_CUSTOM_EMPIRE_TITLE, "Laden eines Imperiums"},
    {TR_EDITOR_UNABLE_TO_LOAD_EMPIRE_TITLE, "Benutzerdefiniertes Imperium kann nicht geladen werden"},
    {TR_EDITOR_UNABLE_TO_LOAD_EMPIRE_MESSAGE, "Bitte kontrolliere augustus-log.txt in deinem Augustus Verzeichnis für Details."},
    {TR_EDITOR_SHORT_ROUTE_TEXT, "rt"},
    {TR_EDITOR_REFRESH_EMPIRE, "Aktualisieren (F5)"},
    {TR_EDITOR_MAX_WAGES, "hoch bis"},
    {TR_EDITOR_MIN_WAGES, "runter bis"},
    {TR_EDITOR_CITY_PREVIEW, "Vorschau auf die Stadt: " },
    {TR_EDITOR_CURRENT_COORDS, "Aktuelle Koordinaten: " },
    {TR_EDITOR_FAVOUR_DISFAVOR, "verlorene Gunst, wenn Zeit verlängert wird" },
    {TR_EDITOR_FAVOUR_EXTENSION_MONTHS, "Erlaubte Verlängerungsmonate" },
    {TR_EDITOR_FAVOUR_IGNORED, "verlorene Gunst beim Ignorieren der Forderung" },
    {TR_EDITOR_SELECTED_COORDS, "Ausgewählte Koordinaten: " },
    {TR_EDITOR_TOGGLE_INVASIONS, "Invasionen anzeigen" },
    {TR_EDITOR_SCENARIO_EVENTS_TITLE, "Szenario-Ereignisse" },
    {TR_EDITOR_SCENARIO_EVENTS_IMPORT, "Importieren" },
    {TR_EDITOR_SCENARIO_EVENTS_IMPORT_FULL, "Szenario-Ereignisse importieren" },
    {TR_EDITOR_SCENARIO_EVENTS_EXPORT, "Exportieren" },
    {TR_EDITOR_SCENARIO_EVENTS_EXPORT_FULL, "Szenario-Ereignisse exportieren" },
    {TR_EDITOR_SCENARIO_EVENTS_CLEAR, "Alle Ereignisse löschen" },
    {TR_EDITOR_SCENARIO_EVENTS_COUNT, "Szenario-Ereignisse" },
    {TR_EDITOR_SCENARIO_EVENTS_CONDITIONS, "Bedingungen" },
    {TR_EDITOR_SCENARIO_EVENTS_ACTIONS, "Aktionen" },
    {TR_EDITOR_UNABLE_TO_LOAD_EVENTS_TITLE, "Szenario-Ereignisse können nicht geladen werden."},
    {TR_EDITOR_CHECK_LOG_MESSAGE, "Bitte prüfen Sie die Datei augustus-log.txt in Ihrem Augustus-Verzeichnis für Details."},
    {TR_EDITOR_UNABLE_TO_SAVE_EVENTS_TITLE, "Szenario-Ereignisse können nicht gespeichert werden."},
    {TR_EDITOR_IMPORT_LINE, "Line: "},
    {TR_EDITOR_SCENARIO_EVENT_ID, "ID: "},
    {TR_EDITOR_SCENARIO_EVENT_REPEAT_MIN_MONTHS, "Min. Monate vor Wiederholung: "},
    {TR_EDITOR_SCENARIO_EVENT_REPEAT_MAX_MONTHS, "Max. Monate vor Wiederholung: "},
    {TR_EDITOR_SCENARIO_EVENT_MAX_NUM_REPEATS, "Max. Zahl der Wiederholungen: "},
    {TR_EDITOR_SCENARIO_EVENT_REPEATS_FOREVER, "Unendlich"},
    {TR_EDITOR_SCENARIO_EVENT_DOES_NOT_REPEAT, "Wiederholt sich nicht."},
    {TR_EDITOR_SCENARIO_CONDITION, "Bedingung"},
    {TR_EDITOR_SCENARIO_ACTION, "Aktion"},
    {TR_EDITOR_SCENARIO_EVENTS_ADD, "+ neues Event"},
    {TR_EDITOR_SCENARIO_CONDITION_ADD, "+ neue Bedingung"},
    {TR_EDITOR_SCENARIO_ACTION_ADD, "+ neue Aktion"},
    {TR_EDITOR_DELETE, "Löschen"},
    {TR_EDITOR_DELETED, "Gelöscht"},
    {TR_EDITOR_SCENARIO_EVENT_DELETED, "Gelöschtes Ereigniss"},
    {TR_PARAMETER_TYPE_CHECK, "Vergleichs-Check"},
    {TR_PARAMETER_TYPE_MIN_MAX_NUMBER_MIN, "Minimum"},
    {TR_PARAMETER_TYPE_MIN_MAX_NUMBER_MAX, "Maximum"},
    {TR_PARAMETER_TYPE_DIFFICULTY, "Schwierigkeitsgrad"},
    {TR_PARAMETER_TYPE_BOOLEAN, "Wahr oder Falsch"},
    {TR_PARAMETER_TYPE_NUMBER, "Wert"},
    {TR_PARAMETER_TYPE_RESOURCE, "Ressource"},
    {TR_PARAMETER_TYPE_POP_CLASS, "Bevölkerungsklasse"},
    {TR_PARAMETER_TYPE_BUILDING_COUNTING, "Gebäudetyp für die Zählung"},
    {TR_PARAMETER_TYPE_ALLOWED_BUILDING, "Zulässiger Gebäudetyp"},
    {TR_PARAMETER_TYPE_ROUTE, "Zielhandelsroute"},
    {TR_PARAMETER_TYPE_STANDARD_MESSAGE, "Standardnachricht"},
    {TR_PARAMETER_TYPE_FUTURE_CITY, "Zukünftige Handelsstadt als Ziel"},
    {TR_PARAMETER_USE_PERCENTAGE, "Prozentsatz verwenden?"},
    {TR_PARAMETER_IN_CITY_ONLY, "Nur Soldaten in der Stadt zählen?"},
    {TR_PARAMETER_CHECK_FOR_ONGOING, "Prüfen, ob es eine laufende Maßnahme ist?"},
    {TR_PARAMETER_SHOW_MESSAGE, "Nachricht anzeigen?"},
    {TR_PARAMETER_SET_TO_VALUE, "Auf Wert setzen?"},
    {TR_PARAMETER_PRODUCED, "Produziert?"},
    {TR_PARAMETER_ALLOWED, "Erlaubt?"},
    {TR_PARAMETER_SET_BUY_PRICE, "Ankaufspreis festlegen?"},
    {TR_CONDITION_TYPE_TIME_PASSED, "Verstrichene Zeit"},
    {TR_CONDITION_TYPE_DIFFICULTY, "Schwierigkeitsgrad"},
    {TR_CONDITION_TYPE_MONEY, "Geld der Stadt"},
    {TR_CONDITION_TYPE_SAVINGS, "Persönliche Ersparnisse"},
    {TR_CONDITION_TYPE_STATS_FAVOR, "Gunst"},
    {TR_CONDITION_TYPE_STATS_PROSPERITY, "Wohlstand"},
    {TR_CONDITION_TYPE_STATS_CULTURE, "Kultur"},
    {TR_CONDITION_TYPE_STATS_PEACE, "Friede"},
    {TR_CONDITION_TYPE_TRADE_SELL_PRICE, "Verkaufspreis im Handel"},
    {TR_CONDITION_TYPE_POPS_UNEMPLOYMENT, "Arbeitslosigkeit"},
    {TR_CONDITION_TYPE_ROME_WAGES, "Von Rom gezahlte Löhne"},
    {TR_CONDITION_TYPE_CITY_POPULATION, "Stadtbevölkerung"},
    {TR_CONDITION_TYPE_BUILDING_COUNT_ACTIVE, "Aktive Anzahl des Gebäudetypen"},
    {TR_CONDITION_TYPE_STATS_CITY_HEALTH, "Gesundheit in der Stadt"},
    {TR_CONDITION_TYPE_COUNT_OWN_TROOPS, "Anzahl der eigenen Truppen"},
    {TR_CONDITION_TYPE_REQUEST_IS_ONGOING, "Forderung ist im Gange"},
    {TR_ACTION_TYPE_ADJUST_FAVOR, "Gunst anpassen"},
    {TR_ACTION_TYPE_ADJUST_MONEY, "Geld anpassen"},
    {TR_ACTION_TYPE_ADJUST_SAVINGS, "Ersparnisse anpassen"},
    {TR_ACTION_TYPE_TRADE_ADJUST_PRICE, "Handelspreis anpassen"},
    {TR_ACTION_TYPE_TRADE_PROBLEM_LAND, "Starte Problem beim Landhandel"},
    {TR_ACTION_TYPE_TRADE_PROBLEM_SEA, "Starte Probleme beim Seehandel"},
    {TR_ACTION_TYPE_TRADE_ADJUST_ROUTE_AMOUNT, "Anzahl gehandelter Güter auf Route anpassen"},
    {TR_ACTION_TYPE_ADJUST_ROME_WAGES, "Anpassung der Löhne in Rom"},
    {TR_ACTION_TYPE_GLADIATOR_REVOLT, "Gladiatorenaufstand starten"},
    {TR_ACTION_TYPE_CHANGE_RESOURCE_PRODUCED, "Ändern der lokal verfügbaren Ressourcen"},
    {TR_ACTION_TYPE_CHANGE_ALLOWED_BUILDINGS, "Gebäude erlauben oder verbieten"},
    {TR_ACTION_TYPE_SEND_STANDARD_MESSAGE, "Standardnachricht senden"},
    {TR_ACTION_TYPE_ADJUST_CITY_HEALTH, "Gesundheit der Stadt anpassen"},
    {TR_ACTION_TYPE_TRADE_SET_PRICE, "Handelspreis festlegen"},
    {TR_ACTION_TYPE_EMPIRE_MAP_CONVERT_FUTURE_TRADE_CITY, "Konvertieren zukünftiger Handelsstadt"},
    {TR_ACTION_TYPE_REQUEST_IMMEDIATELY_START, "Forderung sofort starten"},
    {TR_PARAMETER_VALUE_COMPARISON_TYPE_EQUAL, "Gleich"},
    {TR_PARAMETER_VALUE_COMPARISON_TYPE_EQUAL_OR_LESS, "Kleiner als oder gleich"},
    {TR_PARAMETER_VALUE_COMPARISON_TYPE_EQUAL_OR_MORE, "Größer als oder gleich"},
	{TR_PARAMETER_VALUE_COMPARISON_TYPE_NOT_EQUAL, "Nicht gleich"},
    {TR_PARAMETER_VALUE_COMPARISON_TYPE_LESS_THAN, "Weniger als"},
    {TR_PARAMETER_VALUE_COMPARISON_TYPE_GREATER_THAN, "Größer als"},
    {TR_PARAMETER_VALUE_DIFFICULTY_VERY_EASY, "Sehr einfach"},
    {TR_PARAMETER_VALUE_DIFFICULTY_EASY, "Einfach"},
    {TR_PARAMETER_VALUE_DIFFICULTY_NORMAL, "Normal"},
    {TR_PARAMETER_VALUE_DIFFICULTY_HARD, "Schwierig"},
    {TR_PARAMETER_VALUE_DIFFICULTY_VERY_HARD, "Sehr Schwierig"},
    {TR_PARAMETER_VALUE_BOOLEAN_FALSE, "Falsch"},
    {TR_PARAMETER_VALUE_BOOLEAN_TRUE, "Wahr"},
    {TR_PARAMETER_VALUE_POP_CLASS_ALL, "Alle"},
    {TR_PARAMETER_VALUE_POP_CLASS_PATRICIAN, "Patrizier"},
    {TR_PARAMETER_VALUE_POP_CLASS_PLEBEIAN, "Plebejer"},
    {TR_PARAMETER_VALUE_POP_CLASS_SLUMS, "Elendsviertel"},
    {TR_PARAMETER_VALUE_BUILDING_NONE, "Keine"},
    {TR_PARAMETER_VALUE_BUILDING_ANY, "Beliebig"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_FARMS, "Alle Farmen"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_RAW_MATERIALS, "Alle Rohmaterialien"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_WORKSHOPS, "Alle Werkstätten"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_STATUES, "Alle Statuen"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_GOV_RES, "Alle Gouverneursanwesen"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_GRAND_TEMPLES, "Alle Prachttempel"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_TREES, "Alle dekorativen Bäume"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_PATHS, "Alle dekorativen Pfade"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_PARKS, "Alle dekorativen Parks"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_SMALL_TEMPLES, "Alle kleinen Tempel"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_LARGE_TEMPLES, "Alle großen Tempel"},
    {TR_PARAMETER_VALUE_BUILDING_NATIVE_CROPS, "Eingeborene Feldfrüchte"},
    {TR_PARAMETER_VALUE_BUILDING_SMALL_TEMPLE_CERES, "Kleiner Tempel der Ceres"},
    {TR_PARAMETER_VALUE_BUILDING_SMALL_TEMPLE_NEPTUNE, "Kleiner Tempel des Neptun"},
    {TR_PARAMETER_VALUE_BUILDING_SMALL_TEMPLE_MERCURY, "Kleiner Tempel des Merkur"},
    {TR_PARAMETER_VALUE_BUILDING_SMALL_TEMPLE_MARS, "Kleiner Tempel des Mars"},
    {TR_PARAMETER_VALUE_BUILDING_SMALL_TEMPLE_VENUS, "Kleiner Tempel der Venus"},
    {TR_PARAMETER_VALUE_BUILDING_LARGE_TEMPLE_CERES, "Großer Tempel der Ceres"},
    {TR_PARAMETER_VALUE_BUILDING_LARGE_TEMPLE_NEPTUNE, "Großer Tempel des Neptun"},
    {TR_PARAMETER_VALUE_BUILDING_LARGE_TEMPLE_MERCURY, "Großer Tempel des Merkur"},
    {TR_PARAMETER_VALUE_BUILDING_LARGE_TEMPLE_MARS, "Großer Tempel des Mars"},
    {TR_PARAMETER_VALUE_BUILDING_LARGE_TEMPLE_VENUS, "Großer Tempel der Venus"},
    {TR_PARAMETER_VALUE_DYNAMIC_RESOLVE, "..."},
    {TR_PARAMETER_VALUE_NONE, "Keine"},
    {TR_PARAMETER_VALUE_MESSAGE_CITY_IN_DEBT, "Stadt hat Schulden"},
    {TR_PARAMETER_VALUE_MESSAGE_CITY_IN_DEBT_AGAIN, "Stadt hat wieder Schulden"},
    {TR_PARAMETER_VALUE_MESSAGE_CITY_STILL_IN_DEBT, "Stadt immernoch verschuldet"},
    {TR_PARAMETER_VALUE_MESSAGE_CAESAR_WRATH, "Cäsars Zorn"},
    {TR_PARAMETER_VALUE_MESSAGE_CAESAR_ARMY_CONTINUE, "Cäsars Armee rückt vor"},
    {TR_PARAMETER_VALUE_MESSAGE_CAESAR_ARMY_RETREAT, "Cäsars Armee zieht sich zurück"},
    {TR_PARAMETER_VALUE_MESSAGE_DISTANT_BATTLE, "Entfernte Schlacht"},
    {TR_PARAMETER_VALUE_MESSAGE_ENEMIES_CLOSING, "Feinde rücken näher"},
    {TR_PARAMETER_VALUE_MESSAGE_ENEMIES_AT_THE_DOOR, "Feinde vor den Toren"},
    {TR_PARAMETER_VALUE_MESSAGE_SMALL_FESTIVAL, "Kleines Fest"},
    {TR_PARAMETER_VALUE_MESSAGE_LARGE_FESTIVAL, "Großes Fest"},
    {TR_PARAMETER_VALUE_MESSAGE_GRAND_FESTIVAL, "Gewaltiges Fest"},
    {TR_PARAMETER_VALUE_MESSAGE_GODS_UNHAPPY, "Unglückliche Götter"},
    {TR_PARAMETER_VALUE_MESSAGE_GLADIATOR_REVOLT, "Gladiatorenaufstand"},
    {TR_PARAMETER_VALUE_MESSAGE_GLADIATOR_REVOLT_FINISHED, "Gladiatorenaufstand vorrüber"},
    {TR_PARAMETER_VALUE_MESSAGE_EMPEROR_CHANGE, "Neuer Kaiser"},
    {TR_PARAMETER_VALUE_MESSAGE_LAND_TRADE_DISRUPTED_SANDSTORMS, "Landhandel Sandstürme"},
    {TR_PARAMETER_VALUE_MESSAGE_LAND_TRADE_DISRUPTED_LANDSLIDES, "Landhandel Erdrutsche"},
    {TR_PARAMETER_VALUE_MESSAGE_SEA_TRADE_DISRUPTED, "Seehandel unterbrochen"},
    {TR_PARAMETER_VALUE_MESSAGE_ROME_RAISES_WAGES, "Rom erhöht die Löhne"},
    {TR_PARAMETER_VALUE_MESSAGE_ROME_LOWERS_WAGES, "Rom senkt die Löhne"},
    {TR_PARAMETER_VALUE_MESSAGE_CONTAMINATED_WATER, "Verschmutztes Wasser"},
    {TR_PARAMETER_VALUE_MESSAGE_EMPIRE_HAS_EXPANDED, "Imperium vergrößert"},
    {TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_CERES, "Zorn der Ceres"},
    {TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_NEPTUNE_NO_SEA_TRADE, "Zorn des Neptuns (kein Seehandel)"},
    {TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_MERCURY, "Zorn des Merkurs"},
    {TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_MARS_NO_MILITARY, "Zorn des Mars (kein Militär)"},
    {TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_VENUS, "Zorn der Venus"},
    {TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_NEPTUNE, "Zorn des Neptuns"},
    {TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_MARS, "Zorn des Mars"},
    {TR_PARAMETER_VALUE_MESSAGE_CERES_IS_UPSET, "Ceres ist unglücklich"},
    {TR_PARAMETER_VALUE_MESSAGE_NEPTUNE_IS_UPSET, "Neptun ist unglücklich"},
    {TR_PARAMETER_VALUE_MESSAGE_MERCURY_IS_UPSET, "Merkur ist unglücklich"},
    {TR_PARAMETER_VALUE_MESSAGE_MARS_IS_UPSET, "Mars ist unglücklich"},
    {TR_PARAMETER_VALUE_MESSAGE_VENUS_IS_UPSET, "Venus ist unglücklich"},
    {TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_CERES, "Segen der Ceres"},
    {TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_NEPTUNE, "Segen des Neptuns"},
    {TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_MERCURY, "Segen des Merkurs"},
    {TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_MARS, "Segen des Mars"},
    {TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_VENUS, "Segen der Venus"},
    {TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_MERCURY_ALTERNATE, "Segen des Merkurs (Alternativtext)"},
    {TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_NEPTUNE_ALTERNATE, "Segen des Neptuns (Alternativtext)"},
    {TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_VENUS_ALTERNATE, "Segen der Venus (Alternativtext)"},
    {TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_MARS_NO_NATIVES, "Zorn des Mars (keine Eingeborenen)"},
    {TR_PARAMETER_VALUE_MESSAGE_GODS_WRATHFUL, "Zornige Götter"},
    {TR_PARAMETER_VALUE_MESSAGE_DISTANT_BATTLE_LOST_NO_TROOPS, "Entfernte Schlacht verloren (keine Truppen)"},
    {TR_PARAMETER_VALUE_MESSAGE_DISTANT_BATTLE_LOST_TOO_LATE, "Entfernte Schlacht verloren (zu spät)"},
    {TR_PARAMETER_VALUE_MESSAGE_DISTANT_BATTLE_LOST_TOO_WEAK, "Entfernte Schlacht verloren (zu schwach)"},
    {TR_PARAMETER_VALUE_MESSAGE_DISTANT_BATTLE_WON, "Entfernte Schlacht gewonnen"},
    {TR_PARAMETER_VALUE_MESSAGE_DISTANT_BATTLE_CITY_RETAKEN, "Entfernte Schlacht, Stadt zurückerobert"},
    {TR_PARAMETER_VALUE_MESSAGE_HEALTH_ILLNESS, "Gesundheit: Erkrankungen"},
    {TR_PARAMETER_VALUE_MESSAGE_HEALTH_DISEASE, "Gesundheit: Krankheiten"},
    {TR_PARAMETER_VALUE_MESSAGE_HEALTH_PESTILENCE, "Gesundheit: Pestilenz"},
    {TR_PARAMETER_VALUE_MESSAGE_CAESAR_RESPECT_1, "Cäsars Respekt 1"},
    {TR_PARAMETER_VALUE_MESSAGE_CAESAR_RESPECT_2, "Cäsars Respekt 2"},
    {TR_PARAMETER_VALUE_MESSAGE_CAESAR_RESPECT_3, "Cäsars Respekt 3"},
    {TR_PARAMETER_VALUE_MESSAGE_EMIGRATION, "Auswanderung"},
    {TR_PARAMETER_VALUE_MESSAGE_FIRED, "Gefeuert"},
    {TR_PARAMETER_VALUE_MESSAGE_SOLDIERS_STARVING, "Soldaten hungern"},
    {TR_PARAMETER_VALUE_MESSAGE_CAESAR_ANGER, "Cäsars Zorn"},
    {TR_PARAMETER_VALUE_MESSAGE_ENEMIES_LEAVING, "Feinde verlassen die Stadt"},
    {TR_PARAMETER_VALUE_MEDIA_TYPE_SOUND, "Ton"},
    {TR_PARAMETER_VALUE_MEDIA_TYPE_VIDEO, "Video"},
    {TR_PARAMETER_VALUE_RATING_TYPE_PEACE, "Frieden"},
    {TR_PARAMETER_VALUE_RATING_TYPE_PROSPERITY, "Wohlstand"},
    {TR_PARAMETER_VALUE_STORAGE_TYPE_ALL, "Alle"},
    {TR_PARAMETER_VALUE_STORAGE_TYPE_GRANARIES, "Silos"},
    {TR_PARAMETER_VALUE_STORAGE_TYPE_WAREHOUSES, "Lagerhäuser"},
    {TR_PARAMETER_VALUE_INVASION_TYPE_ENEMY_ARMY, "Feindliche Armee"},
    {TR_PARAMETER_VALUE_INVASION_TYPE_CAESAR, "Caesar"},
    {TR_PARAMETER_VALUE_INVASION_TYPE_NATIVES, "Eingeborene"},
    {TR_PARAMETER_VALUE_INVASION_TYPE_MARS_NATIVES, "Mars' Eingeborene"},
    {TR_PARAMETER_VALUE_FORMATION_ATTACK_FOOD_CHAIN, "Nahrungskette"},
    {TR_PARAMETER_VALUE_FORMATION_ATTACK_GOLD_STORES, "Goldspeicher"},
    {TR_PARAMETER_VALUE_FORMATION_ATTACK_BEST_BUILDINGS, "Beste Gebäude"},
    {TR_PARAMETER_VALUE_FORMATION_ATTACK_TROOPS, "Truppen"},
    {TR_PARAMETER_VALUE_FORMATION_ATTACK_RANDOM, "Zufällig"},
    {TR_PARAMETER_VALUE_ENEMY_UNDEFINED, "Von Karte definiert"},
    {TR_PARAMETER_VALUE_ENEMY_0_BARBARIAN, "Barbaren!"},
    {TR_PARAMETER_VALUE_ENEMY_1_NUMIDIAN, "Numider"},
    {TR_PARAMETER_VALUE_ENEMY_2_GAUL, "Gallier"},
    {TR_PARAMETER_VALUE_ENEMY_3_CELT, "Kelten"},
    {TR_PARAMETER_VALUE_ENEMY_4_GOTH, "Goten"},
    {TR_PARAMETER_VALUE_ENEMY_5_PERGAMUM, "Pergamum"},
    {TR_PARAMETER_VALUE_ENEMY_6_SELEUCID, "Seleukiden"},
    {TR_PARAMETER_VALUE_ENEMY_7_ETRUSCAN, "Etrusker"},
    {TR_PARAMETER_VALUE_ENEMY_8_GREEK, "Griechen"},
    {TR_PARAMETER_VALUE_ENEMY_9_EGYPTIAN, "Ägypter"},
    {TR_PARAMETER_VALUE_ENEMY_10_CARTHAGINIAN, "Karthager"},
    {TR_PARAMETER_VALUE_ENEMY_11_CAESAR, "Caesar"},
    {TR_PARAMETER_DISPLAY_SET_TO, "auf"},
    {TR_PARAMETER_DISPLAY_ADD_TO, "hinzufügen"},
    {TR_PARAMETER_DISPLAY_BETWEEN, "zwischen"},
    {TR_PARAMETER_DISPLAY_IN_CITY, "in Stadt"},
    {TR_PARAMETER_DISPLAY_ANYWHERE, "Beliebig"},
    {TR_PARAMETER_DISPLAY_PERCENTAGE, "Prozentsatz"},
    {TR_PARAMETER_DISPLAY_FLAT_NUMBER, "Anzahl"},
    {TR_PARAMETER_DISPLAY_ONGOING, "ist im Gange"},
    {TR_PARAMETER_DISPLAY_NOT_ONGOING, "ist nicht im Gange"},
    {TR_PARAMETER_DISPLAY_ROUTE_OPEN, "Route ist offen"},
    {TR_PARAMETER_DISPLAY_ROUTE_CLOSED, "Route ist geschlossen"},
    {TR_PARAMETER_DISPLAY_ALLOWED, "erlaubt"},
    {TR_PARAMETER_DISPLAY_DISALLOWED, "verboten"},
    {TR_PARAMETER_DISPLAY_SHOW_MESSAGE, "Zeige Nachricht"},
    {TR_PARAMETER_DISPLAY_DO_NOT_SHOW_MESSAGE, "zeige keine Nachricht"},
    {TR_PARAMETER_DISPLAY_BUY_PRICE, "Kaufpreis"},
    {TR_PARAMETER_DISPLAY_SELL_PRICE, "Verkaufpreis"},
    {TR_PARAMETER_DISPLAY_MONTHS, "Monate"},
    {TR_PARAMETER_DISPLAY_DAYS, "Tage"},
    {TR_PARAMETER_DISPLAY_RESPECT_SETTINGS, "Einstellungen beachten"},
    {TR_PARAMETER_DISPLAY_IGNORE_SETTINGS, "Einstellungen ignorieren"},
    {TR_PARAMETER_DISPLAY_APPLY_COST, "Kosten übernehmen"},
    {TR_PARAMETER_DISPLAY_NO_COST, "Keine Kosten"},
    {TR_PARAMETER_DISPLAY_ADD_AS_BUYING, "Als 'Kauft' hinzufügen"},
    {TR_PARAMETER_DISPLAY_ADD_AS_SELLING, "Als 'Verkauft' hinzufügen"},
    {TR_PARAMETER_DISPLAY_DESTROY_ALL_TYPES, "alle Arten zerstören"},
};

void translation_german(const translation_string **strings, int *num_strings)
{
    *strings = all_strings;
    *num_strings = sizeof(all_strings) / sizeof(translation_string);
}
