# CamiTK Changelog (from Source Code Analysis)

This changelog outlines major and minor changes identified by directly comparing the source code between version 5.2.0 and the current `HEAD` of the `develop` branch.

### 1. Short List of Major Changes

*   **New Extension Generation Framework**: Introduction of `camitk-extensiongenerator` for simplified extension creation using `.camitk` JSON files.
*   **Comprehensive Transformation & Frame-of-Reference System**: A fundamental redesign of how spatial transformations and coordinate systems are managed.
*   **Full Python Integration**: Extensive new Python bindings for core CamiTK functionalities, enabling scripting and advanced workflows.
*   **Updated C++ Standard Support**: Migration to C++20/C++23, allowing for modern language features.
*   **New License Model**: Adoption of LGPL-3 for core CamiTK and generated extensions.

### 2. Detailed List of Major Changes

#### 1. New Extension Generation Framework

*   **Tool `camitk-extensiongenerator`**: A new command-line application that automates the creation of CamiTK extension source code. It reads a `.camitk` (JSON) file, which defines the extension's structure, actions, and properties, and generates the necessary C++ files, CMake configurations, and supporting resources. This significantly simplifies and standardizes the extension development workflow.
*   **`.camitk` File Format**: A new JSON-based schema (`.camitk` files) is introduced for defining extensions. This declarative approach allows developers to describe extensions, actions, components, and their parameters in a concise and structured manner, which is then used by the `extensiongenerator`.
*   **Templating Engine (`TransformEngine`)**: The `extensiongenerator` leverages a templating engine (`TransformEngine`) to dynamically generate C++ code from predefined templates, incorporating license information and other metadata specified in the `.camitk` file.
*   **Multiple Generation Types**: Supports generating various types of action extensions, including "HotPlug C++", "Standard C++", and "Python" actions, indicating a flexible and extensible architecture for new module types.
*   **New Build System Macros**: Introduction of new CMake macros (e.g., `CamiTKExtensionGenerator.cmake`) to integrate the extension generation process directly into the build system, ensuring that generated code is always up-to-date.

#### 2. Comprehensive Transformation & Frame-of-Reference System

*   **Architectural Overhaul**: The previous `Frame` class and related functionalities (observed by the deletion of `sdk/libraries/core/component/Frame.h` and `Frame.cpp`) have been replaced by a robust and centralized `TransformationManager` class.
*   **`FrameOfReference`**: Introduces a dedicated class to represent distinct coordinate systems, each with a unique ID (UUID), name, description, and anatomical orientation. Components now explicitly reference a `FrameOfReference`.
*   **`Transformation`**: A new class to define geometric transformations between two `FrameOfReference` objects, primarily using 4x4 homogeneous matrices. It captures the "from" and "to" frames, as well as the transformation matrix.
*   **`TransformationManager`**: This static class acts as the central registry and control for all `FrameOfReference` and `Transformation` objects. It provides:
    *   **World Frame**: A universal coordinate system (`WorldFrame`) for consistent global referencing.
    *   **Pathfinding**: Algorithms to discover and compute composite transformations between any two frames, even through multiple intermediate steps.
    *   **Automatic Inverses and Composites**: Automatically generates inverse transformations and optimizes frequently used composite paths.
    *   **Ownership Management**: Employs `std::shared_ptr` for internal object management, with clear public methods (`getOwnership`) for extensions to safely share ownership without risking premature deletion.
    *   **Persistence**: Integrates serialization (`toVariant()`) and deserialization (`fromVariant()`) to save and load the entire state of frames and transformations, likely within the `.camitk` workspace files.
*   **Impact on Components and Viewers**: The new system fundamentally changes how components define their spatial location and how viewers display objects, with implications for rendering, interaction, and data alignment.

#### 3. Full Python Integration

*   **`pybind11` Based Bindings**: Extensive new C++ files under `sdk/libraries/python/` (e.g., `action_bindings.cpp`, `component_bindings.cpp`, `transformation_manager_bindings.cpp`) demonstrate a comprehensive integration with Python using `pybind11`.
*   **Exposed CamiTK API**: Key CamiTK classes and functionalities, including actions, application, components, console, core utilities, extension manager, logging, and the new transformation manager, are now exposed to Python.
*   **Python Scripting Capabilities**: This enables developers to write CamiTK extensions and scripts in Python, opening up new possibilities for rapid prototyping, data analysis, and integration with the vast Python ecosystem (e.g., NumPy, SciPy).
*   **Automatic Docstring and Stub Generation**: The presence of `generate_docstrings_and_stub/` implies a build process to automatically create Python docstrings and type stubs (`.pyi` files), improving Python developer experience.

#### 4. Updated C++ Standard Support

*   **C++20 and C++23**: The codebase has been updated to support modern C++ standards, as indicated by CMake configurations and the use of features like `std::shared_ptr` and `std::ranges`. This allows for more expressive, efficient, and safer code.

#### 5. New License Model

*   **LGPL-3 Adoption**: The licensing for CamiTK and generated extensions has shifted to the GNU Lesser General Public License version 3 (LGPL-3), providing more flexibility for derivative works while maintaining open-source principles.

### 3. Detailed List of Minor Changes

*   **New Actions Implemented via Extension Generator**:
    *   **"Meshes From Image" (`multilabelreconstruction.camitk`)**: A new action to generate 3D meshes from a labeled image. It supports different meshing methods (Marching Cubes, Flying Edges) and post-smoothing options. This enhances image segmentation and 3D model creation capabilities.
    *   **"Threshold (VTK)" (`ThresholdUsingVTK.camitk`)**: A new action providing a basic threshold filter using VTK. Users can define low/high thresholds and specify replacement values for voxels inside or outside the threshold range, useful for basic image segmentation.
*   **`TransformationExplorer` Viewer**: A new dedicated viewer (`sdk/viewers/transformationexplorer/`) has been added to visualize and interact with the `FrameOfReference` and `Transformation` objects, aiding developers in debugging and understanding complex spatial relationships.
*   **GUI Improvements**: Several GUI elements and widgets across the application have been enhanced, as seen in changes to `ImpMainWindow.cpp`, various `ActionWidget`s, and the new UI files for transformation editing (e.g., `EditAnatomicalInformation.ui`, `TransformationEditor.ui`).
*   **CMake Build System Enhancements**: Numerous changes in CMake files (`sdk/cmake/`) indicate improvements in build configuration, dependency management, and testing infrastructure (e.g., `QTestDiscoverTests.cmake`, `QtTestAddTests.cmake`, `CamiTKExtension.cmake`), aimed at more robust and efficient builds.
*   **API Simplifications**: The `Property/Action` API has undergone simplifications, making it more streamlined and easier to use for extension developers.
*   **Logging and Error Handling**: Updates to logging mechanisms (`CamiTKLogger`, `LogSyntaxHighlighter`) and error handling throughout the core libraries (e.g., `AbortException.h`) suggest improved debugging and stability.
*   **Tutorials and Examples**: New and updated tutorials and example extensions (e.g., in `tutorials/cppextensions/`, `tutorials/python/`) reflect the new extension generation process and Python integration, providing valuable resources for developers.
*   **Refactoring and Code Cleanup**: General code refactoring, removal of deprecated code (like `FrameExplorer`), and adherence to modern C++ practices contribute to a more maintainable and robust codebase. This includes changes in core components like `Component.h`, `ImageComponent.h`, and `InteractiveViewer.cpp`.