// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

// WARNING, this entire header is generated by
// utils/generate_extended_grapheme_cluster_test.py
// DO NOT MODIFY!

// UNICODE, INC. LICENSE AGREEMENT - DATA FILES AND SOFTWARE
//
// See Terms of Use <https://www.unicode.org/copyright.html>
// for definitions of Unicode Inc.'s Data Files and Software.
//
// NOTICE TO USER: Carefully read the following legal agreement.
// BY DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING UNICODE INC.'S
// DATA FILES ("DATA FILES"), AND/OR SOFTWARE ("SOFTWARE"),
// YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
// TERMS AND CONDITIONS OF THIS AGREEMENT.
// IF YOU DO NOT AGREE, DO NOT DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE
// THE DATA FILES OR SOFTWARE.
//
// COPYRIGHT AND PERMISSION NOTICE
//
// Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
// Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of the Unicode data files and any associated documentation
// (the "Data Files") or Unicode software and any associated documentation
// (the "Software") to deal in the Data Files or Software
// without restriction, including without limitation the rights to use,
// copy, modify, merge, publish, distribute, and/or sell copies of
// the Data Files or Software, and to permit persons to whom the Data Files
// or Software are furnished to do so, provided that either
// (a) this copyright and permission notice appear with all copies
// of the Data Files or Software, or
// (b) this copyright and permission notice appear in associated
// Documentation.
//
// THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
// ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT OF THIRD PARTY RIGHTS.
// IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
// NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
// DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
// DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
// TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
// PERFORMANCE OF THE DATA FILES OR SOFTWARE.
//
// Except as contained in this notice, the name of a copyright holder
// shall not be used in advertising or otherwise to promote the sale,
// use or other dealings in these Data Files or Software without prior
// written authorization of the copyright holder.

#ifndef LIBCXX_TEST_STD_UTILITIES_FORMAT_FORMAT_STRING_FORMAT_STRING_STD_EXTENDED_GRAPHEME_CLUSTER_H
#define LIBCXX_TEST_STD_UTILITIES_FORMAT_FORMAT_STRING_FORMAT_STRING_STD_EXTENDED_GRAPHEME_CLUSTER_H

#include <array>
#include <string_view>
#include <vector>

#include "test_macros.h"

template <class CharT>
struct data {
  /// The input to parse.
  std::basic_string_view<CharT> input;

  /// The first code point all extended grapheme clusters in the input.
  std::vector<char32_t> code_points;

  /// The offset of the last code units of the extended grapheme clusters in the input.
  ///
  /// The vector has the same number of entries as \ref code_points.
  std::vector<std::size_t> breaks;
};

/// The data for UTF-8.
std::array<data<char>, 1093> data_utf8 = {{
     {"\U00000020\U00000020", {32, 32}, {1, 2}},
     {"\U00000020\U00000308\U00000020", {32, 32}, {3, 4}},
     {"\U00000020\U0000000d", {32, 13}, {1, 2}},
     {"\U00000020\U00000308\U0000000d", {32, 13}, {3, 4}},
     {"\U00000020\U0000000a", {32, 10}, {1, 2}},
     {"\U00000020\U00000308\U0000000a", {32, 10}, {3, 4}},
     {"\U00000020\U00000001", {32, 1}, {1, 2}},
     {"\U00000020\U00000308\U00000001", {32, 1}, {3, 4}},
     {"\U00000020\U0000200c", {32}, {4}},
     {"\U00000020\U00000308\U0000200c", {32}, {6}},
     {"\U00000020\U0001f1e6", {32, 127462}, {1, 5}},
     {"\U00000020\U00000308\U0001f1e6", {32, 127462}, {3, 7}},
     {"\U00000020\U00000600", {32, 1536}, {1, 3}},
     {"\U00000020\U00000308\U00000600", {32, 1536}, {3, 5}},
     {"\U00000020\U00000a03", {32}, {4}},
     {"\U00000020\U00000308\U00000a03", {32}, {6}},
     {"\U00000020\U00001100", {32, 4352}, {1, 4}},
     {"\U00000020\U00000308\U00001100", {32, 4352}, {3, 6}},
     {"\U00000020\U00001160", {32, 4448}, {1, 4}},
     {"\U00000020\U00000308\U00001160", {32, 4448}, {3, 6}},
     {"\U00000020\U000011a8", {32, 4520}, {1, 4}},
     {"\U00000020\U00000308\U000011a8", {32, 4520}, {3, 6}},
     {"\U00000020\U0000ac00", {32, 44032}, {1, 4}},
     {"\U00000020\U00000308\U0000ac00", {32, 44032}, {3, 6}},
     {"\U00000020\U0000ac01", {32, 44033}, {1, 4}},
     {"\U00000020\U00000308\U0000ac01", {32, 44033}, {3, 6}},
     {"\U00000020\U00000903", {32}, {4}},
     {"\U00000020\U00000308\U00000903", {32}, {6}},
     {"\U00000020\U00000904", {32, 2308}, {1, 4}},
     {"\U00000020\U00000308\U00000904", {32, 2308}, {3, 6}},
     {"\U00000020\U00000d4e", {32, 3406}, {1, 4}},
     {"\U00000020\U00000308\U00000d4e", {32, 3406}, {3, 6}},
     {"\U00000020\U00000915", {32, 2325}, {1, 4}},
     {"\U00000020\U00000308\U00000915", {32, 2325}, {3, 6}},
     {"\U00000020\U0000231a", {32, 8986}, {1, 4}},
     {"\U00000020\U00000308\U0000231a", {32, 8986}, {3, 6}},
     {"\U00000020\U00000300", {32}, {3}},
     {"\U00000020\U00000308\U00000300", {32}, {5}},
     {"\U00000020\U00000900", {32}, {4}},
     {"\U00000020\U00000308\U00000900", {32}, {6}},
     {"\U00000020\U0000094d", {32}, {4}},
     {"\U00000020\U00000308\U0000094d", {32}, {6}},
     {"\U00000020\U0000200d", {32}, {4}},
     {"\U00000020\U00000308\U0000200d", {32}, {6}},
     {"\U00000020\U00000378", {32, 888}, {1, 3}},
     {"\U00000020\U00000308\U00000378", {32, 888}, {3, 5}},
     {"\U0000000d\U00000020", {13, 32}, {1, 2}},
     {"\U0000000d\U00000308\U00000020", {13, 776, 32}, {1, 3, 4}},
     {"\U0000000d\U0000000d", {13, 13}, {1, 2}},
     {"\U0000000d\U00000308\U0000000d", {13, 776, 13}, {1, 3, 4}},
     {"\U0000000d\U0000000a", {13}, {2}},
     {"\U0000000d\U00000308\U0000000a", {13, 776, 10}, {1, 3, 4}},
     {"\U0000000d\U00000001", {13, 1}, {1, 2}},
     {"\U0000000d\U00000308\U00000001", {13, 776, 1}, {1, 3, 4}},
     {"\U0000000d\U0000200c", {13, 8204}, {1, 4}},
     {"\U0000000d\U00000308\U0000200c", {13, 776}, {1, 6}},
     {"\U0000000d\U0001f1e6", {13, 127462}, {1, 5}},
     {"\U0000000d\U00000308\U0001f1e6", {13, 776, 127462}, {1, 3, 7}},
     {"\U0000000d\U00000600", {13, 1536}, {1, 3}},
     {"\U0000000d\U00000308\U00000600", {13, 776, 1536}, {1, 3, 5}},
     {"\U0000000d\U00000a03", {13, 2563}, {1, 4}},
     {"\U0000000d\U00000308\U00000a03", {13, 776}, {1, 6}},
     {"\U0000000d\U00001100", {13, 4352}, {1, 4}},
     {"\U0000000d\U00000308\U00001100", {13, 776, 4352}, {1, 3, 6}},
     {"\U0000000d\U00001160", {13, 4448}, {1, 4}},
     {"\U0000000d\U00000308\U00001160", {13, 776, 4448}, {1, 3, 6}},
     {"\U0000000d\U000011a8", {13, 4520}, {1, 4}},
     {"\U0000000d\U00000308\U000011a8", {13, 776, 4520}, {1, 3, 6}},
     {"\U0000000d\U0000ac00", {13, 44032}, {1, 4}},
     {"\U0000000d\U00000308\U0000ac00", {13, 776, 44032}, {1, 3, 6}},
     {"\U0000000d\U0000ac01", {13, 44033}, {1, 4}},
     {"\U0000000d\U00000308\U0000ac01", {13, 776, 44033}, {1, 3, 6}},
     {"\U0000000d\U00000903", {13, 2307}, {1, 4}},
     {"\U0000000d\U00000308\U00000903", {13, 776}, {1, 6}},
     {"\U0000000d\U00000904", {13, 2308}, {1, 4}},
     {"\U0000000d\U00000308\U00000904", {13, 776, 2308}, {1, 3, 6}},
     {"\U0000000d\U00000d4e", {13, 3406}, {1, 4}},
     {"\U0000000d\U00000308\U00000d4e", {13, 776, 3406}, {1, 3, 6}},
     {"\U0000000d\U00000915", {13, 2325}, {1, 4}},
     {"\U0000000d\U00000308\U00000915", {13, 776, 2325}, {1, 3, 6}},
     {"\U0000000d\U0000231a", {13, 8986}, {1, 4}},
     {"\U0000000d\U00000308\U0000231a", {13, 776, 8986}, {1, 3, 6}},
     {"\U0000000d\U00000300", {13, 768}, {1, 3}},
     {"\U0000000d\U00000308\U00000300", {13, 776}, {1, 5}},
     {"\U0000000d\U00000900", {13, 2304}, {1, 4}},
     {"\U0000000d\U00000308\U00000900", {13, 776}, {1, 6}},
     {"\U0000000d\U0000094d", {13, 2381}, {1, 4}},
     {"\U0000000d\U00000308\U0000094d", {13, 776}, {1, 6}},
     {"\U0000000d\U0000200d", {13, 8205}, {1, 4}},
     {"\U0000000d\U00000308\U0000200d", {13, 776}, {1, 6}},
     {"\U0000000d\U00000378", {13, 888}, {1, 3}},
     {"\U0000000d\U00000308\U00000378", {13, 776, 888}, {1, 3, 5}},
     {"\U0000000a\U00000020", {10, 32}, {1, 2}},
     {"\U0000000a\U00000308\U00000020", {10, 776, 32}, {1, 3, 4}},
     {"\U0000000a\U0000000d", {10, 13}, {1, 2}},
     {"\U0000000a\U00000308\U0000000d", {10, 776, 13}, {1, 3, 4}},
     {"\U0000000a\U0000000a", {10, 10}, {1, 2}},
     {"\U0000000a\U00000308\U0000000a", {10, 776, 10}, {1, 3, 4}},
     {"\U0000000a\U00000001", {10, 1}, {1, 2}},
     {"\U0000000a\U00000308\U00000001", {10, 776, 1}, {1, 3, 4}},
     {"\U0000000a\U0000200c", {10, 8204}, {1, 4}},
     {"\U0000000a\U00000308\U0000200c", {10, 776}, {1, 6}},
     {"\U0000000a\U0001f1e6", {10, 127462}, {1, 5}},
     {"\U0000000a\U00000308\U0001f1e6", {10, 776, 127462}, {1, 3, 7}},
     {"\U0000000a\U00000600", {10, 1536}, {1, 3}},
     {"\U0000000a\U00000308\U00000600", {10, 776, 1536}, {1, 3, 5}},
     {"\U0000000a\U00000a03", {10, 2563}, {1, 4}},
     {"\U0000000a\U00000308\U00000a03", {10, 776}, {1, 6}},
     {"\U0000000a\U00001100", {10, 4352}, {1, 4}},
     {"\U0000000a\U00000308\U00001100", {10, 776, 4352}, {1, 3, 6}},
     {"\U0000000a\U00001160", {10, 4448}, {1, 4}},
     {"\U0000000a\U00000308\U00001160", {10, 776, 4448}, {1, 3, 6}},
     {"\U0000000a\U000011a8", {10, 4520}, {1, 4}},
     {"\U0000000a\U00000308\U000011a8", {10, 776, 4520}, {1, 3, 6}},
     {"\U0000000a\U0000ac00", {10, 44032}, {1, 4}},
     {"\U0000000a\U00000308\U0000ac00", {10, 776, 44032}, {1, 3, 6}},
     {"\U0000000a\U0000ac01", {10, 44033}, {1, 4}},
     {"\U0000000a\U00000308\U0000ac01", {10, 776, 44033}, {1, 3, 6}},
     {"\U0000000a\U00000903", {10, 2307}, {1, 4}},
     {"\U0000000a\U00000308\U00000903", {10, 776}, {1, 6}},
     {"\U0000000a\U00000904", {10, 2308}, {1, 4}},
     {"\U0000000a\U00000308\U00000904", {10, 776, 2308}, {1, 3, 6}},
     {"\U0000000a\U00000d4e", {10, 3406}, {1, 4}},
     {"\U0000000a\U00000308\U00000d4e", {10, 776, 3406}, {1, 3, 6}},
     {"\U0000000a\U00000915", {10, 2325}, {1, 4}},
     {"\U0000000a\U00000308\U00000915", {10, 776, 2325}, {1, 3, 6}},
     {"\U0000000a\U0000231a", {10, 8986}, {1, 4}},
     {"\U0000000a\U00000308\U0000231a", {10, 776, 8986}, {1, 3, 6}},
     {"\U0000000a\U00000300", {10, 768}, {1, 3}},
     {"\U0000000a\U00000308\U00000300", {10, 776}, {1, 5}},
     {"\U0000000a\U00000900", {10, 2304}, {1, 4}},
     {"\U0000000a\U00000308\U00000900", {10, 776}, {1, 6}},
     {"\U0000000a\U0000094d", {10, 2381}, {1, 4}},
     {"\U0000000a\U00000308\U0000094d", {10, 776}, {1, 6}},
     {"\U0000000a\U0000200d", {10, 8205}, {1, 4}},
     {"\U0000000a\U00000308\U0000200d", {10, 776}, {1, 6}},
     {"\U0000000a\U00000378", {10, 888}, {1, 3}},
     {"\U0000000a\U00000308\U00000378", {10, 776, 888}, {1, 3, 5}},
     {"\U00000001\U00000020", {1, 32}, {1, 2}},
     {"\U00000001\U00000308\U00000020", {1, 776, 32}, {1, 3, 4}},
     {"\U00000001\U0000000d", {1, 13}, {1, 2}},
     {"\U00000001\U00000308\U0000000d", {1, 776, 13}, {1, 3, 4}},
     {"\U00000001\U0000000a", {1, 10}, {1, 2}},
     {"\U00000001\U00000308\U0000000a", {1, 776, 10}, {1, 3, 4}},
     {"\U00000001\U00000001", {1, 1}, {1, 2}},
     {"\U00000001\U00000308\U00000001", {1, 776, 1}, {1, 3, 4}},
     {"\U00000001\U0000200c", {1, 8204}, {1, 4}},
     {"\U00000001\U00000308\U0000200c", {1, 776}, {1, 6}},
     {"\U00000001\U0001f1e6", {1, 127462}, {1, 5}},
     {"\U00000001\U00000308\U0001f1e6", {1, 776, 127462}, {1, 3, 7}},
     {"\U00000001\U00000600", {1, 1536}, {1, 3}},
     {"\U00000001\U00000308\U00000600", {1, 776, 1536}, {1, 3, 5}},
     {"\U00000001\U00000a03", {1, 2563}, {1, 4}},
     {"\U00000001\U00000308\U00000a03", {1, 776}, {1, 6}},
     {"\U00000001\U00001100", {1, 4352}, {1, 4}},
     {"\U00000001\U00000308\U00001100", {1, 776, 4352}, {1, 3, 6}},
     {"\U00000001\U00001160", {1, 4448}, {1, 4}},
     {"\U00000001\U00000308\U00001160", {1, 776, 4448}, {1, 3, 6}},
     {"\U00000001\U000011a8", {1, 4520}, {1, 4}},
     {"\U00000001\U00000308\U000011a8", {1, 776, 4520}, {1, 3, 6}},
     {"\U00000001\U0000ac00", {1, 44032}, {1, 4}},
     {"\U00000001\U00000308\U0000ac00", {1, 776, 44032}, {1, 3, 6}},
     {"\U00000001\U0000ac01", {1, 44033}, {1, 4}},
     {"\U00000001\U00000308\U0000ac01", {1, 776, 44033}, {1, 3, 6}},
     {"\U00000001\U00000903", {1, 2307}, {1, 4}},
     {"\U00000001\U00000308\U00000903", {1, 776}, {1, 6}},
     {"\U00000001\U00000904", {1, 2308}, {1, 4}},
     {"\U00000001\U00000308\U00000904", {1, 776, 2308}, {1, 3, 6}},
     {"\U00000001\U00000d4e", {1, 3406}, {1, 4}},
     {"\U00000001\U00000308\U00000d4e", {1, 776, 3406}, {1, 3, 6}},
     {"\U00000001\U00000915", {1, 2325}, {1, 4}},
     {"\U00000001\U00000308\U00000915", {1, 776, 2325}, {1, 3, 6}},
     {"\U00000001\U0000231a", {1, 8986}, {1, 4}},
     {"\U00000001\U00000308\U0000231a", {1, 776, 8986}, {1, 3, 6}},
     {"\U00000001\U00000300", {1, 768}, {1, 3}},
     {"\U00000001\U00000308\U00000300", {1, 776}, {1, 5}},
     {"\U00000001\U00000900", {1, 2304}, {1, 4}},
     {"\U00000001\U00000308\U00000900", {1, 776}, {1, 6}},
     {"\U00000001\U0000094d", {1, 2381}, {1, 4}},
     {"\U00000001\U00000308\U0000094d", {1, 776}, {1, 6}},
     {"\U00000001\U0000200d", {1, 8205}, {1, 4}},
     {"\U00000001\U00000308\U0000200d", {1, 776}, {1, 6}},
     {"\U00000001\U00000378", {1, 888}, {1, 3}},
     {"\U00000001\U00000308\U00000378", {1, 776, 888}, {1, 3, 5}},
     {"\U0000200c\U00000020", {8204, 32}, {3, 4}},
     {"\U0000200c\U00000308\U00000020", {8204, 32}, {5, 6}},
     {"\U0000200c\U0000000d", {8204, 13}, {3, 4}},
     {"\U0000200c\U00000308\U0000000d", {8204, 13}, {5, 6}},
     {"\U0000200c\U0000000a", {8204, 10}, {3, 4}},
     {"\U0000200c\U00000308\U0000000a", {8204, 10}, {5, 6}},
     {"\U0000200c\U00000001", {8204, 1}, {3, 4}},
     {"\U0000200c\U00000308\U00000001", {8204, 1}, {5, 6}},
     {"\U0000200c\U0000200c", {8204}, {6}},
     {"\U0000200c\U00000308\U0000200c", {8204}, {8}},
     {"\U0000200c\U0001f1e6", {8204, 127462}, {3, 7}},
     {"\U0000200c\U00000308\U0001f1e6", {8204, 127462}, {5, 9}},
     {"\U0000200c\U00000600", {8204, 1536}, {3, 5}},
     {"\U0000200c\U00000308\U00000600", {8204, 1536}, {5, 7}},
     {"\U0000200c\U00000a03", {8204}, {6}},
     {"\U0000200c\U00000308\U00000a03", {8204}, {8}},
     {"\U0000200c\U00001100", {8204, 4352}, {3, 6}},
     {"\U0000200c\U00000308\U00001100", {8204, 4352}, {5, 8}},
     {"\U0000200c\U00001160", {8204, 4448}, {3, 6}},
     {"\U0000200c\U00000308\U00001160", {8204, 4448}, {5, 8}},
     {"\U0000200c\U000011a8", {8204, 4520}, {3, 6}},
     {"\U0000200c\U00000308\U000011a8", {8204, 4520}, {5, 8}},
     {"\U0000200c\U0000ac00", {8204, 44032}, {3, 6}},
     {"\U0000200c\U00000308\U0000ac00", {8204, 44032}, {5, 8}},
     {"\U0000200c\U0000ac01", {8204, 44033}, {3, 6}},
     {"\U0000200c\U00000308\U0000ac01", {8204, 44033}, {5, 8}},
     {"\U0000200c\U00000903", {8204}, {6}},
     {"\U0000200c\U00000308\U00000903", {8204}, {8}},
     {"\U0000200c\U00000904", {8204, 2308}, {3, 6}},
     {"\U0000200c\U00000308\U00000904", {8204, 2308}, {5, 8}},
     {"\U0000200c\U00000d4e", {8204, 3406}, {3, 6}},
     {"\U0000200c\U00000308\U00000d4e", {8204, 3406}, {5, 8}},
     {"\U0000200c\U00000915", {8204, 2325}, {3, 6}},
     {"\U0000200c\U00000308\U00000915", {8204, 2325}, {5, 8}},
     {"\U0000200c\U0000231a", {8204, 8986}, {3, 6}},
     {"\U0000200c\U00000308\U0000231a", {8204, 8986}, {5, 8}},
     {"\U0000200c\U00000300", {8204}, {5}},
     {"\U0000200c\U00000308\U00000300", {8204}, {7}},
     {"\U0000200c\U00000900", {8204}, {6}},
     {"\U0000200c\U00000308\U00000900", {8204}, {8}},
     {"\U0000200c\U0000094d", {8204}, {6}},
     {"\U0000200c\U00000308\U0000094d", {8204}, {8}},
     {"\U0000200c\U0000200d", {8204}, {6}},
     {"\U0000200c\U00000308\U0000200d", {8204}, {8}},
     {"\U0000200c\U00000378", {8204, 888}, {3, 5}},
     {"\U0000200c\U00000308\U00000378", {8204, 888}, {5, 7}},
     {"\U0001f1e6\U00000020", {127462, 32}, {4, 5}},
     {"\U0001f1e6\U00000308\U00000020", {127462, 32}, {6, 7}},
     {"\U0001f1e6\U0000000d", {127462, 13}, {4, 5}},
     {"\U0001f1e6\U00000308\U0000000d", {127462, 13}, {6, 7}},
     {"\U0001f1e6\U0000000a", {127462, 10}, {4, 5}},
     {"\U0001f1e6\U00000308\U0000000a", {127462, 10}, {6, 7}},
     {"\U0001f1e6\U00000001", {127462, 1}, {4, 5}},
     {"\U0001f1e6\U00000308\U00000001", {127462, 1}, {6, 7}},
     {"\U0001f1e6\U0000200c", {127462}, {7}},
     {"\U0001f1e6\U00000308\U0000200c", {127462}, {9}},
     {"\U0001f1e6\U0001f1e6", {127462}, {8}},
     {"\U0001f1e6\U00000308\U0001f1e6", {127462, 127462}, {6, 10}},
     {"\U0001f1e6\U00000600", {127462, 1536}, {4, 6}},
     {"\U0001f1e6\U00000308\U00000600", {127462, 1536}, {6, 8}},
     {"\U0001f1e6\U00000a03", {127462}, {7}},
     {"\U0001f1e6\U00000308\U00000a03", {127462}, {9}},
     {"\U0001f1e6\U00001100", {127462, 4352}, {4, 7}},
     {"\U0001f1e6\U00000308\U00001100", {127462, 4352}, {6, 9}},
     {"\U0001f1e6\U00001160", {127462, 4448}, {4, 7}},
     {"\U0001f1e6\U00000308\U00001160", {127462, 4448}, {6, 9}},
     {"\U0001f1e6\U000011a8", {127462, 4520}, {4, 7}},
     {"\U0001f1e6\U00000308\U000011a8", {127462, 4520}, {6, 9}},
     {"\U0001f1e6\U0000ac00", {127462, 44032}, {4, 7}},
     {"\U0001f1e6\U00000308\U0000ac00", {127462, 44032}, {6, 9}},
     {"\U0001f1e6\U0000ac01", {127462, 44033}, {4, 7}},
     {"\U0001f1e6\U00000308\U0000ac01", {127462, 44033}, {6, 9}},
     {"\U0001f1e6\U00000903", {127462}, {7}},
     {"\U0001f1e6\U00000308\U00000903", {127462}, {9}},
     {"\U0001f1e6\U00000904", {127462, 2308}, {4, 7}},
     {"\U0001f1e6\U00000308\U00000904", {127462, 2308}, {6, 9}},
     {"\U0001f1e6\U00000d4e", {127462, 3406}, {4, 7}},
     {"\U0001f1e6\U00000308\U00000d4e", {127462, 3406}, {6, 9}},
     {"\U0001f1e6\U00000915", {127462, 2325}, {4, 7}},
     {"\U0001f1e6\U00000308\U00000915", {127462, 2325}, {6, 9}},
     {"\U0001f1e6\U0000231a", {127462, 8986}, {4, 7}},
     {"\U0001f1e6\U00000308\U0000231a", {127462, 8986}, {6, 9}},
     {"\U0001f1e6\U00000300", {127462}, {6}},
     {"\U0001f1e6\U00000308\U00000300", {127462}, {8}},
     {"\U0001f1e6\U00000900", {127462}, {7}},
     {"\U0001f1e6\U00000308\U00000900", {127462}, {9}},
     {"\U0001f1e6\U0000094d", {127462}, {7}},
     {"\U0001f1e6\U00000308\U0000094d", {127462}, {9}},
     {"\U0001f1e6\U0000200d", {127462}, {7}},
     {"\U0001f1e6\U00000308\U0000200d", {127462}, {9}},
     {"\U0001f1e6\U00000378", {127462, 888}, {4, 6}},
     {"\U0001f1e6\U00000308\U00000378", {127462, 888}, {6, 8}},
     {"\U00000600\U00000020", {1536}, {3}},
     {"\U00000600\U00000308\U00000020", {1536, 32}, {4, 5}},
     {"\U00000600\U0000000d", {1536, 13}, {2, 3}},
     {"\U00000600\U00000308\U0000000d", {1536, 13}, {4, 5}},
     {"\U00000600\U0000000a", {1536, 10}, {2, 3}},
     {"\U00000600\U00000308\U0000000a", {1536, 10}, {4, 5}},
     {"\U00000600\U00000001", {1536, 1}, {2, 3}},
     {"\U00000600\U00000308\U00000001", {1536, 1}, {4, 5}},
     {"\U00000600\U0000200c", {1536}, {5}},
     {"\U00000600\U00000308\U0000200c", {1536}, {7}},
     {"\U00000600\U0001f1e6", {1536}, {6}},
     {"\U00000600\U00000308\U0001f1e6", {1536, 127462}, {4, 8}},
     {"\U00000600\U00000600", {1536}, {4}},
     {"\U00000600\U00000308\U00000600", {1536, 1536}, {4, 6}},
     {"\U00000600\U00000a03", {1536}, {5}},
     {"\U00000600\U00000308\U00000a03", {1536}, {7}},
     {"\U00000600\U00001100", {1536}, {5}},
     {"\U00000600\U00000308\U00001100", {1536, 4352}, {4, 7}},
     {"\U00000600\U00001160", {1536}, {5}},
     {"\U00000600\U00000308\U00001160", {1536, 4448}, {4, 7}},
     {"\U00000600\U000011a8", {1536}, {5}},
     {"\U00000600\U00000308\U000011a8", {1536, 4520}, {4, 7}},
     {"\U00000600\U0000ac00", {1536}, {5}},
     {"\U00000600\U00000308\U0000ac00", {1536, 44032}, {4, 7}},
     {"\U00000600\U0000ac01", {1536}, {5}},
     {"\U00000600\U00000308\U0000ac01", {1536, 44033}, {4, 7}},
     {"\U00000600\U00000903", {1536}, {5}},
     {"\U00000600\U00000308\U00000903", {1536}, {7}},
     {"\U00000600\U00000904", {1536}, {5}},
     {"\U00000600\U00000308\U00000904", {1536, 2308}, {4, 7}},
     {"\U00000600\U00000d4e", {1536}, {5}},
     {"\U00000600\U00000308\U00000d4e", {1536, 3406}, {4, 7}},
     {"\U00000600\U00000915", {1536}, {5}},
     {"\U00000600\U00000308\U00000915", {1536, 2325}, {4, 7}},
     {"\U00000600\U0000231a", {1536}, {5}},
     {"\U00000600\U00000308\U0000231a", {1536, 8986}, {4, 7}},
     {"\U00000600\U00000300", {1536}, {4}},
     {"\U00000600\U00000308\U00000300", {1536}, {6}},
     {"\U00000600\U00000900", {1536}, {5}},
     {"\U00000600\U00000308\U00000900", {1536}, {7}},
     {"\U00000600\U0000094d", {1536}, {5}},
     {"\U00000600\U00000308\U0000094d", {1536}, {7}},
     {"\U00000600\U0000200d", {1536}, {5}},
     {"\U00000600\U00000308\U0000200d", {1536}, {7}},
     {"\U00000600\U00000378", {1536}, {4}},
     {"\U00000600\U00000308\U00000378", {1536, 888}, {4, 6}},
     {"\U00000a03\U00000020", {2563, 32}, {3, 4}},
     {"\U00000a03\U00000308\U00000020", {2563, 32}, {5, 6}},
     {"\U00000a03\U0000000d", {2563, 13}, {3, 4}},
     {"\U00000a03\U00000308\U0000000d", {2563, 13}, {5, 6}},
     {"\U00000a03\U0000000a", {2563, 10}, {3, 4}},
     {"\U00000a03\U00000308\U0000000a", {2563, 10}, {5, 6}},
     {"\U00000a03\U00000001", {2563, 1}, {3, 4}},
     {"\U00000a03\U00000308\U00000001", {2563, 1}, {5, 6}},
     {"\U00000a03\U0000200c", {2563}, {6}},
     {"\U00000a03\U00000308\U0000200c", {2563}, {8}},
     {"\U00000a03\U0001f1e6", {2563, 127462}, {3, 7}},
     {"\U00000a03\U00000308\U0001f1e6", {2563, 127462}, {5, 9}},
     {"\U00000a03\U00000600", {2563, 1536}, {3, 5}},
     {"\U00000a03\U00000308\U00000600", {2563, 1536}, {5, 7}},
     {"\U00000a03\U00000a03", {2563}, {6}},
     {"\U00000a03\U00000308\U00000a03", {2563}, {8}},
     {"\U00000a03\U00001100", {2563, 4352}, {3, 6}},
     {"\U00000a03\U00000308\U00001100", {2563, 4352}, {5, 8}},
     {"\U00000a03\U00001160", {2563, 4448}, {3, 6}},
     {"\U00000a03\U00000308\U00001160", {2563, 4448}, {5, 8}},
     {"\U00000a03\U000011a8", {2563, 4520}, {3, 6}},
     {"\U00000a03\U00000308\U000011a8", {2563, 4520}, {5, 8}},
     {"\U00000a03\U0000ac00", {2563, 44032}, {3, 6}},
     {"\U00000a03\U00000308\U0000ac00", {2563, 44032}, {5, 8}},
     {"\U00000a03\U0000ac01", {2563, 44033}, {3, 6}},
     {"\U00000a03\U00000308\U0000ac01", {2563, 44033}, {5, 8}},
     {"\U00000a03\U00000903", {2563}, {6}},
     {"\U00000a03\U00000308\U00000903", {2563}, {8}},
     {"\U00000a03\U00000904", {2563, 2308}, {3, 6}},
     {"\U00000a03\U00000308\U00000904", {2563, 2308}, {5, 8}},
     {"\U00000a03\U00000d4e", {2563, 3406}, {3, 6}},
     {"\U00000a03\U00000308\U00000d4e", {2563, 3406}, {5, 8}},
     {"\U00000a03\U00000915", {2563, 2325}, {3, 6}},
     {"\U00000a03\U00000308\U00000915", {2563, 2325}, {5, 8}},
     {"\U00000a03\U0000231a", {2563, 8986}, {3, 6}},
     {"\U00000a03\U00000308\U0000231a", {2563, 8986}, {5, 8}},
     {"\U00000a03\U00000300", {2563}, {5}},
     {"\U00000a03\U00000308\U00000300", {2563}, {7}},
     {"\U00000a03\U00000900", {2563}, {6}},
     {"\U00000a03\U00000308\U00000900", {2563}, {8}},
     {"\U00000a03\U0000094d", {2563}, {6}},
     {"\U00000a03\U00000308\U0000094d", {2563}, {8}},
     {"\U00000a03\U0000200d", {2563}, {6}},
     {"\U00000a03\U00000308\U0000200d", {2563}, {8}},
     {"\U00000a03\U00000378", {2563, 888}, {3, 5}},
     {"\U00000a03\U00000308\U00000378", {2563, 888}, {5, 7}},
     {"\U00001100\U00000020", {4352, 32}, {3, 4}},
     {"\U00001100\U00000308\U00000020", {4352, 32}, {5, 6}},
     {"\U00001100\U0000000d", {4352, 13}, {3, 4}},
     {"\U00001100\U00000308\U0000000d", {4352, 13}, {5, 6}},
     {"\U00001100\U0000000a", {4352, 10}, {3, 4}},
     {"\U00001100\U00000308\U0000000a", {4352, 10}, {5, 6}},
     {"\U00001100\U00000001", {4352, 1}, {3, 4}},
     {"\U00001100\U00000308\U00000001", {4352, 1}, {5, 6}},
     {"\U00001100\U0000200c", {4352}, {6}},
     {"\U00001100\U00000308\U0000200c", {4352}, {8}},
     {"\U00001100\U0001f1e6", {4352, 127462}, {3, 7}},
     {"\U00001100\U00000308\U0001f1e6", {4352, 127462}, {5, 9}},
     {"\U00001100\U00000600", {4352, 1536}, {3, 5}},
     {"\U00001100\U00000308\U00000600", {4352, 1536}, {5, 7}},
     {"\U00001100\U00000a03", {4352}, {6}},
     {"\U00001100\U00000308\U00000a03", {4352}, {8}},
     {"\U00001100\U00001100", {4352}, {6}},
     {"\U00001100\U00000308\U00001100", {4352, 4352}, {5, 8}},
     {"\U00001100\U00001160", {4352}, {6}},
     {"\U00001100\U00000308\U00001160", {4352, 4448}, {5, 8}},
     {"\U00001100\U000011a8", {4352, 4520}, {3, 6}},
     {"\U00001100\U00000308\U000011a8", {4352, 4520}, {5, 8}},
     {"\U00001100\U0000ac00", {4352}, {6}},
     {"\U00001100\U00000308\U0000ac00", {4352, 44032}, {5, 8}},
     {"\U00001100\U0000ac01", {4352}, {6}},
     {"\U00001100\U00000308\U0000ac01", {4352, 44033}, {5, 8}},
     {"\U00001100\U00000903", {4352}, {6}},
     {"\U00001100\U00000308\U00000903", {4352}, {8}},
     {"\U00001100\U00000904", {4352, 2308}, {3, 6}},
     {"\U00001100\U00000308\U00000904", {4352, 2308}, {5, 8}},
     {"\U00001100\U00000d4e", {4352, 3406}, {3, 6}},
     {"\U00001100\U00000308\U00000d4e", {4352, 3406}, {5, 8}},
     {"\U00001100\U00000915", {4352, 2325}, {3, 6}},
     {"\U00001100\U00000308\U00000915", {4352, 2325}, {5, 8}},
     {"\U00001100\U0000231a", {4352, 8986}, {3, 6}},
     {"\U00001100\U00000308\U0000231a", {4352, 8986}, {5, 8}},
     {"\U00001100\U00000300", {4352}, {5}},
     {"\U00001100\U00000308\U00000300", {4352}, {7}},
     {"\U00001100\U00000900", {4352}, {6}},
     {"\U00001100\U00000308\U00000900", {4352}, {8}},
     {"\U00001100\U0000094d", {4352}, {6}},
     {"\U00001100\U00000308\U0000094d", {4352}, {8}},
     {"\U00001100\U0000200d", {4352}, {6}},
     {"\U00001100\U00000308\U0000200d", {4352}, {8}},
     {"\U00001100\U00000378", {4352, 888}, {3, 5}},
     {"\U00001100\U00000308\U00000378", {4352, 888}, {5, 7}},
     {"\U00001160\U00000020", {4448, 32}, {3, 4}},
     {"\U00001160\U00000308\U00000020", {4448, 32}, {5, 6}},
     {"\U00001160\U0000000d", {4448, 13}, {3, 4}},
     {"\U00001160\U00000308\U0000000d", {4448, 13}, {5, 6}},
     {"\U00001160\U0000000a", {4448, 10}, {3, 4}},
     {"\U00001160\U00000308\U0000000a", {4448, 10}, {5, 6}},
     {"\U00001160\U00000001", {4448, 1}, {3, 4}},
     {"\U00001160\U00000308\U00000001", {4448, 1}, {5, 6}},
     {"\U00001160\U0000200c", {4448}, {6}},
     {"\U00001160\U00000308\U0000200c", {4448}, {8}},
     {"\U00001160\U0001f1e6", {4448, 127462}, {3, 7}},
     {"\U00001160\U00000308\U0001f1e6", {4448, 127462}, {5, 9}},
     {"\U00001160\U00000600", {4448, 1536}, {3, 5}},
     {"\U00001160\U00000308\U00000600", {4448, 1536}, {5, 7}},
     {"\U00001160\U00000a03", {4448}, {6}},
     {"\U00001160\U00000308\U00000a03", {4448}, {8}},
     {"\U00001160\U00001100", {4448, 4352}, {3, 6}},
     {"\U00001160\U00000308\U00001100", {4448, 4352}, {5, 8}},
     {"\U00001160\U00001160", {4448}, {6}},
     {"\U00001160\U00000308\U00001160", {4448, 4448}, {5, 8}},
     {"\U00001160\U000011a8", {4448}, {6}},
     {"\U00001160\U00000308\U000011a8", {4448, 4520}, {5, 8}},
     {"\U00001160\U0000ac00", {4448, 44032}, {3, 6}},
     {"\U00001160\U00000308\U0000ac00", {4448, 44032}, {5, 8}},
     {"\U00001160\U0000ac01", {4448, 44033}, {3, 6}},
     {"\U00001160\U00000308\U0000ac01", {4448, 44033}, {5, 8}},
     {"\U00001160\U00000903", {4448}, {6}},
     {"\U00001160\U00000308\U00000903", {4448}, {8}},
     {"\U00001160\U00000904", {4448, 2308}, {3, 6}},
     {"\U00001160\U00000308\U00000904", {4448, 2308}, {5, 8}},
     {"\U00001160\U00000d4e", {4448, 3406}, {3, 6}},
     {"\U00001160\U00000308\U00000d4e", {4448, 3406}, {5, 8}},
     {"\U00001160\U00000915", {4448, 2325}, {3, 6}},
     {"\U00001160\U00000308\U00000915", {4448, 2325}, {5, 8}},
     {"\U00001160\U0000231a", {4448, 8986}, {3, 6}},
     {"\U00001160\U00000308\U0000231a", {4448, 8986}, {5, 8}},
     {"\U00001160\U00000300", {4448}, {5}},
     {"\U00001160\U00000308\U00000300", {4448}, {7}},
     {"\U00001160\U00000900", {4448}, {6}},
     {"\U00001160\U00000308\U00000900", {4448}, {8}},
     {"\U00001160\U0000094d", {4448}, {6}},
     {"\U00001160\U00000308\U0000094d", {4448}, {8}},
     {"\U00001160\U0000200d", {4448}, {6}},
     {"\U00001160\U00000308\U0000200d", {4448}, {8}},
     {"\U00001160\U00000378", {4448, 888}, {3, 5}},
     {"\U00001160\U00000308\U00000378", {4448, 888}, {5, 7}},
     {"\U000011a8\U00000020", {4520, 32}, {3, 4}},
     {"\U000011a8\U00000308\U00000020", {4520, 32}, {5, 6}},
     {"\U000011a8\U0000000d", {4520, 13}, {3, 4}},
     {"\U000011a8\U00000308\U0000000d", {4520, 13}, {5, 6}},
     {"\U000011a8\U0000000a", {4520, 10}, {3, 4}},
     {"\U000011a8\U00000308\U0000000a", {4520, 10}, {5, 6}},
     {"\U000011a8\U00000001", {4520, 1}, {3, 4}},
     {"\U000011a8\U00000308\U00000001", {4520, 1}, {5, 6}},
     {"\U000011a8\U0000200c", {4520}, {6}},
     {"\U000011a8\U00000308\U0000200c", {4520}, {8}},
     {"\U000011a8\U0001f1e6", {4520, 127462}, {3, 7}},
     {"\U000011a8\U00000308\U0001f1e6", {4520, 127462}, {5, 9}},
     {"\U000011a8\U00000600", {4520, 1536}, {3, 5}},
     {"\U000011a8\U00000308\U00000600", {4520, 1536}, {5, 7}},
     {"\U000011a8\U00000a03", {4520}, {6}},
     {"\U000011a8\U00000308\U00000a03", {4520}, {8}},
     {"\U000011a8\U00001100", {4520, 4352}, {3, 6}},
     {"\U000011a8\U00000308\U00001100", {4520, 4352}, {5, 8}},
     {"\U000011a8\U00001160", {4520, 4448}, {3, 6}},
     {"\U000011a8\U00000308\U00001160", {4520, 4448}, {5, 8}},
     {"\U000011a8\U000011a8", {4520}, {6}},
     {"\U000011a8\U00000308\U000011a8", {4520, 4520}, {5, 8}},
     {"\U000011a8\U0000ac00", {4520, 44032}, {3, 6}},
     {"\U000011a8\U00000308\U0000ac00", {4520, 44032}, {5, 8}},
     {"\U000011a8\U0000ac01", {4520, 44033}, {3, 6}},
     {"\U000011a8\U00000308\U0000ac01", {4520, 44033}, {5, 8}},
     {"\U000011a8\U00000903", {4520}, {6}},
     {"\U000011a8\U00000308\U00000903", {4520}, {8}},
     {"\U000011a8\U00000904", {4520, 2308}, {3, 6}},
     {"\U000011a8\U00000308\U00000904", {4520, 2308}, {5, 8}},
     {"\U000011a8\U00000d4e", {4520, 3406}, {3, 6}},
     {"\U000011a8\U00000308\U00000d4e", {4520, 3406}, {5, 8}},
     {"\U000011a8\U00000915", {4520, 2325}, {3, 6}},
     {"\U000011a8\U00000308\U00000915", {4520, 2325}, {5, 8}},
     {"\U000011a8\U0000231a", {4520, 8986}, {3, 6}},
     {"\U000011a8\U00000308\U0000231a", {4520, 8986}, {5, 8}},
     {"\U000011a8\U00000300", {4520}, {5}},
     {"\U000011a8\U00000308\U00000300", {4520}, {7}},
     {"\U000011a8\U00000900", {4520}, {6}},
     {"\U000011a8\U00000308\U00000900", {4520}, {8}},
     {"\U000011a8\U0000094d", {4520}, {6}},
     {"\U000011a8\U00000308\U0000094d", {4520}, {8}},
     {"\U000011a8\U0000200d", {4520}, {6}},
     {"\U000011a8\U00000308\U0000200d", {4520}, {8}},
     {"\U000011a8\U00000378", {4520, 888}, {3, 5}},
     {"\U000011a8\U00000308\U00000378", {4520, 888}, {5, 7}},
     {"\U0000ac00\U00000020", {44032, 32}, {3, 4}},
     {"\U0000ac00\U00000308\U00000020", {44032, 32}, {5, 6}},
     {"\U0000ac00\U0000000d", {44032, 13}, {3, 4}},
     {"\U0000ac00\U00000308\U0000000d", {44032, 13}, {5, 6}},
     {"\U0000ac00\U0000000a", {44032, 10}, {3, 4}},
     {"\U0000ac00\U00000308\U0000000a", {44032, 10}, {5, 6}},
     {"\U0000ac00\U00000001", {44032, 1}, {3, 4}},
     {"\U0000ac00\U00000308\U00000001", {44032, 1}, {5, 6}},
     {"\U0000ac00\U0000200c", {44032}, {6}},
     {"\U0000ac00\U00000308\U0000200c", {44032}, {8}},
     {"\U0000ac00\U0001f1e6", {44032, 127462}, {3, 7}},
     {"\U0000ac00\U00000308\U0001f1e6", {44032, 127462}, {5, 9}},
     {"\U0000ac00\U00000600", {44032, 1536}, {3, 5}},
     {"\U0000ac00\U00000308\U00000600", {44032, 1536}, {5, 7}},
     {"\U0000ac00\U00000a03", {44032}, {6}},
     {"\U0000ac00\U00000308\U00000a03", {44032}, {8}},
     {"\U0000ac00\U00001100", {44032, 4352}, {3, 6}},
     {"\U0000ac00\U00000308\U00001100", {44032, 4352}, {5, 8}},
     {"\U0000ac00\U00001160", {44032}, {6}},
     {"\U0000ac00\U00000308\U00001160", {44032, 4448}, {5, 8}},
     {"\U0000ac00\U000011a8", {44032}, {6}},
     {"\U0000ac00\U00000308\U000011a8", {44032, 4520}, {5, 8}},
     {"\U0000ac00\U0000ac00", {44032, 44032}, {3, 6}},
     {"\U0000ac00\U00000308\U0000ac00", {44032, 44032}, {5, 8}},
     {"\U0000ac00\U0000ac01", {44032, 44033}, {3, 6}},
     {"\U0000ac00\U00000308\U0000ac01", {44032, 44033}, {5, 8}},
     {"\U0000ac00\U00000903", {44032}, {6}},
     {"\U0000ac00\U00000308\U00000903", {44032}, {8}},
     {"\U0000ac00\U00000904", {44032, 2308}, {3, 6}},
     {"\U0000ac00\U00000308\U00000904", {44032, 2308}, {5, 8}},
     {"\U0000ac00\U00000d4e", {44032, 3406}, {3, 6}},
     {"\U0000ac00\U00000308\U00000d4e", {44032, 3406}, {5, 8}},
     {"\U0000ac00\U00000915", {44032, 2325}, {3, 6}},
     {"\U0000ac00\U00000308\U00000915", {44032, 2325}, {5, 8}},
     {"\U0000ac00\U0000231a", {44032, 8986}, {3, 6}},
     {"\U0000ac00\U00000308\U0000231a", {44032, 8986}, {5, 8}},
     {"\U0000ac00\U00000300", {44032}, {5}},
     {"\U0000ac00\U00000308\U00000300", {44032}, {7}},
     {"\U0000ac00\U00000900", {44032}, {6}},
     {"\U0000ac00\U00000308\U00000900", {44032}, {8}},
     {"\U0000ac00\U0000094d", {44032}, {6}},
     {"\U0000ac00\U00000308\U0000094d", {44032}, {8}},
     {"\U0000ac00\U0000200d", {44032}, {6}},
     {"\U0000ac00\U00000308\U0000200d", {44032}, {8}},
     {"\U0000ac00\U00000378", {44032, 888}, {3, 5}},
     {"\U0000ac00\U00000308\U00000378", {44032, 888}, {5, 7}},
     {"\U0000ac01\U00000020", {44033, 32}, {3, 4}},
     {"\U0000ac01\U00000308\U00000020", {44033, 32}, {5, 6}},
     {"\U0000ac01\U0000000d", {44033, 13}, {3, 4}},
     {"\U0000ac01\U00000308\U0000000d", {44033, 13}, {5, 6}},
     {"\U0000ac01\U0000000a", {44033, 10}, {3, 4}},
     {"\U0000ac01\U00000308\U0000000a", {44033, 10}, {5, 6}},
     {"\U0000ac01\U00000001", {44033, 1}, {3, 4}},
     {"\U0000ac01\U00000308\U00000001", {44033, 1}, {5, 6}},
     {"\U0000ac01\U0000200c", {44033}, {6}},
     {"\U0000ac01\U00000308\U0000200c", {44033}, {8}},
     {"\U0000ac01\U0001f1e6", {44033, 127462}, {3, 7}},
     {"\U0000ac01\U00000308\U0001f1e6", {44033, 127462}, {5, 9}},
     {"\U0000ac01\U00000600", {44033, 1536}, {3, 5}},
     {"\U0000ac01\U00000308\U00000600", {44033, 1536}, {5, 7}},
     {"\U0000ac01\U00000a03", {44033}, {6}},
     {"\U0000ac01\U00000308\U00000a03", {44033}, {8}},
     {"\U0000ac01\U00001100", {44033, 4352}, {3, 6}},
     {"\U0000ac01\U00000308\U00001100", {44033, 4352}, {5, 8}},
     {"\U0000ac01\U00001160", {44033, 4448}, {3, 6}},
     {"\U0000ac01\U00000308\U00001160", {44033, 4448}, {5, 8}},
     {"\U0000ac01\U000011a8", {44033}, {6}},
     {"\U0000ac01\U00000308\U000011a8", {44033, 4520}, {5, 8}},
     {"\U0000ac01\U0000ac00", {44033, 44032}, {3, 6}},
     {"\U0000ac01\U00000308\U0000ac00", {44033, 44032}, {5, 8}},
     {"\U0000ac01\U0000ac01", {44033, 44033}, {3, 6}},
     {"\U0000ac01\U00000308\U0000ac01", {44033, 44033}, {5, 8}},
     {"\U0000ac01\U00000903", {44033}, {6}},
     {"\U0000ac01\U00000308\U00000903", {44033}, {8}},
     {"\U0000ac01\U00000904", {44033, 2308}, {3, 6}},
     {"\U0000ac01\U00000308\U00000904", {44033, 2308}, {5, 8}},
     {"\U0000ac01\U00000d4e", {44033, 3406}, {3, 6}},
     {"\U0000ac01\U00000308\U00000d4e", {44033, 3406}, {5, 8}},
     {"\U0000ac01\U00000915", {44033, 2325}, {3, 6}},
     {"\U0000ac01\U00000308\U00000915", {44033, 2325}, {5, 8}},
     {"\U0000ac01\U0000231a", {44033, 8986}, {3, 6}},
     {"\U0000ac01\U00000308\U0000231a", {44033, 8986}, {5, 8}},
     {"\U0000ac01\U00000300", {44033}, {5}},
     {"\U0000ac01\U00000308\U00000300", {44033}, {7}},
     {"\U0000ac01\U00000900", {44033}, {6}},
     {"\U0000ac01\U00000308\U00000900", {44033}, {8}},
     {"\U0000ac01\U0000094d", {44033}, {6}},
     {"\U0000ac01\U00000308\U0000094d", {44033}, {8}},
     {"\U0000ac01\U0000200d", {44033}, {6}},
     {"\U0000ac01\U00000308\U0000200d", {44033}, {8}},
     {"\U0000ac01\U00000378", {44033, 888}, {3, 5}},
     {"\U0000ac01\U00000308\U00000378", {44033, 888}, {5, 7}},
     {"\U00000903\U00000020", {2307, 32}, {3, 4}},
     {"\U00000903\U00000308\U00000020", {2307, 32}, {5, 6}},
     {"\U00000903\U0000000d", {2307, 13}, {3, 4}},
     {"\U00000903\U00000308\U0000000d", {2307, 13}, {5, 6}},
     {"\U00000903\U0000000a", {2307, 10}, {3, 4}},
     {"\U00000903\U00000308\U0000000a", {2307, 10}, {5, 6}},
     {"\U00000903\U00000001", {2307, 1}, {3, 4}},
     {"\U00000903\U00000308\U00000001", {2307, 1}, {5, 6}},
     {"\U00000903\U0000200c", {2307}, {6}},
     {"\U00000903\U00000308\U0000200c", {2307}, {8}},
     {"\U00000903\U0001f1e6", {2307, 127462}, {3, 7}},
     {"\U00000903\U00000308\U0001f1e6", {2307, 127462}, {5, 9}},
     {"\U00000903\U00000600", {2307, 1536}, {3, 5}},
     {"\U00000903\U00000308\U00000600", {2307, 1536}, {5, 7}},
     {"\U00000903\U00000a03", {2307}, {6}},
     {"\U00000903\U00000308\U00000a03", {2307}, {8}},
     {"\U00000903\U00001100", {2307, 4352}, {3, 6}},
     {"\U00000903\U00000308\U00001100", {2307, 4352}, {5, 8}},
     {"\U00000903\U00001160", {2307, 4448}, {3, 6}},
     {"\U00000903\U00000308\U00001160", {2307, 4448}, {5, 8}},
     {"\U00000903\U000011a8", {2307, 4520}, {3, 6}},
     {"\U00000903\U00000308\U000011a8", {2307, 4520}, {5, 8}},
     {"\U00000903\U0000ac00", {2307, 44032}, {3, 6}},
     {"\U00000903\U00000308\U0000ac00", {2307, 44032}, {5, 8}},
     {"\U00000903\U0000ac01", {2307, 44033}, {3, 6}},
     {"\U00000903\U00000308\U0000ac01", {2307, 44033}, {5, 8}},
     {"\U00000903\U00000903", {2307}, {6}},
     {"\U00000903\U00000308\U00000903", {2307}, {8}},
     {"\U00000903\U00000904", {2307, 2308}, {3, 6}},
     {"\U00000903\U00000308\U00000904", {2307, 2308}, {5, 8}},
     {"\U00000903\U00000d4e", {2307, 3406}, {3, 6}},
     {"\U00000903\U00000308\U00000d4e", {2307, 3406}, {5, 8}},
     {"\U00000903\U00000915", {2307, 2325}, {3, 6}},
     {"\U00000903\U00000308\U00000915", {2307, 2325}, {5, 8}},
     {"\U00000903\U0000231a", {2307, 8986}, {3, 6}},
     {"\U00000903\U00000308\U0000231a", {2307, 8986}, {5, 8}},
     {"\U00000903\U00000300", {2307}, {5}},
     {"\U00000903\U00000308\U00000300", {2307}, {7}},
     {"\U00000903\U00000900", {2307}, {6}},
     {"\U00000903\U00000308\U00000900", {2307}, {8}},
     {"\U00000903\U0000094d", {2307}, {6}},
     {"\U00000903\U00000308\U0000094d", {2307}, {8}},
     {"\U00000903\U0000200d", {2307}, {6}},
     {"\U00000903\U00000308\U0000200d", {2307}, {8}},
     {"\U00000903\U00000378", {2307, 888}, {3, 5}},
     {"\U00000903\U00000308\U00000378", {2307, 888}, {5, 7}},
     {"\U00000904\U00000020", {2308, 32}, {3, 4}},
     {"\U00000904\U00000308\U00000020", {2308, 32}, {5, 6}},
     {"\U00000904\U0000000d", {2308, 13}, {3, 4}},
     {"\U00000904\U00000308\U0000000d", {2308, 13}, {5, 6}},
     {"\U00000904\U0000000a", {2308, 10}, {3, 4}},
     {"\U00000904\U00000308\U0000000a", {2308, 10}, {5, 6}},
     {"\U00000904\U00000001", {2308, 1}, {3, 4}},
     {"\U00000904\U00000308\U00000001", {2308, 1}, {5, 6}},
     {"\U00000904\U0000200c", {2308}, {6}},
     {"\U00000904\U00000308\U0000200c", {2308}, {8}},
     {"\U00000904\U0001f1e6", {2308, 127462}, {3, 7}},
     {"\U00000904\U00000308\U0001f1e6", {2308, 127462}, {5, 9}},
     {"\U00000904\U00000600", {2308, 1536}, {3, 5}},
     {"\U00000904\U00000308\U00000600", {2308, 1536}, {5, 7}},
     {"\U00000904\U00000a03", {2308}, {6}},
     {"\U00000904\U00000308\U00000a03", {2308}, {8}},
     {"\U00000904\U00001100", {2308, 4352}, {3, 6}},
     {"\U00000904\U00000308\U00001100", {2308, 4352}, {5, 8}},
     {"\U00000904\U00001160", {2308, 4448}, {3, 6}},
     {"\U00000904\U00000308\U00001160", {2308, 4448}, {5, 8}},
     {"\U00000904\U000011a8", {2308, 4520}, {3, 6}},
     {"\U00000904\U00000308\U000011a8", {2308, 4520}, {5, 8}},
     {"\U00000904\U0000ac00", {2308, 44032}, {3, 6}},
     {"\U00000904\U00000308\U0000ac00", {2308, 44032}, {5, 8}},
     {"\U00000904\U0000ac01", {2308, 44033}, {3, 6}},
     {"\U00000904\U00000308\U0000ac01", {2308, 44033}, {5, 8}},
     {"\U00000904\U00000903", {2308}, {6}},
     {"\U00000904\U00000308\U00000903", {2308}, {8}},
     {"\U00000904\U00000904", {2308, 2308}, {3, 6}},
     {"\U00000904\U00000308\U00000904", {2308, 2308}, {5, 8}},
     {"\U00000904\U00000d4e", {2308, 3406}, {3, 6}},
     {"\U00000904\U00000308\U00000d4e", {2308, 3406}, {5, 8}},
     {"\U00000904\U00000915", {2308, 2325}, {3, 6}},
     {"\U00000904\U00000308\U00000915", {2308, 2325}, {5, 8}},
     {"\U00000904\U0000231a", {2308, 8986}, {3, 6}},
     {"\U00000904\U00000308\U0000231a", {2308, 8986}, {5, 8}},
     {"\U00000904\U00000300", {2308}, {5}},
     {"\U00000904\U00000308\U00000300", {2308}, {7}},
     {"\U00000904\U00000900", {2308}, {6}},
     {"\U00000904\U00000308\U00000900", {2308}, {8}},
     {"\U00000904\U0000094d", {2308}, {6}},
     {"\U00000904\U00000308\U0000094d", {2308}, {8}},
     {"\U00000904\U0000200d", {2308}, {6}},
     {"\U00000904\U00000308\U0000200d", {2308}, {8}},
     {"\U00000904\U00000378", {2308, 888}, {3, 5}},
     {"\U00000904\U00000308\U00000378", {2308, 888}, {5, 7}},
     {"\U00000d4e\U00000020", {3406}, {4}},
     {"\U00000d4e\U00000308\U00000020", {3406, 32}, {5, 6}},
     {"\U00000d4e\U0000000d", {3406, 13}, {3, 4}},
     {"\U00000d4e\U00000308\U0000000d", {3406, 13}, {5, 6}},
     {"\U00000d4e\U0000000a", {3406, 10}, {3, 4}},
     {"\U00000d4e\U00000308\U0000000a", {3406, 10}, {5, 6}},
     {"\U00000d4e\U00000001", {3406, 1}, {3, 4}},
     {"\U00000d4e\U00000308\U00000001", {3406, 1}, {5, 6}},
     {"\U00000d4e\U0000200c", {3406}, {6}},
     {"\U00000d4e\U00000308\U0000200c", {3406}, {8}},
     {"\U00000d4e\U0001f1e6", {3406}, {7}},
     {"\U00000d4e\U00000308\U0001f1e6", {3406, 127462}, {5, 9}},
     {"\U00000d4e\U00000600", {3406}, {5}},
     {"\U00000d4e\U00000308\U00000600", {3406, 1536}, {5, 7}},
     {"\U00000d4e\U00000a03", {3406}, {6}},
     {"\U00000d4e\U00000308\U00000a03", {3406}, {8}},
     {"\U00000d4e\U00001100", {3406}, {6}},
     {"\U00000d4e\U00000308\U00001100", {3406, 4352}, {5, 8}},
     {"\U00000d4e\U00001160", {3406}, {6}},
     {"\U00000d4e\U00000308\U00001160", {3406, 4448}, {5, 8}},
     {"\U00000d4e\U000011a8", {3406}, {6}},
     {"\U00000d4e\U00000308\U000011a8", {3406, 4520}, {5, 8}},
     {"\U00000d4e\U0000ac00", {3406}, {6}},
     {"\U00000d4e\U00000308\U0000ac00", {3406, 44032}, {5, 8}},
     {"\U00000d4e\U0000ac01", {3406}, {6}},
     {"\U00000d4e\U00000308\U0000ac01", {3406, 44033}, {5, 8}},
     {"\U00000d4e\U00000903", {3406}, {6}},
     {"\U00000d4e\U00000308\U00000903", {3406}, {8}},
     {"\U00000d4e\U00000904", {3406}, {6}},
     {"\U00000d4e\U00000308\U00000904", {3406, 2308}, {5, 8}},
     {"\U00000d4e\U00000d4e", {3406}, {6}},
     {"\U00000d4e\U00000308\U00000d4e", {3406, 3406}, {5, 8}},
     {"\U00000d4e\U00000915", {3406}, {6}},
     {"\U00000d4e\U00000308\U00000915", {3406, 2325}, {5, 8}},
     {"\U00000d4e\U0000231a", {3406}, {6}},
     {"\U00000d4e\U00000308\U0000231a", {3406, 8986}, {5, 8}},
     {"\U00000d4e\U00000300", {3406}, {5}},
     {"\U00000d4e\U00000308\U00000300", {3406}, {7}},
     {"\U00000d4e\U00000900", {3406}, {6}},
     {"\U00000d4e\U00000308\U00000900", {3406}, {8}},
     {"\U00000d4e\U0000094d", {3406}, {6}},
     {"\U00000d4e\U00000308\U0000094d", {3406}, {8}},
     {"\U00000d4e\U0000200d", {3406}, {6}},
     {"\U00000d4e\U00000308\U0000200d", {3406}, {8}},
     {"\U00000d4e\U00000378", {3406}, {5}},
     {"\U00000d4e\U00000308\U00000378", {3406, 888}, {5, 7}},
     {"\U00000915\U00000020", {2325, 32}, {3, 4}},
     {"\U00000915\U00000308\U00000020", {2325, 32}, {5, 6}},
     {"\U00000915\U0000000d", {2325, 13}, {3, 4}},
     {"\U00000915\U00000308\U0000000d", {2325, 13}, {5, 6}},
     {"\U00000915\U0000000a", {2325, 10}, {3, 4}},
     {"\U00000915\U00000308\U0000000a", {2325, 10}, {5, 6}},
     {"\U00000915\U00000001", {2325, 1}, {3, 4}},
     {"\U00000915\U00000308\U00000001", {2325, 1}, {5, 6}},
     {"\U00000915\U0000200c", {2325}, {6}},
     {"\U00000915\U00000308\U0000200c", {2325}, {8}},
     {"\U00000915\U0001f1e6", {2325, 127462}, {3, 7}},
     {"\U00000915\U00000308\U0001f1e6", {2325, 127462}, {5, 9}},
     {"\U00000915\U00000600", {2325, 1536}, {3, 5}},
     {"\U00000915\U00000308\U00000600", {2325, 1536}, {5, 7}},
     {"\U00000915\U00000a03", {2325}, {6}},
     {"\U00000915\U00000308\U00000a03", {2325}, {8}},
     {"\U00000915\U00001100", {2325, 4352}, {3, 6}},
     {"\U00000915\U00000308\U00001100", {2325, 4352}, {5, 8}},
     {"\U00000915\U00001160", {2325, 4448}, {3, 6}},
     {"\U00000915\U00000308\U00001160", {2325, 4448}, {5, 8}},
     {"\U00000915\U000011a8", {2325, 4520}, {3, 6}},
     {"\U00000915\U00000308\U000011a8", {2325, 4520}, {5, 8}},
     {"\U00000915\U0000ac00", {2325, 44032}, {3, 6}},
     {"\U00000915\U00000308\U0000ac00", {2325, 44032}, {5, 8}},
     {"\U00000915\U0000ac01", {2325, 44033}, {3, 6}},
     {"\U00000915\U00000308\U0000ac01", {2325, 44033}, {5, 8}},
     {"\U00000915\U00000903", {2325}, {6}},
     {"\U00000915\U00000308\U00000903", {2325}, {8}},
     {"\U00000915\U00000904", {2325, 2308}, {3, 6}},
     {"\U00000915\U00000308\U00000904", {2325, 2308}, {5, 8}},
     {"\U00000915\U00000d4e", {2325, 3406}, {3, 6}},
     {"\U00000915\U00000308\U00000d4e", {2325, 3406}, {5, 8}},
     {"\U00000915\U00000915", {2325, 2325}, {3, 6}},
     {"\U00000915\U00000308\U00000915", {2325, 2325}, {5, 8}},
     {"\U00000915\U0000231a", {2325, 8986}, {3, 6}},
     {"\U00000915\U00000308\U0000231a", {2325, 8986}, {5, 8}},
     {"\U00000915\U00000300", {2325}, {5}},
     {"\U00000915\U00000308\U00000300", {2325}, {7}},
     {"\U00000915\U00000900", {2325}, {6}},
     {"\U00000915\U00000308\U00000900", {2325}, {8}},
     {"\U00000915\U0000094d", {2325}, {6}},
     {"\U00000915\U00000308\U0000094d", {2325}, {8}},
     {"\U00000915\U0000200d", {2325}, {6}},
     {"\U00000915\U00000308\U0000200d", {2325}, {8}},
     {"\U00000915\U00000378", {2325, 888}, {3, 5}},
     {"\U00000915\U00000308\U00000378", {2325, 888}, {5, 7}},
     {"\U0000231a\U00000020", {8986, 32}, {3, 4}},
     {"\U0000231a\U00000308\U00000020", {8986, 32}, {5, 6}},
     {"\U0000231a\U0000000d", {8986, 13}, {3, 4}},
     {"\U0000231a\U00000308\U0000000d", {8986, 13}, {5, 6}},
     {"\U0000231a\U0000000a", {8986, 10}, {3, 4}},
     {"\U0000231a\U00000308\U0000000a", {8986, 10}, {5, 6}},
     {"\U0000231a\U00000001", {8986, 1}, {3, 4}},
     {"\U0000231a\U00000308\U00000001", {8986, 1}, {5, 6}},
     {"\U0000231a\U0000200c", {8986}, {6}},
     {"\U0000231a\U00000308\U0000200c", {8986}, {8}},
     {"\U0000231a\U0001f1e6", {8986, 127462}, {3, 7}},
     {"\U0000231a\U00000308\U0001f1e6", {8986, 127462}, {5, 9}},
     {"\U0000231a\U00000600", {8986, 1536}, {3, 5}},
     {"\U0000231a\U00000308\U00000600", {8986, 1536}, {5, 7}},
     {"\U0000231a\U00000a03", {8986}, {6}},
     {"\U0000231a\U00000308\U00000a03", {8986}, {8}},
     {"\U0000231a\U00001100", {8986, 4352}, {3, 6}},
     {"\U0000231a\U00000308\U00001100", {8986, 4352}, {5, 8}},
     {"\U0000231a\U00001160", {8986, 4448}, {3, 6}},
     {"\U0000231a\U00000308\U00001160", {8986, 4448}, {5, 8}},
     {"\U0000231a\U000011a8", {8986, 4520}, {3, 6}},
     {"\U0000231a\U00000308\U000011a8", {8986, 4520}, {5, 8}},
     {"\U0000231a\U0000ac00", {8986, 44032}, {3, 6}},
     {"\U0000231a\U00000308\U0000ac00", {8986, 44032}, {5, 8}},
     {"\U0000231a\U0000ac01", {8986, 44033}, {3, 6}},
     {"\U0000231a\U00000308\U0000ac01", {8986, 44033}, {5, 8}},
     {"\U0000231a\U00000903", {8986}, {6}},
     {"\U0000231a\U00000308\U00000903", {8986}, {8}},
     {"\U0000231a\U00000904", {8986, 2308}, {3, 6}},
     {"\U0000231a\U00000308\U00000904", {8986, 2308}, {5, 8}},
     {"\U0000231a\U00000d4e", {8986, 3406}, {3, 6}},
     {"\U0000231a\U00000308\U00000d4e", {8986, 3406}, {5, 8}},
     {"\U0000231a\U00000915", {8986, 2325}, {3, 6}},
     {"\U0000231a\U00000308\U00000915", {8986, 2325}, {5, 8}},
     {"\U0000231a\U0000231a", {8986, 8986}, {3, 6}},
     {"\U0000231a\U00000308\U0000231a", {8986, 8986}, {5, 8}},
     {"\U0000231a\U00000300", {8986}, {5}},
     {"\U0000231a\U00000308\U00000300", {8986}, {7}},
     {"\U0000231a\U00000900", {8986}, {6}},
     {"\U0000231a\U00000308\U00000900", {8986}, {8}},
     {"\U0000231a\U0000094d", {8986}, {6}},
     {"\U0000231a\U00000308\U0000094d", {8986}, {8}},
     {"\U0000231a\U0000200d", {8986}, {6}},
     {"\U0000231a\U00000308\U0000200d", {8986}, {8}},
     {"\U0000231a\U00000378", {8986, 888}, {3, 5}},
     {"\U0000231a\U00000308\U00000378", {8986, 888}, {5, 7}},
     {"\U00000300\U00000020", {768, 32}, {2, 3}},
     {"\U00000300\U00000308\U00000020", {768, 32}, {4, 5}},
     {"\U00000300\U0000000d", {768, 13}, {2, 3}},
     {"\U00000300\U00000308\U0000000d", {768, 13}, {4, 5}},
     {"\U00000300\U0000000a", {768, 10}, {2, 3}},
     {"\U00000300\U00000308\U0000000a", {768, 10}, {4, 5}},
     {"\U00000300\U00000001", {768, 1}, {2, 3}},
     {"\U00000300\U00000308\U00000001", {768, 1}, {4, 5}},
     {"\U00000300\U0000200c", {768}, {5}},
     {"\U00000300\U00000308\U0000200c", {768}, {7}},
     {"\U00000300\U0001f1e6", {768, 127462}, {2, 6}},
     {"\U00000300\U00000308\U0001f1e6", {768, 127462}, {4, 8}},
     {"\U00000300\U00000600", {768, 1536}, {2, 4}},
     {"\U00000300\U00000308\U00000600", {768, 1536}, {4, 6}},
     {"\U00000300\U00000a03", {768}, {5}},
     {"\U00000300\U00000308\U00000a03", {768}, {7}},
     {"\U00000300\U00001100", {768, 4352}, {2, 5}},
     {"\U00000300\U00000308\U00001100", {768, 4352}, {4, 7}},
     {"\U00000300\U00001160", {768, 4448}, {2, 5}},
     {"\U00000300\U00000308\U00001160", {768, 4448}, {4, 7}},
     {"\U00000300\U000011a8", {768, 4520}, {2, 5}},
     {"\U00000300\U00000308\U000011a8", {768, 4520}, {4, 7}},
     {"\U00000300\U0000ac00", {768, 44032}, {2, 5}},
     {"\U00000300\U00000308\U0000ac00", {768, 44032}, {4, 7}},
     {"\U00000300\U0000ac01", {768, 44033}, {2, 5}},
     {"\U00000300\U00000308\U0000ac01", {768, 44033}, {4, 7}},
     {"\U00000300\U00000903", {768}, {5}},
     {"\U00000300\U00000308\U00000903", {768}, {7}},
     {"\U00000300\U00000904", {768, 2308}, {2, 5}},
     {"\U00000300\U00000308\U00000904", {768, 2308}, {4, 7}},
     {"\U00000300\U00000d4e", {768, 3406}, {2, 5}},
     {"\U00000300\U00000308\U00000d4e", {768, 3406}, {4, 7}},
     {"\U00000300\U00000915", {768, 2325}, {2, 5}},
     {"\U00000300\U00000308\U00000915", {768, 2325}, {4, 7}},
     {"\U00000300\U0000231a", {768, 8986}, {2, 5}},
     {"\U00000300\U00000308\U0000231a", {768, 8986}, {4, 7}},
     {"\U00000300\U00000300", {768}, {4}},
     {"\U00000300\U00000308\U00000300", {768}, {6}},
     {"\U00000300\U00000900", {768}, {5}},
     {"\U00000300\U00000308\U00000900", {768}, {7}},
     {"\U00000300\U0000094d", {768}, {5}},
     {"\U00000300\U00000308\U0000094d", {768}, {7}},
     {"\U00000300\U0000200d", {768}, {5}},
     {"\U00000300\U00000308\U0000200d", {768}, {7}},
     {"\U00000300\U00000378", {768, 888}, {2, 4}},
     {"\U00000300\U00000308\U00000378", {768, 888}, {4, 6}},
     {"\U00000900\U00000020", {2304, 32}, {3, 4}},
     {"\U00000900\U00000308\U00000020", {2304, 32}, {5, 6}},
     {"\U00000900\U0000000d", {2304, 13}, {3, 4}},
     {"\U00000900\U00000308\U0000000d", {2304, 13}, {5, 6}},
     {"\U00000900\U0000000a", {2304, 10}, {3, 4}},
     {"\U00000900\U00000308\U0000000a", {2304, 10}, {5, 6}},
     {"\U00000900\U00000001", {2304, 1}, {3, 4}},
     {"\U00000900\U00000308\U00000001", {2304, 1}, {5, 6}},
     {"\U00000900\U0000200c", {2304}, {6}},
     {"\U00000900\U00000308\U0000200c", {2304}, {8}},
     {"\U00000900\U0001f1e6", {2304, 127462}, {3, 7}},
     {"\U00000900\U00000308\U0001f1e6", {2304, 127462}, {5, 9}},
     {"\U00000900\U00000600", {2304, 1536}, {3, 5}},
     {"\U00000900\U00000308\U00000600", {2304, 1536}, {5, 7}},
     {"\U00000900\U00000a03", {2304}, {6}},
     {"\U00000900\U00000308\U00000a03", {2304}, {8}},
     {"\U00000900\U00001100", {2304, 4352}, {3, 6}},
     {"\U00000900\U00000308\U00001100", {2304, 4352}, {5, 8}},
     {"\U00000900\U00001160", {2304, 4448}, {3, 6}},
     {"\U00000900\U00000308\U00001160", {2304, 4448}, {5, 8}},
     {"\U00000900\U000011a8", {2304, 4520}, {3, 6}},
     {"\U00000900\U00000308\U000011a8", {2304, 4520}, {5, 8}},
     {"\U00000900\U0000ac00", {2304, 44032}, {3, 6}},
     {"\U00000900\U00000308\U0000ac00", {2304, 44032}, {5, 8}},
     {"\U00000900\U0000ac01", {2304, 44033}, {3, 6}},
     {"\U00000900\U00000308\U0000ac01", {2304, 44033}, {5, 8}},
     {"\U00000900\U00000903", {2304}, {6}},
     {"\U00000900\U00000308\U00000903", {2304}, {8}},
     {"\U00000900\U00000904", {2304, 2308}, {3, 6}},
     {"\U00000900\U00000308\U00000904", {2304, 2308}, {5, 8}},
     {"\U00000900\U00000d4e", {2304, 3406}, {3, 6}},
     {"\U00000900\U00000308\U00000d4e", {2304, 3406}, {5, 8}},
     {"\U00000900\U00000915", {2304, 2325}, {3, 6}},
     {"\U00000900\U00000308\U00000915", {2304, 2325}, {5, 8}},
     {"\U00000900\U0000231a", {2304, 8986}, {3, 6}},
     {"\U00000900\U00000308\U0000231a", {2304, 8986}, {5, 8}},
     {"\U00000900\U00000300", {2304}, {5}},
     {"\U00000900\U00000308\U00000300", {2304}, {7}},
     {"\U00000900\U00000900", {2304}, {6}},
     {"\U00000900\U00000308\U00000900", {2304}, {8}},
     {"\U00000900\U0000094d", {2304}, {6}},
     {"\U00000900\U00000308\U0000094d", {2304}, {8}},
     {"\U00000900\U0000200d", {2304}, {6}},
     {"\U00000900\U00000308\U0000200d", {2304}, {8}},
     {"\U00000900\U00000378", {2304, 888}, {3, 5}},
     {"\U00000900\U00000308\U00000378", {2304, 888}, {5, 7}},
     {"\U0000094d\U00000020", {2381, 32}, {3, 4}},
     {"\U0000094d\U00000308\U00000020", {2381, 32}, {5, 6}},
     {"\U0000094d\U0000000d", {2381, 13}, {3, 4}},
     {"\U0000094d\U00000308\U0000000d", {2381, 13}, {5, 6}},
     {"\U0000094d\U0000000a", {2381, 10}, {3, 4}},
     {"\U0000094d\U00000308\U0000000a", {2381, 10}, {5, 6}},
     {"\U0000094d\U00000001", {2381, 1}, {3, 4}},
     {"\U0000094d\U00000308\U00000001", {2381, 1}, {5, 6}},
     {"\U0000094d\U0000200c", {2381}, {6}},
     {"\U0000094d\U00000308\U0000200c", {2381}, {8}},
     {"\U0000094d\U0001f1e6", {2381, 127462}, {3, 7}},
     {"\U0000094d\U00000308\U0001f1e6", {2381, 127462}, {5, 9}},
     {"\U0000094d\U00000600", {2381, 1536}, {3, 5}},
     {"\U0000094d\U00000308\U00000600", {2381, 1536}, {5, 7}},
     {"\U0000094d\U00000a03", {2381}, {6}},
     {"\U0000094d\U00000308\U00000a03", {2381}, {8}},
     {"\U0000094d\U00001100", {2381, 4352}, {3, 6}},
     {"\U0000094d\U00000308\U00001100", {2381, 4352}, {5, 8}},
     {"\U0000094d\U00001160", {2381, 4448}, {3, 6}},
     {"\U0000094d\U00000308\U00001160", {2381, 4448}, {5, 8}},
     {"\U0000094d\U000011a8", {2381, 4520}, {3, 6}},
     {"\U0000094d\U00000308\U000011a8", {2381, 4520}, {5, 8}},
     {"\U0000094d\U0000ac00", {2381, 44032}, {3, 6}},
     {"\U0000094d\U00000308\U0000ac00", {2381, 44032}, {5, 8}},
     {"\U0000094d\U0000ac01", {2381, 44033}, {3, 6}},
     {"\U0000094d\U00000308\U0000ac01", {2381, 44033}, {5, 8}},
     {"\U0000094d\U00000903", {2381}, {6}},
     {"\U0000094d\U00000308\U00000903", {2381}, {8}},
     {"\U0000094d\U00000904", {2381, 2308}, {3, 6}},
     {"\U0000094d\U00000308\U00000904", {2381, 2308}, {5, 8}},
     {"\U0000094d\U00000d4e", {2381, 3406}, {3, 6}},
     {"\U0000094d\U00000308\U00000d4e", {2381, 3406}, {5, 8}},
     {"\U0000094d\U00000915", {2381, 2325}, {3, 6}},
     {"\U0000094d\U00000308\U00000915", {2381, 2325}, {5, 8}},
     {"\U0000094d\U0000231a", {2381, 8986}, {3, 6}},
     {"\U0000094d\U00000308\U0000231a", {2381, 8986}, {5, 8}},
     {"\U0000094d\U00000300", {2381}, {5}},
     {"\U0000094d\U00000308\U00000300", {2381}, {7}},
     {"\U0000094d\U00000900", {2381}, {6}},
     {"\U0000094d\U00000308\U00000900", {2381}, {8}},
     {"\U0000094d\U0000094d", {2381}, {6}},
     {"\U0000094d\U00000308\U0000094d", {2381}, {8}},
     {"\U0000094d\U0000200d", {2381}, {6}},
     {"\U0000094d\U00000308\U0000200d", {2381}, {8}},
     {"\U0000094d\U00000378", {2381, 888}, {3, 5}},
     {"\U0000094d\U00000308\U00000378", {2381, 888}, {5, 7}},
     {"\U0000200d\U00000020", {8205, 32}, {3, 4}},
     {"\U0000200d\U00000308\U00000020", {8205, 32}, {5, 6}},
     {"\U0000200d\U0000000d", {8205, 13}, {3, 4}},
     {"\U0000200d\U00000308\U0000000d", {8205, 13}, {5, 6}},
     {"\U0000200d\U0000000a", {8205, 10}, {3, 4}},
     {"\U0000200d\U00000308\U0000000a", {8205, 10}, {5, 6}},
     {"\U0000200d\U00000001", {8205, 1}, {3, 4}},
     {"\U0000200d\U00000308\U00000001", {8205, 1}, {5, 6}},
     {"\U0000200d\U0000200c", {8205}, {6}},
     {"\U0000200d\U00000308\U0000200c", {8205}, {8}},
     {"\U0000200d\U0001f1e6", {8205, 127462}, {3, 7}},
     {"\U0000200d\U00000308\U0001f1e6", {8205, 127462}, {5, 9}},
     {"\U0000200d\U00000600", {8205, 1536}, {3, 5}},
     {"\U0000200d\U00000308\U00000600", {8205, 1536}, {5, 7}},
     {"\U0000200d\U00000a03", {8205}, {6}},
     {"\U0000200d\U00000308\U00000a03", {8205}, {8}},
     {"\U0000200d\U00001100", {8205, 4352}, {3, 6}},
     {"\U0000200d\U00000308\U00001100", {8205, 4352}, {5, 8}},
     {"\U0000200d\U00001160", {8205, 4448}, {3, 6}},
     {"\U0000200d\U00000308\U00001160", {8205, 4448}, {5, 8}},
     {"\U0000200d\U000011a8", {8205, 4520}, {3, 6}},
     {"\U0000200d\U00000308\U000011a8", {8205, 4520}, {5, 8}},
     {"\U0000200d\U0000ac00", {8205, 44032}, {3, 6}},
     {"\U0000200d\U00000308\U0000ac00", {8205, 44032}, {5, 8}},
     {"\U0000200d\U0000ac01", {8205, 44033}, {3, 6}},
     {"\U0000200d\U00000308\U0000ac01", {8205, 44033}, {5, 8}},
     {"\U0000200d\U00000903", {8205}, {6}},
     {"\U0000200d\U00000308\U00000903", {8205}, {8}},
     {"\U0000200d\U00000904", {8205, 2308}, {3, 6}},
     {"\U0000200d\U00000308\U00000904", {8205, 2308}, {5, 8}},
     {"\U0000200d\U00000d4e", {8205, 3406}, {3, 6}},
     {"\U0000200d\U00000308\U00000d4e", {8205, 3406}, {5, 8}},
     {"\U0000200d\U00000915", {8205, 2325}, {3, 6}},
     {"\U0000200d\U00000308\U00000915", {8205, 2325}, {5, 8}},
     {"\U0000200d\U0000231a", {8205, 8986}, {3, 6}},
     {"\U0000200d\U00000308\U0000231a", {8205, 8986}, {5, 8}},
     {"\U0000200d\U00000300", {8205}, {5}},
     {"\U0000200d\U00000308\U00000300", {8205}, {7}},
     {"\U0000200d\U00000900", {8205}, {6}},
     {"\U0000200d\U00000308\U00000900", {8205}, {8}},
     {"\U0000200d\U0000094d", {8205}, {6}},
     {"\U0000200d\U00000308\U0000094d", {8205}, {8}},
     {"\U0000200d\U0000200d", {8205}, {6}},
     {"\U0000200d\U00000308\U0000200d", {8205}, {8}},
     {"\U0000200d\U00000378", {8205, 888}, {3, 5}},
     {"\U0000200d\U00000308\U00000378", {8205, 888}, {5, 7}},
     {"\U00000378\U00000020", {888, 32}, {2, 3}},
     {"\U00000378\U00000308\U00000020", {888, 32}, {4, 5}},
     {"\U00000378\U0000000d", {888, 13}, {2, 3}},
     {"\U00000378\U00000308\U0000000d", {888, 13}, {4, 5}},
     {"\U00000378\U0000000a", {888, 10}, {2, 3}},
     {"\U00000378\U00000308\U0000000a", {888, 10}, {4, 5}},
     {"\U00000378\U00000001", {888, 1}, {2, 3}},
     {"\U00000378\U00000308\U00000001", {888, 1}, {4, 5}},
     {"\U00000378\U0000200c", {888}, {5}},
     {"\U00000378\U00000308\U0000200c", {888}, {7}},
     {"\U00000378\U0001f1e6", {888, 127462}, {2, 6}},
     {"\U00000378\U00000308\U0001f1e6", {888, 127462}, {4, 8}},
     {"\U00000378\U00000600", {888, 1536}, {2, 4}},
     {"\U00000378\U00000308\U00000600", {888, 1536}, {4, 6}},
     {"\U00000378\U00000a03", {888}, {5}},
     {"\U00000378\U00000308\U00000a03", {888}, {7}},
     {"\U00000378\U00001100", {888, 4352}, {2, 5}},
     {"\U00000378\U00000308\U00001100", {888, 4352}, {4, 7}},
     {"\U00000378\U00001160", {888, 4448}, {2, 5}},
     {"\U00000378\U00000308\U00001160", {888, 4448}, {4, 7}},
     {"\U00000378\U000011a8", {888, 4520}, {2, 5}},
     {"\U00000378\U00000308\U000011a8", {888, 4520}, {4, 7}},
     {"\U00000378\U0000ac00", {888, 44032}, {2, 5}},
     {"\U00000378\U00000308\U0000ac00", {888, 44032}, {4, 7}},
     {"\U00000378\U0000ac01", {888, 44033}, {2, 5}},
     {"\U00000378\U00000308\U0000ac01", {888, 44033}, {4, 7}},
     {"\U00000378\U00000903", {888}, {5}},
     {"\U00000378\U00000308\U00000903", {888}, {7}},
     {"\U00000378\U00000904", {888, 2308}, {2, 5}},
     {"\U00000378\U00000308\U00000904", {888, 2308}, {4, 7}},
     {"\U00000378\U00000d4e", {888, 3406}, {2, 5}},
     {"\U00000378\U00000308\U00000d4e", {888, 3406}, {4, 7}},
     {"\U00000378\U00000915", {888, 2325}, {2, 5}},
     {"\U00000378\U00000308\U00000915", {888, 2325}, {4, 7}},
     {"\U00000378\U0000231a", {888, 8986}, {2, 5}},
     {"\U00000378\U00000308\U0000231a", {888, 8986}, {4, 7}},
     {"\U00000378\U00000300", {888}, {4}},
     {"\U00000378\U00000308\U00000300", {888}, {6}},
     {"\U00000378\U00000900", {888}, {5}},
     {"\U00000378\U00000308\U00000900", {888}, {7}},
     {"\U00000378\U0000094d", {888}, {5}},
     {"\U00000378\U00000308\U0000094d", {888}, {7}},
     {"\U00000378\U0000200d", {888}, {5}},
     {"\U00000378\U00000308\U0000200d", {888}, {7}},
     {"\U00000378\U00000378", {888, 888}, {2, 4}},
     {"\U00000378\U00000308\U00000378", {888, 888}, {4, 6}},
     {"\U0000000d\U0000000a\U00000061\U0000000a\U00000308", {13, 97, 10, 776}, {2, 3, 4, 6}},
     {"\U00000061\U00000308", {97}, {3}},
     {"\U00000020\U0000200d\U00000646", {32, 1606}, {4, 6}},
     {"\U00000646\U0000200d\U00000020", {1606, 32}, {5, 6}},
     {"\U00001100\U00001100", {4352}, {6}},
     {"\U0000ac00\U000011a8\U00001100", {44032, 4352}, {6, 9}},
     {"\U0000ac01\U000011a8\U00001100", {44033, 4352}, {6, 9}},
     {"\U0001f1e6\U0001f1e7\U0001f1e8\U00000062", {127462, 127464, 98}, {8, 12, 13}},
     {"\U00000061\U0001f1e6\U0001f1e7\U0001f1e8\U00000062", {97, 127462, 127464, 98}, {1, 9, 13, 14}},
     {"\U00000061\U0001f1e6\U0001f1e7\U0000200d\U0001f1e8\U00000062", {97, 127462, 127464, 98}, {1, 12, 16, 17}},
     {"\U00000061\U0001f1e6\U0000200d\U0001f1e7\U0001f1e8\U00000062", {97, 127462, 127463, 98}, {1, 8, 16, 17}},
     {"\U00000061\U0001f1e6\U0001f1e7\U0001f1e8\U0001f1e9\U00000062", {97, 127462, 127464, 98}, {1, 9, 17, 18}},
     {"\U00000061\U0000200d", {97}, {4}},
     {"\U00000061\U00000308\U00000062", {97, 98}, {3, 4}},
     {"\U00000061\U00000903\U00000062", {97, 98}, {4, 5}},
     {"\U00000061\U00000600\U00000062", {97, 1536}, {1, 4}},
     {"\U0001f476\U0001f3ff\U0001f476", {128118, 128118}, {8, 12}},
     {"\U00000061\U0001f3ff\U0001f476", {97, 128118}, {5, 9}},
     {"\U00000061\U0001f3ff\U0001f476\U0000200d\U0001f6d1", {97, 128118}, {5, 16}},
     {"\U0001f476\U0001f3ff\U00000308\U0000200d\U0001f476\U0001f3ff", {128118}, {21}},
     {"\U0001f6d1\U0000200d\U0001f6d1", {128721}, {11}},
     {"\U00000061\U0000200d\U0001f6d1", {97, 128721}, {4, 8}},
     {"\U00002701\U0000200d\U00002701", {9985}, {9}},
     {"\U00000061\U0000200d\U00002701", {97, 9985}, {4, 7}},
     {"\U00000915\U00000924", {2325, 2340}, {3, 6}},
     {"\U00000915\U0000094d\U00000924", {2325}, {9}},
     {"\U00000915\U0000094d\U0000094d\U00000924", {2325}, {12}},
     {"\U00000915\U0000094d\U0000200d\U00000924", {2325}, {12}},
     {"\U00000915\U0000093c\U0000200d\U0000094d\U00000924", {2325}, {15}},
     {"\U00000915\U0000093c\U0000094d\U0000200d\U00000924", {2325}, {15}},
     {"\U00000915\U0000094d\U00000924\U0000094d\U0000092f", {2325}, {15}},
     {"\U00000915\U0000094d\U00000061", {2325, 97}, {6, 7}},
     {"\U00000061\U0000094d\U00000924", {97, 2340}, {4, 7}},
     {"\U0000003f\U0000094d\U00000924", {63, 2340}, {4, 7}},
     {"\U00000915\U0000094d\U0000094d\U00000924", {2325}, {12}}}};

/// The data for UTF-16.
///
/// Note that most of the data for the UTF-16 and UTF-32 are identical. However
/// since the size of the code units differ the breaks can contain different
/// values.
#ifndef TEST_HAS_NO_WIDE_CHARACTERS
std::array<data<wchar_t>, 1093> data_utf16 = {{
     {L"\U00000020\U00000020", {32, 32}, {1, 2}},
     {L"\U00000020\U00000308\U00000020", {32, 32}, {2, 3}},
     {L"\U00000020\U0000000d", {32, 13}, {1, 2}},
     {L"\U00000020\U00000308\U0000000d", {32, 13}, {2, 3}},
     {L"\U00000020\U0000000a", {32, 10}, {1, 2}},
     {L"\U00000020\U00000308\U0000000a", {32, 10}, {2, 3}},
     {L"\U00000020\U00000001", {32, 1}, {1, 2}},
     {L"\U00000020\U00000308\U00000001", {32, 1}, {2, 3}},
     {L"\U00000020\U0000200c", {32}, {2}},
     {L"\U00000020\U00000308\U0000200c", {32}, {3}},
     {L"\U00000020\U0001f1e6", {32, 127462}, {1, 3}},
     {L"\U00000020\U00000308\U0001f1e6", {32, 127462}, {2, 4}},
     {L"\U00000020\U00000600", {32, 1536}, {1, 2}},
     {L"\U00000020\U00000308\U00000600", {32, 1536}, {2, 3}},
     {L"\U00000020\U00000a03", {32}, {2}},
     {L"\U00000020\U00000308\U00000a03", {32}, {3}},
     {L"\U00000020\U00001100", {32, 4352}, {1, 2}},
     {L"\U00000020\U00000308\U00001100", {32, 4352}, {2, 3}},
     {L"\U00000020\U00001160", {32, 4448}, {1, 2}},
     {L"\U00000020\U00000308\U00001160", {32, 4448}, {2, 3}},
     {L"\U00000020\U000011a8", {32, 4520}, {1, 2}},
     {L"\U00000020\U00000308\U000011a8", {32, 4520}, {2, 3}},
     {L"\U00000020\U0000ac00", {32, 44032}, {1, 2}},
     {L"\U00000020\U00000308\U0000ac00", {32, 44032}, {2, 3}},
     {L"\U00000020\U0000ac01", {32, 44033}, {1, 2}},
     {L"\U00000020\U00000308\U0000ac01", {32, 44033}, {2, 3}},
     {L"\U00000020\U00000903", {32}, {2}},
     {L"\U00000020\U00000308\U00000903", {32}, {3}},
     {L"\U00000020\U00000904", {32, 2308}, {1, 2}},
     {L"\U00000020\U00000308\U00000904", {32, 2308}, {2, 3}},
     {L"\U00000020\U00000d4e", {32, 3406}, {1, 2}},
     {L"\U00000020\U00000308\U00000d4e", {32, 3406}, {2, 3}},
     {L"\U00000020\U00000915", {32, 2325}, {1, 2}},
     {L"\U00000020\U00000308\U00000915", {32, 2325}, {2, 3}},
     {L"\U00000020\U0000231a", {32, 8986}, {1, 2}},
     {L"\U00000020\U00000308\U0000231a", {32, 8986}, {2, 3}},
     {L"\U00000020\U00000300", {32}, {2}},
     {L"\U00000020\U00000308\U00000300", {32}, {3}},
     {L"\U00000020\U00000900", {32}, {2}},
     {L"\U00000020\U00000308\U00000900", {32}, {3}},
     {L"\U00000020\U0000094d", {32}, {2}},
     {L"\U00000020\U00000308\U0000094d", {32}, {3}},
     {L"\U00000020\U0000200d", {32}, {2}},
     {L"\U00000020\U00000308\U0000200d", {32}, {3}},
     {L"\U00000020\U00000378", {32, 888}, {1, 2}},
     {L"\U00000020\U00000308\U00000378", {32, 888}, {2, 3}},
     {L"\U0000000d\U00000020", {13, 32}, {1, 2}},
     {L"\U0000000d\U00000308\U00000020", {13, 776, 32}, {1, 2, 3}},
     {L"\U0000000d\U0000000d", {13, 13}, {1, 2}},
     {L"\U0000000d\U00000308\U0000000d", {13, 776, 13}, {1, 2, 3}},
     {L"\U0000000d\U0000000a", {13}, {2}},
     {L"\U0000000d\U00000308\U0000000a", {13, 776, 10}, {1, 2, 3}},
     {L"\U0000000d\U00000001", {13, 1}, {1, 2}},
     {L"\U0000000d\U00000308\U00000001", {13, 776, 1}, {1, 2, 3}},
     {L"\U0000000d\U0000200c", {13, 8204}, {1, 2}},
     {L"\U0000000d\U00000308\U0000200c", {13, 776}, {1, 3}},
     {L"\U0000000d\U0001f1e6", {13, 127462}, {1, 3}},
     {L"\U0000000d\U00000308\U0001f1e6", {13, 776, 127462}, {1, 2, 4}},
     {L"\U0000000d\U00000600", {13, 1536}, {1, 2}},
     {L"\U0000000d\U00000308\U00000600", {13, 776, 1536}, {1, 2, 3}},
     {L"\U0000000d\U00000a03", {13, 2563}, {1, 2}},
     {L"\U0000000d\U00000308\U00000a03", {13, 776}, {1, 3}},
     {L"\U0000000d\U00001100", {13, 4352}, {1, 2}},
     {L"\U0000000d\U00000308\U00001100", {13, 776, 4352}, {1, 2, 3}},
     {L"\U0000000d\U00001160", {13, 4448}, {1, 2}},
     {L"\U0000000d\U00000308\U00001160", {13, 776, 4448}, {1, 2, 3}},
     {L"\U0000000d\U000011a8", {13, 4520}, {1, 2}},
     {L"\U0000000d\U00000308\U000011a8", {13, 776, 4520}, {1, 2, 3}},
     {L"\U0000000d\U0000ac00", {13, 44032}, {1, 2}},
     {L"\U0000000d\U00000308\U0000ac00", {13, 776, 44032}, {1, 2, 3}},
     {L"\U0000000d\U0000ac01", {13, 44033}, {1, 2}},
     {L"\U0000000d\U00000308\U0000ac01", {13, 776, 44033}, {1, 2, 3}},
     {L"\U0000000d\U00000903", {13, 2307}, {1, 2}},
     {L"\U0000000d\U00000308\U00000903", {13, 776}, {1, 3}},
     {L"\U0000000d\U00000904", {13, 2308}, {1, 2}},
     {L"\U0000000d\U00000308\U00000904", {13, 776, 2308}, {1, 2, 3}},
     {L"\U0000000d\U00000d4e", {13, 3406}, {1, 2}},
     {L"\U0000000d\U00000308\U00000d4e", {13, 776, 3406}, {1, 2, 3}},
     {L"\U0000000d\U00000915", {13, 2325}, {1, 2}},
     {L"\U0000000d\U00000308\U00000915", {13, 776, 2325}, {1, 2, 3}},
     {L"\U0000000d\U0000231a", {13, 8986}, {1, 2}},
     {L"\U0000000d\U00000308\U0000231a", {13, 776, 8986}, {1, 2, 3}},
     {L"\U0000000d\U00000300", {13, 768}, {1, 2}},
     {L"\U0000000d\U00000308\U00000300", {13, 776}, {1, 3}},
     {L"\U0000000d\U00000900", {13, 2304}, {1, 2}},
     {L"\U0000000d\U00000308\U00000900", {13, 776}, {1, 3}},
     {L"\U0000000d\U0000094d", {13, 2381}, {1, 2}},
     {L"\U0000000d\U00000308\U0000094d", {13, 776}, {1, 3}},
     {L"\U0000000d\U0000200d", {13, 8205}, {1, 2}},
     {L"\U0000000d\U00000308\U0000200d", {13, 776}, {1, 3}},
     {L"\U0000000d\U00000378", {13, 888}, {1, 2}},
     {L"\U0000000d\U00000308\U00000378", {13, 776, 888}, {1, 2, 3}},
     {L"\U0000000a\U00000020", {10, 32}, {1, 2}},
     {L"\U0000000a\U00000308\U00000020", {10, 776, 32}, {1, 2, 3}},
     {L"\U0000000a\U0000000d", {10, 13}, {1, 2}},
     {L"\U0000000a\U00000308\U0000000d", {10, 776, 13}, {1, 2, 3}},
     {L"\U0000000a\U0000000a", {10, 10}, {1, 2}},
     {L"\U0000000a\U00000308\U0000000a", {10, 776, 10}, {1, 2, 3}},
     {L"\U0000000a\U00000001", {10, 1}, {1, 2}},
     {L"\U0000000a\U00000308\U00000001", {10, 776, 1}, {1, 2, 3}},
     {L"\U0000000a\U0000200c", {10, 8204}, {1, 2}},
     {L"\U0000000a\U00000308\U0000200c", {10, 776}, {1, 3}},
     {L"\U0000000a\U0001f1e6", {10, 127462}, {1, 3}},
     {L"\U0000000a\U00000308\U0001f1e6", {10, 776, 127462}, {1, 2, 4}},
     {L"\U0000000a\U00000600", {10, 1536}, {1, 2}},
     {L"\U0000000a\U00000308\U00000600", {10, 776, 1536}, {1, 2, 3}},
     {L"\U0000000a\U00000a03", {10, 2563}, {1, 2}},
     {L"\U0000000a\U00000308\U00000a03", {10, 776}, {1, 3}},
     {L"\U0000000a\U00001100", {10, 4352}, {1, 2}},
     {L"\U0000000a\U00000308\U00001100", {10, 776, 4352}, {1, 2, 3}},
     {L"\U0000000a\U00001160", {10, 4448}, {1, 2}},
     {L"\U0000000a\U00000308\U00001160", {10, 776, 4448}, {1, 2, 3}},
     {L"\U0000000a\U000011a8", {10, 4520}, {1, 2}},
     {L"\U0000000a\U00000308\U000011a8", {10, 776, 4520}, {1, 2, 3}},
     {L"\U0000000a\U0000ac00", {10, 44032}, {1, 2}},
     {L"\U0000000a\U00000308\U0000ac00", {10, 776, 44032}, {1, 2, 3}},
     {L"\U0000000a\U0000ac01", {10, 44033}, {1, 2}},
     {L"\U0000000a\U00000308\U0000ac01", {10, 776, 44033}, {1, 2, 3}},
     {L"\U0000000a\U00000903", {10, 2307}, {1, 2}},
     {L"\U0000000a\U00000308\U00000903", {10, 776}, {1, 3}},
     {L"\U0000000a\U00000904", {10, 2308}, {1, 2}},
     {L"\U0000000a\U00000308\U00000904", {10, 776, 2308}, {1, 2, 3}},
     {L"\U0000000a\U00000d4e", {10, 3406}, {1, 2}},
     {L"\U0000000a\U00000308\U00000d4e", {10, 776, 3406}, {1, 2, 3}},
     {L"\U0000000a\U00000915", {10, 2325}, {1, 2}},
     {L"\U0000000a\U00000308\U00000915", {10, 776, 2325}, {1, 2, 3}},
     {L"\U0000000a\U0000231a", {10, 8986}, {1, 2}},
     {L"\U0000000a\U00000308\U0000231a", {10, 776, 8986}, {1, 2, 3}},
     {L"\U0000000a\U00000300", {10, 768}, {1, 2}},
     {L"\U0000000a\U00000308\U00000300", {10, 776}, {1, 3}},
     {L"\U0000000a\U00000900", {10, 2304}, {1, 2}},
     {L"\U0000000a\U00000308\U00000900", {10, 776}, {1, 3}},
     {L"\U0000000a\U0000094d", {10, 2381}, {1, 2}},
     {L"\U0000000a\U00000308\U0000094d", {10, 776}, {1, 3}},
     {L"\U0000000a\U0000200d", {10, 8205}, {1, 2}},
     {L"\U0000000a\U00000308\U0000200d", {10, 776}, {1, 3}},
     {L"\U0000000a\U00000378", {10, 888}, {1, 2}},
     {L"\U0000000a\U00000308\U00000378", {10, 776, 888}, {1, 2, 3}},
     {L"\U00000001\U00000020", {1, 32}, {1, 2}},
     {L"\U00000001\U00000308\U00000020", {1, 776, 32}, {1, 2, 3}},
     {L"\U00000001\U0000000d", {1, 13}, {1, 2}},
     {L"\U00000001\U00000308\U0000000d", {1, 776, 13}, {1, 2, 3}},
     {L"\U00000001\U0000000a", {1, 10}, {1, 2}},
     {L"\U00000001\U00000308\U0000000a", {1, 776, 10}, {1, 2, 3}},
     {L"\U00000001\U00000001", {1, 1}, {1, 2}},
     {L"\U00000001\U00000308\U00000001", {1, 776, 1}, {1, 2, 3}},
     {L"\U00000001\U0000200c", {1, 8204}, {1, 2}},
     {L"\U00000001\U00000308\U0000200c", {1, 776}, {1, 3}},
     {L"\U00000001\U0001f1e6", {1, 127462}, {1, 3}},
     {L"\U00000001\U00000308\U0001f1e6", {1, 776, 127462}, {1, 2, 4}},
     {L"\U00000001\U00000600", {1, 1536}, {1, 2}},
     {L"\U00000001\U00000308\U00000600", {1, 776, 1536}, {1, 2, 3}},
     {L"\U00000001\U00000a03", {1, 2563}, {1, 2}},
     {L"\U00000001\U00000308\U00000a03", {1, 776}, {1, 3}},
     {L"\U00000001\U00001100", {1, 4352}, {1, 2}},
     {L"\U00000001\U00000308\U00001100", {1, 776, 4352}, {1, 2, 3}},
     {L"\U00000001\U00001160", {1, 4448}, {1, 2}},
     {L"\U00000001\U00000308\U00001160", {1, 776, 4448}, {1, 2, 3}},
     {L"\U00000001\U000011a8", {1, 4520}, {1, 2}},
     {L"\U00000001\U00000308\U000011a8", {1, 776, 4520}, {1, 2, 3}},
     {L"\U00000001\U0000ac00", {1, 44032}, {1, 2}},
     {L"\U00000001\U00000308\U0000ac00", {1, 776, 44032}, {1, 2, 3}},
     {L"\U00000001\U0000ac01", {1, 44033}, {1, 2}},
     {L"\U00000001\U00000308\U0000ac01", {1, 776, 44033}, {1, 2, 3}},
     {L"\U00000001\U00000903", {1, 2307}, {1, 2}},
     {L"\U00000001\U00000308\U00000903", {1, 776}, {1, 3}},
     {L"\U00000001\U00000904", {1, 2308}, {1, 2}},
     {L"\U00000001\U00000308\U00000904", {1, 776, 2308}, {1, 2, 3}},
     {L"\U00000001\U00000d4e", {1, 3406}, {1, 2}},
     {L"\U00000001\U00000308\U00000d4e", {1, 776, 3406}, {1, 2, 3}},
     {L"\U00000001\U00000915", {1, 2325}, {1, 2}},
     {L"\U00000001\U00000308\U00000915", {1, 776, 2325}, {1, 2, 3}},
     {L"\U00000001\U0000231a", {1, 8986}, {1, 2}},
     {L"\U00000001\U00000308\U0000231a", {1, 776, 8986}, {1, 2, 3}},
     {L"\U00000001\U00000300", {1, 768}, {1, 2}},
     {L"\U00000001\U00000308\U00000300", {1, 776}, {1, 3}},
     {L"\U00000001\U00000900", {1, 2304}, {1, 2}},
     {L"\U00000001\U00000308\U00000900", {1, 776}, {1, 3}},
     {L"\U00000001\U0000094d", {1, 2381}, {1, 2}},
     {L"\U00000001\U00000308\U0000094d", {1, 776}, {1, 3}},
     {L"\U00000001\U0000200d", {1, 8205}, {1, 2}},
     {L"\U00000001\U00000308\U0000200d", {1, 776}, {1, 3}},
     {L"\U00000001\U00000378", {1, 888}, {1, 2}},
     {L"\U00000001\U00000308\U00000378", {1, 776, 888}, {1, 2, 3}},
     {L"\U0000200c\U00000020", {8204, 32}, {1, 2}},
     {L"\U0000200c\U00000308\U00000020", {8204, 32}, {2, 3}},
     {L"\U0000200c\U0000000d", {8204, 13}, {1, 2}},
     {L"\U0000200c\U00000308\U0000000d", {8204, 13}, {2, 3}},
     {L"\U0000200c\U0000000a", {8204, 10}, {1, 2}},
     {L"\U0000200c\U00000308\U0000000a", {8204, 10}, {2, 3}},
     {L"\U0000200c\U00000001", {8204, 1}, {1, 2}},
     {L"\U0000200c\U00000308\U00000001", {8204, 1}, {2, 3}},
     {L"\U0000200c\U0000200c", {8204}, {2}},
     {L"\U0000200c\U00000308\U0000200c", {8204}, {3}},
     {L"\U0000200c\U0001f1e6", {8204, 127462}, {1, 3}},
     {L"\U0000200c\U00000308\U0001f1e6", {8204, 127462}, {2, 4}},
     {L"\U0000200c\U00000600", {8204, 1536}, {1, 2}},
     {L"\U0000200c\U00000308\U00000600", {8204, 1536}, {2, 3}},
     {L"\U0000200c\U00000a03", {8204}, {2}},
     {L"\U0000200c\U00000308\U00000a03", {8204}, {3}},
     {L"\U0000200c\U00001100", {8204, 4352}, {1, 2}},
     {L"\U0000200c\U00000308\U00001100", {8204, 4352}, {2, 3}},
     {L"\U0000200c\U00001160", {8204, 4448}, {1, 2}},
     {L"\U0000200c\U00000308\U00001160", {8204, 4448}, {2, 3}},
     {L"\U0000200c\U000011a8", {8204, 4520}, {1, 2}},
     {L"\U0000200c\U00000308\U000011a8", {8204, 4520}, {2, 3}},
     {L"\U0000200c\U0000ac00", {8204, 44032}, {1, 2}},
     {L"\U0000200c\U00000308\U0000ac00", {8204, 44032}, {2, 3}},
     {L"\U0000200c\U0000ac01", {8204, 44033}, {1, 2}},
     {L"\U0000200c\U00000308\U0000ac01", {8204, 44033}, {2, 3}},
     {L"\U0000200c\U00000903", {8204}, {2}},
     {L"\U0000200c\U00000308\U00000903", {8204}, {3}},
     {L"\U0000200c\U00000904", {8204, 2308}, {1, 2}},
     {L"\U0000200c\U00000308\U00000904", {8204, 2308}, {2, 3}},
     {L"\U0000200c\U00000d4e", {8204, 3406}, {1, 2}},
     {L"\U0000200c\U00000308\U00000d4e", {8204, 3406}, {2, 3}},
     {L"\U0000200c\U00000915", {8204, 2325}, {1, 2}},
     {L"\U0000200c\U00000308\U00000915", {8204, 2325}, {2, 3}},
     {L"\U0000200c\U0000231a", {8204, 8986}, {1, 2}},
     {L"\U0000200c\U00000308\U0000231a", {8204, 8986}, {2, 3}},
     {L"\U0000200c\U00000300", {8204}, {2}},
     {L"\U0000200c\U00000308\U00000300", {8204}, {3}},
     {L"\U0000200c\U00000900", {8204}, {2}},
     {L"\U0000200c\U00000308\U00000900", {8204}, {3}},
     {L"\U0000200c\U0000094d", {8204}, {2}},
     {L"\U0000200c\U00000308\U0000094d", {8204}, {3}},
     {L"\U0000200c\U0000200d", {8204}, {2}},
     {L"\U0000200c\U00000308\U0000200d", {8204}, {3}},
     {L"\U0000200c\U00000378", {8204, 888}, {1, 2}},
     {L"\U0000200c\U00000308\U00000378", {8204, 888}, {2, 3}},
     {L"\U0001f1e6\U00000020", {127462, 32}, {2, 3}},
     {L"\U0001f1e6\U00000308\U00000020", {127462, 32}, {3, 4}},
     {L"\U0001f1e6\U0000000d", {127462, 13}, {2, 3}},
     {L"\U0001f1e6\U00000308\U0000000d", {127462, 13}, {3, 4}},
     {L"\U0001f1e6\U0000000a", {127462, 10}, {2, 3}},
     {L"\U0001f1e6\U00000308\U0000000a", {127462, 10}, {3, 4}},
     {L"\U0001f1e6\U00000001", {127462, 1}, {2, 3}},
     {L"\U0001f1e6\U00000308\U00000001", {127462, 1}, {3, 4}},
     {L"\U0001f1e6\U0000200c", {127462}, {3}},
     {L"\U0001f1e6\U00000308\U0000200c", {127462}, {4}},
     {L"\U0001f1e6\U0001f1e6", {127462}, {4}},
     {L"\U0001f1e6\U00000308\U0001f1e6", {127462, 127462}, {3, 5}},
     {L"\U0001f1e6\U00000600", {127462, 1536}, {2, 3}},
     {L"\U0001f1e6\U00000308\U00000600", {127462, 1536}, {3, 4}},
     {L"\U0001f1e6\U00000a03", {127462}, {3}},
     {L"\U0001f1e6\U00000308\U00000a03", {127462}, {4}},
     {L"\U0001f1e6\U00001100", {127462, 4352}, {2, 3}},
     {L"\U0001f1e6\U00000308\U00001100", {127462, 4352}, {3, 4}},
     {L"\U0001f1e6\U00001160", {127462, 4448}, {2, 3}},
     {L"\U0001f1e6\U00000308\U00001160", {127462, 4448}, {3, 4}},
     {L"\U0001f1e6\U000011a8", {127462, 4520}, {2, 3}},
     {L"\U0001f1e6\U00000308\U000011a8", {127462, 4520}, {3, 4}},
     {L"\U0001f1e6\U0000ac00", {127462, 44032}, {2, 3}},
     {L"\U0001f1e6\U00000308\U0000ac00", {127462, 44032}, {3, 4}},
     {L"\U0001f1e6\U0000ac01", {127462, 44033}, {2, 3}},
     {L"\U0001f1e6\U00000308\U0000ac01", {127462, 44033}, {3, 4}},
     {L"\U0001f1e6\U00000903", {127462}, {3}},
     {L"\U0001f1e6\U00000308\U00000903", {127462}, {4}},
     {L"\U0001f1e6\U00000904", {127462, 2308}, {2, 3}},
     {L"\U0001f1e6\U00000308\U00000904", {127462, 2308}, {3, 4}},
     {L"\U0001f1e6\U00000d4e", {127462, 3406}, {2, 3}},
     {L"\U0001f1e6\U00000308\U00000d4e", {127462, 3406}, {3, 4}},
     {L"\U0001f1e6\U00000915", {127462, 2325}, {2, 3}},
     {L"\U0001f1e6\U00000308\U00000915", {127462, 2325}, {3, 4}},
     {L"\U0001f1e6\U0000231a", {127462, 8986}, {2, 3}},
     {L"\U0001f1e6\U00000308\U0000231a", {127462, 8986}, {3, 4}},
     {L"\U0001f1e6\U00000300", {127462}, {3}},
     {L"\U0001f1e6\U00000308\U00000300", {127462}, {4}},
     {L"\U0001f1e6\U00000900", {127462}, {3}},
     {L"\U0001f1e6\U00000308\U00000900", {127462}, {4}},
     {L"\U0001f1e6\U0000094d", {127462}, {3}},
     {L"\U0001f1e6\U00000308\U0000094d", {127462}, {4}},
     {L"\U0001f1e6\U0000200d", {127462}, {3}},
     {L"\U0001f1e6\U00000308\U0000200d", {127462}, {4}},
     {L"\U0001f1e6\U00000378", {127462, 888}, {2, 3}},
     {L"\U0001f1e6\U00000308\U00000378", {127462, 888}, {3, 4}},
     {L"\U00000600\U00000020", {1536}, {2}},
     {L"\U00000600\U00000308\U00000020", {1536, 32}, {2, 3}},
     {L"\U00000600\U0000000d", {1536, 13}, {1, 2}},
     {L"\U00000600\U00000308\U0000000d", {1536, 13}, {2, 3}},
     {L"\U00000600\U0000000a", {1536, 10}, {1, 2}},
     {L"\U00000600\U00000308\U0000000a", {1536, 10}, {2, 3}},
     {L"\U00000600\U00000001", {1536, 1}, {1, 2}},
     {L"\U00000600\U00000308\U00000001", {1536, 1}, {2, 3}},
     {L"\U00000600\U0000200c", {1536}, {2}},
     {L"\U00000600\U00000308\U0000200c", {1536}, {3}},
     {L"\U00000600\U0001f1e6", {1536}, {3}},
     {L"\U00000600\U00000308\U0001f1e6", {1536, 127462}, {2, 4}},
     {L"\U00000600\U00000600", {1536}, {2}},
     {L"\U00000600\U00000308\U00000600", {1536, 1536}, {2, 3}},
     {L"\U00000600\U00000a03", {1536}, {2}},
     {L"\U00000600\U00000308\U00000a03", {1536}, {3}},
     {L"\U00000600\U00001100", {1536}, {2}},
     {L"\U00000600\U00000308\U00001100", {1536, 4352}, {2, 3}},
     {L"\U00000600\U00001160", {1536}, {2}},
     {L"\U00000600\U00000308\U00001160", {1536, 4448}, {2, 3}},
     {L"\U00000600\U000011a8", {1536}, {2}},
     {L"\U00000600\U00000308\U000011a8", {1536, 4520}, {2, 3}},
     {L"\U00000600\U0000ac00", {1536}, {2}},
     {L"\U00000600\U00000308\U0000ac00", {1536, 44032}, {2, 3}},
     {L"\U00000600\U0000ac01", {1536}, {2}},
     {L"\U00000600\U00000308\U0000ac01", {1536, 44033}, {2, 3}},
     {L"\U00000600\U00000903", {1536}, {2}},
     {L"\U00000600\U00000308\U00000903", {1536}, {3}},
     {L"\U00000600\U00000904", {1536}, {2}},
     {L"\U00000600\U00000308\U00000904", {1536, 2308}, {2, 3}},
     {L"\U00000600\U00000d4e", {1536}, {2}},
     {L"\U00000600\U00000308\U00000d4e", {1536, 3406}, {2, 3}},
     {L"\U00000600\U00000915", {1536}, {2}},
     {L"\U00000600\U00000308\U00000915", {1536, 2325}, {2, 3}},
     {L"\U00000600\U0000231a", {1536}, {2}},
     {L"\U00000600\U00000308\U0000231a", {1536, 8986}, {2, 3}},
     {L"\U00000600\U00000300", {1536}, {2}},
     {L"\U00000600\U00000308\U00000300", {1536}, {3}},
     {L"\U00000600\U00000900", {1536}, {2}},
     {L"\U00000600\U00000308\U00000900", {1536}, {3}},
     {L"\U00000600\U0000094d", {1536}, {2}},
     {L"\U00000600\U00000308\U0000094d", {1536}, {3}},
     {L"\U00000600\U0000200d", {1536}, {2}},
     {L"\U00000600\U00000308\U0000200d", {1536}, {3}},
     {L"\U00000600\U00000378", {1536}, {2}},
     {L"\U00000600\U00000308\U00000378", {1536, 888}, {2, 3}},
     {L"\U00000a03\U00000020", {2563, 32}, {1, 2}},
     {L"\U00000a03\U00000308\U00000020", {2563, 32}, {2, 3}},
     {L"\U00000a03\U0000000d", {2563, 13}, {1, 2}},
     {L"\U00000a03\U00000308\U0000000d", {2563, 13}, {2, 3}},
     {L"\U00000a03\U0000000a", {2563, 10}, {1, 2}},
     {L"\U00000a03\U00000308\U0000000a", {2563, 10}, {2, 3}},
     {L"\U00000a03\U00000001", {2563, 1}, {1, 2}},
     {L"\U00000a03\U00000308\U00000001", {2563, 1}, {2, 3}},
     {L"\U00000a03\U0000200c", {2563}, {2}},
     {L"\U00000a03\U00000308\U0000200c", {2563}, {3}},
     {L"\U00000a03\U0001f1e6", {2563, 127462}, {1, 3}},
     {L"\U00000a03\U00000308\U0001f1e6", {2563, 127462}, {2, 4}},
     {L"\U00000a03\U00000600", {2563, 1536}, {1, 2}},
     {L"\U00000a03\U00000308\U00000600", {2563, 1536}, {2, 3}},
     {L"\U00000a03\U00000a03", {2563}, {2}},
     {L"\U00000a03\U00000308\U00000a03", {2563}, {3}},
     {L"\U00000a03\U00001100", {2563, 4352}, {1, 2}},
     {L"\U00000a03\U00000308\U00001100", {2563, 4352}, {2, 3}},
     {L"\U00000a03\U00001160", {2563, 4448}, {1, 2}},
     {L"\U00000a03\U00000308\U00001160", {2563, 4448}, {2, 3}},
     {L"\U00000a03\U000011a8", {2563, 4520}, {1, 2}},
     {L"\U00000a03\U00000308\U000011a8", {2563, 4520}, {2, 3}},
     {L"\U00000a03\U0000ac00", {2563, 44032}, {1, 2}},
     {L"\U00000a03\U00000308\U0000ac00", {2563, 44032}, {2, 3}},
     {L"\U00000a03\U0000ac01", {2563, 44033}, {1, 2}},
     {L"\U00000a03\U00000308\U0000ac01", {2563, 44033}, {2, 3}},
     {L"\U00000a03\U00000903", {2563}, {2}},
     {L"\U00000a03\U00000308\U00000903", {2563}, {3}},
     {L"\U00000a03\U00000904", {2563, 2308}, {1, 2}},
     {L"\U00000a03\U00000308\U00000904", {2563, 2308}, {2, 3}},
     {L"\U00000a03\U00000d4e", {2563, 3406}, {1, 2}},
     {L"\U00000a03\U00000308\U00000d4e", {2563, 3406}, {2, 3}},
     {L"\U00000a03\U00000915", {2563, 2325}, {1, 2}},
     {L"\U00000a03\U00000308\U00000915", {2563, 2325}, {2, 3}},
     {L"\U00000a03\U0000231a", {2563, 8986}, {1, 2}},
     {L"\U00000a03\U00000308\U0000231a", {2563, 8986}, {2, 3}},
     {L"\U00000a03\U00000300", {2563}, {2}},
     {L"\U00000a03\U00000308\U00000300", {2563}, {3}},
     {L"\U00000a03\U00000900", {2563}, {2}},
     {L"\U00000a03\U00000308\U00000900", {2563}, {3}},
     {L"\U00000a03\U0000094d", {2563}, {2}},
     {L"\U00000a03\U00000308\U0000094d", {2563}, {3}},
     {L"\U00000a03\U0000200d", {2563}, {2}},
     {L"\U00000a03\U00000308\U0000200d", {2563}, {3}},
     {L"\U00000a03\U00000378", {2563, 888}, {1, 2}},
     {L"\U00000a03\U00000308\U00000378", {2563, 888}, {2, 3}},
     {L"\U00001100\U00000020", {4352, 32}, {1, 2}},
     {L"\U00001100\U00000308\U00000020", {4352, 32}, {2, 3}},
     {L"\U00001100\U0000000d", {4352, 13}, {1, 2}},
     {L"\U00001100\U00000308\U0000000d", {4352, 13}, {2, 3}},
     {L"\U00001100\U0000000a", {4352, 10}, {1, 2}},
     {L"\U00001100\U00000308\U0000000a", {4352, 10}, {2, 3}},
     {L"\U00001100\U00000001", {4352, 1}, {1, 2}},
     {L"\U00001100\U00000308\U00000001", {4352, 1}, {2, 3}},
     {L"\U00001100\U0000200c", {4352}, {2}},
     {L"\U00001100\U00000308\U0000200c", {4352}, {3}},
     {L"\U00001100\U0001f1e6", {4352, 127462}, {1, 3}},
     {L"\U00001100\U00000308\U0001f1e6", {4352, 127462}, {2, 4}},
     {L"\U00001100\U00000600", {4352, 1536}, {1, 2}},
     {L"\U00001100\U00000308\U00000600", {4352, 1536}, {2, 3}},
     {L"\U00001100\U00000a03", {4352}, {2}},
     {L"\U00001100\U00000308\U00000a03", {4352}, {3}},
     {L"\U00001100\U00001100", {4352}, {2}},
     {L"\U00001100\U00000308\U00001100", {4352, 4352}, {2, 3}},
     {L"\U00001100\U00001160", {4352}, {2}},
     {L"\U00001100\U00000308\U00001160", {4352, 4448}, {2, 3}},
     {L"\U00001100\U000011a8", {4352, 4520}, {1, 2}},
     {L"\U00001100\U00000308\U000011a8", {4352, 4520}, {2, 3}},
     {L"\U00001100\U0000ac00", {4352}, {2}},
     {L"\U00001100\U00000308\U0000ac00", {4352, 44032}, {2, 3}},
     {L"\U00001100\U0000ac01", {4352}, {2}},
     {L"\U00001100\U00000308\U0000ac01", {4352, 44033}, {2, 3}},
     {L"\U00001100\U00000903", {4352}, {2}},
     {L"\U00001100\U00000308\U00000903", {4352}, {3}},
     {L"\U00001100\U00000904", {4352, 2308}, {1, 2}},
     {L"\U00001100\U00000308\U00000904", {4352, 2308}, {2, 3}},
     {L"\U00001100\U00000d4e", {4352, 3406}, {1, 2}},
     {L"\U00001100\U00000308\U00000d4e", {4352, 3406}, {2, 3}},
     {L"\U00001100\U00000915", {4352, 2325}, {1, 2}},
     {L"\U00001100\U00000308\U00000915", {4352, 2325}, {2, 3}},
     {L"\U00001100\U0000231a", {4352, 8986}, {1, 2}},
     {L"\U00001100\U00000308\U0000231a", {4352, 8986}, {2, 3}},
     {L"\U00001100\U00000300", {4352}, {2}},
     {L"\U00001100\U00000308\U00000300", {4352}, {3}},
     {L"\U00001100\U00000900", {4352}, {2}},
     {L"\U00001100\U00000308\U00000900", {4352}, {3}},
     {L"\U00001100\U0000094d", {4352}, {2}},
     {L"\U00001100\U00000308\U0000094d", {4352}, {3}},
     {L"\U00001100\U0000200d", {4352}, {2}},
     {L"\U00001100\U00000308\U0000200d", {4352}, {3}},
     {L"\U00001100\U00000378", {4352, 888}, {1, 2}},
     {L"\U00001100\U00000308\U00000378", {4352, 888}, {2, 3}},
     {L"\U00001160\U00000020", {4448, 32}, {1, 2}},
     {L"\U00001160\U00000308\U00000020", {4448, 32}, {2, 3}},
     {L"\U00001160\U0000000d", {4448, 13}, {1, 2}},
     {L"\U00001160\U00000308\U0000000d", {4448, 13}, {2, 3}},
     {L"\U00001160\U0000000a", {4448, 10}, {1, 2}},
     {L"\U00001160\U00000308\U0000000a", {4448, 10}, {2, 3}},
     {L"\U00001160\U00000001", {4448, 1}, {1, 2}},
     {L"\U00001160\U00000308\U00000001", {4448, 1}, {2, 3}},
     {L"\U00001160\U0000200c", {4448}, {2}},
     {L"\U00001160\U00000308\U0000200c", {4448}, {3}},
     {L"\U00001160\U0001f1e6", {4448, 127462}, {1, 3}},
     {L"\U00001160\U00000308\U0001f1e6", {4448, 127462}, {2, 4}},
     {L"\U00001160\U00000600", {4448, 1536}, {1, 2}},
     {L"\U00001160\U00000308\U00000600", {4448, 1536}, {2, 3}},
     {L"\U00001160\U00000a03", {4448}, {2}},
     {L"\U00001160\U00000308\U00000a03", {4448}, {3}},
     {L"\U00001160\U00001100", {4448, 4352}, {1, 2}},
     {L"\U00001160\U00000308\U00001100", {4448, 4352}, {2, 3}},
     {L"\U00001160\U00001160", {4448}, {2}},
     {L"\U00001160\U00000308\U00001160", {4448, 4448}, {2, 3}},
     {L"\U00001160\U000011a8", {4448}, {2}},
     {L"\U00001160\U00000308\U000011a8", {4448, 4520}, {2, 3}},
     {L"\U00001160\U0000ac00", {4448, 44032}, {1, 2}},
     {L"\U00001160\U00000308\U0000ac00", {4448, 44032}, {2, 3}},
     {L"\U00001160\U0000ac01", {4448, 44033}, {1, 2}},
     {L"\U00001160\U00000308\U0000ac01", {4448, 44033}, {2, 3}},
     {L"\U00001160\U00000903", {4448}, {2}},
     {L"\U00001160\U00000308\U00000903", {4448}, {3}},
     {L"\U00001160\U00000904", {4448, 2308}, {1, 2}},
     {L"\U00001160\U00000308\U00000904", {4448, 2308}, {2, 3}},
     {L"\U00001160\U00000d4e", {4448, 3406}, {1, 2}},
     {L"\U00001160\U00000308\U00000d4e", {4448, 3406}, {2, 3}},
     {L"\U00001160\U00000915", {4448, 2325}, {1, 2}},
     {L"\U00001160\U00000308\U00000915", {4448, 2325}, {2, 3}},
     {L"\U00001160\U0000231a", {4448, 8986}, {1, 2}},
     {L"\U00001160\U00000308\U0000231a", {4448, 8986}, {2, 3}},
     {L"\U00001160\U00000300", {4448}, {2}},
     {L"\U00001160\U00000308\U00000300", {4448}, {3}},
     {L"\U00001160\U00000900", {4448}, {2}},
     {L"\U00001160\U00000308\U00000900", {4448}, {3}},
     {L"\U00001160\U0000094d", {4448}, {2}},
     {L"\U00001160\U00000308\U0000094d", {4448}, {3}},
     {L"\U00001160\U0000200d", {4448}, {2}},
     {L"\U00001160\U00000308\U0000200d", {4448}, {3}},
     {L"\U00001160\U00000378", {4448, 888}, {1, 2}},
     {L"\U00001160\U00000308\U00000378", {4448, 888}, {2, 3}},
     {L"\U000011a8\U00000020", {4520, 32}, {1, 2}},
     {L"\U000011a8\U00000308\U00000020", {4520, 32}, {2, 3}},
     {L"\U000011a8\U0000000d", {4520, 13}, {1, 2}},
     {L"\U000011a8\U00000308\U0000000d", {4520, 13}, {2, 3}},
     {L"\U000011a8\U0000000a", {4520, 10}, {1, 2}},
     {L"\U000011a8\U00000308\U0000000a", {4520, 10}, {2, 3}},
     {L"\U000011a8\U00000001", {4520, 1}, {1, 2}},
     {L"\U000011a8\U00000308\U00000001", {4520, 1}, {2, 3}},
     {L"\U000011a8\U0000200c", {4520}, {2}},
     {L"\U000011a8\U00000308\U0000200c", {4520}, {3}},
     {L"\U000011a8\U0001f1e6", {4520, 127462}, {1, 3}},
     {L"\U000011a8\U00000308\U0001f1e6", {4520, 127462}, {2, 4}},
     {L"\U000011a8\U00000600", {4520, 1536}, {1, 2}},
     {L"\U000011a8\U00000308\U00000600", {4520, 1536}, {2, 3}},
     {L"\U000011a8\U00000a03", {4520}, {2}},
     {L"\U000011a8\U00000308\U00000a03", {4520}, {3}},
     {L"\U000011a8\U00001100", {4520, 4352}, {1, 2}},
     {L"\U000011a8\U00000308\U00001100", {4520, 4352}, {2, 3}},
     {L"\U000011a8\U00001160", {4520, 4448}, {1, 2}},
     {L"\U000011a8\U00000308\U00001160", {4520, 4448}, {2, 3}},
     {L"\U000011a8\U000011a8", {4520}, {2}},
     {L"\U000011a8\U00000308\U000011a8", {4520, 4520}, {2, 3}},
     {L"\U000011a8\U0000ac00", {4520, 44032}, {1, 2}},
     {L"\U000011a8\U00000308\U0000ac00", {4520, 44032}, {2, 3}},
     {L"\U000011a8\U0000ac01", {4520, 44033}, {1, 2}},
     {L"\U000011a8\U00000308\U0000ac01", {4520, 44033}, {2, 3}},
     {L"\U000011a8\U00000903", {4520}, {2}},
     {L"\U000011a8\U00000308\U00000903", {4520}, {3}},
     {L"\U000011a8\U00000904", {4520, 2308}, {1, 2}},
     {L"\U000011a8\U00000308\U00000904", {4520, 2308}, {2, 3}},
     {L"\U000011a8\U00000d4e", {4520, 3406}, {1, 2}},
     {L"\U000011a8\U00000308\U00000d4e", {4520, 3406}, {2, 3}},
     {L"\U000011a8\U00000915", {4520, 2325}, {1, 2}},
     {L"\U000011a8\U00000308\U00000915", {4520, 2325}, {2, 3}},
     {L"\U000011a8\U0000231a", {4520, 8986}, {1, 2}},
     {L"\U000011a8\U00000308\U0000231a", {4520, 8986}, {2, 3}},
     {L"\U000011a8\U00000300", {4520}, {2}},
     {L"\U000011a8\U00000308\U00000300", {4520}, {3}},
     {L"\U000011a8\U00000900", {4520}, {2}},
     {L"\U000011a8\U00000308\U00000900", {4520}, {3}},
     {L"\U000011a8\U0000094d", {4520}, {2}},
     {L"\U000011a8\U00000308\U0000094d", {4520}, {3}},
     {L"\U000011a8\U0000200d", {4520}, {2}},
     {L"\U000011a8\U00000308\U0000200d", {4520}, {3}},
     {L"\U000011a8\U00000378", {4520, 888}, {1, 2}},
     {L"\U000011a8\U00000308\U00000378", {4520, 888}, {2, 3}},
     {L"\U0000ac00\U00000020", {44032, 32}, {1, 2}},
     {L"\U0000ac00\U00000308\U00000020", {44032, 32}, {2, 3}},
     {L"\U0000ac00\U0000000d", {44032, 13}, {1, 2}},
     {L"\U0000ac00\U00000308\U0000000d", {44032, 13}, {2, 3}},
     {L"\U0000ac00\U0000000a", {44032, 10}, {1, 2}},
     {L"\U0000ac00\U00000308\U0000000a", {44032, 10}, {2, 3}},
     {L"\U0000ac00\U00000001", {44032, 1}, {1, 2}},
     {L"\U0000ac00\U00000308\U00000001", {44032, 1}, {2, 3}},
     {L"\U0000ac00\U0000200c", {44032}, {2}},
     {L"\U0000ac00\U00000308\U0000200c", {44032}, {3}},
     {L"\U0000ac00\U0001f1e6", {44032, 127462}, {1, 3}},
     {L"\U0000ac00\U00000308\U0001f1e6", {44032, 127462}, {2, 4}},
     {L"\U0000ac00\U00000600", {44032, 1536}, {1, 2}},
     {L"\U0000ac00\U00000308\U00000600", {44032, 1536}, {2, 3}},
     {L"\U0000ac00\U00000a03", {44032}, {2}},
     {L"\U0000ac00\U00000308\U00000a03", {44032}, {3}},
     {L"\U0000ac00\U00001100", {44032, 4352}, {1, 2}},
     {L"\U0000ac00\U00000308\U00001100", {44032, 4352}, {2, 3}},
     {L"\U0000ac00\U00001160", {44032}, {2}},
     {L"\U0000ac00\U00000308\U00001160", {44032, 4448}, {2, 3}},
     {L"\U0000ac00\U000011a8", {44032}, {2}},
     {L"\U0000ac00\U00000308\U000011a8", {44032, 4520}, {2, 3}},
     {L"\U0000ac00\U0000ac00", {44032, 44032}, {1, 2}},
     {L"\U0000ac00\U00000308\U0000ac00", {44032, 44032}, {2, 3}},
     {L"\U0000ac00\U0000ac01", {44032, 44033}, {1, 2}},
     {L"\U0000ac00\U00000308\U0000ac01", {44032, 44033}, {2, 3}},
     {L"\U0000ac00\U00000903", {44032}, {2}},
     {L"\U0000ac00\U00000308\U00000903", {44032}, {3}},
     {L"\U0000ac00\U00000904", {44032, 2308}, {1, 2}},
     {L"\U0000ac00\U00000308\U00000904", {44032, 2308}, {2, 3}},
     {L"\U0000ac00\U00000d4e", {44032, 3406}, {1, 2}},
     {L"\U0000ac00\U00000308\U00000d4e", {44032, 3406}, {2, 3}},
     {L"\U0000ac00\U00000915", {44032, 2325}, {1, 2}},
     {L"\U0000ac00\U00000308\U00000915", {44032, 2325}, {2, 3}},
     {L"\U0000ac00\U0000231a", {44032, 8986}, {1, 2}},
     {L"\U0000ac00\U00000308\U0000231a", {44032, 8986}, {2, 3}},
     {L"\U0000ac00\U00000300", {44032}, {2}},
     {L"\U0000ac00\U00000308\U00000300", {44032}, {3}},
     {L"\U0000ac00\U00000900", {44032}, {2}},
     {L"\U0000ac00\U00000308\U00000900", {44032}, {3}},
     {L"\U0000ac00\U0000094d", {44032}, {2}},
     {L"\U0000ac00\U00000308\U0000094d", {44032}, {3}},
     {L"\U0000ac00\U0000200d", {44032}, {2}},
     {L"\U0000ac00\U00000308\U0000200d", {44032}, {3}},
     {L"\U0000ac00\U00000378", {44032, 888}, {1, 2}},
     {L"\U0000ac00\U00000308\U00000378", {44032, 888}, {2, 3}},
     {L"\U0000ac01\U00000020", {44033, 32}, {1, 2}},
     {L"\U0000ac01\U00000308\U00000020", {44033, 32}, {2, 3}},
     {L"\U0000ac01\U0000000d", {44033, 13}, {1, 2}},
     {L"\U0000ac01\U00000308\U0000000d", {44033, 13}, {2, 3}},
     {L"\U0000ac01\U0000000a", {44033, 10}, {1, 2}},
     {L"\U0000ac01\U00000308\U0000000a", {44033, 10}, {2, 3}},
     {L"\U0000ac01\U00000001", {44033, 1}, {1, 2}},
     {L"\U0000ac01\U00000308\U00000001", {44033, 1}, {2, 3}},
     {L"\U0000ac01\U0000200c", {44033}, {2}},
     {L"\U0000ac01\U00000308\U0000200c", {44033}, {3}},
     {L"\U0000ac01\U0001f1e6", {44033, 127462}, {1, 3}},
     {L"\U0000ac01\U00000308\U0001f1e6", {44033, 127462}, {2, 4}},
     {L"\U0000ac01\U00000600", {44033, 1536}, {1, 2}},
     {L"\U0000ac01\U00000308\U00000600", {44033, 1536}, {2, 3}},
     {L"\U0000ac01\U00000a03", {44033}, {2}},
     {L"\U0000ac01\U00000308\U00000a03", {44033}, {3}},
     {L"\U0000ac01\U00001100", {44033, 4352}, {1, 2}},
     {L"\U0000ac01\U00000308\U00001100", {44033, 4352}, {2, 3}},
     {L"\U0000ac01\U00001160", {44033, 4448}, {1, 2}},
     {L"\U0000ac01\U00000308\U00001160", {44033, 4448}, {2, 3}},
     {L"\U0000ac01\U000011a8", {44033}, {2}},
     {L"\U0000ac01\U00000308\U000011a8", {44033, 4520}, {2, 3}},
     {L"\U0000ac01\U0000ac00", {44033, 44032}, {1, 2}},
     {L"\U0000ac01\U00000308\U0000ac00", {44033, 44032}, {2, 3}},
     {L"\U0000ac01\U0000ac01", {44033, 44033}, {1, 2}},
     {L"\U0000ac01\U00000308\U0000ac01", {44033, 44033}, {2, 3}},
     {L"\U0000ac01\U00000903", {44033}, {2}},
     {L"\U0000ac01\U00000308\U00000903", {44033}, {3}},
     {L"\U0000ac01\U00000904", {44033, 2308}, {1, 2}},
     {L"\U0000ac01\U00000308\U00000904", {44033, 2308}, {2, 3}},
     {L"\U0000ac01\U00000d4e", {44033, 3406}, {1, 2}},
     {L"\U0000ac01\U00000308\U00000d4e", {44033, 3406}, {2, 3}},
     {L"\U0000ac01\U00000915", {44033, 2325}, {1, 2}},
     {L"\U0000ac01\U00000308\U00000915", {44033, 2325}, {2, 3}},
     {L"\U0000ac01\U0000231a", {44033, 8986}, {1, 2}},
     {L"\U0000ac01\U00000308\U0000231a", {44033, 8986}, {2, 3}},
     {L"\U0000ac01\U00000300", {44033}, {2}},
     {L"\U0000ac01\U00000308\U00000300", {44033}, {3}},
     {L"\U0000ac01\U00000900", {44033}, {2}},
     {L"\U0000ac01\U00000308\U00000900", {44033}, {3}},
     {L"\U0000ac01\U0000094d", {44033}, {2}},
     {L"\U0000ac01\U00000308\U0000094d", {44033}, {3}},
     {L"\U0000ac01\U0000200d", {44033}, {2}},
     {L"\U0000ac01\U00000308\U0000200d", {44033}, {3}},
     {L"\U0000ac01\U00000378", {44033, 888}, {1, 2}},
     {L"\U0000ac01\U00000308\U00000378", {44033, 888}, {2, 3}},
     {L"\U00000903\U00000020", {2307, 32}, {1, 2}},
     {L"\U00000903\U00000308\U00000020", {2307, 32}, {2, 3}},
     {L"\U00000903\U0000000d", {2307, 13}, {1, 2}},
     {L"\U00000903\U00000308\U0000000d", {2307, 13}, {2, 3}},
     {L"\U00000903\U0000000a", {2307, 10}, {1, 2}},
     {L"\U00000903\U00000308\U0000000a", {2307, 10}, {2, 3}},
     {L"\U00000903\U00000001", {2307, 1}, {1, 2}},
     {L"\U00000903\U00000308\U00000001", {2307, 1}, {2, 3}},
     {L"\U00000903\U0000200c", {2307}, {2}},
     {L"\U00000903\U00000308\U0000200c", {2307}, {3}},
     {L"\U00000903\U0001f1e6", {2307, 127462}, {1, 3}},
     {L"\U00000903\U00000308\U0001f1e6", {2307, 127462}, {2, 4}},
     {L"\U00000903\U00000600", {2307, 1536}, {1, 2}},
     {L"\U00000903\U00000308\U00000600", {2307, 1536}, {2, 3}},
     {L"\U00000903\U00000a03", {2307}, {2}},
     {L"\U00000903\U00000308\U00000a03", {2307}, {3}},
     {L"\U00000903\U00001100", {2307, 4352}, {1, 2}},
     {L"\U00000903\U00000308\U00001100", {2307, 4352}, {2, 3}},
     {L"\U00000903\U00001160", {2307, 4448}, {1, 2}},
     {L"\U00000903\U00000308\U00001160", {2307, 4448}, {2, 3}},
     {L"\U00000903\U000011a8", {2307, 4520}, {1, 2}},
     {L"\U00000903\U00000308\U000011a8", {2307, 4520}, {2, 3}},
     {L"\U00000903\U0000ac00", {2307, 44032}, {1, 2}},
     {L"\U00000903\U00000308\U0000ac00", {2307, 44032}, {2, 3}},
     {L"\U00000903\U0000ac01", {2307, 44033}, {1, 2}},
     {L"\U00000903\U00000308\U0000ac01", {2307, 44033}, {2, 3}},
     {L"\U00000903\U00000903", {2307}, {2}},
     {L"\U00000903\U00000308\U00000903", {2307}, {3}},
     {L"\U00000903\U00000904", {2307, 2308}, {1, 2}},
     {L"\U00000903\U00000308\U00000904", {2307, 2308}, {2, 3}},
     {L"\U00000903\U00000d4e", {2307, 3406}, {1, 2}},
     {L"\U00000903\U00000308\U00000d4e", {2307, 3406}, {2, 3}},
     {L"\U00000903\U00000915", {2307, 2325}, {1, 2}},
     {L"\U00000903\U00000308\U00000915", {2307, 2325}, {2, 3}},
     {L"\U00000903\U0000231a", {2307, 8986}, {1, 2}},
     {L"\U00000903\U00000308\U0000231a", {2307, 8986}, {2, 3}},
     {L"\U00000903\U00000300", {2307}, {2}},
     {L"\U00000903\U00000308\U00000300", {2307}, {3}},
     {L"\U00000903\U00000900", {2307}, {2}},
     {L"\U00000903\U00000308\U00000900", {2307}, {3}},
     {L"\U00000903\U0000094d", {2307}, {2}},
     {L"\U00000903\U00000308\U0000094d", {2307}, {3}},
     {L"\U00000903\U0000200d", {2307}, {2}},
     {L"\U00000903\U00000308\U0000200d", {2307}, {3}},
     {L"\U00000903\U00000378", {2307, 888}, {1, 2}},
     {L"\U00000903\U00000308\U00000378", {2307, 888}, {2, 3}},
     {L"\U00000904\U00000020", {2308, 32}, {1, 2}},
     {L"\U00000904\U00000308\U00000020", {2308, 32}, {2, 3}},
     {L"\U00000904\U0000000d", {2308, 13}, {1, 2}},
     {L"\U00000904\U00000308\U0000000d", {2308, 13}, {2, 3}},
     {L"\U00000904\U0000000a", {2308, 10}, {1, 2}},
     {L"\U00000904\U00000308\U0000000a", {2308, 10}, {2, 3}},
     {L"\U00000904\U00000001", {2308, 1}, {1, 2}},
     {L"\U00000904\U00000308\U00000001", {2308, 1}, {2, 3}},
     {L"\U00000904\U0000200c", {2308}, {2}},
     {L"\U00000904\U00000308\U0000200c", {2308}, {3}},
     {L"\U00000904\U0001f1e6", {2308, 127462}, {1, 3}},
     {L"\U00000904\U00000308\U0001f1e6", {2308, 127462}, {2, 4}},
     {L"\U00000904\U00000600", {2308, 1536}, {1, 2}},
     {L"\U00000904\U00000308\U00000600", {2308, 1536}, {2, 3}},
     {L"\U00000904\U00000a03", {2308}, {2}},
     {L"\U00000904\U00000308\U00000a03", {2308}, {3}},
     {L"\U00000904\U00001100", {2308, 4352}, {1, 2}},
     {L"\U00000904\U00000308\U00001100", {2308, 4352}, {2, 3}},
     {L"\U00000904\U00001160", {2308, 4448}, {1, 2}},
     {L"\U00000904\U00000308\U00001160", {2308, 4448}, {2, 3}},
     {L"\U00000904\U000011a8", {2308, 4520}, {1, 2}},
     {L"\U00000904\U00000308\U000011a8", {2308, 4520}, {2, 3}},
     {L"\U00000904\U0000ac00", {2308, 44032}, {1, 2}},
     {L"\U00000904\U00000308\U0000ac00", {2308, 44032}, {2, 3}},
     {L"\U00000904\U0000ac01", {2308, 44033}, {1, 2}},
     {L"\U00000904\U00000308\U0000ac01", {2308, 44033}, {2, 3}},
     {L"\U00000904\U00000903", {2308}, {2}},
     {L"\U00000904\U00000308\U00000903", {2308}, {3}},
     {L"\U00000904\U00000904", {2308, 2308}, {1, 2}},
     {L"\U00000904\U00000308\U00000904", {2308, 2308}, {2, 3}},
     {L"\U00000904\U00000d4e", {2308, 3406}, {1, 2}},
     {L"\U00000904\U00000308\U00000d4e", {2308, 3406}, {2, 3}},
     {L"\U00000904\U00000915", {2308, 2325}, {1, 2}},
     {L"\U00000904\U00000308\U00000915", {2308, 2325}, {2, 3}},
     {L"\U00000904\U0000231a", {2308, 8986}, {1, 2}},
     {L"\U00000904\U00000308\U0000231a", {2308, 8986}, {2, 3}},
     {L"\U00000904\U00000300", {2308}, {2}},
     {L"\U00000904\U00000308\U00000300", {2308}, {3}},
     {L"\U00000904\U00000900", {2308}, {2}},
     {L"\U00000904\U00000308\U00000900", {2308}, {3}},
     {L"\U00000904\U0000094d", {2308}, {2}},
     {L"\U00000904\U00000308\U0000094d", {2308}, {3}},
     {L"\U00000904\U0000200d", {2308}, {2}},
     {L"\U00000904\U00000308\U0000200d", {2308}, {3}},
     {L"\U00000904\U00000378", {2308, 888}, {1, 2}},
     {L"\U00000904\U00000308\U00000378", {2308, 888}, {2, 3}},
     {L"\U00000d4e\U00000020", {3406}, {2}},
     {L"\U00000d4e\U00000308\U00000020", {3406, 32}, {2, 3}},
     {L"\U00000d4e\U0000000d", {3406, 13}, {1, 2}},
     {L"\U00000d4e\U00000308\U0000000d", {3406, 13}, {2, 3}},
     {L"\U00000d4e\U0000000a", {3406, 10}, {1, 2}},
     {L"\U00000d4e\U00000308\U0000000a", {3406, 10}, {2, 3}},
     {L"\U00000d4e\U00000001", {3406, 1}, {1, 2}},
     {L"\U00000d4e\U00000308\U00000001", {3406, 1}, {2, 3}},
     {L"\U00000d4e\U0000200c", {3406}, {2}},
     {L"\U00000d4e\U00000308\U0000200c", {3406}, {3}},
     {L"\U00000d4e\U0001f1e6", {3406}, {3}},
     {L"\U00000d4e\U00000308\U0001f1e6", {3406, 127462}, {2, 4}},
     {L"\U00000d4e\U00000600", {3406}, {2}},
     {L"\U00000d4e\U00000308\U00000600", {3406, 1536}, {2, 3}},
     {L"\U00000d4e\U00000a03", {3406}, {2}},
     {L"\U00000d4e\U00000308\U00000a03", {3406}, {3}},
     {L"\U00000d4e\U00001100", {3406}, {2}},
     {L"\U00000d4e\U00000308\U00001100", {3406, 4352}, {2, 3}},
     {L"\U00000d4e\U00001160", {3406}, {2}},
     {L"\U00000d4e\U00000308\U00001160", {3406, 4448}, {2, 3}},
     {L"\U00000d4e\U000011a8", {3406}, {2}},
     {L"\U00000d4e\U00000308\U000011a8", {3406, 4520}, {2, 3}},
     {L"\U00000d4e\U0000ac00", {3406}, {2}},
     {L"\U00000d4e\U00000308\U0000ac00", {3406, 44032}, {2, 3}},
     {L"\U00000d4e\U0000ac01", {3406}, {2}},
     {L"\U00000d4e\U00000308\U0000ac01", {3406, 44033}, {2, 3}},
     {L"\U00000d4e\U00000903", {3406}, {2}},
     {L"\U00000d4e\U00000308\U00000903", {3406}, {3}},
     {L"\U00000d4e\U00000904", {3406}, {2}},
     {L"\U00000d4e\U00000308\U00000904", {3406, 2308}, {2, 3}},
     {L"\U00000d4e\U00000d4e", {3406}, {2}},
     {L"\U00000d4e\U00000308\U00000d4e", {3406, 3406}, {2, 3}},
     {L"\U00000d4e\U00000915", {3406}, {2}},
     {L"\U00000d4e\U00000308\U00000915", {3406, 2325}, {2, 3}},
     {L"\U00000d4e\U0000231a", {3406}, {2}},
     {L"\U00000d4e\U00000308\U0000231a", {3406, 8986}, {2, 3}},
     {L"\U00000d4e\U00000300", {3406}, {2}},
     {L"\U00000d4e\U00000308\U00000300", {3406}, {3}},
     {L"\U00000d4e\U00000900", {3406}, {2}},
     {L"\U00000d4e\U00000308\U00000900", {3406}, {3}},
     {L"\U00000d4e\U0000094d", {3406}, {2}},
     {L"\U00000d4e\U00000308\U0000094d", {3406}, {3}},
     {L"\U00000d4e\U0000200d", {3406}, {2}},
     {L"\U00000d4e\U00000308\U0000200d", {3406}, {3}},
     {L"\U00000d4e\U00000378", {3406}, {2}},
     {L"\U00000d4e\U00000308\U00000378", {3406, 888}, {2, 3}},
     {L"\U00000915\U00000020", {2325, 32}, {1, 2}},
     {L"\U00000915\U00000308\U00000020", {2325, 32}, {2, 3}},
     {L"\U00000915\U0000000d", {2325, 13}, {1, 2}},
     {L"\U00000915\U00000308\U0000000d", {2325, 13}, {2, 3}},
     {L"\U00000915\U0000000a", {2325, 10}, {1, 2}},
     {L"\U00000915\U00000308\U0000000a", {2325, 10}, {2, 3}},
     {L"\U00000915\U00000001", {2325, 1}, {1, 2}},
     {L"\U00000915\U00000308\U00000001", {2325, 1}, {2, 3}},
     {L"\U00000915\U0000200c", {2325}, {2}},
     {L"\U00000915\U00000308\U0000200c", {2325}, {3}},
     {L"\U00000915\U0001f1e6", {2325, 127462}, {1, 3}},
     {L"\U00000915\U00000308\U0001f1e6", {2325, 127462}, {2, 4}},
     {L"\U00000915\U00000600", {2325, 1536}, {1, 2}},
     {L"\U00000915\U00000308\U00000600", {2325, 1536}, {2, 3}},
     {L"\U00000915\U00000a03", {2325}, {2}},
     {L"\U00000915\U00000308\U00000a03", {2325}, {3}},
     {L"\U00000915\U00001100", {2325, 4352}, {1, 2}},
     {L"\U00000915\U00000308\U00001100", {2325, 4352}, {2, 3}},
     {L"\U00000915\U00001160", {2325, 4448}, {1, 2}},
     {L"\U00000915\U00000308\U00001160", {2325, 4448}, {2, 3}},
     {L"\U00000915\U000011a8", {2325, 4520}, {1, 2}},
     {L"\U00000915\U00000308\U000011a8", {2325, 4520}, {2, 3}},
     {L"\U00000915\U0000ac00", {2325, 44032}, {1, 2}},
     {L"\U00000915\U00000308\U0000ac00", {2325, 44032}, {2, 3}},
     {L"\U00000915\U0000ac01", {2325, 44033}, {1, 2}},
     {L"\U00000915\U00000308\U0000ac01", {2325, 44033}, {2, 3}},
     {L"\U00000915\U00000903", {2325}, {2}},
     {L"\U00000915\U00000308\U00000903", {2325}, {3}},
     {L"\U00000915\U00000904", {2325, 2308}, {1, 2}},
     {L"\U00000915\U00000308\U00000904", {2325, 2308}, {2, 3}},
     {L"\U00000915\U00000d4e", {2325, 3406}, {1, 2}},
     {L"\U00000915\U00000308\U00000d4e", {2325, 3406}, {2, 3}},
     {L"\U00000915\U00000915", {2325, 2325}, {1, 2}},
     {L"\U00000915\U00000308\U00000915", {2325, 2325}, {2, 3}},
     {L"\U00000915\U0000231a", {2325, 8986}, {1, 2}},
     {L"\U00000915\U00000308\U0000231a", {2325, 8986}, {2, 3}},
     {L"\U00000915\U00000300", {2325}, {2}},
     {L"\U00000915\U00000308\U00000300", {2325}, {3}},
     {L"\U00000915\U00000900", {2325}, {2}},
     {L"\U00000915\U00000308\U00000900", {2325}, {3}},
     {L"\U00000915\U0000094d", {2325}, {2}},
     {L"\U00000915\U00000308\U0000094d", {2325}, {3}},
     {L"\U00000915\U0000200d", {2325}, {2}},
     {L"\U00000915\U00000308\U0000200d", {2325}, {3}},
     {L"\U00000915\U00000378", {2325, 888}, {1, 2}},
     {L"\U00000915\U00000308\U00000378", {2325, 888}, {2, 3}},
     {L"\U0000231a\U00000020", {8986, 32}, {1, 2}},
     {L"\U0000231a\U00000308\U00000020", {8986, 32}, {2, 3}},
     {L"\U0000231a\U0000000d", {8986, 13}, {1, 2}},
     {L"\U0000231a\U00000308\U0000000d", {8986, 13}, {2, 3}},
     {L"\U0000231a\U0000000a", {8986, 10}, {1, 2}},
     {L"\U0000231a\U00000308\U0000000a", {8986, 10}, {2, 3}},
     {L"\U0000231a\U00000001", {8986, 1}, {1, 2}},
     {L"\U0000231a\U00000308\U00000001", {8986, 1}, {2, 3}},
     {L"\U0000231a\U0000200c", {8986}, {2}},
     {L"\U0000231a\U00000308\U0000200c", {8986}, {3}},
     {L"\U0000231a\U0001f1e6", {8986, 127462}, {1, 3}},
     {L"\U0000231a\U00000308\U0001f1e6", {8986, 127462}, {2, 4}},
     {L"\U0000231a\U00000600", {8986, 1536}, {1, 2}},
     {L"\U0000231a\U00000308\U00000600", {8986, 1536}, {2, 3}},
     {L"\U0000231a\U00000a03", {8986}, {2}},
     {L"\U0000231a\U00000308\U00000a03", {8986}, {3}},
     {L"\U0000231a\U00001100", {8986, 4352}, {1, 2}},
     {L"\U0000231a\U00000308\U00001100", {8986, 4352}, {2, 3}},
     {L"\U0000231a\U00001160", {8986, 4448}, {1, 2}},
     {L"\U0000231a\U00000308\U00001160", {8986, 4448}, {2, 3}},
     {L"\U0000231a\U000011a8", {8986, 4520}, {1, 2}},
     {L"\U0000231a\U00000308\U000011a8", {8986, 4520}, {2, 3}},
     {L"\U0000231a\U0000ac00", {8986, 44032}, {1, 2}},
     {L"\U0000231a\U00000308\U0000ac00", {8986, 44032}, {2, 3}},
     {L"\U0000231a\U0000ac01", {8986, 44033}, {1, 2}},
     {L"\U0000231a\U00000308\U0000ac01", {8986, 44033}, {2, 3}},
     {L"\U0000231a\U00000903", {8986}, {2}},
     {L"\U0000231a\U00000308\U00000903", {8986}, {3}},
     {L"\U0000231a\U00000904", {8986, 2308}, {1, 2}},
     {L"\U0000231a\U00000308\U00000904", {8986, 2308}, {2, 3}},
     {L"\U0000231a\U00000d4e", {8986, 3406}, {1, 2}},
     {L"\U0000231a\U00000308\U00000d4e", {8986, 3406}, {2, 3}},
     {L"\U0000231a\U00000915", {8986, 2325}, {1, 2}},
     {L"\U0000231a\U00000308\U00000915", {8986, 2325}, {2, 3}},
     {L"\U0000231a\U0000231a", {8986, 8986}, {1, 2}},
     {L"\U0000231a\U00000308\U0000231a", {8986, 8986}, {2, 3}},
     {L"\U0000231a\U00000300", {8986}, {2}},
     {L"\U0000231a\U00000308\U00000300", {8986}, {3}},
     {L"\U0000231a\U00000900", {8986}, {2}},
     {L"\U0000231a\U00000308\U00000900", {8986}, {3}},
     {L"\U0000231a\U0000094d", {8986}, {2}},
     {L"\U0000231a\U00000308\U0000094d", {8986}, {3}},
     {L"\U0000231a\U0000200d", {8986}, {2}},
     {L"\U0000231a\U00000308\U0000200d", {8986}, {3}},
     {L"\U0000231a\U00000378", {8986, 888}, {1, 2}},
     {L"\U0000231a\U00000308\U00000378", {8986, 888}, {2, 3}},
     {L"\U00000300\U00000020", {768, 32}, {1, 2}},
     {L"\U00000300\U00000308\U00000020", {768, 32}, {2, 3}},
     {L"\U00000300\U0000000d", {768, 13}, {1, 2}},
     {L"\U00000300\U00000308\U0000000d", {768, 13}, {2, 3}},
     {L"\U00000300\U0000000a", {768, 10}, {1, 2}},
     {L"\U00000300\U00000308\U0000000a", {768, 10}, {2, 3}},
     {L"\U00000300\U00000001", {768, 1}, {1, 2}},
     {L"\U00000300\U00000308\U00000001", {768, 1}, {2, 3}},
     {L"\U00000300\U0000200c", {768}, {2}},
     {L"\U00000300\U00000308\U0000200c", {768}, {3}},
     {L"\U00000300\U0001f1e6", {768, 127462}, {1, 3}},
     {L"\U00000300\U00000308\U0001f1e6", {768, 127462}, {2, 4}},
     {L"\U00000300\U00000600", {768, 1536}, {1, 2}},
     {L"\U00000300\U00000308\U00000600", {768, 1536}, {2, 3}},
     {L"\U00000300\U00000a03", {768}, {2}},
     {L"\U00000300\U00000308\U00000a03", {768}, {3}},
     {L"\U00000300\U00001100", {768, 4352}, {1, 2}},
     {L"\U00000300\U00000308\U00001100", {768, 4352}, {2, 3}},
     {L"\U00000300\U00001160", {768, 4448}, {1, 2}},
     {L"\U00000300\U00000308\U00001160", {768, 4448}, {2, 3}},
     {L"\U00000300\U000011a8", {768, 4520}, {1, 2}},
     {L"\U00000300\U00000308\U000011a8", {768, 4520}, {2, 3}},
     {L"\U00000300\U0000ac00", {768, 44032}, {1, 2}},
     {L"\U00000300\U00000308\U0000ac00", {768, 44032}, {2, 3}},
     {L"\U00000300\U0000ac01", {768, 44033}, {1, 2}},
     {L"\U00000300\U00000308\U0000ac01", {768, 44033}, {2, 3}},
     {L"\U00000300\U00000903", {768}, {2}},
     {L"\U00000300\U00000308\U00000903", {768}, {3}},
     {L"\U00000300\U00000904", {768, 2308}, {1, 2}},
     {L"\U00000300\U00000308\U00000904", {768, 2308}, {2, 3}},
     {L"\U00000300\U00000d4e", {768, 3406}, {1, 2}},
     {L"\U00000300\U00000308\U00000d4e", {768, 3406}, {2, 3}},
     {L"\U00000300\U00000915", {768, 2325}, {1, 2}},
     {L"\U00000300\U00000308\U00000915", {768, 2325}, {2, 3}},
     {L"\U00000300\U0000231a", {768, 8986}, {1, 2}},
     {L"\U00000300\U00000308\U0000231a", {768, 8986}, {2, 3}},
     {L"\U00000300\U00000300", {768}, {2}},
     {L"\U00000300\U00000308\U00000300", {768}, {3}},
     {L"\U00000300\U00000900", {768}, {2}},
     {L"\U00000300\U00000308\U00000900", {768}, {3}},
     {L"\U00000300\U0000094d", {768}, {2}},
     {L"\U00000300\U00000308\U0000094d", {768}, {3}},
     {L"\U00000300\U0000200d", {768}, {2}},
     {L"\U00000300\U00000308\U0000200d", {768}, {3}},
     {L"\U00000300\U00000378", {768, 888}, {1, 2}},
     {L"\U00000300\U00000308\U00000378", {768, 888}, {2, 3}},
     {L"\U00000900\U00000020", {2304, 32}, {1, 2}},
     {L"\U00000900\U00000308\U00000020", {2304, 32}, {2, 3}},
     {L"\U00000900\U0000000d", {2304, 13}, {1, 2}},
     {L"\U00000900\U00000308\U0000000d", {2304, 13}, {2, 3}},
     {L"\U00000900\U0000000a", {2304, 10}, {1, 2}},
     {L"\U00000900\U00000308\U0000000a", {2304, 10}, {2, 3}},
     {L"\U00000900\U00000001", {2304, 1}, {1, 2}},
     {L"\U00000900\U00000308\U00000001", {2304, 1}, {2, 3}},
     {L"\U00000900\U0000200c", {2304}, {2}},
     {L"\U00000900\U00000308\U0000200c", {2304}, {3}},
     {L"\U00000900\U0001f1e6", {2304, 127462}, {1, 3}},
     {L"\U00000900\U00000308\U0001f1e6", {2304, 127462}, {2, 4}},
     {L"\U00000900\U00000600", {2304, 1536}, {1, 2}},
     {L"\U00000900\U00000308\U00000600", {2304, 1536}, {2, 3}},
     {L"\U00000900\U00000a03", {2304}, {2}},
     {L"\U00000900\U00000308\U00000a03", {2304}, {3}},
     {L"\U00000900\U00001100", {2304, 4352}, {1, 2}},
     {L"\U00000900\U00000308\U00001100", {2304, 4352}, {2, 3}},
     {L"\U00000900\U00001160", {2304, 4448}, {1, 2}},
     {L"\U00000900\U00000308\U00001160", {2304, 4448}, {2, 3}},
     {L"\U00000900\U000011a8", {2304, 4520}, {1, 2}},
     {L"\U00000900\U00000308\U000011a8", {2304, 4520}, {2, 3}},
     {L"\U00000900\U0000ac00", {2304, 44032}, {1, 2}},
     {L"\U00000900\U00000308\U0000ac00", {2304, 44032}, {2, 3}},
     {L"\U00000900\U0000ac01", {2304, 44033}, {1, 2}},
     {L"\U00000900\U00000308\U0000ac01", {2304, 44033}, {2, 3}},
     {L"\U00000900\U00000903", {2304}, {2}},
     {L"\U00000900\U00000308\U00000903", {2304}, {3}},
     {L"\U00000900\U00000904", {2304, 2308}, {1, 2}},
     {L"\U00000900\U00000308\U00000904", {2304, 2308}, {2, 3}},
     {L"\U00000900\U00000d4e", {2304, 3406}, {1, 2}},
     {L"\U00000900\U00000308\U00000d4e", {2304, 3406}, {2, 3}},
     {L"\U00000900\U00000915", {2304, 2325}, {1, 2}},
     {L"\U00000900\U00000308\U00000915", {2304, 2325}, {2, 3}},
     {L"\U00000900\U0000231a", {2304, 8986}, {1, 2}},
     {L"\U00000900\U00000308\U0000231a", {2304, 8986}, {2, 3}},
     {L"\U00000900\U00000300", {2304}, {2}},
     {L"\U00000900\U00000308\U00000300", {2304}, {3}},
     {L"\U00000900\U00000900", {2304}, {2}},
     {L"\U00000900\U00000308\U00000900", {2304}, {3}},
     {L"\U00000900\U0000094d", {2304}, {2}},
     {L"\U00000900\U00000308\U0000094d", {2304}, {3}},
     {L"\U00000900\U0000200d", {2304}, {2}},
     {L"\U00000900\U00000308\U0000200d", {2304}, {3}},
     {L"\U00000900\U00000378", {2304, 888}, {1, 2}},
     {L"\U00000900\U00000308\U00000378", {2304, 888}, {2, 3}},
     {L"\U0000094d\U00000020", {2381, 32}, {1, 2}},
     {L"\U0000094d\U00000308\U00000020", {2381, 32}, {2, 3}},
     {L"\U0000094d\U0000000d", {2381, 13}, {1, 2}},
     {L"\U0000094d\U00000308\U0000000d", {2381, 13}, {2, 3}},
     {L"\U0000094d\U0000000a", {2381, 10}, {1, 2}},
     {L"\U0000094d\U00000308\U0000000a", {2381, 10}, {2, 3}},
     {L"\U0000094d\U00000001", {2381, 1}, {1, 2}},
     {L"\U0000094d\U00000308\U00000001", {2381, 1}, {2, 3}},
     {L"\U0000094d\U0000200c", {2381}, {2}},
     {L"\U0000094d\U00000308\U0000200c", {2381}, {3}},
     {L"\U0000094d\U0001f1e6", {2381, 127462}, {1, 3}},
     {L"\U0000094d\U00000308\U0001f1e6", {2381, 127462}, {2, 4}},
     {L"\U0000094d\U00000600", {2381, 1536}, {1, 2}},
     {L"\U0000094d\U00000308\U00000600", {2381, 1536}, {2, 3}},
     {L"\U0000094d\U00000a03", {2381}, {2}},
     {L"\U0000094d\U00000308\U00000a03", {2381}, {3}},
     {L"\U0000094d\U00001100", {2381, 4352}, {1, 2}},
     {L"\U0000094d\U00000308\U00001100", {2381, 4352}, {2, 3}},
     {L"\U0000094d\U00001160", {2381, 4448}, {1, 2}},
     {L"\U0000094d\U00000308\U00001160", {2381, 4448}, {2, 3}},
     {L"\U0000094d\U000011a8", {2381, 4520}, {1, 2}},
     {L"\U0000094d\U00000308\U000011a8", {2381, 4520}, {2, 3}},
     {L"\U0000094d\U0000ac00", {2381, 44032}, {1, 2}},
     {L"\U0000094d\U00000308\U0000ac00", {2381, 44032}, {2, 3}},
     {L"\U0000094d\U0000ac01", {2381, 44033}, {1, 2}},
     {L"\U0000094d\U00000308\U0000ac01", {2381, 44033}, {2, 3}},
     {L"\U0000094d\U00000903", {2381}, {2}},
     {L"\U0000094d\U00000308\U00000903", {2381}, {3}},
     {L"\U0000094d\U00000904", {2381, 2308}, {1, 2}},
     {L"\U0000094d\U00000308\U00000904", {2381, 2308}, {2, 3}},
     {L"\U0000094d\U00000d4e", {2381, 3406}, {1, 2}},
     {L"\U0000094d\U00000308\U00000d4e", {2381, 3406}, {2, 3}},
     {L"\U0000094d\U00000915", {2381, 2325}, {1, 2}},
     {L"\U0000094d\U00000308\U00000915", {2381, 2325}, {2, 3}},
     {L"\U0000094d\U0000231a", {2381, 8986}, {1, 2}},
     {L"\U0000094d\U00000308\U0000231a", {2381, 8986}, {2, 3}},
     {L"\U0000094d\U00000300", {2381}, {2}},
     {L"\U0000094d\U00000308\U00000300", {2381}, {3}},
     {L"\U0000094d\U00000900", {2381}, {2}},
     {L"\U0000094d\U00000308\U00000900", {2381}, {3}},
     {L"\U0000094d\U0000094d", {2381}, {2}},
     {L"\U0000094d\U00000308\U0000094d", {2381}, {3}},
     {L"\U0000094d\U0000200d", {2381}, {2}},
     {L"\U0000094d\U00000308\U0000200d", {2381}, {3}},
     {L"\U0000094d\U00000378", {2381, 888}, {1, 2}},
     {L"\U0000094d\U00000308\U00000378", {2381, 888}, {2, 3}},
     {L"\U0000200d\U00000020", {8205, 32}, {1, 2}},
     {L"\U0000200d\U00000308\U00000020", {8205, 32}, {2, 3}},
     {L"\U0000200d\U0000000d", {8205, 13}, {1, 2}},
     {L"\U0000200d\U00000308\U0000000d", {8205, 13}, {2, 3}},
     {L"\U0000200d\U0000000a", {8205, 10}, {1, 2}},
     {L"\U0000200d\U00000308\U0000000a", {8205, 10}, {2, 3}},
     {L"\U0000200d\U00000001", {8205, 1}, {1, 2}},
     {L"\U0000200d\U00000308\U00000001", {8205, 1}, {2, 3}},
     {L"\U0000200d\U0000200c", {8205}, {2}},
     {L"\U0000200d\U00000308\U0000200c", {8205}, {3}},
     {L"\U0000200d\U0001f1e6", {8205, 127462}, {1, 3}},
     {L"\U0000200d\U00000308\U0001f1e6", {8205, 127462}, {2, 4}},
     {L"\U0000200d\U00000600", {8205, 1536}, {1, 2}},
     {L"\U0000200d\U00000308\U00000600", {8205, 1536}, {2, 3}},
     {L"\U0000200d\U00000a03", {8205}, {2}},
     {L"\U0000200d\U00000308\U00000a03", {8205}, {3}},
     {L"\U0000200d\U00001100", {8205, 4352}, {1, 2}},
     {L"\U0000200d\U00000308\U00001100", {8205, 4352}, {2, 3}},
     {L"\U0000200d\U00001160", {8205, 4448}, {1, 2}},
     {L"\U0000200d\U00000308\U00001160", {8205, 4448}, {2, 3}},
     {L"\U0000200d\U000011a8", {8205, 4520}, {1, 2}},
     {L"\U0000200d\U00000308\U000011a8", {8205, 4520}, {2, 3}},
     {L"\U0000200d\U0000ac00", {8205, 44032}, {1, 2}},
     {L"\U0000200d\U00000308\U0000ac00", {8205, 44032}, {2, 3}},
     {L"\U0000200d\U0000ac01", {8205, 44033}, {1, 2}},
     {L"\U0000200d\U00000308\U0000ac01", {8205, 44033}, {2, 3}},
     {L"\U0000200d\U00000903", {8205}, {2}},
     {L"\U0000200d\U00000308\U00000903", {8205}, {3}},
     {L"\U0000200d\U00000904", {8205, 2308}, {1, 2}},
     {L"\U0000200d\U00000308\U00000904", {8205, 2308}, {2, 3}},
     {L"\U0000200d\U00000d4e", {8205, 3406}, {1, 2}},
     {L"\U0000200d\U00000308\U00000d4e", {8205, 3406}, {2, 3}},
     {L"\U0000200d\U00000915", {8205, 2325}, {1, 2}},
     {L"\U0000200d\U00000308\U00000915", {8205, 2325}, {2, 3}},
     {L"\U0000200d\U0000231a", {8205, 8986}, {1, 2}},
     {L"\U0000200d\U00000308\U0000231a", {8205, 8986}, {2, 3}},
     {L"\U0000200d\U00000300", {8205}, {2}},
     {L"\U0000200d\U00000308\U00000300", {8205}, {3}},
     {L"\U0000200d\U00000900", {8205}, {2}},
     {L"\U0000200d\U00000308\U00000900", {8205}, {3}},
     {L"\U0000200d\U0000094d", {8205}, {2}},
     {L"\U0000200d\U00000308\U0000094d", {8205}, {3}},
     {L"\U0000200d\U0000200d", {8205}, {2}},
     {L"\U0000200d\U00000308\U0000200d", {8205}, {3}},
     {L"\U0000200d\U00000378", {8205, 888}, {1, 2}},
     {L"\U0000200d\U00000308\U00000378", {8205, 888}, {2, 3}},
     {L"\U00000378\U00000020", {888, 32}, {1, 2}},
     {L"\U00000378\U00000308\U00000020", {888, 32}, {2, 3}},
     {L"\U00000378\U0000000d", {888, 13}, {1, 2}},
     {L"\U00000378\U00000308\U0000000d", {888, 13}, {2, 3}},
     {L"\U00000378\U0000000a", {888, 10}, {1, 2}},
     {L"\U00000378\U00000308\U0000000a", {888, 10}, {2, 3}},
     {L"\U00000378\U00000001", {888, 1}, {1, 2}},
     {L"\U00000378\U00000308\U00000001", {888, 1}, {2, 3}},
     {L"\U00000378\U0000200c", {888}, {2}},
     {L"\U00000378\U00000308\U0000200c", {888}, {3}},
     {L"\U00000378\U0001f1e6", {888, 127462}, {1, 3}},
     {L"\U00000378\U00000308\U0001f1e6", {888, 127462}, {2, 4}},
     {L"\U00000378\U00000600", {888, 1536}, {1, 2}},
     {L"\U00000378\U00000308\U00000600", {888, 1536}, {2, 3}},
     {L"\U00000378\U00000a03", {888}, {2}},
     {L"\U00000378\U00000308\U00000a03", {888}, {3}},
     {L"\U00000378\U00001100", {888, 4352}, {1, 2}},
     {L"\U00000378\U00000308\U00001100", {888, 4352}, {2, 3}},
     {L"\U00000378\U00001160", {888, 4448}, {1, 2}},
     {L"\U00000378\U00000308\U00001160", {888, 4448}, {2, 3}},
     {L"\U00000378\U000011a8", {888, 4520}, {1, 2}},
     {L"\U00000378\U00000308\U000011a8", {888, 4520}, {2, 3}},
     {L"\U00000378\U0000ac00", {888, 44032}, {1, 2}},
     {L"\U00000378\U00000308\U0000ac00", {888, 44032}, {2, 3}},
     {L"\U00000378\U0000ac01", {888, 44033}, {1, 2}},
     {L"\U00000378\U00000308\U0000ac01", {888, 44033}, {2, 3}},
     {L"\U00000378\U00000903", {888}, {2}},
     {L"\U00000378\U00000308\U00000903", {888}, {3}},
     {L"\U00000378\U00000904", {888, 2308}, {1, 2}},
     {L"\U00000378\U00000308\U00000904", {888, 2308}, {2, 3}},
     {L"\U00000378\U00000d4e", {888, 3406}, {1, 2}},
     {L"\U00000378\U00000308\U00000d4e", {888, 3406}, {2, 3}},
     {L"\U00000378\U00000915", {888, 2325}, {1, 2}},
     {L"\U00000378\U00000308\U00000915", {888, 2325}, {2, 3}},
     {L"\U00000378\U0000231a", {888, 8986}, {1, 2}},
     {L"\U00000378\U00000308\U0000231a", {888, 8986}, {2, 3}},
     {L"\U00000378\U00000300", {888}, {2}},
     {L"\U00000378\U00000308\U00000300", {888}, {3}},
     {L"\U00000378\U00000900", {888}, {2}},
     {L"\U00000378\U00000308\U00000900", {888}, {3}},
     {L"\U00000378\U0000094d", {888}, {2}},
     {L"\U00000378\U00000308\U0000094d", {888}, {3}},
     {L"\U00000378\U0000200d", {888}, {2}},
     {L"\U00000378\U00000308\U0000200d", {888}, {3}},
     {L"\U00000378\U00000378", {888, 888}, {1, 2}},
     {L"\U00000378\U00000308\U00000378", {888, 888}, {2, 3}},
     {L"\U0000000d\U0000000a\U00000061\U0000000a\U00000308", {13, 97, 10, 776}, {2, 3, 4, 5}},
     {L"\U00000061\U00000308", {97}, {2}},
     {L"\U00000020\U0000200d\U00000646", {32, 1606}, {2, 3}},
     {L"\U00000646\U0000200d\U00000020", {1606, 32}, {2, 3}},
     {L"\U00001100\U00001100", {4352}, {2}},
     {L"\U0000ac00\U000011a8\U00001100", {44032, 4352}, {2, 3}},
     {L"\U0000ac01\U000011a8\U00001100", {44033, 4352}, {2, 3}},
     {L"\U0001f1e6\U0001f1e7\U0001f1e8\U00000062", {127462, 127464, 98}, {4, 6, 7}},
     {L"\U00000061\U0001f1e6\U0001f1e7\U0001f1e8\U00000062", {97, 127462, 127464, 98}, {1, 5, 7, 8}},
     {L"\U00000061\U0001f1e6\U0001f1e7\U0000200d\U0001f1e8\U00000062", {97, 127462, 127464, 98}, {1, 6, 8, 9}},
     {L"\U00000061\U0001f1e6\U0000200d\U0001f1e7\U0001f1e8\U00000062", {97, 127462, 127463, 98}, {1, 4, 8, 9}},
     {L"\U00000061\U0001f1e6\U0001f1e7\U0001f1e8\U0001f1e9\U00000062", {97, 127462, 127464, 98}, {1, 5, 9, 10}},
     {L"\U00000061\U0000200d", {97}, {2}},
     {L"\U00000061\U00000308\U00000062", {97, 98}, {2, 3}},
     {L"\U00000061\U00000903\U00000062", {97, 98}, {2, 3}},
     {L"\U00000061\U00000600\U00000062", {97, 1536}, {1, 3}},
     {L"\U0001f476\U0001f3ff\U0001f476", {128118, 128118}, {4, 6}},
     {L"\U00000061\U0001f3ff\U0001f476", {97, 128118}, {3, 5}},
     {L"\U00000061\U0001f3ff\U0001f476\U0000200d\U0001f6d1", {97, 128118}, {3, 8}},
     {L"\U0001f476\U0001f3ff\U00000308\U0000200d\U0001f476\U0001f3ff", {128118}, {10}},
     {L"\U0001f6d1\U0000200d\U0001f6d1", {128721}, {5}},
     {L"\U00000061\U0000200d\U0001f6d1", {97, 128721}, {2, 4}},
     {L"\U00002701\U0000200d\U00002701", {9985}, {3}},
     {L"\U00000061\U0000200d\U00002701", {97, 9985}, {2, 3}},
     {L"\U00000915\U00000924", {2325, 2340}, {1, 2}},
     {L"\U00000915\U0000094d\U00000924", {2325}, {3}},
     {L"\U00000915\U0000094d\U0000094d\U00000924", {2325}, {4}},
     {L"\U00000915\U0000094d\U0000200d\U00000924", {2325}, {4}},
     {L"\U00000915\U0000093c\U0000200d\U0000094d\U00000924", {2325}, {5}},
     {L"\U00000915\U0000093c\U0000094d\U0000200d\U00000924", {2325}, {5}},
     {L"\U00000915\U0000094d\U00000924\U0000094d\U0000092f", {2325}, {5}},
     {L"\U00000915\U0000094d\U00000061", {2325, 97}, {2, 3}},
     {L"\U00000061\U0000094d\U00000924", {97, 2340}, {2, 3}},
     {L"\U0000003f\U0000094d\U00000924", {63, 2340}, {2, 3}},
     {L"\U00000915\U0000094d\U0000094d\U00000924", {2325}, {4}}}};

/// The data for UTF-8.
///
/// Note that most of the data for the UTF-16 and UTF-32 are identical. However
/// since the size of the code units differ the breaks can contain different
/// values.
std::array<data<wchar_t>, 1093> data_utf32 = {{
     {L"\U00000020\U00000020", {32, 32}, {1, 2}},
     {L"\U00000020\U00000308\U00000020", {32, 32}, {2, 3}},
     {L"\U00000020\U0000000d", {32, 13}, {1, 2}},
     {L"\U00000020\U00000308\U0000000d", {32, 13}, {2, 3}},
     {L"\U00000020\U0000000a", {32, 10}, {1, 2}},
     {L"\U00000020\U00000308\U0000000a", {32, 10}, {2, 3}},
     {L"\U00000020\U00000001", {32, 1}, {1, 2}},
     {L"\U00000020\U00000308\U00000001", {32, 1}, {2, 3}},
     {L"\U00000020\U0000200c", {32}, {2}},
     {L"\U00000020\U00000308\U0000200c", {32}, {3}},
     {L"\U00000020\U0001f1e6", {32, 127462}, {1, 2}},
     {L"\U00000020\U00000308\U0001f1e6", {32, 127462}, {2, 3}},
     {L"\U00000020\U00000600", {32, 1536}, {1, 2}},
     {L"\U00000020\U00000308\U00000600", {32, 1536}, {2, 3}},
     {L"\U00000020\U00000a03", {32}, {2}},
     {L"\U00000020\U00000308\U00000a03", {32}, {3}},
     {L"\U00000020\U00001100", {32, 4352}, {1, 2}},
     {L"\U00000020\U00000308\U00001100", {32, 4352}, {2, 3}},
     {L"\U00000020\U00001160", {32, 4448}, {1, 2}},
     {L"\U00000020\U00000308\U00001160", {32, 4448}, {2, 3}},
     {L"\U00000020\U000011a8", {32, 4520}, {1, 2}},
     {L"\U00000020\U00000308\U000011a8", {32, 4520}, {2, 3}},
     {L"\U00000020\U0000ac00", {32, 44032}, {1, 2}},
     {L"\U00000020\U00000308\U0000ac00", {32, 44032}, {2, 3}},
     {L"\U00000020\U0000ac01", {32, 44033}, {1, 2}},
     {L"\U00000020\U00000308\U0000ac01", {32, 44033}, {2, 3}},
     {L"\U00000020\U00000903", {32}, {2}},
     {L"\U00000020\U00000308\U00000903", {32}, {3}},
     {L"\U00000020\U00000904", {32, 2308}, {1, 2}},
     {L"\U00000020\U00000308\U00000904", {32, 2308}, {2, 3}},
     {L"\U00000020\U00000d4e", {32, 3406}, {1, 2}},
     {L"\U00000020\U00000308\U00000d4e", {32, 3406}, {2, 3}},
     {L"\U00000020\U00000915", {32, 2325}, {1, 2}},
     {L"\U00000020\U00000308\U00000915", {32, 2325}, {2, 3}},
     {L"\U00000020\U0000231a", {32, 8986}, {1, 2}},
     {L"\U00000020\U00000308\U0000231a", {32, 8986}, {2, 3}},
     {L"\U00000020\U00000300", {32}, {2}},
     {L"\U00000020\U00000308\U00000300", {32}, {3}},
     {L"\U00000020\U00000900", {32}, {2}},
     {L"\U00000020\U00000308\U00000900", {32}, {3}},
     {L"\U00000020\U0000094d", {32}, {2}},
     {L"\U00000020\U00000308\U0000094d", {32}, {3}},
     {L"\U00000020\U0000200d", {32}, {2}},
     {L"\U00000020\U00000308\U0000200d", {32}, {3}},
     {L"\U00000020\U00000378", {32, 888}, {1, 2}},
     {L"\U00000020\U00000308\U00000378", {32, 888}, {2, 3}},
     {L"\U0000000d\U00000020", {13, 32}, {1, 2}},
     {L"\U0000000d\U00000308\U00000020", {13, 776, 32}, {1, 2, 3}},
     {L"\U0000000d\U0000000d", {13, 13}, {1, 2}},
     {L"\U0000000d\U00000308\U0000000d", {13, 776, 13}, {1, 2, 3}},
     {L"\U0000000d\U0000000a", {13}, {2}},
     {L"\U0000000d\U00000308\U0000000a", {13, 776, 10}, {1, 2, 3}},
     {L"\U0000000d\U00000001", {13, 1}, {1, 2}},
     {L"\U0000000d\U00000308\U00000001", {13, 776, 1}, {1, 2, 3}},
     {L"\U0000000d\U0000200c", {13, 8204}, {1, 2}},
     {L"\U0000000d\U00000308\U0000200c", {13, 776}, {1, 3}},
     {L"\U0000000d\U0001f1e6", {13, 127462}, {1, 2}},
     {L"\U0000000d\U00000308\U0001f1e6", {13, 776, 127462}, {1, 2, 3}},
     {L"\U0000000d\U00000600", {13, 1536}, {1, 2}},
     {L"\U0000000d\U00000308\U00000600", {13, 776, 1536}, {1, 2, 3}},
     {L"\U0000000d\U00000a03", {13, 2563}, {1, 2}},
     {L"\U0000000d\U00000308\U00000a03", {13, 776}, {1, 3}},
     {L"\U0000000d\U00001100", {13, 4352}, {1, 2}},
     {L"\U0000000d\U00000308\U00001100", {13, 776, 4352}, {1, 2, 3}},
     {L"\U0000000d\U00001160", {13, 4448}, {1, 2}},
     {L"\U0000000d\U00000308\U00001160", {13, 776, 4448}, {1, 2, 3}},
     {L"\U0000000d\U000011a8", {13, 4520}, {1, 2}},
     {L"\U0000000d\U00000308\U000011a8", {13, 776, 4520}, {1, 2, 3}},
     {L"\U0000000d\U0000ac00", {13, 44032}, {1, 2}},
     {L"\U0000000d\U00000308\U0000ac00", {13, 776, 44032}, {1, 2, 3}},
     {L"\U0000000d\U0000ac01", {13, 44033}, {1, 2}},
     {L"\U0000000d\U00000308\U0000ac01", {13, 776, 44033}, {1, 2, 3}},
     {L"\U0000000d\U00000903", {13, 2307}, {1, 2}},
     {L"\U0000000d\U00000308\U00000903", {13, 776}, {1, 3}},
     {L"\U0000000d\U00000904", {13, 2308}, {1, 2}},
     {L"\U0000000d\U00000308\U00000904", {13, 776, 2308}, {1, 2, 3}},
     {L"\U0000000d\U00000d4e", {13, 3406}, {1, 2}},
     {L"\U0000000d\U00000308\U00000d4e", {13, 776, 3406}, {1, 2, 3}},
     {L"\U0000000d\U00000915", {13, 2325}, {1, 2}},
     {L"\U0000000d\U00000308\U00000915", {13, 776, 2325}, {1, 2, 3}},
     {L"\U0000000d\U0000231a", {13, 8986}, {1, 2}},
     {L"\U0000000d\U00000308\U0000231a", {13, 776, 8986}, {1, 2, 3}},
     {L"\U0000000d\U00000300", {13, 768}, {1, 2}},
     {L"\U0000000d\U00000308\U00000300", {13, 776}, {1, 3}},
     {L"\U0000000d\U00000900", {13, 2304}, {1, 2}},
     {L"\U0000000d\U00000308\U00000900", {13, 776}, {1, 3}},
     {L"\U0000000d\U0000094d", {13, 2381}, {1, 2}},
     {L"\U0000000d\U00000308\U0000094d", {13, 776}, {1, 3}},
     {L"\U0000000d\U0000200d", {13, 8205}, {1, 2}},
     {L"\U0000000d\U00000308\U0000200d", {13, 776}, {1, 3}},
     {L"\U0000000d\U00000378", {13, 888}, {1, 2}},
     {L"\U0000000d\U00000308\U00000378", {13, 776, 888}, {1, 2, 3}},
     {L"\U0000000a\U00000020", {10, 32}, {1, 2}},
     {L"\U0000000a\U00000308\U00000020", {10, 776, 32}, {1, 2, 3}},
     {L"\U0000000a\U0000000d", {10, 13}, {1, 2}},
     {L"\U0000000a\U00000308\U0000000d", {10, 776, 13}, {1, 2, 3}},
     {L"\U0000000a\U0000000a", {10, 10}, {1, 2}},
     {L"\U0000000a\U00000308\U0000000a", {10, 776, 10}, {1, 2, 3}},
     {L"\U0000000a\U00000001", {10, 1}, {1, 2}},
     {L"\U0000000a\U00000308\U00000001", {10, 776, 1}, {1, 2, 3}},
     {L"\U0000000a\U0000200c", {10, 8204}, {1, 2}},
     {L"\U0000000a\U00000308\U0000200c", {10, 776}, {1, 3}},
     {L"\U0000000a\U0001f1e6", {10, 127462}, {1, 2}},
     {L"\U0000000a\U00000308\U0001f1e6", {10, 776, 127462}, {1, 2, 3}},
     {L"\U0000000a\U00000600", {10, 1536}, {1, 2}},
     {L"\U0000000a\U00000308\U00000600", {10, 776, 1536}, {1, 2, 3}},
     {L"\U0000000a\U00000a03", {10, 2563}, {1, 2}},
     {L"\U0000000a\U00000308\U00000a03", {10, 776}, {1, 3}},
     {L"\U0000000a\U00001100", {10, 4352}, {1, 2}},
     {L"\U0000000a\U00000308\U00001100", {10, 776, 4352}, {1, 2, 3}},
     {L"\U0000000a\U00001160", {10, 4448}, {1, 2}},
     {L"\U0000000a\U00000308\U00001160", {10, 776, 4448}, {1, 2, 3}},
     {L"\U0000000a\U000011a8", {10, 4520}, {1, 2}},
     {L"\U0000000a\U00000308\U000011a8", {10, 776, 4520}, {1, 2, 3}},
     {L"\U0000000a\U0000ac00", {10, 44032}, {1, 2}},
     {L"\U0000000a\U00000308\U0000ac00", {10, 776, 44032}, {1, 2, 3}},
     {L"\U0000000a\U0000ac01", {10, 44033}, {1, 2}},
     {L"\U0000000a\U00000308\U0000ac01", {10, 776, 44033}, {1, 2, 3}},
     {L"\U0000000a\U00000903", {10, 2307}, {1, 2}},
     {L"\U0000000a\U00000308\U00000903", {10, 776}, {1, 3}},
     {L"\U0000000a\U00000904", {10, 2308}, {1, 2}},
     {L"\U0000000a\U00000308\U00000904", {10, 776, 2308}, {1, 2, 3}},
     {L"\U0000000a\U00000d4e", {10, 3406}, {1, 2}},
     {L"\U0000000a\U00000308\U00000d4e", {10, 776, 3406}, {1, 2, 3}},
     {L"\U0000000a\U00000915", {10, 2325}, {1, 2}},
     {L"\U0000000a\U00000308\U00000915", {10, 776, 2325}, {1, 2, 3}},
     {L"\U0000000a\U0000231a", {10, 8986}, {1, 2}},
     {L"\U0000000a\U00000308\U0000231a", {10, 776, 8986}, {1, 2, 3}},
     {L"\U0000000a\U00000300", {10, 768}, {1, 2}},
     {L"\U0000000a\U00000308\U00000300", {10, 776}, {1, 3}},
     {L"\U0000000a\U00000900", {10, 2304}, {1, 2}},
     {L"\U0000000a\U00000308\U00000900", {10, 776}, {1, 3}},
     {L"\U0000000a\U0000094d", {10, 2381}, {1, 2}},
     {L"\U0000000a\U00000308\U0000094d", {10, 776}, {1, 3}},
     {L"\U0000000a\U0000200d", {10, 8205}, {1, 2}},
     {L"\U0000000a\U00000308\U0000200d", {10, 776}, {1, 3}},
     {L"\U0000000a\U00000378", {10, 888}, {1, 2}},
     {L"\U0000000a\U00000308\U00000378", {10, 776, 888}, {1, 2, 3}},
     {L"\U00000001\U00000020", {1, 32}, {1, 2}},
     {L"\U00000001\U00000308\U00000020", {1, 776, 32}, {1, 2, 3}},
     {L"\U00000001\U0000000d", {1, 13}, {1, 2}},
     {L"\U00000001\U00000308\U0000000d", {1, 776, 13}, {1, 2, 3}},
     {L"\U00000001\U0000000a", {1, 10}, {1, 2}},
     {L"\U00000001\U00000308\U0000000a", {1, 776, 10}, {1, 2, 3}},
     {L"\U00000001\U00000001", {1, 1}, {1, 2}},
     {L"\U00000001\U00000308\U00000001", {1, 776, 1}, {1, 2, 3}},
     {L"\U00000001\U0000200c", {1, 8204}, {1, 2}},
     {L"\U00000001\U00000308\U0000200c", {1, 776}, {1, 3}},
     {L"\U00000001\U0001f1e6", {1, 127462}, {1, 2}},
     {L"\U00000001\U00000308\U0001f1e6", {1, 776, 127462}, {1, 2, 3}},
     {L"\U00000001\U00000600", {1, 1536}, {1, 2}},
     {L"\U00000001\U00000308\U00000600", {1, 776, 1536}, {1, 2, 3}},
     {L"\U00000001\U00000a03", {1, 2563}, {1, 2}},
     {L"\U00000001\U00000308\U00000a03", {1, 776}, {1, 3}},
     {L"\U00000001\U00001100", {1, 4352}, {1, 2}},
     {L"\U00000001\U00000308\U00001100", {1, 776, 4352}, {1, 2, 3}},
     {L"\U00000001\U00001160", {1, 4448}, {1, 2}},
     {L"\U00000001\U00000308\U00001160", {1, 776, 4448}, {1, 2, 3}},
     {L"\U00000001\U000011a8", {1, 4520}, {1, 2}},
     {L"\U00000001\U00000308\U000011a8", {1, 776, 4520}, {1, 2, 3}},
     {L"\U00000001\U0000ac00", {1, 44032}, {1, 2}},
     {L"\U00000001\U00000308\U0000ac00", {1, 776, 44032}, {1, 2, 3}},
     {L"\U00000001\U0000ac01", {1, 44033}, {1, 2}},
     {L"\U00000001\U00000308\U0000ac01", {1, 776, 44033}, {1, 2, 3}},
     {L"\U00000001\U00000903", {1, 2307}, {1, 2}},
     {L"\U00000001\U00000308\U00000903", {1, 776}, {1, 3}},
     {L"\U00000001\U00000904", {1, 2308}, {1, 2}},
     {L"\U00000001\U00000308\U00000904", {1, 776, 2308}, {1, 2, 3}},
     {L"\U00000001\U00000d4e", {1, 3406}, {1, 2}},
     {L"\U00000001\U00000308\U00000d4e", {1, 776, 3406}, {1, 2, 3}},
     {L"\U00000001\U00000915", {1, 2325}, {1, 2}},
     {L"\U00000001\U00000308\U00000915", {1, 776, 2325}, {1, 2, 3}},
     {L"\U00000001\U0000231a", {1, 8986}, {1, 2}},
     {L"\U00000001\U00000308\U0000231a", {1, 776, 8986}, {1, 2, 3}},
     {L"\U00000001\U00000300", {1, 768}, {1, 2}},
     {L"\U00000001\U00000308\U00000300", {1, 776}, {1, 3}},
     {L"\U00000001\U00000900", {1, 2304}, {1, 2}},
     {L"\U00000001\U00000308\U00000900", {1, 776}, {1, 3}},
     {L"\U00000001\U0000094d", {1, 2381}, {1, 2}},
     {L"\U00000001\U00000308\U0000094d", {1, 776}, {1, 3}},
     {L"\U00000001\U0000200d", {1, 8205}, {1, 2}},
     {L"\U00000001\U00000308\U0000200d", {1, 776}, {1, 3}},
     {L"\U00000001\U00000378", {1, 888}, {1, 2}},
     {L"\U00000001\U00000308\U00000378", {1, 776, 888}, {1, 2, 3}},
     {L"\U0000200c\U00000020", {8204, 32}, {1, 2}},
     {L"\U0000200c\U00000308\U00000020", {8204, 32}, {2, 3}},
     {L"\U0000200c\U0000000d", {8204, 13}, {1, 2}},
     {L"\U0000200c\U00000308\U0000000d", {8204, 13}, {2, 3}},
     {L"\U0000200c\U0000000a", {8204, 10}, {1, 2}},
     {L"\U0000200c\U00000308\U0000000a", {8204, 10}, {2, 3}},
     {L"\U0000200c\U00000001", {8204, 1}, {1, 2}},
     {L"\U0000200c\U00000308\U00000001", {8204, 1}, {2, 3}},
     {L"\U0000200c\U0000200c", {8204}, {2}},
     {L"\U0000200c\U00000308\U0000200c", {8204}, {3}},
     {L"\U0000200c\U0001f1e6", {8204, 127462}, {1, 2}},
     {L"\U0000200c\U00000308\U0001f1e6", {8204, 127462}, {2, 3}},
     {L"\U0000200c\U00000600", {8204, 1536}, {1, 2}},
     {L"\U0000200c\U00000308\U00000600", {8204, 1536}, {2, 3}},
     {L"\U0000200c\U00000a03", {8204}, {2}},
     {L"\U0000200c\U00000308\U00000a03", {8204}, {3}},
     {L"\U0000200c\U00001100", {8204, 4352}, {1, 2}},
     {L"\U0000200c\U00000308\U00001100", {8204, 4352}, {2, 3}},
     {L"\U0000200c\U00001160", {8204, 4448}, {1, 2}},
     {L"\U0000200c\U00000308\U00001160", {8204, 4448}, {2, 3}},
     {L"\U0000200c\U000011a8", {8204, 4520}, {1, 2}},
     {L"\U0000200c\U00000308\U000011a8", {8204, 4520}, {2, 3}},
     {L"\U0000200c\U0000ac00", {8204, 44032}, {1, 2}},
     {L"\U0000200c\U00000308\U0000ac00", {8204, 44032}, {2, 3}},
     {L"\U0000200c\U0000ac01", {8204, 44033}, {1, 2}},
     {L"\U0000200c\U00000308\U0000ac01", {8204, 44033}, {2, 3}},
     {L"\U0000200c\U00000903", {8204}, {2}},
     {L"\U0000200c\U00000308\U00000903", {8204}, {3}},
     {L"\U0000200c\U00000904", {8204, 2308}, {1, 2}},
     {L"\U0000200c\U00000308\U00000904", {8204, 2308}, {2, 3}},
     {L"\U0000200c\U00000d4e", {8204, 3406}, {1, 2}},
     {L"\U0000200c\U00000308\U00000d4e", {8204, 3406}, {2, 3}},
     {L"\U0000200c\U00000915", {8204, 2325}, {1, 2}},
     {L"\U0000200c\U00000308\U00000915", {8204, 2325}, {2, 3}},
     {L"\U0000200c\U0000231a", {8204, 8986}, {1, 2}},
     {L"\U0000200c\U00000308\U0000231a", {8204, 8986}, {2, 3}},
     {L"\U0000200c\U00000300", {8204}, {2}},
     {L"\U0000200c\U00000308\U00000300", {8204}, {3}},
     {L"\U0000200c\U00000900", {8204}, {2}},
     {L"\U0000200c\U00000308\U00000900", {8204}, {3}},
     {L"\U0000200c\U0000094d", {8204}, {2}},
     {L"\U0000200c\U00000308\U0000094d", {8204}, {3}},
     {L"\U0000200c\U0000200d", {8204}, {2}},
     {L"\U0000200c\U00000308\U0000200d", {8204}, {3}},
     {L"\U0000200c\U00000378", {8204, 888}, {1, 2}},
     {L"\U0000200c\U00000308\U00000378", {8204, 888}, {2, 3}},
     {L"\U0001f1e6\U00000020", {127462, 32}, {1, 2}},
     {L"\U0001f1e6\U00000308\U00000020", {127462, 32}, {2, 3}},
     {L"\U0001f1e6\U0000000d", {127462, 13}, {1, 2}},
     {L"\U0001f1e6\U00000308\U0000000d", {127462, 13}, {2, 3}},
     {L"\U0001f1e6\U0000000a", {127462, 10}, {1, 2}},
     {L"\U0001f1e6\U00000308\U0000000a", {127462, 10}, {2, 3}},
     {L"\U0001f1e6\U00000001", {127462, 1}, {1, 2}},
     {L"\U0001f1e6\U00000308\U00000001", {127462, 1}, {2, 3}},
     {L"\U0001f1e6\U0000200c", {127462}, {2}},
     {L"\U0001f1e6\U00000308\U0000200c", {127462}, {3}},
     {L"\U0001f1e6\U0001f1e6", {127462}, {2}},
     {L"\U0001f1e6\U00000308\U0001f1e6", {127462, 127462}, {2, 3}},
     {L"\U0001f1e6\U00000600", {127462, 1536}, {1, 2}},
     {L"\U0001f1e6\U00000308\U00000600", {127462, 1536}, {2, 3}},
     {L"\U0001f1e6\U00000a03", {127462}, {2}},
     {L"\U0001f1e6\U00000308\U00000a03", {127462}, {3}},
     {L"\U0001f1e6\U00001100", {127462, 4352}, {1, 2}},
     {L"\U0001f1e6\U00000308\U00001100", {127462, 4352}, {2, 3}},
     {L"\U0001f1e6\U00001160", {127462, 4448}, {1, 2}},
     {L"\U0001f1e6\U00000308\U00001160", {127462, 4448}, {2, 3}},
     {L"\U0001f1e6\U000011a8", {127462, 4520}, {1, 2}},
     {L"\U0001f1e6\U00000308\U000011a8", {127462, 4520}, {2, 3}},
     {L"\U0001f1e6\U0000ac00", {127462, 44032}, {1, 2}},
     {L"\U0001f1e6\U00000308\U0000ac00", {127462, 44032}, {2, 3}},
     {L"\U0001f1e6\U0000ac01", {127462, 44033}, {1, 2}},
     {L"\U0001f1e6\U00000308\U0000ac01", {127462, 44033}, {2, 3}},
     {L"\U0001f1e6\U00000903", {127462}, {2}},
     {L"\U0001f1e6\U00000308\U00000903", {127462}, {3}},
     {L"\U0001f1e6\U00000904", {127462, 2308}, {1, 2}},
     {L"\U0001f1e6\U00000308\U00000904", {127462, 2308}, {2, 3}},
     {L"\U0001f1e6\U00000d4e", {127462, 3406}, {1, 2}},
     {L"\U0001f1e6\U00000308\U00000d4e", {127462, 3406}, {2, 3}},
     {L"\U0001f1e6\U00000915", {127462, 2325}, {1, 2}},
     {L"\U0001f1e6\U00000308\U00000915", {127462, 2325}, {2, 3}},
     {L"\U0001f1e6\U0000231a", {127462, 8986}, {1, 2}},
     {L"\U0001f1e6\U00000308\U0000231a", {127462, 8986}, {2, 3}},
     {L"\U0001f1e6\U00000300", {127462}, {2}},
     {L"\U0001f1e6\U00000308\U00000300", {127462}, {3}},
     {L"\U0001f1e6\U00000900", {127462}, {2}},
     {L"\U0001f1e6\U00000308\U00000900", {127462}, {3}},
     {L"\U0001f1e6\U0000094d", {127462}, {2}},
     {L"\U0001f1e6\U00000308\U0000094d", {127462}, {3}},
     {L"\U0001f1e6\U0000200d", {127462}, {2}},
     {L"\U0001f1e6\U00000308\U0000200d", {127462}, {3}},
     {L"\U0001f1e6\U00000378", {127462, 888}, {1, 2}},
     {L"\U0001f1e6\U00000308\U00000378", {127462, 888}, {2, 3}},
     {L"\U00000600\U00000020", {1536}, {2}},
     {L"\U00000600\U00000308\U00000020", {1536, 32}, {2, 3}},
     {L"\U00000600\U0000000d", {1536, 13}, {1, 2}},
     {L"\U00000600\U00000308\U0000000d", {1536, 13}, {2, 3}},
     {L"\U00000600\U0000000a", {1536, 10}, {1, 2}},
     {L"\U00000600\U00000308\U0000000a", {1536, 10}, {2, 3}},
     {L"\U00000600\U00000001", {1536, 1}, {1, 2}},
     {L"\U00000600\U00000308\U00000001", {1536, 1}, {2, 3}},
     {L"\U00000600\U0000200c", {1536}, {2}},
     {L"\U00000600\U00000308\U0000200c", {1536}, {3}},
     {L"\U00000600\U0001f1e6", {1536}, {2}},
     {L"\U00000600\U00000308\U0001f1e6", {1536, 127462}, {2, 3}},
     {L"\U00000600\U00000600", {1536}, {2}},
     {L"\U00000600\U00000308\U00000600", {1536, 1536}, {2, 3}},
     {L"\U00000600\U00000a03", {1536}, {2}},
     {L"\U00000600\U00000308\U00000a03", {1536}, {3}},
     {L"\U00000600\U00001100", {1536}, {2}},
     {L"\U00000600\U00000308\U00001100", {1536, 4352}, {2, 3}},
     {L"\U00000600\U00001160", {1536}, {2}},
     {L"\U00000600\U00000308\U00001160", {1536, 4448}, {2, 3}},
     {L"\U00000600\U000011a8", {1536}, {2}},
     {L"\U00000600\U00000308\U000011a8", {1536, 4520}, {2, 3}},
     {L"\U00000600\U0000ac00", {1536}, {2}},
     {L"\U00000600\U00000308\U0000ac00", {1536, 44032}, {2, 3}},
     {L"\U00000600\U0000ac01", {1536}, {2}},
     {L"\U00000600\U00000308\U0000ac01", {1536, 44033}, {2, 3}},
     {L"\U00000600\U00000903", {1536}, {2}},
     {L"\U00000600\U00000308\U00000903", {1536}, {3}},
     {L"\U00000600\U00000904", {1536}, {2}},
     {L"\U00000600\U00000308\U00000904", {1536, 2308}, {2, 3}},
     {L"\U00000600\U00000d4e", {1536}, {2}},
     {L"\U00000600\U00000308\U00000d4e", {1536, 3406}, {2, 3}},
     {L"\U00000600\U00000915", {1536}, {2}},
     {L"\U00000600\U00000308\U00000915", {1536, 2325}, {2, 3}},
     {L"\U00000600\U0000231a", {1536}, {2}},
     {L"\U00000600\U00000308\U0000231a", {1536, 8986}, {2, 3}},
     {L"\U00000600\U00000300", {1536}, {2}},
     {L"\U00000600\U00000308\U00000300", {1536}, {3}},
     {L"\U00000600\U00000900", {1536}, {2}},
     {L"\U00000600\U00000308\U00000900", {1536}, {3}},
     {L"\U00000600\U0000094d", {1536}, {2}},
     {L"\U00000600\U00000308\U0000094d", {1536}, {3}},
     {L"\U00000600\U0000200d", {1536}, {2}},
     {L"\U00000600\U00000308\U0000200d", {1536}, {3}},
     {L"\U00000600\U00000378", {1536}, {2}},
     {L"\U00000600\U00000308\U00000378", {1536, 888}, {2, 3}},
     {L"\U00000a03\U00000020", {2563, 32}, {1, 2}},
     {L"\U00000a03\U00000308\U00000020", {2563, 32}, {2, 3}},
     {L"\U00000a03\U0000000d", {2563, 13}, {1, 2}},
     {L"\U00000a03\U00000308\U0000000d", {2563, 13}, {2, 3}},
     {L"\U00000a03\U0000000a", {2563, 10}, {1, 2}},
     {L"\U00000a03\U00000308\U0000000a", {2563, 10}, {2, 3}},
     {L"\U00000a03\U00000001", {2563, 1}, {1, 2}},
     {L"\U00000a03\U00000308\U00000001", {2563, 1}, {2, 3}},
     {L"\U00000a03\U0000200c", {2563}, {2}},
     {L"\U00000a03\U00000308\U0000200c", {2563}, {3}},
     {L"\U00000a03\U0001f1e6", {2563, 127462}, {1, 2}},
     {L"\U00000a03\U00000308\U0001f1e6", {2563, 127462}, {2, 3}},
     {L"\U00000a03\U00000600", {2563, 1536}, {1, 2}},
     {L"\U00000a03\U00000308\U00000600", {2563, 1536}, {2, 3}},
     {L"\U00000a03\U00000a03", {2563}, {2}},
     {L"\U00000a03\U00000308\U00000a03", {2563}, {3}},
     {L"\U00000a03\U00001100", {2563, 4352}, {1, 2}},
     {L"\U00000a03\U00000308\U00001100", {2563, 4352}, {2, 3}},
     {L"\U00000a03\U00001160", {2563, 4448}, {1, 2}},
     {L"\U00000a03\U00000308\U00001160", {2563, 4448}, {2, 3}},
     {L"\U00000a03\U000011a8", {2563, 4520}, {1, 2}},
     {L"\U00000a03\U00000308\U000011a8", {2563, 4520}, {2, 3}},
     {L"\U00000a03\U0000ac00", {2563, 44032}, {1, 2}},
     {L"\U00000a03\U00000308\U0000ac00", {2563, 44032}, {2, 3}},
     {L"\U00000a03\U0000ac01", {2563, 44033}, {1, 2}},
     {L"\U00000a03\U00000308\U0000ac01", {2563, 44033}, {2, 3}},
     {L"\U00000a03\U00000903", {2563}, {2}},
     {L"\U00000a03\U00000308\U00000903", {2563}, {3}},
     {L"\U00000a03\U00000904", {2563, 2308}, {1, 2}},
     {L"\U00000a03\U00000308\U00000904", {2563, 2308}, {2, 3}},
     {L"\U00000a03\U00000d4e", {2563, 3406}, {1, 2}},
     {L"\U00000a03\U00000308\U00000d4e", {2563, 3406}, {2, 3}},
     {L"\U00000a03\U00000915", {2563, 2325}, {1, 2}},
     {L"\U00000a03\U00000308\U00000915", {2563, 2325}, {2, 3}},
     {L"\U00000a03\U0000231a", {2563, 8986}, {1, 2}},
     {L"\U00000a03\U00000308\U0000231a", {2563, 8986}, {2, 3}},
     {L"\U00000a03\U00000300", {2563}, {2}},
     {L"\U00000a03\U00000308\U00000300", {2563}, {3}},
     {L"\U00000a03\U00000900", {2563}, {2}},
     {L"\U00000a03\U00000308\U00000900", {2563}, {3}},
     {L"\U00000a03\U0000094d", {2563}, {2}},
     {L"\U00000a03\U00000308\U0000094d", {2563}, {3}},
     {L"\U00000a03\U0000200d", {2563}, {2}},
     {L"\U00000a03\U00000308\U0000200d", {2563}, {3}},
     {L"\U00000a03\U00000378", {2563, 888}, {1, 2}},
     {L"\U00000a03\U00000308\U00000378", {2563, 888}, {2, 3}},
     {L"\U00001100\U00000020", {4352, 32}, {1, 2}},
     {L"\U00001100\U00000308\U00000020", {4352, 32}, {2, 3}},
     {L"\U00001100\U0000000d", {4352, 13}, {1, 2}},
     {L"\U00001100\U00000308\U0000000d", {4352, 13}, {2, 3}},
     {L"\U00001100\U0000000a", {4352, 10}, {1, 2}},
     {L"\U00001100\U00000308\U0000000a", {4352, 10}, {2, 3}},
     {L"\U00001100\U00000001", {4352, 1}, {1, 2}},
     {L"\U00001100\U00000308\U00000001", {4352, 1}, {2, 3}},
     {L"\U00001100\U0000200c", {4352}, {2}},
     {L"\U00001100\U00000308\U0000200c", {4352}, {3}},
     {L"\U00001100\U0001f1e6", {4352, 127462}, {1, 2}},
     {L"\U00001100\U00000308\U0001f1e6", {4352, 127462}, {2, 3}},
     {L"\U00001100\U00000600", {4352, 1536}, {1, 2}},
     {L"\U00001100\U00000308\U00000600", {4352, 1536}, {2, 3}},
     {L"\U00001100\U00000a03", {4352}, {2}},
     {L"\U00001100\U00000308\U00000a03", {4352}, {3}},
     {L"\U00001100\U00001100", {4352}, {2}},
     {L"\U00001100\U00000308\U00001100", {4352, 4352}, {2, 3}},
     {L"\U00001100\U00001160", {4352}, {2}},
     {L"\U00001100\U00000308\U00001160", {4352, 4448}, {2, 3}},
     {L"\U00001100\U000011a8", {4352, 4520}, {1, 2}},
     {L"\U00001100\U00000308\U000011a8", {4352, 4520}, {2, 3}},
     {L"\U00001100\U0000ac00", {4352}, {2}},
     {L"\U00001100\U00000308\U0000ac00", {4352, 44032}, {2, 3}},
     {L"\U00001100\U0000ac01", {4352}, {2}},
     {L"\U00001100\U00000308\U0000ac01", {4352, 44033}, {2, 3}},
     {L"\U00001100\U00000903", {4352}, {2}},
     {L"\U00001100\U00000308\U00000903", {4352}, {3}},
     {L"\U00001100\U00000904", {4352, 2308}, {1, 2}},
     {L"\U00001100\U00000308\U00000904", {4352, 2308}, {2, 3}},
     {L"\U00001100\U00000d4e", {4352, 3406}, {1, 2}},
     {L"\U00001100\U00000308\U00000d4e", {4352, 3406}, {2, 3}},
     {L"\U00001100\U00000915", {4352, 2325}, {1, 2}},
     {L"\U00001100\U00000308\U00000915", {4352, 2325}, {2, 3}},
     {L"\U00001100\U0000231a", {4352, 8986}, {1, 2}},
     {L"\U00001100\U00000308\U0000231a", {4352, 8986}, {2, 3}},
     {L"\U00001100\U00000300", {4352}, {2}},
     {L"\U00001100\U00000308\U00000300", {4352}, {3}},
     {L"\U00001100\U00000900", {4352}, {2}},
     {L"\U00001100\U00000308\U00000900", {4352}, {3}},
     {L"\U00001100\U0000094d", {4352}, {2}},
     {L"\U00001100\U00000308\U0000094d", {4352}, {3}},
     {L"\U00001100\U0000200d", {4352}, {2}},
     {L"\U00001100\U00000308\U0000200d", {4352}, {3}},
     {L"\U00001100\U00000378", {4352, 888}, {1, 2}},
     {L"\U00001100\U00000308\U00000378", {4352, 888}, {2, 3}},
     {L"\U00001160\U00000020", {4448, 32}, {1, 2}},
     {L"\U00001160\U00000308\U00000020", {4448, 32}, {2, 3}},
     {L"\U00001160\U0000000d", {4448, 13}, {1, 2}},
     {L"\U00001160\U00000308\U0000000d", {4448, 13}, {2, 3}},
     {L"\U00001160\U0000000a", {4448, 10}, {1, 2}},
     {L"\U00001160\U00000308\U0000000a", {4448, 10}, {2, 3}},
     {L"\U00001160\U00000001", {4448, 1}, {1, 2}},
     {L"\U00001160\U00000308\U00000001", {4448, 1}, {2, 3}},
     {L"\U00001160\U0000200c", {4448}, {2}},
     {L"\U00001160\U00000308\U0000200c", {4448}, {3}},
     {L"\U00001160\U0001f1e6", {4448, 127462}, {1, 2}},
     {L"\U00001160\U00000308\U0001f1e6", {4448, 127462}, {2, 3}},
     {L"\U00001160\U00000600", {4448, 1536}, {1, 2}},
     {L"\U00001160\U00000308\U00000600", {4448, 1536}, {2, 3}},
     {L"\U00001160\U00000a03", {4448}, {2}},
     {L"\U00001160\U00000308\U00000a03", {4448}, {3}},
     {L"\U00001160\U00001100", {4448, 4352}, {1, 2}},
     {L"\U00001160\U00000308\U00001100", {4448, 4352}, {2, 3}},
     {L"\U00001160\U00001160", {4448}, {2}},
     {L"\U00001160\U00000308\U00001160", {4448, 4448}, {2, 3}},
     {L"\U00001160\U000011a8", {4448}, {2}},
     {L"\U00001160\U00000308\U000011a8", {4448, 4520}, {2, 3}},
     {L"\U00001160\U0000ac00", {4448, 44032}, {1, 2}},
     {L"\U00001160\U00000308\U0000ac00", {4448, 44032}, {2, 3}},
     {L"\U00001160\U0000ac01", {4448, 44033}, {1, 2}},
     {L"\U00001160\U00000308\U0000ac01", {4448, 44033}, {2, 3}},
     {L"\U00001160\U00000903", {4448}, {2}},
     {L"\U00001160\U00000308\U00000903", {4448}, {3}},
     {L"\U00001160\U00000904", {4448, 2308}, {1, 2}},
     {L"\U00001160\U00000308\U00000904", {4448, 2308}, {2, 3}},
     {L"\U00001160\U00000d4e", {4448, 3406}, {1, 2}},
     {L"\U00001160\U00000308\U00000d4e", {4448, 3406}, {2, 3}},
     {L"\U00001160\U00000915", {4448, 2325}, {1, 2}},
     {L"\U00001160\U00000308\U00000915", {4448, 2325}, {2, 3}},
     {L"\U00001160\U0000231a", {4448, 8986}, {1, 2}},
     {L"\U00001160\U00000308\U0000231a", {4448, 8986}, {2, 3}},
     {L"\U00001160\U00000300", {4448}, {2}},
     {L"\U00001160\U00000308\U00000300", {4448}, {3}},
     {L"\U00001160\U00000900", {4448}, {2}},
     {L"\U00001160\U00000308\U00000900", {4448}, {3}},
     {L"\U00001160\U0000094d", {4448}, {2}},
     {L"\U00001160\U00000308\U0000094d", {4448}, {3}},
     {L"\U00001160\U0000200d", {4448}, {2}},
     {L"\U00001160\U00000308\U0000200d", {4448}, {3}},
     {L"\U00001160\U00000378", {4448, 888}, {1, 2}},
     {L"\U00001160\U00000308\U00000378", {4448, 888}, {2, 3}},
     {L"\U000011a8\U00000020", {4520, 32}, {1, 2}},
     {L"\U000011a8\U00000308\U00000020", {4520, 32}, {2, 3}},
     {L"\U000011a8\U0000000d", {4520, 13}, {1, 2}},
     {L"\U000011a8\U00000308\U0000000d", {4520, 13}, {2, 3}},
     {L"\U000011a8\U0000000a", {4520, 10}, {1, 2}},
     {L"\U000011a8\U00000308\U0000000a", {4520, 10}, {2, 3}},
     {L"\U000011a8\U00000001", {4520, 1}, {1, 2}},
     {L"\U000011a8\U00000308\U00000001", {4520, 1}, {2, 3}},
     {L"\U000011a8\U0000200c", {4520}, {2}},
     {L"\U000011a8\U00000308\U0000200c", {4520}, {3}},
     {L"\U000011a8\U0001f1e6", {4520, 127462}, {1, 2}},
     {L"\U000011a8\U00000308\U0001f1e6", {4520, 127462}, {2, 3}},
     {L"\U000011a8\U00000600", {4520, 1536}, {1, 2}},
     {L"\U000011a8\U00000308\U00000600", {4520, 1536}, {2, 3}},
     {L"\U000011a8\U00000a03", {4520}, {2}},
     {L"\U000011a8\U00000308\U00000a03", {4520}, {3}},
     {L"\U000011a8\U00001100", {4520, 4352}, {1, 2}},
     {L"\U000011a8\U00000308\U00001100", {4520, 4352}, {2, 3}},
     {L"\U000011a8\U00001160", {4520, 4448}, {1, 2}},
     {L"\U000011a8\U00000308\U00001160", {4520, 4448}, {2, 3}},
     {L"\U000011a8\U000011a8", {4520}, {2}},
     {L"\U000011a8\U00000308\U000011a8", {4520, 4520}, {2, 3}},
     {L"\U000011a8\U0000ac00", {4520, 44032}, {1, 2}},
     {L"\U000011a8\U00000308\U0000ac00", {4520, 44032}, {2, 3}},
     {L"\U000011a8\U0000ac01", {4520, 44033}, {1, 2}},
     {L"\U000011a8\U00000308\U0000ac01", {4520, 44033}, {2, 3}},
     {L"\U000011a8\U00000903", {4520}, {2}},
     {L"\U000011a8\U00000308\U00000903", {4520}, {3}},
     {L"\U000011a8\U00000904", {4520, 2308}, {1, 2}},
     {L"\U000011a8\U00000308\U00000904", {4520, 2308}, {2, 3}},
     {L"\U000011a8\U00000d4e", {4520, 3406}, {1, 2}},
     {L"\U000011a8\U00000308\U00000d4e", {4520, 3406}, {2, 3}},
     {L"\U000011a8\U00000915", {4520, 2325}, {1, 2}},
     {L"\U000011a8\U00000308\U00000915", {4520, 2325}, {2, 3}},
     {L"\U000011a8\U0000231a", {4520, 8986}, {1, 2}},
     {L"\U000011a8\U00000308\U0000231a", {4520, 8986}, {2, 3}},
     {L"\U000011a8\U00000300", {4520}, {2}},
     {L"\U000011a8\U00000308\U00000300", {4520}, {3}},
     {L"\U000011a8\U00000900", {4520}, {2}},
     {L"\U000011a8\U00000308\U00000900", {4520}, {3}},
     {L"\U000011a8\U0000094d", {4520}, {2}},
     {L"\U000011a8\U00000308\U0000094d", {4520}, {3}},
     {L"\U000011a8\U0000200d", {4520}, {2}},
     {L"\U000011a8\U00000308\U0000200d", {4520}, {3}},
     {L"\U000011a8\U00000378", {4520, 888}, {1, 2}},
     {L"\U000011a8\U00000308\U00000378", {4520, 888}, {2, 3}},
     {L"\U0000ac00\U00000020", {44032, 32}, {1, 2}},
     {L"\U0000ac00\U00000308\U00000020", {44032, 32}, {2, 3}},
     {L"\U0000ac00\U0000000d", {44032, 13}, {1, 2}},
     {L"\U0000ac00\U00000308\U0000000d", {44032, 13}, {2, 3}},
     {L"\U0000ac00\U0000000a", {44032, 10}, {1, 2}},
     {L"\U0000ac00\U00000308\U0000000a", {44032, 10}, {2, 3}},
     {L"\U0000ac00\U00000001", {44032, 1}, {1, 2}},
     {L"\U0000ac00\U00000308\U00000001", {44032, 1}, {2, 3}},
     {L"\U0000ac00\U0000200c", {44032}, {2}},
     {L"\U0000ac00\U00000308\U0000200c", {44032}, {3}},
     {L"\U0000ac00\U0001f1e6", {44032, 127462}, {1, 2}},
     {L"\U0000ac00\U00000308\U0001f1e6", {44032, 127462}, {2, 3}},
     {L"\U0000ac00\U00000600", {44032, 1536}, {1, 2}},
     {L"\U0000ac00\U00000308\U00000600", {44032, 1536}, {2, 3}},
     {L"\U0000ac00\U00000a03", {44032}, {2}},
     {L"\U0000ac00\U00000308\U00000a03", {44032}, {3}},
     {L"\U0000ac00\U00001100", {44032, 4352}, {1, 2}},
     {L"\U0000ac00\U00000308\U00001100", {44032, 4352}, {2, 3}},
     {L"\U0000ac00\U00001160", {44032}, {2}},
     {L"\U0000ac00\U00000308\U00001160", {44032, 4448}, {2, 3}},
     {L"\U0000ac00\U000011a8", {44032}, {2}},
     {L"\U0000ac00\U00000308\U000011a8", {44032, 4520}, {2, 3}},
     {L"\U0000ac00\U0000ac00", {44032, 44032}, {1, 2}},
     {L"\U0000ac00\U00000308\U0000ac00", {44032, 44032}, {2, 3}},
     {L"\U0000ac00\U0000ac01", {44032, 44033}, {1, 2}},
     {L"\U0000ac00\U00000308\U0000ac01", {44032, 44033}, {2, 3}},
     {L"\U0000ac00\U00000903", {44032}, {2}},
     {L"\U0000ac00\U00000308\U00000903", {44032}, {3}},
     {L"\U0000ac00\U00000904", {44032, 2308}, {1, 2}},
     {L"\U0000ac00\U00000308\U00000904", {44032, 2308}, {2, 3}},
     {L"\U0000ac00\U00000d4e", {44032, 3406}, {1, 2}},
     {L"\U0000ac00\U00000308\U00000d4e", {44032, 3406}, {2, 3}},
     {L"\U0000ac00\U00000915", {44032, 2325}, {1, 2}},
     {L"\U0000ac00\U00000308\U00000915", {44032, 2325}, {2, 3}},
     {L"\U0000ac00\U0000231a", {44032, 8986}, {1, 2}},
     {L"\U0000ac00\U00000308\U0000231a", {44032, 8986}, {2, 3}},
     {L"\U0000ac00\U00000300", {44032}, {2}},
     {L"\U0000ac00\U00000308\U00000300", {44032}, {3}},
     {L"\U0000ac00\U00000900", {44032}, {2}},
     {L"\U0000ac00\U00000308\U00000900", {44032}, {3}},
     {L"\U0000ac00\U0000094d", {44032}, {2}},
     {L"\U0000ac00\U00000308\U0000094d", {44032}, {3}},
     {L"\U0000ac00\U0000200d", {44032}, {2}},
     {L"\U0000ac00\U00000308\U0000200d", {44032}, {3}},
     {L"\U0000ac00\U00000378", {44032, 888}, {1, 2}},
     {L"\U0000ac00\U00000308\U00000378", {44032, 888}, {2, 3}},
     {L"\U0000ac01\U00000020", {44033, 32}, {1, 2}},
     {L"\U0000ac01\U00000308\U00000020", {44033, 32}, {2, 3}},
     {L"\U0000ac01\U0000000d", {44033, 13}, {1, 2}},
     {L"\U0000ac01\U00000308\U0000000d", {44033, 13}, {2, 3}},
     {L"\U0000ac01\U0000000a", {44033, 10}, {1, 2}},
     {L"\U0000ac01\U00000308\U0000000a", {44033, 10}, {2, 3}},
     {L"\U0000ac01\U00000001", {44033, 1}, {1, 2}},
     {L"\U0000ac01\U00000308\U00000001", {44033, 1}, {2, 3}},
     {L"\U0000ac01\U0000200c", {44033}, {2}},
     {L"\U0000ac01\U00000308\U0000200c", {44033}, {3}},
     {L"\U0000ac01\U0001f1e6", {44033, 127462}, {1, 2}},
     {L"\U0000ac01\U00000308\U0001f1e6", {44033, 127462}, {2, 3}},
     {L"\U0000ac01\U00000600", {44033, 1536}, {1, 2}},
     {L"\U0000ac01\U00000308\U00000600", {44033, 1536}, {2, 3}},
     {L"\U0000ac01\U00000a03", {44033}, {2}},
     {L"\U0000ac01\U00000308\U00000a03", {44033}, {3}},
     {L"\U0000ac01\U00001100", {44033, 4352}, {1, 2}},
     {L"\U0000ac01\U00000308\U00001100", {44033, 4352}, {2, 3}},
     {L"\U0000ac01\U00001160", {44033, 4448}, {1, 2}},
     {L"\U0000ac01\U00000308\U00001160", {44033, 4448}, {2, 3}},
     {L"\U0000ac01\U000011a8", {44033}, {2}},
     {L"\U0000ac01\U00000308\U000011a8", {44033, 4520}, {2, 3}},
     {L"\U0000ac01\U0000ac00", {44033, 44032}, {1, 2}},
     {L"\U0000ac01\U00000308\U0000ac00", {44033, 44032}, {2, 3}},
     {L"\U0000ac01\U0000ac01", {44033, 44033}, {1, 2}},
     {L"\U0000ac01\U00000308\U0000ac01", {44033, 44033}, {2, 3}},
     {L"\U0000ac01\U00000903", {44033}, {2}},
     {L"\U0000ac01\U00000308\U00000903", {44033}, {3}},
     {L"\U0000ac01\U00000904", {44033, 2308}, {1, 2}},
     {L"\U0000ac01\U00000308\U00000904", {44033, 2308}, {2, 3}},
     {L"\U0000ac01\U00000d4e", {44033, 3406}, {1, 2}},
     {L"\U0000ac01\U00000308\U00000d4e", {44033, 3406}, {2, 3}},
     {L"\U0000ac01\U00000915", {44033, 2325}, {1, 2}},
     {L"\U0000ac01\U00000308\U00000915", {44033, 2325}, {2, 3}},
     {L"\U0000ac01\U0000231a", {44033, 8986}, {1, 2}},
     {L"\U0000ac01\U00000308\U0000231a", {44033, 8986}, {2, 3}},
     {L"\U0000ac01\U00000300", {44033}, {2}},
     {L"\U0000ac01\U00000308\U00000300", {44033}, {3}},
     {L"\U0000ac01\U00000900", {44033}, {2}},
     {L"\U0000ac01\U00000308\U00000900", {44033}, {3}},
     {L"\U0000ac01\U0000094d", {44033}, {2}},
     {L"\U0000ac01\U00000308\U0000094d", {44033}, {3}},
     {L"\U0000ac01\U0000200d", {44033}, {2}},
     {L"\U0000ac01\U00000308\U0000200d", {44033}, {3}},
     {L"\U0000ac01\U00000378", {44033, 888}, {1, 2}},
     {L"\U0000ac01\U00000308\U00000378", {44033, 888}, {2, 3}},
     {L"\U00000903\U00000020", {2307, 32}, {1, 2}},
     {L"\U00000903\U00000308\U00000020", {2307, 32}, {2, 3}},
     {L"\U00000903\U0000000d", {2307, 13}, {1, 2}},
     {L"\U00000903\U00000308\U0000000d", {2307, 13}, {2, 3}},
     {L"\U00000903\U0000000a", {2307, 10}, {1, 2}},
     {L"\U00000903\U00000308\U0000000a", {2307, 10}, {2, 3}},
     {L"\U00000903\U00000001", {2307, 1}, {1, 2}},
     {L"\U00000903\U00000308\U00000001", {2307, 1}, {2, 3}},
     {L"\U00000903\U0000200c", {2307}, {2}},
     {L"\U00000903\U00000308\U0000200c", {2307}, {3}},
     {L"\U00000903\U0001f1e6", {2307, 127462}, {1, 2}},
     {L"\U00000903\U00000308\U0001f1e6", {2307, 127462}, {2, 3}},
     {L"\U00000903\U00000600", {2307, 1536}, {1, 2}},
     {L"\U00000903\U00000308\U00000600", {2307, 1536}, {2, 3}},
     {L"\U00000903\U00000a03", {2307}, {2}},
     {L"\U00000903\U00000308\U00000a03", {2307}, {3}},
     {L"\U00000903\U00001100", {2307, 4352}, {1, 2}},
     {L"\U00000903\U00000308\U00001100", {2307, 4352}, {2, 3}},
     {L"\U00000903\U00001160", {2307, 4448}, {1, 2}},
     {L"\U00000903\U00000308\U00001160", {2307, 4448}, {2, 3}},
     {L"\U00000903\U000011a8", {2307, 4520}, {1, 2}},
     {L"\U00000903\U00000308\U000011a8", {2307, 4520}, {2, 3}},
     {L"\U00000903\U0000ac00", {2307, 44032}, {1, 2}},
     {L"\U00000903\U00000308\U0000ac00", {2307, 44032}, {2, 3}},
     {L"\U00000903\U0000ac01", {2307, 44033}, {1, 2}},
     {L"\U00000903\U00000308\U0000ac01", {2307, 44033}, {2, 3}},
     {L"\U00000903\U00000903", {2307}, {2}},
     {L"\U00000903\U00000308\U00000903", {2307}, {3}},
     {L"\U00000903\U00000904", {2307, 2308}, {1, 2}},
     {L"\U00000903\U00000308\U00000904", {2307, 2308}, {2, 3}},
     {L"\U00000903\U00000d4e", {2307, 3406}, {1, 2}},
     {L"\U00000903\U00000308\U00000d4e", {2307, 3406}, {2, 3}},
     {L"\U00000903\U00000915", {2307, 2325}, {1, 2}},
     {L"\U00000903\U00000308\U00000915", {2307, 2325}, {2, 3}},
     {L"\U00000903\U0000231a", {2307, 8986}, {1, 2}},
     {L"\U00000903\U00000308\U0000231a", {2307, 8986}, {2, 3}},
     {L"\U00000903\U00000300", {2307}, {2}},
     {L"\U00000903\U00000308\U00000300", {2307}, {3}},
     {L"\U00000903\U00000900", {2307}, {2}},
     {L"\U00000903\U00000308\U00000900", {2307}, {3}},
     {L"\U00000903\U0000094d", {2307}, {2}},
     {L"\U00000903\U00000308\U0000094d", {2307}, {3}},
     {L"\U00000903\U0000200d", {2307}, {2}},
     {L"\U00000903\U00000308\U0000200d", {2307}, {3}},
     {L"\U00000903\U00000378", {2307, 888}, {1, 2}},
     {L"\U00000903\U00000308\U00000378", {2307, 888}, {2, 3}},
     {L"\U00000904\U00000020", {2308, 32}, {1, 2}},
     {L"\U00000904\U00000308\U00000020", {2308, 32}, {2, 3}},
     {L"\U00000904\U0000000d", {2308, 13}, {1, 2}},
     {L"\U00000904\U00000308\U0000000d", {2308, 13}, {2, 3}},
     {L"\U00000904\U0000000a", {2308, 10}, {1, 2}},
     {L"\U00000904\U00000308\U0000000a", {2308, 10}, {2, 3}},
     {L"\U00000904\U00000001", {2308, 1}, {1, 2}},
     {L"\U00000904\U00000308\U00000001", {2308, 1}, {2, 3}},
     {L"\U00000904\U0000200c", {2308}, {2}},
     {L"\U00000904\U00000308\U0000200c", {2308}, {3}},
     {L"\U00000904\U0001f1e6", {2308, 127462}, {1, 2}},
     {L"\U00000904\U00000308\U0001f1e6", {2308, 127462}, {2, 3}},
     {L"\U00000904\U00000600", {2308, 1536}, {1, 2}},
     {L"\U00000904\U00000308\U00000600", {2308, 1536}, {2, 3}},
     {L"\U00000904\U00000a03", {2308}, {2}},
     {L"\U00000904\U00000308\U00000a03", {2308}, {3}},
     {L"\U00000904\U00001100", {2308, 4352}, {1, 2}},
     {L"\U00000904\U00000308\U00001100", {2308, 4352}, {2, 3}},
     {L"\U00000904\U00001160", {2308, 4448}, {1, 2}},
     {L"\U00000904\U00000308\U00001160", {2308, 4448}, {2, 3}},
     {L"\U00000904\U000011a8", {2308, 4520}, {1, 2}},
     {L"\U00000904\U00000308\U000011a8", {2308, 4520}, {2, 3}},
     {L"\U00000904\U0000ac00", {2308, 44032}, {1, 2}},
     {L"\U00000904\U00000308\U0000ac00", {2308, 44032}, {2, 3}},
     {L"\U00000904\U0000ac01", {2308, 44033}, {1, 2}},
     {L"\U00000904\U00000308\U0000ac01", {2308, 44033}, {2, 3}},
     {L"\U00000904\U00000903", {2308}, {2}},
     {L"\U00000904\U00000308\U00000903", {2308}, {3}},
     {L"\U00000904\U00000904", {2308, 2308}, {1, 2}},
     {L"\U00000904\U00000308\U00000904", {2308, 2308}, {2, 3}},
     {L"\U00000904\U00000d4e", {2308, 3406}, {1, 2}},
     {L"\U00000904\U00000308\U00000d4e", {2308, 3406}, {2, 3}},
     {L"\U00000904\U00000915", {2308, 2325}, {1, 2}},
     {L"\U00000904\U00000308\U00000915", {2308, 2325}, {2, 3}},
     {L"\U00000904\U0000231a", {2308, 8986}, {1, 2}},
     {L"\U00000904\U00000308\U0000231a", {2308, 8986}, {2, 3}},
     {L"\U00000904\U00000300", {2308}, {2}},
     {L"\U00000904\U00000308\U00000300", {2308}, {3}},
     {L"\U00000904\U00000900", {2308}, {2}},
     {L"\U00000904\U00000308\U00000900", {2308}, {3}},
     {L"\U00000904\U0000094d", {2308}, {2}},
     {L"\U00000904\U00000308\U0000094d", {2308}, {3}},
     {L"\U00000904\U0000200d", {2308}, {2}},
     {L"\U00000904\U00000308\U0000200d", {2308}, {3}},
     {L"\U00000904\U00000378", {2308, 888}, {1, 2}},
     {L"\U00000904\U00000308\U00000378", {2308, 888}, {2, 3}},
     {L"\U00000d4e\U00000020", {3406}, {2}},
     {L"\U00000d4e\U00000308\U00000020", {3406, 32}, {2, 3}},
     {L"\U00000d4e\U0000000d", {3406, 13}, {1, 2}},
     {L"\U00000d4e\U00000308\U0000000d", {3406, 13}, {2, 3}},
     {L"\U00000d4e\U0000000a", {3406, 10}, {1, 2}},
     {L"\U00000d4e\U00000308\U0000000a", {3406, 10}, {2, 3}},
     {L"\U00000d4e\U00000001", {3406, 1}, {1, 2}},
     {L"\U00000d4e\U00000308\U00000001", {3406, 1}, {2, 3}},
     {L"\U00000d4e\U0000200c", {3406}, {2}},
     {L"\U00000d4e\U00000308\U0000200c", {3406}, {3}},
     {L"\U00000d4e\U0001f1e6", {3406}, {2}},
     {L"\U00000d4e\U00000308\U0001f1e6", {3406, 127462}, {2, 3}},
     {L"\U00000d4e\U00000600", {3406}, {2}},
     {L"\U00000d4e\U00000308\U00000600", {3406, 1536}, {2, 3}},
     {L"\U00000d4e\U00000a03", {3406}, {2}},
     {L"\U00000d4e\U00000308\U00000a03", {3406}, {3}},
     {L"\U00000d4e\U00001100", {3406}, {2}},
     {L"\U00000d4e\U00000308\U00001100", {3406, 4352}, {2, 3}},
     {L"\U00000d4e\U00001160", {3406}, {2}},
     {L"\U00000d4e\U00000308\U00001160", {3406, 4448}, {2, 3}},
     {L"\U00000d4e\U000011a8", {3406}, {2}},
     {L"\U00000d4e\U00000308\U000011a8", {3406, 4520}, {2, 3}},
     {L"\U00000d4e\U0000ac00", {3406}, {2}},
     {L"\U00000d4e\U00000308\U0000ac00", {3406, 44032}, {2, 3}},
     {L"\U00000d4e\U0000ac01", {3406}, {2}},
     {L"\U00000d4e\U00000308\U0000ac01", {3406, 44033}, {2, 3}},
     {L"\U00000d4e\U00000903", {3406}, {2}},
     {L"\U00000d4e\U00000308\U00000903", {3406}, {3}},
     {L"\U00000d4e\U00000904", {3406}, {2}},
     {L"\U00000d4e\U00000308\U00000904", {3406, 2308}, {2, 3}},
     {L"\U00000d4e\U00000d4e", {3406}, {2}},
     {L"\U00000d4e\U00000308\U00000d4e", {3406, 3406}, {2, 3}},
     {L"\U00000d4e\U00000915", {3406}, {2}},
     {L"\U00000d4e\U00000308\U00000915", {3406, 2325}, {2, 3}},
     {L"\U00000d4e\U0000231a", {3406}, {2}},
     {L"\U00000d4e\U00000308\U0000231a", {3406, 8986}, {2, 3}},
     {L"\U00000d4e\U00000300", {3406}, {2}},
     {L"\U00000d4e\U00000308\U00000300", {3406}, {3}},
     {L"\U00000d4e\U00000900", {3406}, {2}},
     {L"\U00000d4e\U00000308\U00000900", {3406}, {3}},
     {L"\U00000d4e\U0000094d", {3406}, {2}},
     {L"\U00000d4e\U00000308\U0000094d", {3406}, {3}},
     {L"\U00000d4e\U0000200d", {3406}, {2}},
     {L"\U00000d4e\U00000308\U0000200d", {3406}, {3}},
     {L"\U00000d4e\U00000378", {3406}, {2}},
     {L"\U00000d4e\U00000308\U00000378", {3406, 888}, {2, 3}},
     {L"\U00000915\U00000020", {2325, 32}, {1, 2}},
     {L"\U00000915\U00000308\U00000020", {2325, 32}, {2, 3}},
     {L"\U00000915\U0000000d", {2325, 13}, {1, 2}},
     {L"\U00000915\U00000308\U0000000d", {2325, 13}, {2, 3}},
     {L"\U00000915\U0000000a", {2325, 10}, {1, 2}},
     {L"\U00000915\U00000308\U0000000a", {2325, 10}, {2, 3}},
     {L"\U00000915\U00000001", {2325, 1}, {1, 2}},
     {L"\U00000915\U00000308\U00000001", {2325, 1}, {2, 3}},
     {L"\U00000915\U0000200c", {2325}, {2}},
     {L"\U00000915\U00000308\U0000200c", {2325}, {3}},
     {L"\U00000915\U0001f1e6", {2325, 127462}, {1, 2}},
     {L"\U00000915\U00000308\U0001f1e6", {2325, 127462}, {2, 3}},
     {L"\U00000915\U00000600", {2325, 1536}, {1, 2}},
     {L"\U00000915\U00000308\U00000600", {2325, 1536}, {2, 3}},
     {L"\U00000915\U00000a03", {2325}, {2}},
     {L"\U00000915\U00000308\U00000a03", {2325}, {3}},
     {L"\U00000915\U00001100", {2325, 4352}, {1, 2}},
     {L"\U00000915\U00000308\U00001100", {2325, 4352}, {2, 3}},
     {L"\U00000915\U00001160", {2325, 4448}, {1, 2}},
     {L"\U00000915\U00000308\U00001160", {2325, 4448}, {2, 3}},
     {L"\U00000915\U000011a8", {2325, 4520}, {1, 2}},
     {L"\U00000915\U00000308\U000011a8", {2325, 4520}, {2, 3}},
     {L"\U00000915\U0000ac00", {2325, 44032}, {1, 2}},
     {L"\U00000915\U00000308\U0000ac00", {2325, 44032}, {2, 3}},
     {L"\U00000915\U0000ac01", {2325, 44033}, {1, 2}},
     {L"\U00000915\U00000308\U0000ac01", {2325, 44033}, {2, 3}},
     {L"\U00000915\U00000903", {2325}, {2}},
     {L"\U00000915\U00000308\U00000903", {2325}, {3}},
     {L"\U00000915\U00000904", {2325, 2308}, {1, 2}},
     {L"\U00000915\U00000308\U00000904", {2325, 2308}, {2, 3}},
     {L"\U00000915\U00000d4e", {2325, 3406}, {1, 2}},
     {L"\U00000915\U00000308\U00000d4e", {2325, 3406}, {2, 3}},
     {L"\U00000915\U00000915", {2325, 2325}, {1, 2}},
     {L"\U00000915\U00000308\U00000915", {2325, 2325}, {2, 3}},
     {L"\U00000915\U0000231a", {2325, 8986}, {1, 2}},
     {L"\U00000915\U00000308\U0000231a", {2325, 8986}, {2, 3}},
     {L"\U00000915\U00000300", {2325}, {2}},
     {L"\U00000915\U00000308\U00000300", {2325}, {3}},
     {L"\U00000915\U00000900", {2325}, {2}},
     {L"\U00000915\U00000308\U00000900", {2325}, {3}},
     {L"\U00000915\U0000094d", {2325}, {2}},
     {L"\U00000915\U00000308\U0000094d", {2325}, {3}},
     {L"\U00000915\U0000200d", {2325}, {2}},
     {L"\U00000915\U00000308\U0000200d", {2325}, {3}},
     {L"\U00000915\U00000378", {2325, 888}, {1, 2}},
     {L"\U00000915\U00000308\U00000378", {2325, 888}, {2, 3}},
     {L"\U0000231a\U00000020", {8986, 32}, {1, 2}},
     {L"\U0000231a\U00000308\U00000020", {8986, 32}, {2, 3}},
     {L"\U0000231a\U0000000d", {8986, 13}, {1, 2}},
     {L"\U0000231a\U00000308\U0000000d", {8986, 13}, {2, 3}},
     {L"\U0000231a\U0000000a", {8986, 10}, {1, 2}},
     {L"\U0000231a\U00000308\U0000000a", {8986, 10}, {2, 3}},
     {L"\U0000231a\U00000001", {8986, 1}, {1, 2}},
     {L"\U0000231a\U00000308\U00000001", {8986, 1}, {2, 3}},
     {L"\U0000231a\U0000200c", {8986}, {2}},
     {L"\U0000231a\U00000308\U0000200c", {8986}, {3}},
     {L"\U0000231a\U0001f1e6", {8986, 127462}, {1, 2}},
     {L"\U0000231a\U00000308\U0001f1e6", {8986, 127462}, {2, 3}},
     {L"\U0000231a\U00000600", {8986, 1536}, {1, 2}},
     {L"\U0000231a\U00000308\U00000600", {8986, 1536}, {2, 3}},
     {L"\U0000231a\U00000a03", {8986}, {2}},
     {L"\U0000231a\U00000308\U00000a03", {8986}, {3}},
     {L"\U0000231a\U00001100", {8986, 4352}, {1, 2}},
     {L"\U0000231a\U00000308\U00001100", {8986, 4352}, {2, 3}},
     {L"\U0000231a\U00001160", {8986, 4448}, {1, 2}},
     {L"\U0000231a\U00000308\U00001160", {8986, 4448}, {2, 3}},
     {L"\U0000231a\U000011a8", {8986, 4520}, {1, 2}},
     {L"\U0000231a\U00000308\U000011a8", {8986, 4520}, {2, 3}},
     {L"\U0000231a\U0000ac00", {8986, 44032}, {1, 2}},
     {L"\U0000231a\U00000308\U0000ac00", {8986, 44032}, {2, 3}},
     {L"\U0000231a\U0000ac01", {8986, 44033}, {1, 2}},
     {L"\U0000231a\U00000308\U0000ac01", {8986, 44033}, {2, 3}},
     {L"\U0000231a\U00000903", {8986}, {2}},
     {L"\U0000231a\U00000308\U00000903", {8986}, {3}},
     {L"\U0000231a\U00000904", {8986, 2308}, {1, 2}},
     {L"\U0000231a\U00000308\U00000904", {8986, 2308}, {2, 3}},
     {L"\U0000231a\U00000d4e", {8986, 3406}, {1, 2}},
     {L"\U0000231a\U00000308\U00000d4e", {8986, 3406}, {2, 3}},
     {L"\U0000231a\U00000915", {8986, 2325}, {1, 2}},
     {L"\U0000231a\U00000308\U00000915", {8986, 2325}, {2, 3}},
     {L"\U0000231a\U0000231a", {8986, 8986}, {1, 2}},
     {L"\U0000231a\U00000308\U0000231a", {8986, 8986}, {2, 3}},
     {L"\U0000231a\U00000300", {8986}, {2}},
     {L"\U0000231a\U00000308\U00000300", {8986}, {3}},
     {L"\U0000231a\U00000900", {8986}, {2}},
     {L"\U0000231a\U00000308\U00000900", {8986}, {3}},
     {L"\U0000231a\U0000094d", {8986}, {2}},
     {L"\U0000231a\U00000308\U0000094d", {8986}, {3}},
     {L"\U0000231a\U0000200d", {8986}, {2}},
     {L"\U0000231a\U00000308\U0000200d", {8986}, {3}},
     {L"\U0000231a\U00000378", {8986, 888}, {1, 2}},
     {L"\U0000231a\U00000308\U00000378", {8986, 888}, {2, 3}},
     {L"\U00000300\U00000020", {768, 32}, {1, 2}},
     {L"\U00000300\U00000308\U00000020", {768, 32}, {2, 3}},
     {L"\U00000300\U0000000d", {768, 13}, {1, 2}},
     {L"\U00000300\U00000308\U0000000d", {768, 13}, {2, 3}},
     {L"\U00000300\U0000000a", {768, 10}, {1, 2}},
     {L"\U00000300\U00000308\U0000000a", {768, 10}, {2, 3}},
     {L"\U00000300\U00000001", {768, 1}, {1, 2}},
     {L"\U00000300\U00000308\U00000001", {768, 1}, {2, 3}},
     {L"\U00000300\U0000200c", {768}, {2}},
     {L"\U00000300\U00000308\U0000200c", {768}, {3}},
     {L"\U00000300\U0001f1e6", {768, 127462}, {1, 2}},
     {L"\U00000300\U00000308\U0001f1e6", {768, 127462}, {2, 3}},
     {L"\U00000300\U00000600", {768, 1536}, {1, 2}},
     {L"\U00000300\U00000308\U00000600", {768, 1536}, {2, 3}},
     {L"\U00000300\U00000a03", {768}, {2}},
     {L"\U00000300\U00000308\U00000a03", {768}, {3}},
     {L"\U00000300\U00001100", {768, 4352}, {1, 2}},
     {L"\U00000300\U00000308\U00001100", {768, 4352}, {2, 3}},
     {L"\U00000300\U00001160", {768, 4448}, {1, 2}},
     {L"\U00000300\U00000308\U00001160", {768, 4448}, {2, 3}},
     {L"\U00000300\U000011a8", {768, 4520}, {1, 2}},
     {L"\U00000300\U00000308\U000011a8", {768, 4520}, {2, 3}},
     {L"\U00000300\U0000ac00", {768, 44032}, {1, 2}},
     {L"\U00000300\U00000308\U0000ac00", {768, 44032}, {2, 3}},
     {L"\U00000300\U0000ac01", {768, 44033}, {1, 2}},
     {L"\U00000300\U00000308\U0000ac01", {768, 44033}, {2, 3}},
     {L"\U00000300\U00000903", {768}, {2}},
     {L"\U00000300\U00000308\U00000903", {768}, {3}},
     {L"\U00000300\U00000904", {768, 2308}, {1, 2}},
     {L"\U00000300\U00000308\U00000904", {768, 2308}, {2, 3}},
     {L"\U00000300\U00000d4e", {768, 3406}, {1, 2}},
     {L"\U00000300\U00000308\U00000d4e", {768, 3406}, {2, 3}},
     {L"\U00000300\U00000915", {768, 2325}, {1, 2}},
     {L"\U00000300\U00000308\U00000915", {768, 2325}, {2, 3}},
     {L"\U00000300\U0000231a", {768, 8986}, {1, 2}},
     {L"\U00000300\U00000308\U0000231a", {768, 8986}, {2, 3}},
     {L"\U00000300\U00000300", {768}, {2}},
     {L"\U00000300\U00000308\U00000300", {768}, {3}},
     {L"\U00000300\U00000900", {768}, {2}},
     {L"\U00000300\U00000308\U00000900", {768}, {3}},
     {L"\U00000300\U0000094d", {768}, {2}},
     {L"\U00000300\U00000308\U0000094d", {768}, {3}},
     {L"\U00000300\U0000200d", {768}, {2}},
     {L"\U00000300\U00000308\U0000200d", {768}, {3}},
     {L"\U00000300\U00000378", {768, 888}, {1, 2}},
     {L"\U00000300\U00000308\U00000378", {768, 888}, {2, 3}},
     {L"\U00000900\U00000020", {2304, 32}, {1, 2}},
     {L"\U00000900\U00000308\U00000020", {2304, 32}, {2, 3}},
     {L"\U00000900\U0000000d", {2304, 13}, {1, 2}},
     {L"\U00000900\U00000308\U0000000d", {2304, 13}, {2, 3}},
     {L"\U00000900\U0000000a", {2304, 10}, {1, 2}},
     {L"\U00000900\U00000308\U0000000a", {2304, 10}, {2, 3}},
     {L"\U00000900\U00000001", {2304, 1}, {1, 2}},
     {L"\U00000900\U00000308\U00000001", {2304, 1}, {2, 3}},
     {L"\U00000900\U0000200c", {2304}, {2}},
     {L"\U00000900\U00000308\U0000200c", {2304}, {3}},
     {L"\U00000900\U0001f1e6", {2304, 127462}, {1, 2}},
     {L"\U00000900\U00000308\U0001f1e6", {2304, 127462}, {2, 3}},
     {L"\U00000900\U00000600", {2304, 1536}, {1, 2}},
     {L"\U00000900\U00000308\U00000600", {2304, 1536}, {2, 3}},
     {L"\U00000900\U00000a03", {2304}, {2}},
     {L"\U00000900\U00000308\U00000a03", {2304}, {3}},
     {L"\U00000900\U00001100", {2304, 4352}, {1, 2}},
     {L"\U00000900\U00000308\U00001100", {2304, 4352}, {2, 3}},
     {L"\U00000900\U00001160", {2304, 4448}, {1, 2}},
     {L"\U00000900\U00000308\U00001160", {2304, 4448}, {2, 3}},
     {L"\U00000900\U000011a8", {2304, 4520}, {1, 2}},
     {L"\U00000900\U00000308\U000011a8", {2304, 4520}, {2, 3}},
     {L"\U00000900\U0000ac00", {2304, 44032}, {1, 2}},
     {L"\U00000900\U00000308\U0000ac00", {2304, 44032}, {2, 3}},
     {L"\U00000900\U0000ac01", {2304, 44033}, {1, 2}},
     {L"\U00000900\U00000308\U0000ac01", {2304, 44033}, {2, 3}},
     {L"\U00000900\U00000903", {2304}, {2}},
     {L"\U00000900\U00000308\U00000903", {2304}, {3}},
     {L"\U00000900\U00000904", {2304, 2308}, {1, 2}},
     {L"\U00000900\U00000308\U00000904", {2304, 2308}, {2, 3}},
     {L"\U00000900\U00000d4e", {2304, 3406}, {1, 2}},
     {L"\U00000900\U00000308\U00000d4e", {2304, 3406}, {2, 3}},
     {L"\U00000900\U00000915", {2304, 2325}, {1, 2}},
     {L"\U00000900\U00000308\U00000915", {2304, 2325}, {2, 3}},
     {L"\U00000900\U0000231a", {2304, 8986}, {1, 2}},
     {L"\U00000900\U00000308\U0000231a", {2304, 8986}, {2, 3}},
     {L"\U00000900\U00000300", {2304}, {2}},
     {L"\U00000900\U00000308\U00000300", {2304}, {3}},
     {L"\U00000900\U00000900", {2304}, {2}},
     {L"\U00000900\U00000308\U00000900", {2304}, {3}},
     {L"\U00000900\U0000094d", {2304}, {2}},
     {L"\U00000900\U00000308\U0000094d", {2304}, {3}},
     {L"\U00000900\U0000200d", {2304}, {2}},
     {L"\U00000900\U00000308\U0000200d", {2304}, {3}},
     {L"\U00000900\U00000378", {2304, 888}, {1, 2}},
     {L"\U00000900\U00000308\U00000378", {2304, 888}, {2, 3}},
     {L"\U0000094d\U00000020", {2381, 32}, {1, 2}},
     {L"\U0000094d\U00000308\U00000020", {2381, 32}, {2, 3}},
     {L"\U0000094d\U0000000d", {2381, 13}, {1, 2}},
     {L"\U0000094d\U00000308\U0000000d", {2381, 13}, {2, 3}},
     {L"\U0000094d\U0000000a", {2381, 10}, {1, 2}},
     {L"\U0000094d\U00000308\U0000000a", {2381, 10}, {2, 3}},
     {L"\U0000094d\U00000001", {2381, 1}, {1, 2}},
     {L"\U0000094d\U00000308\U00000001", {2381, 1}, {2, 3}},
     {L"\U0000094d\U0000200c", {2381}, {2}},
     {L"\U0000094d\U00000308\U0000200c", {2381}, {3}},
     {L"\U0000094d\U0001f1e6", {2381, 127462}, {1, 2}},
     {L"\U0000094d\U00000308\U0001f1e6", {2381, 127462}, {2, 3}},
     {L"\U0000094d\U00000600", {2381, 1536}, {1, 2}},
     {L"\U0000094d\U00000308\U00000600", {2381, 1536}, {2, 3}},
     {L"\U0000094d\U00000a03", {2381}, {2}},
     {L"\U0000094d\U00000308\U00000a03", {2381}, {3}},
     {L"\U0000094d\U00001100", {2381, 4352}, {1, 2}},
     {L"\U0000094d\U00000308\U00001100", {2381, 4352}, {2, 3}},
     {L"\U0000094d\U00001160", {2381, 4448}, {1, 2}},
     {L"\U0000094d\U00000308\U00001160", {2381, 4448}, {2, 3}},
     {L"\U0000094d\U000011a8", {2381, 4520}, {1, 2}},
     {L"\U0000094d\U00000308\U000011a8", {2381, 4520}, {2, 3}},
     {L"\U0000094d\U0000ac00", {2381, 44032}, {1, 2}},
     {L"\U0000094d\U00000308\U0000ac00", {2381, 44032}, {2, 3}},
     {L"\U0000094d\U0000ac01", {2381, 44033}, {1, 2}},
     {L"\U0000094d\U00000308\U0000ac01", {2381, 44033}, {2, 3}},
     {L"\U0000094d\U00000903", {2381}, {2}},
     {L"\U0000094d\U00000308\U00000903", {2381}, {3}},
     {L"\U0000094d\U00000904", {2381, 2308}, {1, 2}},
     {L"\U0000094d\U00000308\U00000904", {2381, 2308}, {2, 3}},
     {L"\U0000094d\U00000d4e", {2381, 3406}, {1, 2}},
     {L"\U0000094d\U00000308\U00000d4e", {2381, 3406}, {2, 3}},
     {L"\U0000094d\U00000915", {2381, 2325}, {1, 2}},
     {L"\U0000094d\U00000308\U00000915", {2381, 2325}, {2, 3}},
     {L"\U0000094d\U0000231a", {2381, 8986}, {1, 2}},
     {L"\U0000094d\U00000308\U0000231a", {2381, 8986}, {2, 3}},
     {L"\U0000094d\U00000300", {2381}, {2}},
     {L"\U0000094d\U00000308\U00000300", {2381}, {3}},
     {L"\U0000094d\U00000900", {2381}, {2}},
     {L"\U0000094d\U00000308\U00000900", {2381}, {3}},
     {L"\U0000094d\U0000094d", {2381}, {2}},
     {L"\U0000094d\U00000308\U0000094d", {2381}, {3}},
     {L"\U0000094d\U0000200d", {2381}, {2}},
     {L"\U0000094d\U00000308\U0000200d", {2381}, {3}},
     {L"\U0000094d\U00000378", {2381, 888}, {1, 2}},
     {L"\U0000094d\U00000308\U00000378", {2381, 888}, {2, 3}},
     {L"\U0000200d\U00000020", {8205, 32}, {1, 2}},
     {L"\U0000200d\U00000308\U00000020", {8205, 32}, {2, 3}},
     {L"\U0000200d\U0000000d", {8205, 13}, {1, 2}},
     {L"\U0000200d\U00000308\U0000000d", {8205, 13}, {2, 3}},
     {L"\U0000200d\U0000000a", {8205, 10}, {1, 2}},
     {L"\U0000200d\U00000308\U0000000a", {8205, 10}, {2, 3}},
     {L"\U0000200d\U00000001", {8205, 1}, {1, 2}},
     {L"\U0000200d\U00000308\U00000001", {8205, 1}, {2, 3}},
     {L"\U0000200d\U0000200c", {8205}, {2}},
     {L"\U0000200d\U00000308\U0000200c", {8205}, {3}},
     {L"\U0000200d\U0001f1e6", {8205, 127462}, {1, 2}},
     {L"\U0000200d\U00000308\U0001f1e6", {8205, 127462}, {2, 3}},
     {L"\U0000200d\U00000600", {8205, 1536}, {1, 2}},
     {L"\U0000200d\U00000308\U00000600", {8205, 1536}, {2, 3}},
     {L"\U0000200d\U00000a03", {8205}, {2}},
     {L"\U0000200d\U00000308\U00000a03", {8205}, {3}},
     {L"\U0000200d\U00001100", {8205, 4352}, {1, 2}},
     {L"\U0000200d\U00000308\U00001100", {8205, 4352}, {2, 3}},
     {L"\U0000200d\U00001160", {8205, 4448}, {1, 2}},
     {L"\U0000200d\U00000308\U00001160", {8205, 4448}, {2, 3}},
     {L"\U0000200d\U000011a8", {8205, 4520}, {1, 2}},
     {L"\U0000200d\U00000308\U000011a8", {8205, 4520}, {2, 3}},
     {L"\U0000200d\U0000ac00", {8205, 44032}, {1, 2}},
     {L"\U0000200d\U00000308\U0000ac00", {8205, 44032}, {2, 3}},
     {L"\U0000200d\U0000ac01", {8205, 44033}, {1, 2}},
     {L"\U0000200d\U00000308\U0000ac01", {8205, 44033}, {2, 3}},
     {L"\U0000200d\U00000903", {8205}, {2}},
     {L"\U0000200d\U00000308\U00000903", {8205}, {3}},
     {L"\U0000200d\U00000904", {8205, 2308}, {1, 2}},
     {L"\U0000200d\U00000308\U00000904", {8205, 2308}, {2, 3}},
     {L"\U0000200d\U00000d4e", {8205, 3406}, {1, 2}},
     {L"\U0000200d\U00000308\U00000d4e", {8205, 3406}, {2, 3}},
     {L"\U0000200d\U00000915", {8205, 2325}, {1, 2}},
     {L"\U0000200d\U00000308\U00000915", {8205, 2325}, {2, 3}},
     {L"\U0000200d\U0000231a", {8205, 8986}, {1, 2}},
     {L"\U0000200d\U00000308\U0000231a", {8205, 8986}, {2, 3}},
     {L"\U0000200d\U00000300", {8205}, {2}},
     {L"\U0000200d\U00000308\U00000300", {8205}, {3}},
     {L"\U0000200d\U00000900", {8205}, {2}},
     {L"\U0000200d\U00000308\U00000900", {8205}, {3}},
     {L"\U0000200d\U0000094d", {8205}, {2}},
     {L"\U0000200d\U00000308\U0000094d", {8205}, {3}},
     {L"\U0000200d\U0000200d", {8205}, {2}},
     {L"\U0000200d\U00000308\U0000200d", {8205}, {3}},
     {L"\U0000200d\U00000378", {8205, 888}, {1, 2}},
     {L"\U0000200d\U00000308\U00000378", {8205, 888}, {2, 3}},
     {L"\U00000378\U00000020", {888, 32}, {1, 2}},
     {L"\U00000378\U00000308\U00000020", {888, 32}, {2, 3}},
     {L"\U00000378\U0000000d", {888, 13}, {1, 2}},
     {L"\U00000378\U00000308\U0000000d", {888, 13}, {2, 3}},
     {L"\U00000378\U0000000a", {888, 10}, {1, 2}},
     {L"\U00000378\U00000308\U0000000a", {888, 10}, {2, 3}},
     {L"\U00000378\U00000001", {888, 1}, {1, 2}},
     {L"\U00000378\U00000308\U00000001", {888, 1}, {2, 3}},
     {L"\U00000378\U0000200c", {888}, {2}},
     {L"\U00000378\U00000308\U0000200c", {888}, {3}},
     {L"\U00000378\U0001f1e6", {888, 127462}, {1, 2}},
     {L"\U00000378\U00000308\U0001f1e6", {888, 127462}, {2, 3}},
     {L"\U00000378\U00000600", {888, 1536}, {1, 2}},
     {L"\U00000378\U00000308\U00000600", {888, 1536}, {2, 3}},
     {L"\U00000378\U00000a03", {888}, {2}},
     {L"\U00000378\U00000308\U00000a03", {888}, {3}},
     {L"\U00000378\U00001100", {888, 4352}, {1, 2}},
     {L"\U00000378\U00000308\U00001100", {888, 4352}, {2, 3}},
     {L"\U00000378\U00001160", {888, 4448}, {1, 2}},
     {L"\U00000378\U00000308\U00001160", {888, 4448}, {2, 3}},
     {L"\U00000378\U000011a8", {888, 4520}, {1, 2}},
     {L"\U00000378\U00000308\U000011a8", {888, 4520}, {2, 3}},
     {L"\U00000378\U0000ac00", {888, 44032}, {1, 2}},
     {L"\U00000378\U00000308\U0000ac00", {888, 44032}, {2, 3}},
     {L"\U00000378\U0000ac01", {888, 44033}, {1, 2}},
     {L"\U00000378\U00000308\U0000ac01", {888, 44033}, {2, 3}},
     {L"\U00000378\U00000903", {888}, {2}},
     {L"\U00000378\U00000308\U00000903", {888}, {3}},
     {L"\U00000378\U00000904", {888, 2308}, {1, 2}},
     {L"\U00000378\U00000308\U00000904", {888, 2308}, {2, 3}},
     {L"\U00000378\U00000d4e", {888, 3406}, {1, 2}},
     {L"\U00000378\U00000308\U00000d4e", {888, 3406}, {2, 3}},
     {L"\U00000378\U00000915", {888, 2325}, {1, 2}},
     {L"\U00000378\U00000308\U00000915", {888, 2325}, {2, 3}},
     {L"\U00000378\U0000231a", {888, 8986}, {1, 2}},
     {L"\U00000378\U00000308\U0000231a", {888, 8986}, {2, 3}},
     {L"\U00000378\U00000300", {888}, {2}},
     {L"\U00000378\U00000308\U00000300", {888}, {3}},
     {L"\U00000378\U00000900", {888}, {2}},
     {L"\U00000378\U00000308\U00000900", {888}, {3}},
     {L"\U00000378\U0000094d", {888}, {2}},
     {L"\U00000378\U00000308\U0000094d", {888}, {3}},
     {L"\U00000378\U0000200d", {888}, {2}},
     {L"\U00000378\U00000308\U0000200d", {888}, {3}},
     {L"\U00000378\U00000378", {888, 888}, {1, 2}},
     {L"\U00000378\U00000308\U00000378", {888, 888}, {2, 3}},
     {L"\U0000000d\U0000000a\U00000061\U0000000a\U00000308", {13, 97, 10, 776}, {2, 3, 4, 5}},
     {L"\U00000061\U00000308", {97}, {2}},
     {L"\U00000020\U0000200d\U00000646", {32, 1606}, {2, 3}},
     {L"\U00000646\U0000200d\U00000020", {1606, 32}, {2, 3}},
     {L"\U00001100\U00001100", {4352}, {2}},
     {L"\U0000ac00\U000011a8\U00001100", {44032, 4352}, {2, 3}},
     {L"\U0000ac01\U000011a8\U00001100", {44033, 4352}, {2, 3}},
     {L"\U0001f1e6\U0001f1e7\U0001f1e8\U00000062", {127462, 127464, 98}, {2, 3, 4}},
     {L"\U00000061\U0001f1e6\U0001f1e7\U0001f1e8\U00000062", {97, 127462, 127464, 98}, {1, 3, 4, 5}},
     {L"\U00000061\U0001f1e6\U0001f1e7\U0000200d\U0001f1e8\U00000062", {97, 127462, 127464, 98}, {1, 4, 5, 6}},
     {L"\U00000061\U0001f1e6\U0000200d\U0001f1e7\U0001f1e8\U00000062", {97, 127462, 127463, 98}, {1, 3, 5, 6}},
     {L"\U00000061\U0001f1e6\U0001f1e7\U0001f1e8\U0001f1e9\U00000062", {97, 127462, 127464, 98}, {1, 3, 5, 6}},
     {L"\U00000061\U0000200d", {97}, {2}},
     {L"\U00000061\U00000308\U00000062", {97, 98}, {2, 3}},
     {L"\U00000061\U00000903\U00000062", {97, 98}, {2, 3}},
     {L"\U00000061\U00000600\U00000062", {97, 1536}, {1, 3}},
     {L"\U0001f476\U0001f3ff\U0001f476", {128118, 128118}, {2, 3}},
     {L"\U00000061\U0001f3ff\U0001f476", {97, 128118}, {2, 3}},
     {L"\U00000061\U0001f3ff\U0001f476\U0000200d\U0001f6d1", {97, 128118}, {2, 5}},
     {L"\U0001f476\U0001f3ff\U00000308\U0000200d\U0001f476\U0001f3ff", {128118}, {6}},
     {L"\U0001f6d1\U0000200d\U0001f6d1", {128721}, {3}},
     {L"\U00000061\U0000200d\U0001f6d1", {97, 128721}, {2, 3}},
     {L"\U00002701\U0000200d\U00002701", {9985}, {3}},
     {L"\U00000061\U0000200d\U00002701", {97, 9985}, {2, 3}},
     {L"\U00000915\U00000924", {2325, 2340}, {1, 2}},
     {L"\U00000915\U0000094d\U00000924", {2325}, {3}},
     {L"\U00000915\U0000094d\U0000094d\U00000924", {2325}, {4}},
     {L"\U00000915\U0000094d\U0000200d\U00000924", {2325}, {4}},
     {L"\U00000915\U0000093c\U0000200d\U0000094d\U00000924", {2325}, {5}},
     {L"\U00000915\U0000093c\U0000094d\U0000200d\U00000924", {2325}, {5}},
     {L"\U00000915\U0000094d\U00000924\U0000094d\U0000092f", {2325}, {5}},
     {L"\U00000915\U0000094d\U00000061", {2325, 97}, {2, 3}},
     {L"\U00000061\U0000094d\U00000924", {97, 2340}, {2, 3}},
     {L"\U0000003f\U0000094d\U00000924", {63, 2340}, {2, 3}},
     {L"\U00000915\U0000094d\U0000094d\U00000924", {2325}, {4}}}};
#endif // TEST_HAS_NO_WIDE_CHARACTERS

#endif // LIBCXX_TEST_STD_UTILITIES_FORMAT_FORMAT_STRING_FORMAT_STRING_STD_EXTENDED_GRAPHEME_CLUSTER_H
