set(CMAKE_SYSTEM_NAME Linux)
set(CMAKE_SYSTEM_PROCESSOR aarch64)
set(CMAKE_CROSSCOMPILING TRUE)

set(CMAKE_C_COMPILER /usr/bin/clang)
set(CMAKE_CXX_COMPILER /usr/bin/clang++)

set(CMAKE_C_COMPILER_TARGET aarch64-linux-gnu)
set(CMAKE_CXX_COMPILER_TARGET aarch64-linux-gnu)

set(CMAKE_FIND_ROOT_PATH /usr/aarch64-linux-gnu)
set(CMAKE_FIND_ROOT_PATH_MODE_PROGRAM NEVER)
set(PKG_CONFIG_EXECUTABLE
    /usr/bin/aarch64-linux-gnu-pkg-config
    CACHE FILEPATH "pkg-config executable")

execute_process(
  COMMAND ${CMAKE_C_COMPILER} -print-prog-name=llvm-ranlib
  OUTPUT_VARIABLE CMAKE_RANLIB
  OUTPUT_STRIP_TRAILING_WHITESPACE)

execute_process(
  COMMAND ${CMAKE_C_COMPILER} -print-prog-name=llvm-ar
  OUTPUT_VARIABLE CMAKE_LLVM_AR
  OUTPUT_STRIP_TRAILING_WHITESPACE)

execute_process(
  COMMAND ${CMAKE_C_COMPILER} -print-prog-name=llvm-readelf
  OUTPUT_VARIABLE READELF
  OUTPUT_STRIP_TRAILING_WHITESPACE)

execute_process(
  COMMAND ${CMAKE_C_COMPILER} -print-prog-name=llvm-objcopy
  OUTPUT_VARIABLE CMAKE_LLVM_OBJCOPY
  OUTPUT_STRIP_TRAILING_WHITESPACE)

execute_process(
  COMMAND ${CMAKE_C_COMPILER} -print-prog-name=llvm-objdump
  OUTPUT_VARIABLE CMAKE_LLVM_OBJDUMP
  OUTPUT_STRIP_TRAILING_WHITESPACE)

set(CMAKE_AR
    "${CMAKE_LLVM_AR}"
    CACHE INTERNAL "${CMAKE_SYSTEM_NAME} ar" FORCE)
set(CMAKE_OBJCOPY
    "${CMAKE_LLVM_OBJCOPY}"
    CACHE INTERNAL "${CMAKE_SYSTEM_NAME} objcopy" FORCE)
set(CMAKE_OBJDUMP
    "${CMAKE_LLVM_OBJDUMP}"
    CACHE INTERNAL "${CMAKE_SYSTEM_NAME} objdump" FORCE)

set(CPACK_READELF_EXECUTABLE "${READELF}")
set(CPACK_OBJCOPY_EXECUTABLE "${CMAKE_LLVM_OBJCOPY}")
set(CPACK_OBJDUMP_EXECUTABLE "${CMAKE_LLVM_OBJDUMP}")
set(CPACK_PACKAGE_ARCHITECTURE arm64)
set(CPACK_DEBIAN_PACKAGE_ARCHITECTURE arm64)
