/*
 * Contributed by Stephane Eranian <eranian@gmail.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * This file is part of libpfm, a performance monitoring support library for
 * applications on Linux.
 *
 * PMU: icx_unc_m2m (IcelakeX Uncore M2M)
 * Based on Intel JSON event table version   : 1.21
 * Based on Intel JSON event table published : 06/06/2023
 */
static const intel_x86_umask_t icx_unc_m2m_ag0_ad_crd_occupancy0[]={
  { .uname   = "TGR0",
    .udesc   = "For Transgress 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR1",
    .udesc   = "For Transgress 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR2",
    .udesc   = "For Transgress 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR3",
    .udesc   = "For Transgress 3 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR4",
    .udesc   = "For Transgress 4 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR5",
    .udesc   = "For Transgress 5 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR6",
    .udesc   = "For Transgress 6 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR7",
    .udesc   = "For Transgress 7 (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_ag0_ad_crd_occupancy1[]={
  { .uname   = "TGR10",
    .udesc   = "For Transgress 10 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR8",
    .udesc   = "For Transgress 8 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR9",
    .udesc   = "For Transgress 9 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_ag0_bl_crd_occupancy0[]={
  { .uname   = "TGR0",
    .udesc   = "For Transgress 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR1",
    .udesc   = "For Transgress 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR2",
    .udesc   = "For Transgress 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR3",
    .udesc   = "For Transgress 3 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR4",
    .udesc   = "For Transgress 4 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR5",
    .udesc   = "For Transgress 5 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR6",
    .udesc   = "For Transgress 6 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR7",
    .udesc   = "For Transgress 7 (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_ag0_bl_crd_occupancy1[]={
  { .uname   = "TGR10",
    .udesc   = "For Transgress 10 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR8",
    .udesc   = "For Transgress 8 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR9",
    .udesc   = "For Transgress 9 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_ag1_ad_crd_occupancy0[]={
  { .uname   = "TGR0",
    .udesc   = "For Transgress 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR1",
    .udesc   = "For Transgress 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR2",
    .udesc   = "For Transgress 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR3",
    .udesc   = "For Transgress 3 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR4",
    .udesc   = "For Transgress 4 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR5",
    .udesc   = "For Transgress 5 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR6",
    .udesc   = "For Transgress 6 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR7",
    .udesc   = "For Transgress 7 (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_ag1_ad_crd_occupancy1[]={
  { .uname   = "TGR10",
    .udesc   = "For Transgress 10 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR8",
    .udesc   = "For Transgress 8 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR9",
    .udesc   = "For Transgress 9 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_ag1_bl_crd_acquired0[]={
  { .uname   = "TGR0",
    .udesc   = "For Transgress 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR1",
    .udesc   = "For Transgress 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR2",
    .udesc   = "For Transgress 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR3",
    .udesc   = "For Transgress 3 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR4",
    .udesc   = "For Transgress 4 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR5",
    .udesc   = "For Transgress 5 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR6",
    .udesc   = "For Transgress 4 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR7",
    .udesc   = "For Transgress 5 (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_ag1_bl_crd_occupancy1[]={
  { .uname   = "TGR10",
    .udesc   = "For Transgress 10 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR8",
    .udesc   = "For Transgress 8 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR9",
    .udesc   = "For Transgress 9 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_bypass_m2m_ingress[]={
  { .uname   = "NOT_TAKEN",
    .udesc   = "Not Taken (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TAKEN",
    .udesc   = "Taken (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_directory_lookup[]={
  { .uname   = "ANY",
    .udesc   = "Found in any state",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "STATE_A",
    .udesc   = "Found in A state",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "STATE_I",
    .udesc   = "Found in I state",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "STATE_S",
    .udesc   = "Found in S state",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_directory_miss[]={
  { .uname   = "CLEAN_A",
    .udesc   = "On NonDirty Line in A State (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CLEAN_I",
    .udesc   = "On NonDirty Line in I State (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CLEAN_P",
    .udesc   = "On NonDirty Line in L State (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CLEAN_S",
    .udesc   = "On NonDirty Line in S State (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DIRTY_A",
    .udesc   = "On Dirty Line in A State (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DIRTY_I",
    .udesc   = "On Dirty Line in I State (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DIRTY_P",
    .udesc   = "On Dirty Line in L State (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DIRTY_S",
    .udesc   = "On Dirty Line in S State (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_directory_update[]={
  { .uname   = "ANY",
    .udesc   = "From/to any state. Note: event counts are incorrect in 2LM mode.",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_DFL,
  },
};

static const intel_x86_umask_t icx_unc_m2m_distress_asserted[]={
  { .uname   = "DPT_LOCAL",
    .udesc   = "DPT Local (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DPT_NONLOCAL",
    .udesc   = "DPT Remote (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DPT_STALL_IV",
    .udesc   = "DPT Stalled - IV (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DPT_STALL_NOCRD",
    .udesc   = "DPT Stalled -  No Credit (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "HORZ",
    .udesc   = "Horizontal (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PMM_LOCAL",
    .udesc   = "PMM Local (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PMM_NONLOCAL",
    .udesc   = "PMM Remote (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VERT",
    .udesc   = "Vertical (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_egress_ordering[]={
  { .uname   = "IV_SNOOPGO_DN",
    .udesc   = "Down (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV_SNOOPGO_UP",
    .udesc   = "Up (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_horz_ring_akc_in_use[]={
  { .uname   = "LEFT_EVEN",
    .udesc   = "Left and Even (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LEFT_ODD",
    .udesc   = "Left and Odd (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RIGHT_EVEN",
    .udesc   = "Right and Even (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RIGHT_ODD",
    .udesc   = "Right and Odd (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_horz_ring_bl_in_use[]={
  { .uname   = "LEFT_EVEN",
    .udesc   = "Left and Even (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LEFT_ODD",
    .udesc   = "Left and Odd (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RIGHT_EVEN",
    .udesc   = "Right and Even (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RIGHT_ODD",
    .udesc   = "Right and Odd (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_horz_ring_iv_in_use[]={
  { .uname   = "LEFT",
    .udesc   = "Left (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RIGHT",
    .udesc   = "Right (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_imc_reads[]={
  { .uname   = "ALL",
    .udesc   = "All, regardless of priority. - All Channels (experimental)",
    .ucode   = 0x700000400ull,
    .uflags  = INTEL_X86_NCOMBO | INTEL_X86_DFL,
  },
  { .uname   = "CH0_ALL",
    .udesc   = "All, regardless of priority. - Ch0 (experimental)",
    .ucode   = 0x100000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH0_FROM_TGR",
    .udesc   = "From TGR - Ch0 (experimental)",
    .ucode   = 0x100004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH0_ISOCH",
    .udesc   = "Critical Priority - Ch0 (experimental)",
    .ucode   = 0x100000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH0_NORMAL",
    .udesc   = "Normal Priority - Ch0 (experimental)",
    .ucode   = 0x100000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH0_TO_DDR_AS_CACHE",
    .udesc   = "DDR, acting as Cache - Ch0 (experimental)",
    .ucode   = 0x100001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH0_TO_DDR_AS_MEM",
    .udesc   = "DDR - Ch0 (experimental)",
    .ucode   = 0x100000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH0_TO_PMM",
    .udesc   = "PMM - Ch0 (experimental)",
    .ucode   = 0x100002000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH1_ALL",
    .udesc   = "All, regardless of priority. - Ch1 (experimental)",
    .ucode   = 0x200000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH1_FROM_TGR",
    .udesc   = "From TGR - Ch1 (experimental)",
    .ucode   = 0x200004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH1_ISOCH",
    .udesc   = "Critical Priority - Ch1 (experimental)",
    .ucode   = 0x200000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH1_NORMAL",
    .udesc   = "Normal Priority - Ch1 (experimental)",
    .ucode   = 0x200000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH1_TO_DDR_AS_CACHE",
    .udesc   = "DDR, acting as Cache - Ch1 (experimental)",
    .ucode   = 0x200001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH1_TO_DDR_AS_MEM",
    .udesc   = "DDR - Ch1 (experimental)",
    .ucode   = 0x200000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH1_TO_PMM",
    .udesc   = "PMM - Ch1 (experimental)",
    .ucode   = 0x200002000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH2_FROM_TGR",
    .udesc   = "From TGR - Ch2 (experimental)",
    .ucode   = 0x400004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "FROM_TGR",
    .udesc   = "From TGR - All Channels (experimental)",
    .ucode   = 0x700004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ISOCH",
    .udesc   = "Critical Priority - All Channels (experimental)",
    .ucode   = 0x700000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NORMAL",
    .udesc   = "Normal Priority - All Channels (experimental)",
    .ucode   = 0x700000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TO_DDR_AS_CACHE",
    .udesc   = "DDR, acting as Cache - All Channels (experimental)",
    .ucode   = 0x700001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TO_DDR_AS_MEM",
    .udesc   = "DDR - All Channels (experimental)",
    .ucode   = 0x700000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TO_PMM",
    .udesc   = "PMM - All Channels",
    .ucode   = 0x700002000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_imc_writes[]={
  { .uname   = "ALL",
    .udesc   = "All Writes - All Channels (experimental)",
    .ucode   = 0x1c00001000ull,
    .uflags  = INTEL_X86_NCOMBO | INTEL_X86_DFL,
  },
  { .uname   = "CH0_ALL",
    .udesc   = "All Writes - Ch0 (experimental)",
    .ucode   = 0x400001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH0_FROM_TGR",
    .udesc   = "From TGR - Ch0 (experimental)",
    .ucode   = 0x500000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH0_FULL",
    .udesc   = "Full Line Non-ISOCH - Ch0 (experimental)",
    .ucode   = 0x400000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH0_FULL_ISOCH",
    .udesc   = "ISOCH Full Line - Ch0 (experimental)",
    .ucode   = 0x400000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH0_NI",
    .udesc   = "Non-Inclusive - Ch0 (experimental)",
    .ucode   = 0x600000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH0_NI_MISS",
    .udesc   = "Non-Inclusive Miss - Ch0 (experimental)",
    .ucode   = 0x2000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH0_PARTIAL",
    .udesc   = "Partial Non-ISOCH - Ch0 (experimental)",
    .ucode   = 0x400000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH0_PARTIAL_ISOCH",
    .udesc   = "ISOCH Partial - Ch0 (experimental)",
    .ucode   = 0x400000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH0_TO_DDR_AS_CACHE",
    .udesc   = "DDR, acting as Cache - Ch0 (experimental)",
    .ucode   = 0x400004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH0_TO_DDR_AS_MEM",
    .udesc   = "DDR - Ch0 (experimental)",
    .ucode   = 0x400002000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH0_TO_PMM",
    .udesc   = "PMM - Ch0 (experimental)",
    .ucode   = 0x400008000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH1_ALL",
    .udesc   = "All Writes - Ch1 (experimental)",
    .ucode   = 0x800001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH1_FROM_TGR",
    .udesc   = "From TGR - Ch1 (experimental)",
    .ucode   = 0x900000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH1_FULL",
    .udesc   = "Full Line Non-ISOCH - Ch1 (experimental)",
    .ucode   = 0x800000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH1_FULL_ISOCH",
    .udesc   = "ISOCH Full Line - Ch1 (experimental)",
    .ucode   = 0x800000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH1_NI",
    .udesc   = "Non-Inclusive - Ch1 (experimental)",
    .ucode   = 0xa00000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH1_NI_MISS",
    .udesc   = "Non-Inclusive Miss - Ch1 (experimental)",
    .ucode   = 0xc00000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH1_PARTIAL",
    .udesc   = "Partial Non-ISOCH - Ch1 (experimental)",
    .ucode   = 0x800000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH1_PARTIAL_ISOCH",
    .udesc   = "ISOCH Partial - Ch1 (experimental)",
    .ucode   = 0x800000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH1_TO_DDR_AS_CACHE",
    .udesc   = "DDR, acting as Cache - Ch1 (experimental)",
    .ucode   = 0x800004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH1_TO_DDR_AS_MEM",
    .udesc   = "DDR - Ch1 (experimental)",
    .ucode   = 0x800002000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH1_TO_PMM",
    .udesc   = "PMM - Ch1 (experimental)",
    .ucode   = 0x800008000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "FROM_TGR",
    .udesc   = "From TGR - All Channels (experimental)",
    .ucode   = 0x1d00000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "FULL",
    .udesc   = "Full Line Non-ISOCH - All Channels (experimental)",
    .ucode   = 0x1c00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "FULL_ISOCH",
    .udesc   = "ISOCH Full Line - All Channels (experimental)",
    .ucode   = 0x1c00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NI",
    .udesc   = "Non-Inclusive - All Channels (experimental)",
    .ucode   = 0x1e00000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NI_MISS",
    .udesc   = "Non-Inclusive Miss - All Channels (experimental)",
    .ucode   = 0x1c00000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PARTIAL",
    .udesc   = "Partial Non-ISOCH - All Channels (experimental)",
    .ucode   = 0x1c00000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PARTIAL_ISOCH",
    .udesc   = "ISOCH Partial - All Channels (experimental)",
    .ucode   = 0x1c00000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TO_DDR_AS_CACHE",
    .udesc   = "DDR, acting as Cache - All Channels (experimental)",
    .ucode   = 0x1c00004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TO_DDR_AS_MEM",
    .udesc   = "DDR - All Channels (experimental)",
    .ucode   = 0x1c00002000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TO_PMM",
    .udesc   = "PMM - All Channels",
    .ucode   = 0x1c00008000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_misc_external[]={
  { .uname   = "MBE_INST0",
    .udesc   = "Number of cycles MBE is high for MS2IDI0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MBE_INST1",
    .udesc   = "Number of cycles MBE is high for MS2IDI1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_pkt_match[]={
  { .uname   = "MC",
    .udesc   = "MC Match (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MESH",
    .udesc   = "Mesh Match (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_prefcam_cycles_ne[]={
  { .uname   = "ALLCH",
    .udesc   = "All Channels (experimental)",
    .ucode   = 0x0700ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH0",
    .udesc   = "Channel 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH1",
    .udesc   = "Channel 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH2",
    .udesc   = "Channel 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_prefcam_deallocs[]={
  { .uname   = "CH0_HITA0_INVAL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH0_HITA1_INVAL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH0_MISS_INVAL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH0_RSP_PDRESET",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH1_HITA0_INVAL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH1_HITA1_INVAL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH1_MISS_INVAL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH1_RSP_PDRESET",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH2_HITA0_INVAL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x100000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH2_HITA1_INVAL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x200000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH2_MISS_INVAL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x400000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH2_RSP_PDRESET",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x800000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_prefcam_demand_merge[]={
  { .uname   = "CH0_XPTUPI",
    .udesc   = "XPT & UPI- Ch 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH1_XPTUPI",
    .udesc   = "XPT & UPI - Ch 1 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH2_XPTUPI",
    .udesc   = "XPT & UPI- Ch 2 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "XPTUPI_ALLCH",
    .udesc   = "XPT & UPI- All Channels (experimental)",
    .ucode   = 0x1500ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_prefcam_demand_no_merge[]={
  { .uname   = "CH0_XPTUPI",
    .udesc   = "XPT & UPI - Ch 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH1_XPTUPI",
    .udesc   = "XPT & UPI - Ch 1 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH2_XPTUPI",
    .udesc   = "XPT & UPI - Ch 2 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "XPTUPI_ALLCH",
    .udesc   = "XPT & UPI - All Channels (experimental)",
    .ucode   = 0x1500ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_prefcam_drop_reasons_ch1[]={
  { .uname   = "ERRORBLK_RxC",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NOT_PF_SAD_REGION",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PF_AD_CRD",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PF_CAM_FULL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PF_CAM_HIT",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PF_SECURE_DROP",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RPQ_PROXY",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x100000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "STOP_B2B",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UPI_THRESH",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x400000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WPQ_PROXY",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "XPT_THRESH",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x200000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_prefcam_drop_reasons_ch2[]={
  { .uname   = "ERRORBLK_RxC",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NOT_PF_SAD_REGION",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PF_AD_CRD",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PF_CAM_FULL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PF_CAM_HIT",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PF_SECURE_DROP",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RPQ_PROXY",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x100000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "STOP_B2B",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UPI_THRESH",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x400000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WPQ_PROXY",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "XPT_THRESH",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x200000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_prefcam_inserts[]={
  { .uname   = "CH0_UPI",
    .udesc   = "UPI - Ch 0 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH0_XPT",
    .udesc   = "XPT - Ch 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH1_UPI",
    .udesc   = "UPI - Ch 1 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH1_XPT",
    .udesc   = "XPT - Ch 1 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH2_UPI",
    .udesc   = "UPI - Ch 2 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH2_XPT",
    .udesc   = "XPT - Ch 2 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UPI_ALLCH",
    .udesc   = "UPI - All Channels (experimental)",
    .ucode   = 0x2a00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "XPT_ALLCH",
    .udesc   = "XPT - All Channels (experimental)",
    .ucode   = 0x1500ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_prefcam_resp_miss[]={
  { .uname   = "ALLCH",
    .udesc   = "All Channels (experimental)",
    .ucode   = 0x0700ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH0",
    .udesc   = "Channel 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH1",
    .udesc   = "Channel 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH2",
    .udesc   = "Channel 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_prefcam_rxc_deallocs[]={
  { .uname   = "1LM_POSTED",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CIS",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PMM_MEMMODE_ACCEPT",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SQUASHED",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_ring_bounces_horz[]={
  { .uname   = "AD",
    .udesc   = "AD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK",
    .udesc   = "AK (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL",
    .udesc   = "BL (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV",
    .udesc   = "IV (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_ring_sink_starved_horz[]={
  { .uname   = "AD",
    .udesc   = "AD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK",
    .udesc   = "AK (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_AG1",
    .udesc   = "Acknowledgements to Agent 1 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL",
    .udesc   = "BL (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV",
    .udesc   = "IV (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_ring_sink_starved_vert[]={
  { .uname   = "AD",
    .udesc   = "AD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK",
    .udesc   = "Acknowledgements to core (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AKC",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL",
    .udesc   = "Data Responses to core (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV",
    .udesc   = "Snoops of processor's cache. (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_rpq_no_spec_crd[]={
  { .uname   = "CH0",
    .udesc   = "Channel 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH1",
    .udesc   = "Channel 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH2",
    .udesc   = "Channel 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_rxr_crd_starved[]={
  { .uname   = "AD_ALL",
    .udesc   = "AD - All (experimental)",
    .ucode   = 0x1100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_CRD",
    .udesc   = "AD - Credited (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_UNCRD",
    .udesc   = "AD - Uncredited (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK",
    .udesc   = "AK (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_ALL",
    .udesc   = "BL - All (experimental)",
    .ucode   = 0x4400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_CRD",
    .udesc   = "BL - Credited (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_UNCRD",
    .udesc   = "BL - Uncredited (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IFV",
    .udesc   = "IFV - Credited (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV",
    .udesc   = "IV (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_rxr_inserts[]={
  { .uname   = "AD_ALL",
    .udesc   = "AD - All (experimental)",
    .ucode   = 0x1100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_CRD",
    .udesc   = "AD - Credited (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_UNCRD",
    .udesc   = "AD - Uncredited (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK",
    .udesc   = "AK (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AKC_UNCRD",
    .udesc   = "AKC - Uncredited (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_ALL",
    .udesc   = "BL - All (experimental)",
    .ucode   = 0x4400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_CRD",
    .udesc   = "BL - Credited (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_UNCRD",
    .udesc   = "BL - Uncredited (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV",
    .udesc   = "IV (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_rxr_occupancy[]={
  { .uname   = "AD_ALL",
    .udesc   = "AD - All (experimental)",
    .ucode   = 0x1100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_CRD",
    .udesc   = "AD - Credited (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_UNCRD",
    .udesc   = "AD - Uncredited (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK",
    .udesc   = "AK (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AKC_UNCRD",
    .udesc   = "AKC - Uncredited (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_ALL",
    .udesc   = "BL - All (experimental)",
    .ucode   = 0x4400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_CRD",
    .udesc   = "BL - Credited (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_UNCRD",
    .udesc   = "BL - Uncredited (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV",
    .udesc   = "IV (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_stall0_no_txr_horz_crd_ad_ag0[]={
  { .uname   = "TGR0",
    .udesc   = "For Transgress 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR1",
    .udesc   = "For Transgress 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR2",
    .udesc   = "For Transgress 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR3",
    .udesc   = "For Transgress 3 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR4",
    .udesc   = "For Transgress 4 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR5",
    .udesc   = "For Transgress 5 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR6",
    .udesc   = "For Transgress 6 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR7",
    .udesc   = "For Transgress 7 (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_stall0_no_txr_horz_crd_bl_ag0[]={
  { .uname   = "TGR0",
    .udesc   = "For Transgress 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR1",
    .udesc   = "For Transgress 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR2",
    .udesc   = "For Transgress 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR3",
    .udesc   = "For Transgress 3 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR4",
    .udesc   = "For Transgress 4 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR5",
    .udesc   = "For Transgress 5 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR6",
    .udesc   = "For Transgress 6 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR7",
    .udesc   = "For Transgress 7 (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_stall0_no_txr_horz_crd_bl_ag1[]={
  { .uname   = "TGR0",
    .udesc   = "For Transgress 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR1",
    .udesc   = "For Transgress 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR2",
    .udesc   = "For Transgress 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR3",
    .udesc   = "For Transgress 3 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR4",
    .udesc   = "For Transgress 4 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR5",
    .udesc   = "For Transgress 5 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR6",
    .udesc   = "For Transgress 6 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR7",
    .udesc   = "For Transgress 7 (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_stall1_no_txr_horz_crd_ad_ag1_1[]={
  { .uname   = "TGR10",
    .udesc   = "For Transgress 10 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR8",
    .udesc   = "For Transgress 8 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR9",
    .udesc   = "For Transgress 9 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_stall1_no_txr_horz_crd_bl_ag1_1[]={
  { .uname   = "TGR10",
    .udesc   = "For Transgress 10 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR8",
    .udesc   = "For Transgress 8 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR9",
    .udesc   = "For Transgress 9 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_tag_hit[]={
  { .uname   = "NM_RD_HIT_CLEAN",
    .udesc   = "Clean NearMem Read Hit",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NM_RD_HIT_DIRTY",
    .udesc   = "Dirty NearMem Read Hit",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NM_UFILL_HIT_CLEAN",
    .udesc   = "Clean NearMem Underfill Hit (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NM_UFILL_HIT_DIRTY",
    .udesc   = "Dirty NearMem Underfill Hit (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_tracker_inserts[]={
  { .uname   = "CH0",
    .udesc   = "Channel 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH1",
    .udesc   = "Channel 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH2",
    .udesc   = "Channel 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_tracker_occupancy[]={
  { .uname   = "CH0",
    .udesc   = "Channel 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH1",
    .udesc   = "Channel 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH2",
    .udesc   = "Channel 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_txc_ak[]={
  { .uname   = "CRD_CBO",
    .udesc   = "CRD Transactions to Cbo (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NDR",
    .udesc   = "NDR Transactions (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_txc_ak_cycles_full[]={
  { .uname   = "ALL",
    .udesc   = "All (experimental)",
    .ucode   = 0x0300ull,
    .uflags  = INTEL_X86_NCOMBO | INTEL_X86_DFL,
  },
  { .uname   = "CMS0",
    .udesc   = "Common Mesh Stop - Near Side (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CMS1",
    .udesc   = "Common Mesh Stop - Far Side (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RDCRD0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RDCRD1",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x8800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WRCMP0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WRCMP1",
    .udesc   = "TBD (experimental)",
    .ucode   = 0xa000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WRCRD0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WRCRD1",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x9000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_txc_ak_inserts[]={
  { .uname   = "ALL",
    .udesc   = "All (experimental)",
    .ucode   = 0x0300ull,
    .uflags  = INTEL_X86_NCOMBO | INTEL_X86_DFL,
  },
  { .uname   = "CMS0",
    .udesc   = "Common Mesh Stop - Near Side (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CMS1",
    .udesc   = "Common Mesh Stop - Far Side (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PREF_RD_CAM_HIT",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RDCRD",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WRCMP",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WRCRD",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_txc_ak_no_credit_cycles[]={
  { .uname   = "CMS0",
    .udesc   = "Common Mesh Stop - Near Side (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CMS1",
    .udesc   = "Common Mesh Stop - Far Side (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_txc_ak_occupancy[]={
  { .uname   = "ALL",
    .udesc   = "All (experimental)",
    .ucode   = 0x0300ull,
    .uflags  = INTEL_X86_NCOMBO | INTEL_X86_DFL,
  },
  { .uname   = "CMS0",
    .udesc   = "Common Mesh Stop - Near Side (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CMS1",
    .udesc   = "Common Mesh Stop - Far Side (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RDCRD",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WRCMP",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WRCRD",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_txc_bl[]={
  { .uname   = "DRS_CACHE",
    .udesc   = "Data to Cache (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DRS_CORE",
    .udesc   = "Data to Core (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DRS_UPI",
    .udesc   = "Data to QPI (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_txc_bl_credits_acquired[]={
  { .uname   = "CMS0",
    .udesc   = "Common Mesh Stop - Near Side (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CMS1",
    .udesc   = "Common Mesh Stop - Far Side (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_txc_bl_cycles_ne[]={
  { .uname   = "ALL",
    .udesc   = "All (experimental)",
    .ucode   = 0x0300ull,
    .uflags  = INTEL_X86_NCOMBO | INTEL_X86_DFL,
  },
  { .uname   = "CMS0",
    .udesc   = "Common Mesh Stop - Near Side (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CMS1",
    .udesc   = "Common Mesh Stop - Far Side (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_txc_bl_inserts[]={
  { .uname   = "ALL",
    .udesc   = "All (experimental)",
    .ucode   = 0x0300ull,
    .uflags  = INTEL_X86_NCOMBO | INTEL_X86_DFL,
  },
  { .uname   = "CMS0",
    .udesc   = "Common Mesh Stop - Near Side (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CMS1",
    .udesc   = "Common Mesh Stop - Far Side (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_txc_bl_no_credit_stalled[]={
  { .uname   = "CMS0",
    .udesc   = "Common Mesh Stop - Near Side (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CMS1",
    .udesc   = "Common Mesh Stop - Far Side (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_txr_horz_ads_used[]={
  { .uname   = "AD_ALL",
    .udesc   = "AD - All (experimental)",
    .ucode   = 0x1100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_CRD",
    .udesc   = "AD - Credited (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_UNCRD",
    .udesc   = "AD - Uncredited (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_ALL",
    .udesc   = "BL - All (experimental)",
    .ucode   = 0x4400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_CRD",
    .udesc   = "BL - Credited (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_UNCRD",
    .udesc   = "BL - Uncredited (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_txr_horz_cycles_full[]={
  { .uname   = "AD_ALL",
    .udesc   = "AD - All (experimental)",
    .ucode   = 0x1100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_CRD",
    .udesc   = "AD - Credited (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_UNCRD",
    .udesc   = "AD - Uncredited (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK",
    .udesc   = "AK (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AKC_UNCRD",
    .udesc   = "AKC - Uncredited (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_ALL",
    .udesc   = "BL - All (experimental)",
    .ucode   = 0x4400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_CRD",
    .udesc   = "BL - Credited (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_UNCRD",
    .udesc   = "BL - Uncredited (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV",
    .udesc   = "IV (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_txr_horz_inserts[]={
  { .uname   = "AD_ALL",
    .udesc   = "AD - All (experimental)",
    .ucode   = 0x1100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_CRD",
    .udesc   = "AD - Credited (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_UNCRD",
    .udesc   = "AD - Uncredited (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK",
    .udesc   = "AK (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AKC_UNCRD",
    .udesc   = "AKC - Uncredited (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_ALL",
    .udesc   = "BL - All (experimental)",
    .ucode   = 0x4400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_CRD",
    .udesc   = "BL - Credited (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_UNCRD",
    .udesc   = "BL - Uncredited (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV",
    .udesc   = "IV (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_txr_horz_occupancy[]={
  { .uname   = "AD_ALL",
    .udesc   = "AD - All (experimental)",
    .ucode   = 0x1100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_CRD",
    .udesc   = "AD - Credited (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_UNCRD",
    .udesc   = "AD - Uncredited (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK",
    .udesc   = "AK (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AKC_UNCRD",
    .udesc   = "AKC - Uncredited (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_ALL",
    .udesc   = "BL - All (experimental)",
    .ucode   = 0x4400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_CRD",
    .udesc   = "BL - Credited (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_UNCRD",
    .udesc   = "BL - Uncredited (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV",
    .udesc   = "IV (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_txr_horz_starved[]={
  { .uname   = "AD_ALL",
    .udesc   = "AD - All (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_UNCRD",
    .udesc   = "AD - Uncredited (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK",
    .udesc   = "AK (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AKC_UNCRD",
    .udesc   = "AKC - Uncredited (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_ALL",
    .udesc   = "BL - All (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_UNCRD",
    .udesc   = "BL - Uncredited (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV",
    .udesc   = "IV (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_txr_vert_ads_used[]={
  { .uname   = "AD_AG0",
    .udesc   = "AD - Agent 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_AG1",
    .udesc   = "AD - Agent 1 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_AG0",
    .udesc   = "BL - Agent 0 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_AG1",
    .udesc   = "BL - Agent 1 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_txr_vert_bypass[]={
  { .uname   = "AD_AG0",
    .udesc   = "AD - Agent 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_AG1",
    .udesc   = "AD - Agent 1 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_AG0",
    .udesc   = "AK - Agent 0 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_AG1",
    .udesc   = "AK - Agent 1 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_AG0",
    .udesc   = "BL - Agent 0 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_AG1",
    .udesc   = "BL - Agent 1 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV_AG1",
    .udesc   = "IV - Agent 1 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_txr_vert_cycles_full1[]={
  { .uname   = "AKC_AG0",
    .udesc   = "AKC - Agent 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AKC_AG1",
    .udesc   = "AKC - Agent 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_txr_vert_cycles_ne0[]={
  { .uname   = "AD_AG0",
    .udesc   = "AD - Agent 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_AG1",
    .udesc   = "AD - Agent 1 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_AG0",
    .udesc   = "AK - Agent 0 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_AG1",
    .udesc   = "AK - Agent 1 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_AG0",
    .udesc   = "BL - Agent 0 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_AG1",
    .udesc   = "BL - Agent 1 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV_AG0",
    .udesc   = "IV - Agent 0 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_txr_vert_inserts1[]={
  { .uname   = "AKC_AG0",
    .udesc   = "AKC - Agent 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AKC_AG1",
    .udesc   = "AKC - Agent 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_txr_vert_occupancy0[]={
  { .uname   = "AD_AG0",
    .udesc   = "AD - Agent 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_AG1",
    .udesc   = "AD - Agent 1 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_AG0",
    .udesc   = "AK - Agent 0 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_AG1",
    .udesc   = "AK - Agent 1 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_AG0",
    .udesc   = "BL - Agent 0 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_AG1",
    .udesc   = "BL - Agent 1 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV_AG0",
    .udesc   = "IV - Agent 0 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_txr_vert_occupancy1[]={
  { .uname   = "AKC_AG0",
    .udesc   = "AKC - Agent 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AKC_AG1",
    .udesc   = "AKC - Agent 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_txr_vert_starved0[]={
  { .uname   = "AD_AG0",
    .udesc   = "AD - Agent 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_AG1",
    .udesc   = "AD - Agent 1 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_AG0",
    .udesc   = "AK - Agent 0 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_AG1",
    .udesc   = "AK - Agent 1 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_AG0",
    .udesc   = "BL - Agent 0 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_AG1",
    .udesc   = "BL - Agent 1 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV_AG0",
    .udesc   = "IV (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_txr_vert_starved1[]={
  { .uname   = "AKC_AG0",
    .udesc   = "AKC - Agent 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AKC_AG1",
    .udesc   = "AKC - Agent 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGC",
    .udesc   = "AKC - Agent 0 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_vert_ring_akc_in_use[]={
  { .uname   = "DN_EVEN",
    .udesc   = "Down and Even (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DN_ODD",
    .udesc   = "Down and Odd (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UP_EVEN",
    .udesc   = "Up and Even (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UP_ODD",
    .udesc   = "Up and Odd (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_vert_ring_bl_in_use[]={
  { .uname   = "DN_EVEN",
    .udesc   = "Down and Even (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DN_ODD",
    .udesc   = "Down and Odd (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UP_EVEN",
    .udesc   = "Up and Even (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UP_ODD",
    .udesc   = "Up and Odd (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_vert_ring_iv_in_use[]={
  { .uname   = "DN",
    .udesc   = "Down (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UP",
    .udesc   = "Up (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_vert_ring_tgc_in_use[]={
  { .uname   = "DN_EVEN",
    .udesc   = "Down and Even (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DN_ODD",
    .udesc   = "Down and Odd (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UP_EVEN",
    .udesc   = "Up and Even (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UP_ODD",
    .udesc   = "Up and Odd (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_wpq_no_reg_crd[]={
  { .uname   = "CHN0",
    .udesc   = "Channel 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CHN1",
    .udesc   = "Channel 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CHN2",
    .udesc   = "Channel 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_wpq_no_spec_crd[]={
  { .uname   = "CHN0",
    .udesc   = "Channel 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CHN1",
    .udesc   = "Channel 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CHN2",
    .udesc   = "Channel 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_wr_tracker_full[]={
  { .uname   = "CH0",
    .udesc   = "Channel 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH1",
    .udesc   = "Channel 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH2",
    .udesc   = "Channel 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MIRR",
    .udesc   = "Mirror (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_wr_tracker_inserts[]={
  { .uname   = "CH0",
    .udesc   = "Channel 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH1",
    .udesc   = "Channel 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH2",
    .udesc   = "Channel 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_wr_tracker_nonposted_occupancy[]={
  { .uname   = "CH0",
    .udesc   = "Channel 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH1",
    .udesc   = "Channel 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH2",
    .udesc   = "Channel 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_wr_tracker_occupancy[]={
  { .uname   = "CH0",
    .udesc   = "Channel 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH1",
    .udesc   = "Channel 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH2",
    .udesc   = "Channel 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MIRR",
    .udesc   = "Mirror (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MIRR_NONTGR",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MIRR_PWR",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2m_wr_tracker_posted_occupancy[]={
  { .uname   = "CH0",
    .udesc   = "Channel 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH1",
    .udesc   = "Channel 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CH2",
    .udesc   = "Channel 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_entry_t intel_icx_unc_m2m_pe[]={
  { .name   = "UNC_M2M_AG0_AD_CRD_ACQUIRED0",
    .desc   = "CMS Agent0 AD Credits Acquired",
    .code   = 0x0080,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_ag0_ad_crd_occupancy0), /* shared */
    .umasks = icx_unc_m2m_ag0_ad_crd_occupancy0,
  },
  { .name   = "UNC_M2M_AG0_AD_CRD_ACQUIRED1",
    .desc   = "CMS Agent0 AD Credits Acquired",
    .code   = 0x0081,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_ag0_ad_crd_occupancy1), /* shared */
    .umasks = icx_unc_m2m_ag0_ad_crd_occupancy1,
  },
  { .name   = "UNC_M2M_AG0_AD_CRD_OCCUPANCY0",
    .desc   = "CMS Agent0 AD Credits Occupancy",
    .code   = 0x0082,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_ag0_ad_crd_occupancy0),
    .umasks = icx_unc_m2m_ag0_ad_crd_occupancy0,
  },
  { .name   = "UNC_M2M_AG0_AD_CRD_OCCUPANCY1",
    .desc   = "CMS Agent0 AD Credits Occupancy",
    .code   = 0x0083,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_ag0_ad_crd_occupancy1),
    .umasks = icx_unc_m2m_ag0_ad_crd_occupancy1,
  },
  { .name   = "UNC_M2M_AG0_BL_CRD_ACQUIRED0",
    .desc   = "CMS Agent0 BL Credits Acquired",
    .code   = 0x0088,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_ag0_bl_crd_occupancy0), /* shared */
    .umasks = icx_unc_m2m_ag0_bl_crd_occupancy0,
  },
  { .name   = "UNC_M2M_AG0_BL_CRD_ACQUIRED1",
    .desc   = "CMS Agent0 BL Credits Acquired",
    .code   = 0x0089,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_ag0_bl_crd_occupancy1), /* shared */
    .umasks = icx_unc_m2m_ag0_bl_crd_occupancy1,
  },
  { .name   = "UNC_M2M_AG0_BL_CRD_OCCUPANCY0",
    .desc   = "CMS Agent0 BL Credits Occupancy",
    .code   = 0x008a,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_ag0_bl_crd_occupancy0),
    .umasks = icx_unc_m2m_ag0_bl_crd_occupancy0,
  },
  { .name   = "UNC_M2M_AG0_BL_CRD_OCCUPANCY1",
    .desc   = "CMS Agent0 BL Credits Occupancy",
    .code   = 0x008b,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_ag0_bl_crd_occupancy1),
    .umasks = icx_unc_m2m_ag0_bl_crd_occupancy1,
  },
  { .name   = "UNC_M2M_AG1_AD_CRD_ACQUIRED0",
    .desc   = "CMS Agent1 AD Credits Acquired",
    .code   = 0x0084,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_ag1_ad_crd_occupancy0), /* shared */
    .umasks = icx_unc_m2m_ag1_ad_crd_occupancy0,
  },
  { .name   = "UNC_M2M_AG1_AD_CRD_ACQUIRED1",
    .desc   = "CMS Agent1 AD Credits Acquired",
    .code   = 0x0085,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_ag1_ad_crd_occupancy1), /* shared */
    .umasks = icx_unc_m2m_ag1_ad_crd_occupancy1,
  },
  { .name   = "UNC_M2M_AG1_AD_CRD_OCCUPANCY0",
    .desc   = "CMS Agent1 AD Credits Occupancy",
    .code   = 0x0086,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_ag1_ad_crd_occupancy0),
    .umasks = icx_unc_m2m_ag1_ad_crd_occupancy0,
  },
  { .name   = "UNC_M2M_AG1_AD_CRD_OCCUPANCY1",
    .desc   = "CMS Agent1 AD Credits Occupancy",
    .code   = 0x0087,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_ag1_ad_crd_occupancy1),
    .umasks = icx_unc_m2m_ag1_ad_crd_occupancy1,
  },
  { .name   = "UNC_M2M_AG1_BL_CRD_ACQUIRED0",
    .desc   = "CMS Agent1 BL Credits Acquired",
    .code   = 0x008c,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_ag1_bl_crd_acquired0),
    .umasks = icx_unc_m2m_ag1_bl_crd_acquired0,
  },
  { .name   = "UNC_M2M_AG1_BL_CRD_ACQUIRED1",
    .desc   = "CMS Agent1 BL Credits Acquired",
    .code   = 0x008d,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_ag1_bl_crd_occupancy1), /* shared */
    .umasks = icx_unc_m2m_ag1_bl_crd_occupancy1,
  },
  { .name   = "UNC_M2M_AG1_BL_CRD_OCCUPANCY0",
    .desc   = "CMS Agent1 BL Credits Occupancy",
    .code   = 0x008e,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_stall0_no_txr_horz_crd_ad_ag0), /* shared */
    .umasks = icx_unc_m2m_stall0_no_txr_horz_crd_ad_ag0,
  },
  { .name   = "UNC_M2M_AG1_BL_CRD_OCCUPANCY1",
    .desc   = "CMS Agent1 BL Credits Occupancy",
    .code   = 0x008f,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_ag1_bl_crd_occupancy1),
    .umasks = icx_unc_m2m_ag1_bl_crd_occupancy1,
  },
  { .name   = "UNC_M2M_BYPASS_M2M_EGRESS",
    .desc   = "M2M to iMC Bypass",
    .code   = 0x0022,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_bypass_m2m_ingress), /* shared */
    .umasks = icx_unc_m2m_bypass_m2m_ingress,
  },
  { .name   = "UNC_M2M_BYPASS_M2M_INGRESS",
    .desc   = "M2M to iMC Bypass",
    .code   = 0x0021,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_bypass_m2m_ingress),
    .umasks = icx_unc_m2m_bypass_m2m_ingress,
  },
  { .name   = "UNC_M2M_CLOCKTICKS",
    .desc   = "Clockticks of the mesh to memory (M2M)",
    .code   = 0x0000,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_CMS_CLOCKTICKS",
    .desc   = "CMS Clockticks",
    .code   = 0x00c0,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_DIRECT2CORE_NOT_TAKEN_DIRSTATE",
    .desc   = "Cycles when direct to core mode, which bypasses the CHA, was disabled (experimental)",
    .code   = 0x0024,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_DIRECT2CORE_NOT_TAKEN_NOTFORKED",
    .desc   = "UNC_M2M_DIRECT2CORE_NOT_TAKEN_NOTFORKED (experimental)",
    .code   = 0x0060,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_DIRECT2CORE_TXN_OVERRIDE",
    .desc   = "Number of reads in which direct to core transaction was overridden (experimental)",
    .code   = 0x0025,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_DIRECT2UPI_NOT_TAKEN_CREDITS",
    .desc   = "Number of reads in which direct to Intel UPI transactions were overridden (experimental)",
    .code   = 0x0028,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_DIRECT2UPI_NOT_TAKEN_DIRSTATE",
    .desc   = "Cycles when Direct2UPI was Disabled (experimental)",
    .code   = 0x0027,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_DIRECT2UPI_TXN_OVERRIDE",
    .desc   = "Number of reads that a message sent direct2 Intel UPI was overridden (experimental)",
    .code   = 0x0029,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_DIRECTORY_HIT",
    .desc   = "Directory Hit",
    .code   = 0x002a,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_directory_miss), /* shared */
    .umasks = icx_unc_m2m_directory_miss,
  },
  { .name   = "UNC_M2M_DIRECTORY_LOOKUP",
    .desc   = "Multi-socket cacheline Directory Lookups",
    .code   = 0x002d,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_directory_lookup),
    .umasks = icx_unc_m2m_directory_lookup,
  },
  { .name   = "UNC_M2M_DIRECTORY_MISS",
    .desc   = "Directory Miss",
    .code   = 0x002b,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_directory_miss),
    .umasks = icx_unc_m2m_directory_miss,
  },
  { .name   = "UNC_M2M_DIRECTORY_UPDATE",
    .desc   = "Multi-socket cacheline Directory Updates",
    .code   = 0x002e,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_directory_update),
    .umasks = icx_unc_m2m_directory_update,
  },
  { .name   = "UNC_M2M_DISTRESS_ASSERTED",
    .desc   = "Distress signal asserted",
    .code   = 0x00af,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_distress_asserted),
    .umasks = icx_unc_m2m_distress_asserted,
  },
  { .name   = "UNC_M2M_DISTRESS_PMM",
    .desc   = "UNC_M2M_DISTRESS_PMM (experimental)",
    .code   = 0x00f2,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_DISTRESS_PMM_MEMMODE",
    .desc   = "UNC_M2M_DISTRESS_PMM_MEMMODE (experimental)",
    .code   = 0x00f1,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_EGRESS_ORDERING",
    .desc   = "Egress Blocking due to Ordering requirements",
    .code   = 0x00ba,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_egress_ordering),
    .umasks = icx_unc_m2m_egress_ordering,
  },
  { .name   = "UNC_M2M_HORZ_RING_AD_IN_USE",
    .desc   = "Horizontal AD Ring In Use",
    .code   = 0x00b6,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_horz_ring_akc_in_use), /* shared */
    .umasks = icx_unc_m2m_horz_ring_akc_in_use,
  },
  { .name   = "UNC_M2M_HORZ_RING_AKC_IN_USE",
    .desc   = "Horizontal AK Ring In Use",
    .code   = 0x00bb,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_horz_ring_akc_in_use),
    .umasks = icx_unc_m2m_horz_ring_akc_in_use,
  },
  { .name   = "UNC_M2M_HORZ_RING_AK_IN_USE",
    .desc   = "Horizontal AK Ring In Use",
    .code   = 0x00b7,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_horz_ring_bl_in_use), /* shared */
    .umasks = icx_unc_m2m_horz_ring_bl_in_use,
  },
  { .name   = "UNC_M2M_HORZ_RING_BL_IN_USE",
    .desc   = "Horizontal BL Ring in Use",
    .code   = 0x00b8,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_horz_ring_bl_in_use),
    .umasks = icx_unc_m2m_horz_ring_bl_in_use,
  },
  { .name   = "UNC_M2M_HORZ_RING_IV_IN_USE",
    .desc   = "Horizontal IV Ring in Use",
    .code   = 0x00b9,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_horz_ring_iv_in_use),
    .umasks = icx_unc_m2m_horz_ring_iv_in_use,
  },
  { .name   = "UNC_M2M_IMC_READS",
    .desc   = "M2M Reads Issued to iMC",
    .code   = 0x0037,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_imc_reads),
    .umasks = icx_unc_m2m_imc_reads,
  },
  { .name   = "UNC_M2M_IMC_WRITES",
    .desc   = "M2M Writes Issued to iMC",
    .code   = 0x0038,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_imc_writes),
    .umasks = icx_unc_m2m_imc_writes,
  },
  { .name   = "UNC_M2M_MIRR_WRQ_INSERTS",
    .desc   = "Write Tracker Inserts (experimental)",
    .code   = 0x0064,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_MIRR_WRQ_OCCUPANCY",
    .desc   = "Write Tracker Occupancy (experimental)",
    .code   = 0x0065,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_MISC_EXTERNAL",
    .desc   = "Miscellaneous Events (mostly from MS2IDI)",
    .code   = 0x00e6,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_misc_external),
    .umasks = icx_unc_m2m_misc_external,
  },
  { .name   = "UNC_M2M_PKT_MATCH",
    .desc   = "Number Packet Header Matches",
    .code   = 0x004c,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_pkt_match),
    .umasks = icx_unc_m2m_pkt_match,
  },
  { .name   = "UNC_M2M_PREFCAM_CIS_DROPS",
    .desc   = "UNC_M2M_PREFCAM_CIS_DROPS (experimental)",
    .code   = 0x0073,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_PREFCAM_CYCLES_FULL",
    .desc   = "Prefetch CAM Cycles Full",
    .code   = 0x006b,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_prefcam_cycles_ne), /* shared */
    .umasks = icx_unc_m2m_prefcam_cycles_ne,
  },
  { .name   = "UNC_M2M_PREFCAM_CYCLES_NE",
    .desc   = "Prefetch CAM Cycles Not Empty",
    .code   = 0x006c,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_prefcam_cycles_ne),
    .umasks = icx_unc_m2m_prefcam_cycles_ne,
  },
  { .name   = "UNC_M2M_PREFCAM_DEALLOCS",
    .desc   = "Prefetch CAM Deallocs",
    .code   = 0x006e,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_prefcam_deallocs),
    .umasks = icx_unc_m2m_prefcam_deallocs,
  },
  { .name   = "UNC_M2M_PREFCAM_DEMAND_DROPS",
    .desc   = "Data Prefetches Dropped",
    .code   = 0x006f,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_prefcam_inserts), /* shared */
    .umasks = icx_unc_m2m_prefcam_inserts,
  },
  { .name   = "UNC_M2M_PREFCAM_DEMAND_MERGE",
    .desc   = "Demands Merged with CAMed Prefetches",
    .code   = 0x0074,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_prefcam_demand_merge),
    .umasks = icx_unc_m2m_prefcam_demand_merge,
  },
  { .name   = "UNC_M2M_PREFCAM_DEMAND_NO_MERGE",
    .desc   = "Demands Not Merged with CAMed Prefetches",
    .code   = 0x0075,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_prefcam_demand_no_merge),
    .umasks = icx_unc_m2m_prefcam_demand_no_merge,
  },
  { .name   = "UNC_M2M_PREFCAM_DROP_REASONS_CH0",
    .desc   = "Data Prefetches Dropped Ch0 - Reasons",
    .code   = 0x0070,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_prefcam_drop_reasons_ch1), /* shared */
    .umasks = icx_unc_m2m_prefcam_drop_reasons_ch1,
  },
  { .name   = "UNC_M2M_PREFCAM_DROP_REASONS_CH1",
    .desc   = "Data Prefetches Dropped Ch1 - Reasons",
    .code   = 0x0071,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_prefcam_drop_reasons_ch1),
    .umasks = icx_unc_m2m_prefcam_drop_reasons_ch1,
  },
  { .name   = "UNC_M2M_PREFCAM_DROP_REASONS_CH2",
    .desc   = "Data Prefetches Dropped Ch2 - Reasons",
    .code   = 0x0072,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_prefcam_drop_reasons_ch2),
    .umasks = icx_unc_m2m_prefcam_drop_reasons_ch2,
  },
  { .name   = "UNC_M2M_PREFCAM_INSERTS",
    .desc   = "Prefetch CAM Inserts",
    .code   = 0x006d,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_prefcam_inserts),
    .umasks = icx_unc_m2m_prefcam_inserts,
  },
  { .name   = "UNC_M2M_PREFCAM_OCCUPANCY",
    .desc   = "Prefetch CAM Occupancy",
    .code   = 0x006a,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_prefcam_resp_miss), /* shared */
    .umasks = icx_unc_m2m_prefcam_resp_miss,
  },
  { .name   = "UNC_M2M_PREFCAM_RESP_MISS",
    .desc   = "TBD",
    .code   = 0x0076,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_prefcam_resp_miss),
    .umasks = icx_unc_m2m_prefcam_resp_miss,
  },
  { .name   = "UNC_M2M_PREFCAM_RxC_CYCLES_NE",
    .desc   = "UNC_M2M_PREFCAM_RxC_CYCLES_NE (experimental)",
    .code   = 0x0079,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_PREFCAM_RxC_DEALLOCS",
    .desc   = "UNC_M2M_PREFCAM_RxC_DEALLOCS.SQUASHED",
    .code   = 0x007a,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_prefcam_rxc_deallocs),
    .umasks = icx_unc_m2m_prefcam_rxc_deallocs,
  },
  { .name   = "UNC_M2M_PREFCAM_RxC_INSERTS",
    .desc   = "UNC_M2M_PREFCAM_RxC_INSERTS (experimental)",
    .code   = 0x0078,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_RING_BOUNCES_HORZ",
    .desc   = "Messages that bounced on the Horizontal Ring.",
    .code   = 0x00ac,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_ring_bounces_horz),
    .umasks = icx_unc_m2m_ring_bounces_horz,
  },
  { .name   = "UNC_M2M_RING_BOUNCES_VERT",
    .desc   = "Messages that bounced on the Vertical Ring.",
    .code   = 0x00aa,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_ring_sink_starved_vert), /* shared */
    .umasks = icx_unc_m2m_ring_sink_starved_vert,
  },
  { .name   = "UNC_M2M_RING_SINK_STARVED_HORZ",
    .desc   = "Sink Starvation on Horizontal Ring",
    .code   = 0x00ad,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_ring_sink_starved_horz),
    .umasks = icx_unc_m2m_ring_sink_starved_horz,
  },
  { .name   = "UNC_M2M_RING_SINK_STARVED_VERT",
    .desc   = "Sink Starvation on Vertical Ring",
    .code   = 0x00ab,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_ring_sink_starved_vert),
    .umasks = icx_unc_m2m_ring_sink_starved_vert,
  },
  { .name   = "UNC_M2M_RING_SRC_THRTL",
    .desc   = "Source Throttle (experimental)",
    .code   = 0x00ae,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_RPQ_NO_REG_CRD",
    .desc   = "M2M to iMC RPQ Cycles w/Credits - Regular",
    .code   = 0x0043,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_rpq_no_spec_crd), /* shared */
    .umasks = icx_unc_m2m_rpq_no_spec_crd,
  },
  { .name   = "UNC_M2M_RPQ_NO_REG_CRD_PMM",
    .desc   = "M2M->iMC RPQ Cycles w/Credits - PMM",
    .code   = 0x004f,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_wpq_no_reg_crd), /* shared */
    .umasks = icx_unc_m2m_wpq_no_reg_crd,
  },
  { .name   = "UNC_M2M_RPQ_NO_SPEC_CRD",
    .desc   = "M2M to iMC RPQ Cycles w/Credits - Special",
    .code   = 0x0044,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_rpq_no_spec_crd),
    .umasks = icx_unc_m2m_rpq_no_spec_crd,
  },
  { .name   = "UNC_M2M_RxC_AD_CYCLES_FULL",
    .desc   = "AD Ingress (from CMS) Full (experimental)",
    .code   = 0x0004,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_RxC_AD_CYCLES_NE",
    .desc   = "AD Ingress (from CMS) Not Empty (experimental)",
    .code   = 0x0003,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_RxC_AD_INSERTS",
    .desc   = "AD Ingress (from CMS) Allocations (experimental)",
    .code   = 0x0001,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_RxC_AD_OCCUPANCY",
    .desc   = "AD Ingress (from CMS) Occupancy (experimental)",
    .code   = 0x0002,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_RxC_AD_PREF_OCCUPANCY",
    .desc   = "AD Ingress (from CMS) Occupancy - Prefetches (experimental)",
    .code   = 0x0077,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_RxC_AK_WR_CMP",
    .desc   = "AK Egress (to CMS) Allocations (experimental)",
    .code   = 0x005c,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_RxC_BL_CYCLES_FULL",
    .desc   = "BL Ingress (from CMS) Full (experimental)",
    .code   = 0x0008,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_RxC_BL_CYCLES_NE",
    .desc   = "BL Ingress (from CMS) Not Empty (experimental)",
    .code   = 0x0007,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_RxC_BL_INSERTS",
    .desc   = "BL Ingress (from CMS) Allocations (experimental)",
    .code   = 0x0005,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_RxC_BL_OCCUPANCY",
    .desc   = "BL Ingress (from CMS) Occupancy (experimental)",
    .code   = 0x0006,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_RxR_BUSY_STARVED",
    .desc   = "Transgress Injection Starvation",
    .code   = 0x00e5,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_txr_horz_ads_used), /* shared */
    .umasks = icx_unc_m2m_txr_horz_ads_used,
  },
  { .name   = "UNC_M2M_RxR_BYPASS",
    .desc   = "Transgress Ingress Bypass",
    .code   = 0x00e2,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_rxr_inserts), /* shared */
    .umasks = icx_unc_m2m_rxr_inserts,
  },
  { .name   = "UNC_M2M_RxR_CRD_STARVED",
    .desc   = "Transgress Injection Starvation",
    .code   = 0x00e3,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_rxr_crd_starved),
    .umasks = icx_unc_m2m_rxr_crd_starved,
  },
  { .name   = "UNC_M2M_RxR_CRD_STARVED_1",
    .desc   = "Transgress Injection Starvation (experimental)",
    .code   = 0x00e4,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_RxR_INSERTS",
    .desc   = "Transgress Ingress Allocations",
    .code   = 0x00e1,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_rxr_inserts),
    .umasks = icx_unc_m2m_rxr_inserts,
  },
  { .name   = "UNC_M2M_RxR_OCCUPANCY",
    .desc   = "Transgress Ingress Occupancy",
    .code   = 0x00e0,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_rxr_occupancy),
    .umasks = icx_unc_m2m_rxr_occupancy,
  },
  { .name   = "UNC_M2M_SCOREBOARD_AD_RETRY_ACCEPTS",
    .desc   = "UNC_M2M_SCOREBOARD_AD_RETRY_ACCEPTS (experimental)",
    .code   = 0x0033,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_SCOREBOARD_AD_RETRY_REJECTS",
    .desc   = "UNC_M2M_SCOREBOARD_AD_RETRY_REJECTS (experimental)",
    .code   = 0x0034,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_SCOREBOARD_BL_RETRY_ACCEPTS",
    .desc   = "Retry - Mem Mirroring Mode (experimental)",
    .code   = 0x0035,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_SCOREBOARD_BL_RETRY_REJECTS",
    .desc   = "Retry - Mem Mirroring Mode (experimental)",
    .code   = 0x0036,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_SCOREBOARD_RD_ACCEPTS",
    .desc   = "Scoreboard Accepts (experimental)",
    .code   = 0x002f,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_SCOREBOARD_RD_REJECTS",
    .desc   = "Scoreboard Rejects (experimental)",
    .code   = 0x0030,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_SCOREBOARD_WR_ACCEPTS",
    .desc   = "Scoreboard Accepts (experimental)",
    .code   = 0x0031,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_SCOREBOARD_WR_REJECTS",
    .desc   = "Scoreboard Rejects (experimental)",
    .code   = 0x0032,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_STALL0_NO_TxR_HORZ_CRD_AD_AG0",
    .desc   = "Stall on No AD Agent0 Transgress Credits",
    .code   = 0x00d0,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_stall0_no_txr_horz_crd_ad_ag0),
    .umasks = icx_unc_m2m_stall0_no_txr_horz_crd_ad_ag0,
  },
  { .name   = "UNC_M2M_STALL0_NO_TxR_HORZ_CRD_AD_AG1",
    .desc   = "Stall on No AD Agent1 Transgress Credits",
    .code   = 0x00d2,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_stall0_no_txr_horz_crd_bl_ag0), /* shared */
    .umasks = icx_unc_m2m_stall0_no_txr_horz_crd_bl_ag0,
  },
  { .name   = "UNC_M2M_STALL0_NO_TxR_HORZ_CRD_BL_AG0",
    .desc   = "Stall on No BL Agent0 Transgress Credits",
    .code   = 0x00d4,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_stall0_no_txr_horz_crd_bl_ag0),
    .umasks = icx_unc_m2m_stall0_no_txr_horz_crd_bl_ag0,
  },
  { .name   = "UNC_M2M_STALL0_NO_TxR_HORZ_CRD_BL_AG1",
    .desc   = "Stall on No BL Agent1 Transgress Credits",
    .code   = 0x00d6,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_stall0_no_txr_horz_crd_bl_ag1),
    .umasks = icx_unc_m2m_stall0_no_txr_horz_crd_bl_ag1,
  },
  { .name   = "UNC_M2M_STALL1_NO_TxR_HORZ_CRD_AD_AG0",
    .desc   = "Stall on No AD Agent0 Transgress Credits",
    .code   = 0x00d1,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_stall1_no_txr_horz_crd_ad_ag1_1), /* shared */
    .umasks = icx_unc_m2m_stall1_no_txr_horz_crd_ad_ag1_1,
  },
  { .name   = "UNC_M2M_STALL1_NO_TxR_HORZ_CRD_AD_AG1_1",
    .desc   = "Stall on No AD Agent1 Transgress Credits",
    .code   = 0x00d3,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_stall1_no_txr_horz_crd_ad_ag1_1),
    .umasks = icx_unc_m2m_stall1_no_txr_horz_crd_ad_ag1_1,
  },
  { .name   = "UNC_M2M_STALL1_NO_TxR_HORZ_CRD_BL_AG0_1",
    .desc   = "Stall on No BL Agent0 Transgress Credits",
    .code   = 0x00d5,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_stall1_no_txr_horz_crd_bl_ag1_1), /* shared */
    .umasks = icx_unc_m2m_stall1_no_txr_horz_crd_bl_ag1_1,
  },
  { .name   = "UNC_M2M_STALL1_NO_TxR_HORZ_CRD_BL_AG1_1",
    .desc   = "Stall on No BL Agent1 Transgress Credits",
    .code   = 0x00d7,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_stall1_no_txr_horz_crd_bl_ag1_1),
    .umasks = icx_unc_m2m_stall1_no_txr_horz_crd_bl_ag1_1,
  },
  { .name   = "UNC_M2M_TAG_HIT",
    .desc   = "Tag Hit",
    .code   = 0x002c,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_tag_hit),
    .umasks = icx_unc_m2m_tag_hit,
  },
  { .name   = "UNC_M2M_TAG_MISS",
    .desc   = "Tag Miss (experimental)",
    .code   = 0x0061,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_TGR_AD_CREDITS",
    .desc   = "Number AD Ingress Credits (experimental)",
    .code   = 0x0041,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_TGR_BL_CREDITS",
    .desc   = "Number BL Ingress Credits (experimental)",
    .code   = 0x0042,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_TRACKER_FULL",
    .desc   = "Tracker Cycles Full",
    .code   = 0x0045,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_tracker_inserts), /* shared */
    .umasks = icx_unc_m2m_tracker_inserts,
  },
  { .name   = "UNC_M2M_TRACKER_INSERTS",
    .desc   = "Tracker Inserts",
    .code   = 0x0049,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_tracker_inserts),
    .umasks = icx_unc_m2m_tracker_inserts,
  },
  { .name   = "UNC_M2M_TRACKER_NE",
    .desc   = "Tracker Cycles Not Empty",
    .code   = 0x0046,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_tracker_occupancy), /* shared */
    .umasks = icx_unc_m2m_tracker_occupancy,
  },
  { .name   = "UNC_M2M_TRACKER_OCCUPANCY",
    .desc   = "Tracker Occupancy",
    .code   = 0x0047,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_tracker_occupancy),
    .umasks = icx_unc_m2m_tracker_occupancy,
  },
  { .name   = "UNC_M2M_TxC_AD_CREDITS_ACQUIRED",
    .desc   = "AD Egress (to CMS) Credit Acquired (experimental)",
    .code   = 0x000d,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_TxC_AD_CREDIT_OCCUPANCY",
    .desc   = "AD Egress (to CMS) Credits Occupancy (experimental)",
    .code   = 0x000e,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_TxC_AD_CYCLES_FULL",
    .desc   = "AD Egress (to CMS) Full (experimental)",
    .code   = 0x000c,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_TxC_AD_CYCLES_NE",
    .desc   = "AD Egress (to CMS) Not Empty (experimental)",
    .code   = 0x000b,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_TxC_AD_INSERTS",
    .desc   = "AD Egress (to CMS) Allocations (experimental)",
    .code   = 0x0009,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_TxC_AD_NO_CREDIT_CYCLES",
    .desc   = "Cycles with No AD Egress (to CMS) Credits (experimental)",
    .code   = 0x000f,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_TxC_AD_NO_CREDIT_STALLED",
    .desc   = "Cycles Stalled with No AD Egress (to CMS) Credits (experimental)",
    .code   = 0x0010,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_TxC_AD_OCCUPANCY",
    .desc   = "AD Egress (to CMS) Occupancy (experimental)",
    .code   = 0x000a,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_TxC_AK",
    .desc   = "Outbound Ring Transactions on AK",
    .code   = 0x0039,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_txc_ak),
    .umasks = icx_unc_m2m_txc_ak,
  },
  { .name   = "UNC_M2M_TxC_AKC_CREDITS",
    .desc   = "AKC Credits (experimental)",
    .code   = 0x005f,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2M_TxC_AK_CREDITS_ACQUIRED",
    .desc   = "AK Egress (to CMS) Credit Acquired",
    .code   = 0x001d,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_txc_ak_no_credit_cycles), /* shared */
    .umasks = icx_unc_m2m_txc_ak_no_credit_cycles,
  },
  { .name   = "UNC_M2M_TxC_AK_CYCLES_FULL",
    .desc   = "AK Egress (to CMS) Full",
    .code   = 0x0014,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_txc_ak_cycles_full),
    .umasks = icx_unc_m2m_txc_ak_cycles_full,
  },
  { .name   = "UNC_M2M_TxC_AK_CYCLES_NE",
    .desc   = "AK Egress (to CMS) Not Empty",
    .code   = 0x0013,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_txc_ak_occupancy), /* shared */
    .umasks = icx_unc_m2m_txc_ak_occupancy,
  },
  { .name   = "UNC_M2M_TxC_AK_INSERTS",
    .desc   = "AK Egress (to CMS) Allocations",
    .code   = 0x0011,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_txc_ak_inserts),
    .umasks = icx_unc_m2m_txc_ak_inserts,
  },
  { .name   = "UNC_M2M_TxC_AK_NO_CREDIT_CYCLES",
    .desc   = "Cycles with No AK Egress (to CMS) Credits",
    .code   = 0x001f,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_txc_ak_no_credit_cycles),
    .umasks = icx_unc_m2m_txc_ak_no_credit_cycles,
  },
  { .name   = "UNC_M2M_TxC_AK_NO_CREDIT_STALLED",
    .desc   = "Cycles Stalled with No AK Egress (to CMS) Credits",
    .code   = 0x0020,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_txc_bl_credits_acquired), /* shared */
    .umasks = icx_unc_m2m_txc_bl_credits_acquired,
  },
  { .name   = "UNC_M2M_TxC_AK_OCCUPANCY",
    .desc   = "AK Egress (to CMS) Occupancy",
    .code   = 0x0012,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_txc_ak_occupancy),
    .umasks = icx_unc_m2m_txc_ak_occupancy,
  },
  { .name   = "UNC_M2M_TxC_BL",
    .desc   = "Outbound DRS Ring Transactions to Cache",
    .code   = 0x0040,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_txc_bl),
    .umasks = icx_unc_m2m_txc_bl,
  },
  { .name   = "UNC_M2M_TxC_BL_CREDITS_ACQUIRED",
    .desc   = "BL Egress (to CMS) Credit Acquired",
    .code   = 0x0019,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_txc_bl_credits_acquired),
    .umasks = icx_unc_m2m_txc_bl_credits_acquired,
  },
  { .name   = "UNC_M2M_TxC_BL_CYCLES_FULL",
    .desc   = "BL Egress (to CMS) Full",
    .code   = 0x0018,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_txc_bl_cycles_ne), /* shared */
    .umasks = icx_unc_m2m_txc_bl_cycles_ne,
  },
  { .name   = "UNC_M2M_TxC_BL_CYCLES_NE",
    .desc   = "BL Egress (to CMS) Not Empty",
    .code   = 0x0017,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_txc_bl_cycles_ne),
    .umasks = icx_unc_m2m_txc_bl_cycles_ne,
  },
  { .name   = "UNC_M2M_TxC_BL_INSERTS",
    .desc   = "BL Egress (to CMS) Allocations",
    .code   = 0x0015,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_txc_bl_inserts),
    .umasks = icx_unc_m2m_txc_bl_inserts,
  },
  { .name   = "UNC_M2M_TxC_BL_NO_CREDIT_CYCLES",
    .desc   = "Cycles with No BL Egress (to CMS) Credits",
    .code   = 0x001b,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_txc_bl_no_credit_stalled), /* shared */
    .umasks = icx_unc_m2m_txc_bl_no_credit_stalled,
  },
  { .name   = "UNC_M2M_TxC_BL_NO_CREDIT_STALLED",
    .desc   = "Cycles Stalled with No BL Egress (to CMS) Credits",
    .code   = 0x001c,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_txc_bl_no_credit_stalled),
    .umasks = icx_unc_m2m_txc_bl_no_credit_stalled,
  },
  { .name   = "UNC_M2M_TxR_HORZ_ADS_USED",
    .desc   = "CMS Horizontal ADS Used",
    .code   = 0x00a6,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_txr_horz_ads_used),
    .umasks = icx_unc_m2m_txr_horz_ads_used,
  },
  { .name   = "UNC_M2M_TxR_HORZ_BYPASS",
    .desc   = "CMS Horizontal Bypass Used",
    .code   = 0x00a7,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_txr_horz_cycles_full), /* shared */
    .umasks = icx_unc_m2m_txr_horz_cycles_full,
  },
  { .name   = "UNC_M2M_TxR_HORZ_CYCLES_FULL",
    .desc   = "Cycles CMS Horizontal Egress Queue is Full",
    .code   = 0x00a2,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_txr_horz_cycles_full),
    .umasks = icx_unc_m2m_txr_horz_cycles_full,
  },
  { .name   = "UNC_M2M_TxR_HORZ_CYCLES_NE",
    .desc   = "Cycles CMS Horizontal Egress Queue is Not Empty",
    .code   = 0x00a3,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_txr_horz_inserts), /* shared */
    .umasks = icx_unc_m2m_txr_horz_inserts,
  },
  { .name   = "UNC_M2M_TxR_HORZ_INSERTS",
    .desc   = "CMS Horizontal Egress Inserts",
    .code   = 0x00a1,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_txr_horz_inserts),
    .umasks = icx_unc_m2m_txr_horz_inserts,
  },
  { .name   = "UNC_M2M_TxR_HORZ_NACK",
    .desc   = "CMS Horizontal Egress NACKs",
    .code   = 0x00a4,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_txr_horz_occupancy), /* shared */
    .umasks = icx_unc_m2m_txr_horz_occupancy,
  },
  { .name   = "UNC_M2M_TxR_HORZ_OCCUPANCY",
    .desc   = "CMS Horizontal Egress Occupancy",
    .code   = 0x00a0,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_txr_horz_occupancy),
    .umasks = icx_unc_m2m_txr_horz_occupancy,
  },
  { .name   = "UNC_M2M_TxR_HORZ_STARVED",
    .desc   = "CMS Horizontal Egress Injection Starvation",
    .code   = 0x00a5,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_txr_horz_starved),
    .umasks = icx_unc_m2m_txr_horz_starved,
  },
  { .name   = "UNC_M2M_TxR_VERT_ADS_USED",
    .desc   = "CMS Vertical ADS Used",
    .code   = 0x009c,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_txr_vert_ads_used),
    .umasks = icx_unc_m2m_txr_vert_ads_used,
  },
  { .name   = "UNC_M2M_TxR_VERT_BYPASS",
    .desc   = "CMS Vertical ADS Used",
    .code   = 0x009d,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_txr_vert_bypass),
    .umasks = icx_unc_m2m_txr_vert_bypass,
  },
  { .name   = "UNC_M2M_TxR_VERT_BYPASS_1",
    .desc   = "CMS Vertical ADS Used",
    .code   = 0x009e,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_txr_vert_cycles_full1), /* shared */
    .umasks = icx_unc_m2m_txr_vert_cycles_full1,
  },
  { .name   = "UNC_M2M_TxR_VERT_CYCLES_FULL0",
    .desc   = "Cycles CMS Vertical Egress Queue Is Full",
    .code   = 0x0094,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_txr_vert_cycles_ne0), /* shared */
    .umasks = icx_unc_m2m_txr_vert_cycles_ne0,
  },
  { .name   = "UNC_M2M_TxR_VERT_CYCLES_FULL1",
    .desc   = "Cycles CMS Vertical Egress Queue Is Full",
    .code   = 0x0095,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_txr_vert_cycles_full1),
    .umasks = icx_unc_m2m_txr_vert_cycles_full1,
  },
  { .name   = "UNC_M2M_TxR_VERT_CYCLES_NE0",
    .desc   = "Cycles CMS Vertical Egress Queue Is Not Empty",
    .code   = 0x0096,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_txr_vert_cycles_ne0),
    .umasks = icx_unc_m2m_txr_vert_cycles_ne0,
  },
  { .name   = "UNC_M2M_TxR_VERT_CYCLES_NE1",
    .desc   = "Cycles CMS Vertical Egress Queue Is Not Empty",
    .code   = 0x0097,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_txr_vert_inserts1), /* shared */
    .umasks = icx_unc_m2m_txr_vert_inserts1,
  },
  { .name   = "UNC_M2M_TxR_VERT_INSERTS0",
    .desc   = "CMS Vert Egress Allocations",
    .code   = 0x0092,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_txr_vert_occupancy0), /* shared */
    .umasks = icx_unc_m2m_txr_vert_occupancy0,
  },
  { .name   = "UNC_M2M_TxR_VERT_INSERTS1",
    .desc   = "CMS Vert Egress Allocations",
    .code   = 0x0093,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_txr_vert_inserts1),
    .umasks = icx_unc_m2m_txr_vert_inserts1,
  },
  { .name   = "UNC_M2M_TxR_VERT_NACK0",
    .desc   = "CMS Vertical Egress NACKs",
    .code   = 0x0098,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_txr_vert_starved0), /* shared */
    .umasks = icx_unc_m2m_txr_vert_starved0,
  },
  { .name   = "UNC_M2M_TxR_VERT_NACK1",
    .desc   = "CMS Vertical Egress NACKs",
    .code   = 0x0099,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_txr_vert_occupancy1), /* shared */
    .umasks = icx_unc_m2m_txr_vert_occupancy1,
  },
  { .name   = "UNC_M2M_TxR_VERT_OCCUPANCY0",
    .desc   = "CMS Vert Egress Occupancy",
    .code   = 0x0090,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_txr_vert_occupancy0),
    .umasks = icx_unc_m2m_txr_vert_occupancy0,
  },
  { .name   = "UNC_M2M_TxR_VERT_OCCUPANCY1",
    .desc   = "CMS Vert Egress Occupancy",
    .code   = 0x0091,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_txr_vert_occupancy1),
    .umasks = icx_unc_m2m_txr_vert_occupancy1,
  },
  { .name   = "UNC_M2M_TxR_VERT_STARVED0",
    .desc   = "CMS Vertical Egress Injection Starvation",
    .code   = 0x009a,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_txr_vert_starved0),
    .umasks = icx_unc_m2m_txr_vert_starved0,
  },
  { .name   = "UNC_M2M_TxR_VERT_STARVED1",
    .desc   = "CMS Vertical Egress Injection Starvation",
    .code   = 0x009b,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_txr_vert_starved1),
    .umasks = icx_unc_m2m_txr_vert_starved1,
  },
  { .name   = "UNC_M2M_VERT_RING_AD_IN_USE",
    .desc   = "Vertical AD Ring In Use",
    .code   = 0x00b0,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_vert_ring_akc_in_use), /* shared */
    .umasks = icx_unc_m2m_vert_ring_akc_in_use,
  },
  { .name   = "UNC_M2M_VERT_RING_AKC_IN_USE",
    .desc   = "Vertical AKC Ring In Use",
    .code   = 0x00b4,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_vert_ring_akc_in_use),
    .umasks = icx_unc_m2m_vert_ring_akc_in_use,
  },
  { .name   = "UNC_M2M_VERT_RING_AK_IN_USE",
    .desc   = "Vertical AK Ring In Use",
    .code   = 0x00b1,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_vert_ring_bl_in_use), /* shared */
    .umasks = icx_unc_m2m_vert_ring_bl_in_use,
  },
  { .name   = "UNC_M2M_VERT_RING_BL_IN_USE",
    .desc   = "Vertical BL Ring in Use",
    .code   = 0x00b2,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_vert_ring_bl_in_use),
    .umasks = icx_unc_m2m_vert_ring_bl_in_use,
  },
  { .name   = "UNC_M2M_VERT_RING_IV_IN_USE",
    .desc   = "Vertical IV Ring in Use",
    .code   = 0x00b3,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_vert_ring_iv_in_use),
    .umasks = icx_unc_m2m_vert_ring_iv_in_use,
  },
  { .name   = "UNC_M2M_VERT_RING_TGC_IN_USE",
    .desc   = "Vertical TGC Ring In Use",
    .code   = 0x00b5,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_vert_ring_tgc_in_use),
    .umasks = icx_unc_m2m_vert_ring_tgc_in_use,
  },
  { .name   = "UNC_M2M_WPQ_FLUSH",
    .desc   = "WPQ Flush",
    .code   = 0x0058,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_wr_tracker_inserts), /* shared */
    .umasks = icx_unc_m2m_wr_tracker_inserts,
  },
  { .name   = "UNC_M2M_WPQ_NO_REG_CRD",
    .desc   = "M2M->iMC WPQ Cycles w/Credits - Regular",
    .code   = 0x004d,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_wpq_no_reg_crd),
    .umasks = icx_unc_m2m_wpq_no_reg_crd,
  },
  { .name   = "UNC_M2M_WPQ_NO_REG_CRD_PMM",
    .desc   = "M2M->iMC WPQ Cycles w/Credits - PMM",
    .code   = 0x0051,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_wpq_no_spec_crd), /* shared */
    .umasks = icx_unc_m2m_wpq_no_spec_crd,
  },
  { .name   = "UNC_M2M_WPQ_NO_SPEC_CRD",
    .desc   = "M2M->iMC WPQ Cycles w/Credits - Special",
    .code   = 0x004e,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_wpq_no_spec_crd),
    .umasks = icx_unc_m2m_wpq_no_spec_crd,
  },
  { .name   = "UNC_M2M_WR_TRACKER_FULL",
    .desc   = "Write Tracker Cycles Full",
    .code   = 0x004a,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_wr_tracker_full),
    .umasks = icx_unc_m2m_wr_tracker_full,
  },
  { .name   = "UNC_M2M_WR_TRACKER_INSERTS",
    .desc   = "Write Tracker Inserts",
    .code   = 0x0056,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_wr_tracker_inserts),
    .umasks = icx_unc_m2m_wr_tracker_inserts,
  },
  { .name   = "UNC_M2M_WR_TRACKER_NE",
    .desc   = "Write Tracker Cycles Not Empty",
    .code   = 0x004b,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_wr_tracker_occupancy), /* shared */
    .umasks = icx_unc_m2m_wr_tracker_occupancy,
  },
  { .name   = "UNC_M2M_WR_TRACKER_NONPOSTED_INSERTS",
    .desc   = "Write Tracker Non-Posted Inserts",
    .code   = 0x0063,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_wr_tracker_nonposted_occupancy), /* shared */
    .umasks = icx_unc_m2m_wr_tracker_nonposted_occupancy,
  },
  { .name   = "UNC_M2M_WR_TRACKER_NONPOSTED_OCCUPANCY",
    .desc   = "Write Tracker Non-Posted Occupancy",
    .code   = 0x0062,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_wr_tracker_nonposted_occupancy),
    .umasks = icx_unc_m2m_wr_tracker_nonposted_occupancy,
  },
  { .name   = "UNC_M2M_WR_TRACKER_OCCUPANCY",
    .desc   = "Write Tracker Occupancy",
    .code   = 0x0055,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_wr_tracker_occupancy),
    .umasks = icx_unc_m2m_wr_tracker_occupancy,
  },
  { .name   = "UNC_M2M_WR_TRACKER_POSTED_INSERTS",
    .desc   = "Write Tracker Posted Inserts",
    .code   = 0x005e,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_wr_tracker_posted_occupancy), /* shared */
    .umasks = icx_unc_m2m_wr_tracker_posted_occupancy,
  },
  { .name   = "UNC_M2M_WR_TRACKER_POSTED_OCCUPANCY",
    .desc   = "Write Tracker Posted Occupancy",
    .code   = 0x005d,
    .modmsk = ICX_UNC_M2M_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2m_wr_tracker_posted_occupancy),
    .umasks = icx_unc_m2m_wr_tracker_posted_occupancy,
  },
};
/* 175 events available */
