<?php

/*
 * This file is part of the JoliNotif project.
 *
 * (c) Loïck Piera <pyrech@gmail.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Joli\JoliNotif\tests\Driver;

use Joli\JoliNotif\Driver\DriverInterface;
use Joli\JoliNotif\Driver\PowerShellDriver;
use Psr\Log\NullLogger;

class PowerShellDriverTest extends AbstractDriverTestCase
{
    use AbstractCliBasedDriverTestTrait;

    private const BINARY = 'powershell.exe';

    public function testGetBinary()
    {
        $driver = $this->getDriver();

        $this->assertStringContainsString('powershell', $driver->getBinary());
    }

    public function testGetPriority()
    {
        $driver = $this->getDriver();

        $this->assertSame(DriverInterface::PRIORITY_HIGH, $driver->getPriority());
    }

    protected function getDriver(): PowerShellDriver
    {
        return new PowerShellDriver(new NullLogger());
    }

    protected static function getExpectedCommandLineForNotification(): string
    {
        return <<<'CLI'
            'powershell.exe' '-NoProfile' '-NonInteractive' '-EncodedCommand' 'WwBXAGkAbgBkAG8AdwBzAC4AVQBJAC4ATgBvAHQAaQBmAGkAYwBhAHQAaQBvAG4AcwAuAFQAbwBhAHMAdABOAG8AdABpAGYAaQBjAGEAdABpAG8AbgBNAGEAbgBhAGcAZQByACwAIABXAGkAbgBkAG8AdwBzAC4AVQBJAC4ATgBvAHQAaQBmAGkAYwBhAHQAaQBvAG4AcwAsACAAQwBvAG4AdABlAG4AdABUAHkAcABlACAAPQAgAFcAaQBuAGQAbwB3AHMAUgB1AG4AdABpAG0AZQBdACAAfAAgAE8AdQB0AC0ATgB1AGwAbAA7AAoACgAkAHQAZQBtAHAAbABhAHQAZQAgAD0AIABbAFcAaQBuAGQAbwB3AHMALgBVAEkALgBOAG8AdABpAGYAaQBjAGEAdABpAG8AbgBzAC4AVABvAGEAcwB0AE4AbwB0AGkAZgBpAGMAYQB0AGkAbwBuAE0AYQBuAGEAZwBlAHIAXQA6ADoARwBlAHQAVABlAG0AcABsAGEAdABlAEMAbwBuAHQAZQBuAHQAKABbAFcAaQBuAGQAbwB3AHMALgBVAEkALgBOAG8AdABpAGYAaQBjAGEAdABpAG8AbgBzAC4AVABvAGEAcwB0AFQAZQBtAHAAbABhAHQAZQBUAHkAcABlAF0AOgA6AFQAbwBhAHMAdABJAG0AYQBnAGUAQQBuAGQAVABlAHgAdAAwADEAKQA7AAoACgAkAHQAZQB4AHQATgBvAGQAZQBzACAAPQAgACQAdABlAG0AcABsAGEAdABlAC4ARwBlAHQARQBsAGUAbQBlAG4AdABzAEIAeQBUAGEAZwBOAGEAbQBlACgAIgB0AGUAeAB0ACIAKQA7AAoAJAB0AGUAeAB0AE4AbwBkAGUAcwAuAEkAdABlAG0AKAAwACkALgBBAHAAcABlAG4AZABDAGgAaQBsAGQAKAAKACAAIAAgACAAJAB0AGUAbQBwAGwAYQB0AGUALgBDAHIAZQBhAHQAZQBUAGUAeAB0AE4AbwBkAGUAKAAiAEkAJwBtACAAdABoAGUAIABuAG8AdABpAGYAaQBjAGEAdABpAG8AbgAgAGIAbwBkAHkAIgApAAoAKQAgAHwAIABPAHUAdAAtAE4AdQBsAGwAOwAKAAoAJABpAG0AYQBnAGUATgBvAGQAZQBzACAAPQAgACQAdABlAG0AcABsAGEAdABlAC4ARwBlAHQARQBsAGUAbQBlAG4AdABzAEIAeQBUAGEAZwBOAGEAbQBlACgAIgBpAG0AYQBnAGUAIgApADsACgAKAGkAZgAgACgAIgAiACAALQBuAGUAIAAiACIAKQAgAHsACgAgACAAIAAgACQAaQBtAGEAZwBlAE4AbwBkAGUAcwAuAEkAdABlAG0AKAAwACkALgBTAGUAdABBAHQAdAByAGkAYgB1AHQAZQAoACIAcwByAGMAIgAsACAAIgAiACkAIAB8ACAATwB1AHQALQBOAHUAbABsADsACgB9AAoACgAkAG4AbwB0AGkAZgBpAGUAcgAgAD0AIABbAFcAaQBuAGQAbwB3AHMALgBVAEkALgBOAG8AdABpAGYAaQBjAGEAdABpAG8AbgBzAC4AVABvAGEAcwB0AE4AbwB0AGkAZgBpAGMAYQB0AGkAbwBuAE0AYQBuAGEAZwBlAHIAXQA6ADoAQwByAGUAYQB0AGUAVABvAGEAcwB0AE4AbwB0AGkAZgBpAGUAcgAoACIAIgApADsACgAkAG4AbwB0AGkAZgBpAGUAcgAuAFMAaABvAHcAKABbAFcAaQBuAGQAbwB3AHMALgBVAEkALgBOAG8AdABpAGYAaQBjAGEAdABpAG8AbgBzAC4AVABvAGEAcwB0AE4AbwB0AGkAZgBpAGMAYQB0AGkAbwBuAF0AOgA6AG4AZQB3ACgAJAB0AGUAbQBwAGwAYQB0AGUAKQApAA=='
            CLI;
    }

    protected static function getExpectedCommandLineForNotificationWithATitle(): string
    {
        return <<<'CLI'
            'powershell.exe' '-NoProfile' '-NonInteractive' '-EncodedCommand' 'WwBXAGkAbgBkAG8AdwBzAC4AVQBJAC4ATgBvAHQAaQBmAGkAYwBhAHQAaQBvAG4AcwAuAFQAbwBhAHMAdABOAG8AdABpAGYAaQBjAGEAdABpAG8AbgBNAGEAbgBhAGcAZQByACwAIABXAGkAbgBkAG8AdwBzAC4AVQBJAC4ATgBvAHQAaQBmAGkAYwBhAHQAaQBvAG4AcwAsACAAQwBvAG4AdABlAG4AdABUAHkAcABlACAAPQAgAFcAaQBuAGQAbwB3AHMAUgB1AG4AdABpAG0AZQBdACAAfAAgAE8AdQB0AC0ATgB1AGwAbAA7AAoACgAkAHQAZQBtAHAAbABhAHQAZQAgAD0AIABbAFcAaQBuAGQAbwB3AHMALgBVAEkALgBOAG8AdABpAGYAaQBjAGEAdABpAG8AbgBzAC4AVABvAGEAcwB0AE4AbwB0AGkAZgBpAGMAYQB0AGkAbwBuAE0AYQBuAGEAZwBlAHIAXQA6ADoARwBlAHQAVABlAG0AcABsAGEAdABlAEMAbwBuAHQAZQBuAHQAKABbAFcAaQBuAGQAbwB3AHMALgBVAEkALgBOAG8AdABpAGYAaQBjAGEAdABpAG8AbgBzAC4AVABvAGEAcwB0AFQAZQBtAHAAbABhAHQAZQBUAHkAcABlAF0AOgA6AFQAbwBhAHMAdABJAG0AYQBnAGUAQQBuAGQAVABlAHgAdAAwADEAKQA7AAoACgAkAHQAZQB4AHQATgBvAGQAZQBzACAAPQAgACQAdABlAG0AcABsAGEAdABlAC4ARwBlAHQARQBsAGUAbQBlAG4AdABzAEIAeQBUAGEAZwBOAGEAbQBlACgAIgB0AGUAeAB0ACIAKQA7AAoAJAB0AGUAeAB0AE4AbwBkAGUAcwAuAEkAdABlAG0AKAAwACkALgBBAHAAcABlAG4AZABDAGgAaQBsAGQAKAAKACAAIAAgACAAJAB0AGUAbQBwAGwAYQB0AGUALgBDAHIAZQBhAHQAZQBUAGUAeAB0AE4AbwBkAGUAKAAiAEkAJwBtACAAdABoAGUAIABuAG8AdABpAGYAaQBjAGEAdABpAG8AbgAgAGIAbwBkAHkAIgApAAoAKQAgAHwAIABPAHUAdAAtAE4AdQBsAGwAOwAKAAoAJABpAG0AYQBnAGUATgBvAGQAZQBzACAAPQAgACQAdABlAG0AcABsAGEAdABlAC4ARwBlAHQARQBsAGUAbQBlAG4AdABzAEIAeQBUAGEAZwBOAGEAbQBlACgAIgBpAG0AYQBnAGUAIgApADsACgAKAGkAZgAgACgAIgAiACAALQBuAGUAIAAiACIAKQAgAHsACgAgACAAIAAgACQAaQBtAGEAZwBlAE4AbwBkAGUAcwAuAEkAdABlAG0AKAAwACkALgBTAGUAdABBAHQAdAByAGkAYgB1AHQAZQAoACIAcwByAGMAIgAsACAAIgAiACkAIAB8ACAATwB1AHQALQBOAHUAbABsADsACgB9AAoACgAkAG4AbwB0AGkAZgBpAGUAcgAgAD0AIABbAFcAaQBuAGQAbwB3AHMALgBVAEkALgBOAG8AdABpAGYAaQBjAGEAdABpAG8AbgBzAC4AVABvAGEAcwB0AE4AbwB0AGkAZgBpAGMAYQB0AGkAbwBuAE0AYQBuAGEAZwBlAHIAXQA6ADoAQwByAGUAYQB0AGUAVABvAGEAcwB0AE4AbwB0AGkAZgBpAGUAcgAoACIASQAnAG0AIAB0AGgAZQAgAG4AbwB0AGkAZgBpAGMAYQB0AGkAbwBuACAAdABpAHQAbABlACIAKQA7AAoAJABuAG8AdABpAGYAaQBlAHIALgBTAGgAbwB3ACgAWwBXAGkAbgBkAG8AdwBzAC4AVQBJAC4ATgBvAHQAaQBmAGkAYwBhAHQAaQBvAG4AcwAuAFQAbwBhAHMAdABOAG8AdABpAGYAaQBjAGEAdABpAG8AbgBdADoAOgBuAGUAdwAoACQAdABlAG0AcABsAGEAdABlACkAKQA='
            CLI;
    }

    protected static function getExpectedCommandLineForNotificationWithASubtitle(): string
    {
        return <<<'CLI'
            'powershell.exe' '-NoProfile' '-NonInteractive' '-EncodedCommand' 'WwBXAGkAbgBkAG8AdwBzAC4AVQBJAC4ATgBvAHQAaQBmAGkAYwBhAHQAaQBvAG4AcwAuAFQAbwBhAHMAdABOAG8AdABpAGYAaQBjAGEAdABpAG8AbgBNAGEAbgBhAGcAZQByACwAIABXAGkAbgBkAG8AdwBzAC4AVQBJAC4ATgBvAHQAaQBmAGkAYwBhAHQAaQBvAG4AcwAsACAAQwBvAG4AdABlAG4AdABUAHkAcABlACAAPQAgAFcAaQBuAGQAbwB3AHMAUgB1AG4AdABpAG0AZQBdACAAfAAgAE8AdQB0AC0ATgB1AGwAbAA7AAoACgAkAHQAZQBtAHAAbABhAHQAZQAgAD0AIABbAFcAaQBuAGQAbwB3AHMALgBVAEkALgBOAG8AdABpAGYAaQBjAGEAdABpAG8AbgBzAC4AVABvAGEAcwB0AE4AbwB0AGkAZgBpAGMAYQB0AGkAbwBuAE0AYQBuAGEAZwBlAHIAXQA6ADoARwBlAHQAVABlAG0AcABsAGEAdABlAEMAbwBuAHQAZQBuAHQAKABbAFcAaQBuAGQAbwB3AHMALgBVAEkALgBOAG8AdABpAGYAaQBjAGEAdABpAG8AbgBzAC4AVABvAGEAcwB0AFQAZQBtAHAAbABhAHQAZQBUAHkAcABlAF0AOgA6AFQAbwBhAHMAdABJAG0AYQBnAGUAQQBuAGQAVABlAHgAdAAwADEAKQA7AAoACgAkAHQAZQB4AHQATgBvAGQAZQBzACAAPQAgACQAdABlAG0AcABsAGEAdABlAC4ARwBlAHQARQBsAGUAbQBlAG4AdABzAEIAeQBUAGEAZwBOAGEAbQBlACgAIgB0AGUAeAB0ACIAKQA7AAoAJAB0AGUAeAB0AE4AbwBkAGUAcwAuAEkAdABlAG0AKAAwACkALgBBAHAAcABlAG4AZABDAGgAaQBsAGQAKAAKACAAIAAgACAAJAB0AGUAbQBwAGwAYQB0AGUALgBDAHIAZQBhAHQAZQBUAGUAeAB0AE4AbwBkAGUAKAAiAEkAJwBtACAAdABoAGUAIABuAG8AdABpAGYAaQBjAGEAdABpAG8AbgAgAGIAbwBkAHkAIgApAAoAKQAgAHwAIABPAHUAdAAtAE4AdQBsAGwAOwAKAAoAJABpAG0AYQBnAGUATgBvAGQAZQBzACAAPQAgACQAdABlAG0AcABsAGEAdABlAC4ARwBlAHQARQBsAGUAbQBlAG4AdABzAEIAeQBUAGEAZwBOAGEAbQBlACgAIgBpAG0AYQBnAGUAIgApADsACgAKAGkAZgAgACgAIgAiACAALQBuAGUAIAAiACIAKQAgAHsACgAgACAAIAAgACQAaQBtAGEAZwBlAE4AbwBkAGUAcwAuAEkAdABlAG0AKAAwACkALgBTAGUAdABBAHQAdAByAGkAYgB1AHQAZQAoACIAcwByAGMAIgAsACAAIgAiACkAIAB8ACAATwB1AHQALQBOAHUAbABsADsACgB9AAoACgAkAG4AbwB0AGkAZgBpAGUAcgAgAD0AIABbAFcAaQBuAGQAbwB3AHMALgBVAEkALgBOAG8AdABpAGYAaQBjAGEAdABpAG8AbgBzAC4AVABvAGEAcwB0AE4AbwB0AGkAZgBpAGMAYQB0AGkAbwBuAE0AYQBuAGEAZwBlAHIAXQA6ADoAQwByAGUAYQB0AGUAVABvAGEAcwB0AE4AbwB0AGkAZgBpAGUAcgAoACIAIgApADsACgAkAG4AbwB0AGkAZgBpAGUAcgAuAFMAaABvAHcAKABbAFcAaQBuAGQAbwB3AHMALgBVAEkALgBOAG8AdABpAGYAaQBjAGEAdABpAG8AbgBzAC4AVABvAGEAcwB0AE4AbwB0AGkAZgBpAGMAYQB0AGkAbwBuAF0AOgA6AG4AZQB3ACgAJAB0AGUAbQBwAGwAYQB0AGUAKQApAA=='
            CLI;
    }

    protected static function getExpectedCommandLineForNotificationWithASound(): string
    {
        return <<<'CLI'
            'powershell.exe' '-NoProfile' '-NonInteractive' '-EncodedCommand' 'WwBXAGkAbgBkAG8AdwBzAC4AVQBJAC4ATgBvAHQAaQBmAGkAYwBhAHQAaQBvAG4AcwAuAFQAbwBhAHMAdABOAG8AdABpAGYAaQBjAGEAdABpAG8AbgBNAGEAbgBhAGcAZQByACwAIABXAGkAbgBkAG8AdwBzAC4AVQBJAC4ATgBvAHQAaQBmAGkAYwBhAHQAaQBvAG4AcwAsACAAQwBvAG4AdABlAG4AdABUAHkAcABlACAAPQAgAFcAaQBuAGQAbwB3AHMAUgB1AG4AdABpAG0AZQBdACAAfAAgAE8AdQB0AC0ATgB1AGwAbAA7AAoACgAkAHQAZQBtAHAAbABhAHQAZQAgAD0AIABbAFcAaQBuAGQAbwB3AHMALgBVAEkALgBOAG8AdABpAGYAaQBjAGEAdABpAG8AbgBzAC4AVABvAGEAcwB0AE4AbwB0AGkAZgBpAGMAYQB0AGkAbwBuAE0AYQBuAGEAZwBlAHIAXQA6ADoARwBlAHQAVABlAG0AcABsAGEAdABlAEMAbwBuAHQAZQBuAHQAKABbAFcAaQBuAGQAbwB3AHMALgBVAEkALgBOAG8AdABpAGYAaQBjAGEAdABpAG8AbgBzAC4AVABvAGEAcwB0AFQAZQBtAHAAbABhAHQAZQBUAHkAcABlAF0AOgA6AFQAbwBhAHMAdABJAG0AYQBnAGUAQQBuAGQAVABlAHgAdAAwADEAKQA7AAoACgAkAHQAZQB4AHQATgBvAGQAZQBzACAAPQAgACQAdABlAG0AcABsAGEAdABlAC4ARwBlAHQARQBsAGUAbQBlAG4AdABzAEIAeQBUAGEAZwBOAGEAbQBlACgAIgB0AGUAeAB0ACIAKQA7AAoAJAB0AGUAeAB0AE4AbwBkAGUAcwAuAEkAdABlAG0AKAAwACkALgBBAHAAcABlAG4AZABDAGgAaQBsAGQAKAAKACAAIAAgACAAJAB0AGUAbQBwAGwAYQB0AGUALgBDAHIAZQBhAHQAZQBUAGUAeAB0AE4AbwBkAGUAKAAiAEkAJwBtACAAdABoAGUAIABuAG8AdABpAGYAaQBjAGEAdABpAG8AbgAgAGIAbwBkAHkAIgApAAoAKQAgAHwAIABPAHUAdAAtAE4AdQBsAGwAOwAKAAoAJABpAG0AYQBnAGUATgBvAGQAZQBzACAAPQAgACQAdABlAG0AcABsAGEAdABlAC4ARwBlAHQARQBsAGUAbQBlAG4AdABzAEIAeQBUAGEAZwBOAGEAbQBlACgAIgBpAG0AYQBnAGUAIgApADsACgAKAGkAZgAgACgAIgAiACAALQBuAGUAIAAiACIAKQAgAHsACgAgACAAIAAgACQAaQBtAGEAZwBlAE4AbwBkAGUAcwAuAEkAdABlAG0AKAAwACkALgBTAGUAdABBAHQAdAByAGkAYgB1AHQAZQAoACIAcwByAGMAIgAsACAAIgAiACkAIAB8ACAATwB1AHQALQBOAHUAbABsADsACgB9AAoACgAkAG4AbwB0AGkAZgBpAGUAcgAgAD0AIABbAFcAaQBuAGQAbwB3AHMALgBVAEkALgBOAG8AdABpAGYAaQBjAGEAdABpAG8AbgBzAC4AVABvAGEAcwB0AE4AbwB0AGkAZgBpAGMAYQB0AGkAbwBuAE0AYQBuAGEAZwBlAHIAXQA6ADoAQwByAGUAYQB0AGUAVABvAGEAcwB0AE4AbwB0AGkAZgBpAGUAcgAoACIAIgApADsACgAkAG4AbwB0AGkAZgBpAGUAcgAuAFMAaABvAHcAKABbAFcAaQBuAGQAbwB3AHMALgBVAEkALgBOAG8AdABpAGYAaQBjAGEAdABpAG8AbgBzAC4AVABvAGEAcwB0AE4AbwB0AGkAZgBpAGMAYQB0AGkAbwBuAF0AOgA6AG4AZQB3ACgAJAB0AGUAbQBwAGwAYQB0AGUAKQApAA=='
            CLI;
    }

    protected static function getExpectedCommandLineForNotificationWithAnIcon(): string
    {
        return <<<'CLI'
            'powershell.exe' '-NoProfile' '-NonInteractive' '-EncodedCommand' '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'
            CLI;
    }

    protected static function getExpectedCommandLineForNotificationWithAllOptions(): string
    {
        return <<<'CLI'
            'powershell.exe' '-NoProfile' '-NonInteractive' '-EncodedCommand' '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'
            CLI;
    }
}
