'''OpenGL extension NV.gpu_program5_mem_extended

This module customises the behaviour of the 
OpenGL.raw.GL.NV.gpu_program5_mem_extended to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension provides a new set of storage modifiers that can be used by
	NV_gpu_program5 assembly program instructions loading from or storing to
	various forms of GPU memory.  In particular, we provide support for loads
	and stores using the storage modifiers:
	
	    .F16X2  .F16X4  .F16    (for 16-bit floating-point scalars/vectors)
	    .S8X2   .S8X4           (for 8-bit signed integer vectors)
	    .S16X2  .S16X4          (for 16-bit signed integer vectors)
	    .U8X2   .U8X4           (for 8-bit unsigned integer vectors)
	    .U16X2  .U16X4          (for 16-bit unsigned integer vectors)
	
	These modifiers are allowed for the following load/store instructions:
	
	    LDC             Load from constant buffer
	
	    LOAD            Global load
	    STORE           Global store
	
	    LOADIM          Image load (via EXT_shader_image_load_store)
	    STOREIM         Image store (via EXT_shader_image_load_store)
	
	    LDB             Load from storage buffer (via 
	                      NV_shader_storage_buffer_object) 
	    STB             Store to storage buffer (via 
	                      NV_shader_storage_buffer_object) 
	
	    LDS             Load from shared memory (via NV_compute_program5)
	    STS             Store to shared memory (via NV_compute_program5)
	
	For assembly programs prior to this extension, it was necessary to access
	memory using packed types and then unpack with additional shader
	instructions.
	
	Similar capabilities have already been provided in the OpenGL Shading
	Language (GLSL) via the NV_gpu_shader5 extension, using the extended data
	types provided there (e.g., "float16_t", "u8vec4", "s16vec2").

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/gpu_program5_mem_extended.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.NV.gpu_program5_mem_extended import *
from OpenGL.raw.GL.NV.gpu_program5_mem_extended import _EXTENSION_NAME

def glInitGpuProgram5MemExtendedNV():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION