## [3.24.2](https://github.com/IBM/python-sdk-core/compare/v3.24.1...v3.24.2) (2025-06-12)


### Bug Fixes

* **build:** bump requests to avoid CVE-2024-47081 ([7b5f21b](https://github.com/IBM/python-sdk-core/commit/7b5f21b3d9e3a82e5d1292f290a7d4fee00b27a7))

## [3.24.1](https://github.com/IBM/python-sdk-core/compare/v3.24.0...v3.24.1) (2025-05-30)


### Bug Fixes

* **build:** suppress detect-secrets false positive ([4e9bc4c](https://github.com/IBM/python-sdk-core/commit/4e9bc4c6dbb651a8d25ad28b6233d28569275819))

# [3.24.0](https://github.com/IBM/python-sdk-core/compare/v3.23.0...v3.24.0) (2025-05-30)


### Features

* **auth:** add support for MCSP V2 authentication ([d467d02](https://github.com/IBM/python-sdk-core/commit/d467d02d5a8d49b7dd212319003e727d55494b63))

# [3.23.0](https://github.com/IBM/python-sdk-core/compare/v3.22.1...v3.23.0) (2025-03-07)


### Features

* **ContainerAuthenticator:** add support for code engine workload ([#218](https://github.com/IBM/python-sdk-core/issues/218)) ([765d33f](https://github.com/IBM/python-sdk-core/commit/765d33f794265784f216cdccb156d2f8476a66d1))

## [3.22.1](https://github.com/IBM/python-sdk-core/compare/v3.22.0...v3.22.1) (2025-01-09)


### Bug Fixes

* enable github workflows ([436ba89](https://github.com/IBM/python-sdk-core/commit/436ba891fd0d1f960b3427de3d6b40b1950d1a53))

# [3.22.0](https://github.com/IBM/python-sdk-core/compare/v3.21.0...v3.22.0) (2024-10-15)


### Features

* **IAMAssumeAuthenticator:** introduce a new authenticator ([#211](https://github.com/IBM/python-sdk-core/issues/211)) ([29a8eb7](https://github.com/IBM/python-sdk-core/commit/29a8eb7f5d9d72b7e48d4bf7f3867e5c93e747fb))

# [3.21.0](https://github.com/IBM/python-sdk-core/compare/v3.20.6...v3.21.0) (2024-09-18)


### Bug Fixes

* **logging:** improve python core's debug logging ([67b126c](https://github.com/IBM/python-sdk-core/commit/67b126c2fd87d14057b185a8e6d13644a955f332))


### Features

* redact secrets in debug logging ([#209](https://github.com/IBM/python-sdk-core/issues/209)) ([ed043dc](https://github.com/IBM/python-sdk-core/commit/ed043dc2814a2959da9b92c4286ca8b23b5fa59d))

## [3.20.6](https://github.com/IBM/python-sdk-core/compare/v3.20.5...v3.20.6) (2024-08-08)


### Bug Fixes

* **build:** use correct package list with setuptools ([#207](https://github.com/IBM/python-sdk-core/issues/207)) ([27fa51d](https://github.com/IBM/python-sdk-core/commit/27fa51d85c8df0bc5e52bdc084155bd284a77ec0))

## [3.20.5](https://github.com/IBM/python-sdk-core/compare/v3.20.4...v3.20.5) (2024-08-07)


### Bug Fixes

* **build:** migrate setup.py to pyproject.toml ([#205](https://github.com/IBM/python-sdk-core/issues/205)) ([#206](https://github.com/IBM/python-sdk-core/issues/206)) ([03c8a6d](https://github.com/IBM/python-sdk-core/commit/03c8a6d81dd8227e6510a26fef75e502b82db304))

## [3.20.4](https://github.com/IBM/python-sdk-core/compare/v3.20.3...v3.20.4) (2024-07-29)


### Bug Fixes

* remove test command and related code from `setup.py` ([#203](https://github.com/IBM/python-sdk-core/issues/203)) ([bd44dd1](https://github.com/IBM/python-sdk-core/commit/bd44dd1152e01bb381f95e6295103991c0dd9ac4))

## [3.20.3](https://github.com/IBM/python-sdk-core/compare/v3.20.2...v3.20.3) (2024-07-11)


### Bug Fixes

* improve the detection and loading of default certificates ([#197](https://github.com/IBM/python-sdk-core/issues/197)) ([3dc4cc4](https://github.com/IBM/python-sdk-core/commit/3dc4cc47a8fa5363b1b08c9fbc1412885748af3e))

## [3.20.2](https://github.com/IBM/python-sdk-core/compare/v3.20.1...v3.20.2) (2024-07-09)


### Bug Fixes

* always load the default certs on our custom SSL context ([#196](https://github.com/IBM/python-sdk-core/issues/196)) ([ff14a4b](https://github.com/IBM/python-sdk-core/commit/ff14a4b1177b31ab2afd8aed7c6e3ffecdabfb4c))

## [3.20.1](https://github.com/IBM/python-sdk-core/compare/v3.20.0...v3.20.1) (2024-06-03)


### Bug Fixes

* specify the maximum version of `requests` to avoid regression ([#194](https://github.com/IBM/python-sdk-core/issues/194)) ([f4ac0d1](https://github.com/IBM/python-sdk-core/commit/f4ac0d143d5d0079a4f2e99c1ebf1328b91a432f))

# [3.20.0](https://github.com/IBM/python-sdk-core/compare/v3.19.2...v3.20.0) (2024-04-17)


### Features

* send user-agent header with auth token requests ([#191](https://github.com/IBM/python-sdk-core/issues/191)) ([37014b5](https://github.com/IBM/python-sdk-core/commit/37014b57a27090deb6c51e5e6019dd7bee90a6fd))

## [3.19.2](https://github.com/IBM/python-sdk-core/compare/v3.19.1...v3.19.2) (2024-02-28)


### Bug Fixes

* adjust IAM token expiration time ([#189](https://github.com/IBM/python-sdk-core/issues/189)) ([f4f0b5a](https://github.com/IBM/python-sdk-core/commit/f4f0b5afe4746c8dfc9687ebeb9db20bf1df2414))

## [3.19.1](https://github.com/IBM/python-sdk-core/compare/v3.19.0...v3.19.1) (2024-01-24)


### Bug Fixes

* use the correct SSL config if cert verification is disabled ([#187](https://github.com/IBM/python-sdk-core/issues/187)) ([7fc172a](https://github.com/IBM/python-sdk-core/commit/7fc172ad325545aa07bd5cbab1cb65cb0c078b9b))

# [3.19.0](https://github.com/IBM/python-sdk-core/compare/v3.18.2...v3.19.0) (2024-01-22)


### Features

* rename `ApiException.code` to `ApiException.status_code` ([#185](https://github.com/IBM/python-sdk-core/issues/185)) ([cf74671](https://github.com/IBM/python-sdk-core/commit/cf74671a9a5d538fbf2b28a4e9c5046644e696fb))

## [3.18.2](https://github.com/IBM/python-sdk-core/compare/v3.18.1...v3.18.2) (2023-12-11)


### Bug Fixes

* use retry_interval as retry backoff_max ([#184](https://github.com/IBM/python-sdk-core/issues/184)) ([7e84825](https://github.com/IBM/python-sdk-core/commit/7e848259ca88fa1b4831786eaaae2a02f8afbcd2))

## [3.18.1](https://github.com/IBM/python-sdk-core/compare/v3.18.0...v3.18.1) (2023-12-08)


### Bug Fixes

* bump urllib3 to v2.1.0 ([#183](https://github.com/IBM/python-sdk-core/issues/183)) ([d1ab40c](https://github.com/IBM/python-sdk-core/commit/d1ab40c941fb21be798461169a1937dbaf4de1de))

# [3.18.0](https://github.com/IBM/python-sdk-core/compare/v3.17.3...v3.18.0) (2023-11-15)


### Features

* **MCSPAuthenticator:** add new authenticator for Multi-Cloud Saas Platform ([#181](https://github.com/IBM/python-sdk-core/issues/181)) ([1be97e5](https://github.com/IBM/python-sdk-core/commit/1be97e5712c7b62847d8412cfa75096c1bf51b9d))

## [3.17.3](https://github.com/IBM/python-sdk-core/compare/v3.17.2...v3.17.3) (2023-11-06)


### Bug Fixes

* **build:** bump urllib version to avoid vulnerability ([#180](https://github.com/IBM/python-sdk-core/issues/180)) ([5363104](https://github.com/IBM/python-sdk-core/commit/5363104a765d3b1928ec76e6fc75b314398029c5))

## [3.17.2](https://github.com/IBM/python-sdk-core/compare/v3.17.1...v3.17.2) (2023-10-10)


### Bug Fixes

* use on-the-fly compression only for file objects ([#177](https://github.com/IBM/python-sdk-core/issues/177)) ([dd1cd05](https://github.com/IBM/python-sdk-core/commit/dd1cd056ec030344e2b8fec5093b2acae53ae941))

## [3.17.1](https://github.com/IBM/python-sdk-core/compare/v3.17.0...v3.17.1) (2023-10-04)


### Bug Fixes

* add correct support for compressing file-like objects ([#174](https://github.com/IBM/python-sdk-core/issues/174)) ([2f91105](https://github.com/IBM/python-sdk-core/commit/2f911055aac6ffe8e0bab056b861ce41a29ad58b))

# [3.17.0](https://github.com/IBM/python-sdk-core/compare/v3.16.7...v3.17.0) (2023-10-03)


### Features

* bump min supported version of python to 3.8 ([#175](https://github.com/IBM/python-sdk-core/issues/175)) ([8933684](https://github.com/IBM/python-sdk-core/commit/8933684d8a4a5a4450239811d1169529982c3029))

## [3.16.7](https://github.com/IBM/python-sdk-core/compare/v3.16.6...v3.16.7) (2023-05-31)


### Bug Fixes

* **build:** bump requests to latest version (2.31.0) ([#171](https://github.com/IBM/python-sdk-core/issues/171)) ([a293e76](https://github.com/IBM/python-sdk-core/commit/a293e760228492cb108ab41f5093355bae018cc2))

## [3.16.6](https://github.com/IBM/python-sdk-core/compare/v3.16.5...v3.16.6) (2023-05-22)


### Bug Fixes

* **ContainerAuthenticator:** add sa-token as default CR token filename ([#165](https://github.com/IBM/python-sdk-core/issues/165)) ([7c6bd0f](https://github.com/IBM/python-sdk-core/commit/7c6bd0f1d3521628ef0fd593f7110d9174c5b771))

## [3.16.5](https://github.com/IBM/python-sdk-core/compare/v3.16.4...v3.16.5) (2023-03-23)


### Bug Fixes

* allow control characters in JSON responses ([#160](https://github.com/IBM/python-sdk-core/issues/160)) ([2f09503](https://github.com/IBM/python-sdk-core/commit/2f09503ac4ebfb6f603f142f461122c402aa03d5))

## [3.16.4](https://github.com/IBM/python-sdk-core/compare/v3.16.3...v3.16.4) (2023-03-23)


### Bug Fixes

* bump requests version to avoid import error ([#159](https://github.com/IBM/python-sdk-core/issues/159)) ([e9ca94c](https://github.com/IBM/python-sdk-core/commit/e9ca94c4ddd707b84bfa72b6a04ee3c56d21c08a))

## [3.16.3](https://github.com/IBM/python-sdk-core/compare/v3.16.2...v3.16.3) (2023-03-22)


### Bug Fixes

* detect JSON unmarshal errors in responses ([#157](https://github.com/IBM/python-sdk-core/issues/157)) ([30d7c52](https://github.com/IBM/python-sdk-core/commit/30d7c52659f92f8d9218b66372ef0d707a297232))

## [3.16.2](https://github.com/IBM/python-sdk-core/compare/v3.16.1...v3.16.2) (2023-02-08)


### Bug Fixes

* avoid pylint errors ([00ee90b](https://github.com/IBM/python-sdk-core/commit/00ee90bf223a1f620e211fe9de2ed95ccfff8233))

## [3.16.1](https://github.com/IBM/python-sdk-core/compare/v3.16.0...v3.16.1) (2023-01-09)


### Bug Fixes

* pin build to semantic-release v19 ([03c5474](https://github.com/IBM/python-sdk-core/commit/03c547442c91e0fc497a2a9ba202b8231674562d))
* **VPCInstanceAuthenticator:** use correct version string ([93729a3](https://github.com/IBM/python-sdk-core/commit/93729a3ee09b8011989b7679b4820d042f79964b))

# [3.16.0](https://github.com/IBM/python-sdk-core/compare/v3.15.3...v3.16.0) (2022-08-01)


### Features

* **CP4D Authentication:** add ssl verification for self-signed certificates ([#147](https://github.com/IBM/python-sdk-core/issues/147)) ([a16685d](https://github.com/IBM/python-sdk-core/commit/a16685d83641e467f2dcaf610194fd3f84f13a84))

## [3.15.3](https://github.com/IBM/python-sdk-core/compare/v3.15.2...v3.15.3) (2022-06-07)


### Bug Fixes

* avoid warning when custom headers are used ([#142](https://github.com/IBM/python-sdk-core/issues/142)) ([a87d66d](https://github.com/IBM/python-sdk-core/commit/a87d66da4b9ed98b9ac910ca67c86b674aab7ef6))

## [3.15.2](https://github.com/IBM/python-sdk-core/compare/v3.15.1...v3.15.2) (2022-05-31)


### Bug Fixes

* bump PyJWT version to avoid CVE ([#141](https://github.com/IBM/python-sdk-core/issues/141)) ([bea54f0](https://github.com/IBM/python-sdk-core/commit/bea54f03fab6d9ebef1a26f170280b6e8698c04e))

## [3.15.1](https://github.com/IBM/python-sdk-core/compare/v3.15.0...v3.15.1) (2022-03-21)


### Bug Fixes

* set minimum TLS version to v1.2 ([#139](https://github.com/IBM/python-sdk-core/issues/139)) ([8d6ec4b](https://github.com/IBM/python-sdk-core/commit/8d6ec4b675642664258650e7d7c12c8fc333a410))

# [3.15.0](https://github.com/IBM/python-sdk-core/compare/v3.14.0...v3.15.0) (2022-02-25)


### Features

* update Python versions ([#138](https://github.com/IBM/python-sdk-core/issues/138)) ([a8c201e](https://github.com/IBM/python-sdk-core/commit/a8c201ed7eb88bf3509da0db6da84619190c7bfb))

# [3.14.0](https://github.com/IBM/python-sdk-core/compare/v3.13.2...v3.14.0) (2022-01-14)


### Features

* use module names for loggers ([#136](https://github.com/IBM/python-sdk-core/issues/136)) ([36523c8](https://github.com/IBM/python-sdk-core/commit/36523c869627323374afc7b246959969a8a1c9a3))

## [3.13.2](https://github.com/IBM/python-sdk-core/compare/v3.13.1...v3.13.2) (2021-11-15)


### Bug Fixes

* bump requests and urllib3 deps ([#132](https://github.com/IBM/python-sdk-core/issues/132)) ([ced5b7e](https://github.com/IBM/python-sdk-core/commit/ced5b7ea2398570e187a109bc51dba2b30ab7243))

## [3.13.1](https://github.com/IBM/python-sdk-core/compare/v3.13.0...v3.13.1) (2021-11-15)


### Bug Fixes

* strip trailing slashes in BaseService.set_service_url ([#130](https://github.com/IBM/python-sdk-core/issues/130)) ([37d0099](https://github.com/IBM/python-sdk-core/commit/37d0099cfd7bfe4bdb9f1cddc6bb2b62f4609f60))

# [3.13.0](https://github.com/IBM/python-sdk-core/compare/v3.12.0...v3.13.0) (2021-11-08)


### Features

* **VPCInstanceAuthenticator:** add support for new VPC authentication flow ([#129](https://github.com/IBM/python-sdk-core/issues/129)) ([5cb1c21](https://github.com/IBM/python-sdk-core/commit/5cb1c212aaef5df62df00064a12d6581e960a95b))

# [3.12.0](https://github.com/IBM/python-sdk-core/compare/v3.11.3...v3.12.0) (2021-10-15)


### Features

* add authentication_type method to authenticators ([#127](https://github.com/IBM/python-sdk-core/issues/127)) ([c56ce73](https://github.com/IBM/python-sdk-core/commit/c56ce73454a2d049ed787649be0d3d464aae4c24))

## [3.11.3](https://github.com/IBM/python-sdk-core/compare/v3.11.2...v3.11.3) (2021-08-24)


### Bug Fixes

* multiple IAM based authenticator overrides ([#124](https://github.com/IBM/python-sdk-core/issues/124)) ([b142e9e](https://github.com/IBM/python-sdk-core/commit/b142e9ecf337f73dcfd1e577afb330e993a3371b))

## [3.11.2](https://github.com/IBM/python-sdk-core/compare/v3.11.1...v3.11.2) (2021-08-20)


### Bug Fixes

* **retries:** change default retry_interval to 1 second (was 0.1) ([#122](https://github.com/IBM/python-sdk-core/issues/122)) ([3daef00](https://github.com/IBM/python-sdk-core/commit/3daef00a61c461512da0a3b37952ed275180569d))

## [3.11.1](https://github.com/IBM/python-sdk-core/compare/v3.11.0...v3.11.1) (2021-08-18)


### Bug Fixes

* encode serialized JSON string as UTF-8 ([#121](https://github.com/IBM/python-sdk-core/issues/121)) ([6c1ddac](https://github.com/IBM/python-sdk-core/commit/6c1ddacff512478ec9aaa6f5c6ff454eae780c74))

# [3.11.0](https://github.com/IBM/python-sdk-core/compare/v3.10.1...v3.11.0) (2021-08-12)


### Features

* implement container authentication ([#119](https://github.com/IBM/python-sdk-core/issues/119)) ([5237277](https://github.com/IBM/python-sdk-core/commit/5237277b4e7e9daf54bb70d2ec01882cfa3167c2))

## [3.10.1](https://github.com/IBM/python-sdk-core/compare/v3.10.0...v3.10.1) (2021-07-08)


### Bug Fixes

* remove reserved keywords from kwargs before passing it to requests ([#117](https://github.com/IBM/python-sdk-core/issues/117)) ([6191978](https://github.com/IBM/python-sdk-core/commit/619197844e553fd4fd3c7e9ece2abae752d5dc3f))

# [3.10.0](https://github.com/IBM/python-sdk-core/compare/v3.9.0...v3.10.0) (2021-05-12)


### Features

* support api key use case for CP4D authenticator ([830c28f](https://github.com/IBM/python-sdk-core/commit/830c28f68682a885d5cd4f668964def2864930d0))

# [3.9.0](https://github.com/IBM/python-sdk-core/compare/v3.8.0...v3.9.0) (2021-03-25)


### Features

* **python:** add max retry configuration for python requests session ([481192c](https://github.com/IBM/python-sdk-core/commit/481192c5468c908f28f77ce697cae13350409397))

# [3.8.0](https://github.com/IBM/python-sdk-core/compare/v3.7.0...v3.8.0) (2021-03-17)


### Features

* add datetime to string utils for lists ([2a4260c](https://github.com/IBM/python-sdk-core/commit/2a4260c7aca9b99020e2b06ccffc976ece8bd6ac))

# [3.7.0](https://github.com/IBM/python-sdk-core/compare/v3.6.0...v3.7.0) (2021-03-12)


### Features

* add get_query_param utility method to support pagination ([b40edde](https://github.com/IBM/python-sdk-core/commit/b40edde45dcba59ecfb626ac8bf8a98cbb11b6de))

# [3.6.0](https://github.com/IBM/python-sdk-core/compare/v3.5.2...v3.6.0) (2021-03-05)


### Bug Fixes

* split token manager url path ([18d64b5](https://github.com/IBM/python-sdk-core/commit/18d64b51f0e637a01f72488635e81fc5a7bd6918))
* update default iam url to omit path ([1fbdd0c](https://github.com/IBM/python-sdk-core/commit/1fbdd0c0c61add47182c9e389f5933789276a7d0))


### Features

* expose refresh token in iam authenticator ([31e988d](https://github.com/IBM/python-sdk-core/commit/31e988d4348f313074d5c434ae2b86264e3cbbc1))

## [3.5.2](https://github.com/IBM/python-sdk-core/compare/v3.5.1...v3.5.2) (2021-02-10)


### Bug Fixes

* **build:** main migration ([3664e2e](https://github.com/IBM/python-sdk-core/commit/3664e2e7e564d227b1e9be67831b4c6d4cea8b18))
* **build:** main migration release ([8b3debc](https://github.com/IBM/python-sdk-core/commit/8b3debcf088c2bc71957645ae0925c4fa6dac56a))

## [3.5.1](https://github.com/IBM/python-sdk-core/compare/v3.5.0...v3.5.1) (2021-02-01)


### Bug Fixes

* remove unnecessary logging of exceptions ([e94d5ae](https://github.com/IBM/python-sdk-core/commit/e94d5ae81930a5e65e117f15cb20ecce4134c5ab))
* silently ignore missing configuration file ([d438ade](https://github.com/IBM/python-sdk-core/commit/d438ade26d0ddda65074d6c31f735cc1f53850cf))

# [3.5.0](https://github.com/IBM/python-sdk-core/compare/v3.4.0...v3.5.0) (2021-01-27)


### Features

* **BaseService:** use a requests.Session for retry and other configuration ([14bcf41](https://github.com/IBM/python-sdk-core/commit/14bcf413c74173903621ece3ad55ca8bb0bff81b))

# [3.4.0](https://github.com/IBM/python-sdk-core/compare/v3.3.6...v3.4.0) (2021-01-26)


### Features

* update minimum supported python version to 3.6 ([7f9b968](https://github.com/IBM/python-sdk-core/commit/7f9b968670a637a5619c4dda2405e11c9c3f5328))

## [3.3.6](https://github.com/IBM/python-sdk-core/compare/v3.3.5...v3.3.6) (2021-01-08)


### Bug Fixes

* include requirements.txt in MANIFEST.in for setup.py reference ([cc8935a](https://github.com/IBM/python-sdk-core/commit/cc8935a8082f852a528631b606940336253580f6))

## [3.3.5](https://github.com/IBM/python-sdk-core/compare/v3.3.4...v3.3.5) (2021-01-08)


### Bug Fixes

* update setup.py requirements to match requirements.txt ([c618928](https://github.com/IBM/python-sdk-core/commit/c618928da730eb0e94f12d7efa0ee9ba9370842f))

## [3.3.4](https://github.com/IBM/python-sdk-core/compare/v3.3.3...v3.3.4) (2021-01-07)


### Bug Fixes

* update pyjwt parameters to satisfy 2.x changes ([f2d7225](https://github.com/IBM/python-sdk-core/commit/f2d7225a6f8e8f4b19ed6d1858c93993d7d62cf5))

## [3.3.3](https://github.com/IBM/python-sdk-core/compare/v3.3.2...v3.3.3) (2021-01-06)


### Bug Fixes

* bump minimum requirement versions ([62edeb6](https://github.com/IBM/python-sdk-core/commit/62edeb6f3c89dcb49cddb4cbf315ba664ea7bd73))

## [3.3.2](https://github.com/IBM/python-sdk-core/compare/v3.3.1...v3.3.2) (2020-11-20)


### Bug Fixes

* update requests version to not include vulnerabilities ([16b2827](https://github.com/IBM/python-sdk-core/commit/16b28271f6c025f8207f2819345aecd487804534))

## [3.3.1](https://github.com/IBM/python-sdk-core/compare/v3.3.0...v3.3.1) (2020-11-11)


### Bug Fixes

* replace zlib with gzip for gzip compression ([b6a6da3](https://github.com/IBM/python-sdk-core/commit/b6a6da3445e70374b654221340aaebfc7f9d0ecc))

# [3.3.0](https://github.com/IBM/python-sdk-core/compare/v3.2.0...v3.3.0) (2020-10-07)


### Features

* allow gzip compression on request bodies ([196a407](https://github.com/IBM/python-sdk-core/commit/196a407c40c0c99b2465d19ec8cca1f85b51ee86))

# [3.2.0](https://github.com/IBM/python-sdk-core/compare/v3.1.0...v3.2.0) (2020-09-18)


### Features

* **IAM Authenticator:** add support for optional 'scope' property ([2e776c2](https://github.com/IBM/python-sdk-core/commit/2e776c2ba402c3b2846f5758f64d2776492ae764))

# [3.1.0](https://github.com/IBM/python-sdk-core/compare/v3.0.0...v3.1.0) (2020-06-15)


### Features

* **BaseService:** support stream=True in BaseService.send() ([bf4179b](https://github.com/IBM/python-sdk-core/commit/bf4179b54407c94707b24caeab6c4aeeb67ee3e7))

# [3.0.0](https://github.com/IBM/python-sdk-core/compare/v2.0.5...v3.0.0) (2020-06-01)


### Bug Fixes

* Combine multiple ending slashes to one ([5496948](https://github.com/IBM/python-sdk-core/commit/549694867285c2ba1d77187bfba108543a225e33))


### BREAKING CHANGES

* Fixing the request URL like this will break compatibility with previous generator versions

## [2.0.5](https://github.com/IBM/python-sdk-core/compare/v2.0.4...v2.0.5) (2020-05-29)


### Bug Fixes

* Revert stripping request URL trailing slashes ([09a193c](https://github.com/IBM/python-sdk-core/commit/09a193ce6b4f0b54b027df07d767f29df85ab71c))

## [2.0.4](https://github.com/IBM/python-sdk-core/compare/v2.0.3...v2.0.4) (2020-05-23)


### Bug Fixes

* Revert service_url slash stripping to work with current generated unit tests ([c960b7d](https://github.com/IBM/python-sdk-core/commit/c960b7dc943ac7d8b1bbe748ee7079aa42497504))

## [2.0.3](https://github.com/IBM/python-sdk-core/compare/v2.0.2...v2.0.3) (2020-05-22)


### Bug Fixes

* Don't rstrip slash when service_url is none ([091ecde](https://github.com/IBM/python-sdk-core/commit/091ecde7ab6c8aadc81c71aa35d6a33572856ac8))

## [2.0.2](https://github.com/IBM/python-sdk-core/compare/v2.0.1...v2.0.2) (2020-05-22)


### Bug Fixes

* Strip trailing slash for request url ([47d1d99](https://github.com/IBM/python-sdk-core/commit/47d1d99261767331a2583612ebaf048cf60d1fd3))

## [2.0.1](https://github.com/IBM/python-sdk-core/compare/v2.0.0...v2.0.1) (2020-05-12)


### Bug Fixes

* allow '=' character in environment config values ([8cf4fc9](https://github.com/IBM/python-sdk-core/commit/8cf4fc945a0f77fccf977bfdd0cc3cd203aac0bb))

# [2.0.0](https://github.com/IBM/python-sdk-core/compare/v1.7.3...v2.0.0) (2020-04-10)


### Features

* Add type annotations to parameters and return values ([5d4ef81](https://github.com/IBM/python-sdk-core/commit/5d4ef81a7fa85185839b966b80be6d033bc5eed5))
* Get error status phrase from status code ([d60ae58](https://github.com/IBM/python-sdk-core/commit/d60ae582be18af96c21f1e8a55b707f1d2fa44b4))
* Only override content-type if it is none ([b1177f2](https://github.com/IBM/python-sdk-core/commit/b1177f284a0c08255a5ceea26aca9570c4f699dc))
* Require optional parameters to be keyword-specified ([d9aa1d4](https://github.com/IBM/python-sdk-core/commit/d9aa1d4e4bad68961b3c365aaa8b4d5457921c06))
* Update python super call to newer version ([f038e10](https://github.com/IBM/python-sdk-core/commit/f038e103157afc8ad78d9817b1d233dc507e64db))


### BREAKING CHANGES

* Type annotations new in Python3
* Added super call feature new to Python3
* HTTPStatus is new in Python3
* Keyword-specific optional parameters are new in Python3

## [1.7.3](https://github.com/IBM/python-sdk-core/compare/v1.7.2...v1.7.3) (2020-03-31)


### Bug Fixes

* update classifiers in setup.py ([8b042a8](https://github.com/IBM/python-sdk-core/commit/8b042a831f923f8f09812560f8f0085c7431ce83))

## [1.7.2](https://github.com/IBM/python-sdk-core/compare/v1.7.1...v1.7.2) (2020-03-31)


### Bug Fixes

* update setup.py info for pypi ([1e0d63a](https://github.com/IBM/python-sdk-core/commit/1e0d63aa5b07544b0588fe211dea5b162fe67c49))

## [1.7.1](https://github.com/IBM/python-sdk-core/compare/v1.7.0...v1.7.1) (2020-03-06)


### Bug Fixes

* update README to trigger patch release ([bd389b4](https://github.com/IBM/python-sdk-core/commit/bd389b4e0c4451710c6e12d5325cadcabd6c8289))

# [1.7.0](https://github.com/IBM/python-sdk-core/compare/v1.6.2...v1.7.0) (2020-03-02)


### Features

* Pace requests to token server for new auth tokens ([1dea212](https://github.com/IBM/python-sdk-core/commit/1dea212b8720849370eb8a05d95d74a469a38ab7))

## [1.6.2](https://github.com/IBM/python-sdk-core/compare/v1.6.1...v1.6.2) (2020-02-13)


### Bug Fixes

* Handle conversions for naive datetime values ([f1149fa](https://github.com/IBM/python-sdk-core/commit/f1149fa815f3f1585b3e02da278dd075b9a1f836))

## [1.6.1](https://github.com/IBM/python-sdk-core/compare/v1.6.0...v1.6.1) (2020-02-04)


### Bug Fixes

* Fix date/datetime_to_string handling of non-date/datetime inputs ([8251b82](https://github.com/IBM/python-sdk-core/commit/8251b820e3a00db855d1960defe75279e3b02515))

# [1.6.0](https://github.com/IBM/python-sdk-core/compare/v1.5.2...v1.6.0) (2019-12-19)


### Features

* Add date_to_string and string_to_date utility methods ([6dbfff9](https://github.com/IBM/python-sdk-core/commit/6dbfff92a7758e7cbf78e5cb949dd15beb0dec7f))

## [1.5.2](https://github.com/IBM/python-sdk-core/compare/v1.5.1...v1.5.2) (2019-12-18)


### Bug Fixes

* Update credential file path check to current working directory ([e1ad677](https://github.com/IBM/python-sdk-core/commit/e1ad67781c8bd85739903271deb4ce7a2ea1659a))

## [1.5.1](https://github.com/IBM/python-sdk-core/compare/v1.5.0...v1.5.1) (2019-11-21)


### Bug Fixes

* more semantic-release config changes ([7b20aea](https://github.com/IBM/python-sdk-core/commit/7b20aea08a01df0c5079cb1281c265f31c444d2b))

# [1.5.0](https://github.com/IBM/python-sdk-core/compare/v1.4.0...v1.5.0) (2019-11-21)


### Features

* use new semantic-release config ([040c6a7](https://github.com/IBM/python-sdk-core/commit/040c6a7bb458c109c99e1a9e496b788d24ff12bf))

# [1.4.0](https://github.com/IBM/python-sdk-core/compare/v1.3.0...v1.4.0) (2019-11-20)


### Features

* configure release commit message format ([3d9cbda](https://github.com/IBM/python-sdk-core/commit/3d9cbda0ae2e263d0faf747dac5a99efb090e995))

# [1.3.0](https://github.com/IBM/python-sdk-core/compare/v1.2.0...v1.3.0) (2019-11-20)


### Features

* re-order semrel steps ([525a3fd](https://github.com/IBM/python-sdk-core/commit/525a3fd126a12cb8938c88f89a18f9347394e398))

# [1.2.0](https://github.com/IBM/python-sdk-core/compare/v1.1.3...v1.2.0) (2019-11-20)


### Features

* expand vcap credential loading to support user-defined service names ([32954fa](https://github.com/IBM/python-sdk-core/commit/32954fa1aa6d59416dd4b4c07ea91f51024e7d8f))

## [1.1.3](https://github.com/IBM/python-sdk-core/compare/v1.1.2...v1.1.3) (2019-11-05)


### Bug Fixes

* perform semrel steps in correct order ([545f13e](https://github.com/IBM/python-sdk-core/commit/545f13ebba37578f3cf5f1a7abba28ae159c7faa))

## [1.1.2](https://github.com/IBM/python-sdk-core/compare/v1.1.1...v1.1.2) (2019-11-05)


### Bug Fixes

* updated .buildversion.cfg to trigger patch release ([909196f](https://github.com/IBM/python-sdk-core/commit/909196f2a8e0f24736ee6bf9081b87b7dbcfc499))

## [1.1.1](https://github.com/IBM/python-sdk-core/compare/v1.1.0...v1.1.1) (2019-11-05)


### Bug Fixes

* Fix linting for Python3 and fix all lint issues ([14f2999](https://github.com/IBM/python-sdk-core/commit/14f2999010a9886c20f333247912cbe4996fb662))
