% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zoned-time.R
\name{zoned_time_now}
\alias{zoned_time_now}
\title{What is the current zoned-time?}
\usage{
zoned_time_now(zone)
}
\arguments{
\item{zone}{\verb{[character(1)]}

A time zone to get the current time for.}
}
\value{
A zoned-time of the current time.
}
\description{
\code{zoned_time_now()} returns the current time in the corresponding \code{zone}. It
is a wrapper around \code{\link[=sys_time_now]{sys_time_now()}} that attaches the time zone.
}
\details{
The time is returned with a nanosecond precision, but the actual amount
of data returned is OS dependent. Usually, information at at least the
microsecond level is returned, with some platforms returning nanosecond
information.
}
\examples{
x <- zoned_time_now("America/New_York")
}
