% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/web_fonts.R
\name{search_web_fonts}
\alias{search_web_fonts}
\title{Search font repositories for a font based on family name}
\usage{
search_web_fonts(family, n_max = 10, ...)
}
\arguments{
\item{family}{The font family name to look for}

\item{n_max}{The maximum number of matches to return}

\item{...}{
  Arguments passed on to \code{\link[utils:adist]{utils::adist}}
  \describe{
    \item{\code{costs}}{a numeric vector or list with names partially matching
    \samp{insertions}, \samp{deletions} and \samp{substitutions} giving
    the respective costs for computing the Levenshtein distance, or
    \code{NULL} (default) indicating using unit cost for all three
    possible transformations.}
    \item{\code{counts}}{a logical indicating whether to optionally return the
    transformation counts (numbers of insertions, deletions and
    substitutions) as the \code{"counts"} attribute of the return
    value.}
    \item{\code{fixed}}{a logical.  If \code{TRUE} (default), the \code{x}
    elements are used as string literals.  Otherwise, they are taken as
    regular expressions and \code{partial = TRUE} is implied
    (corresponding to the approximate string distance used by
    \code{\link{agrep}} with \code{fixed = FALSE}).}
    \item{\code{partial}}{a logical indicating whether the transformed \code{x}
    elements must exactly match the complete \code{y} elements, or only
    substrings of these.  The latter corresponds to the approximate
    string distance used by \code{\link{agrep}} (by default).}
    \item{\code{ignore.case}}{a logical.  If \code{TRUE}, case is ignored for
    computing the distances.}
    \item{\code{useBytes}}{a logical.  If \code{TRUE} distance computations are
    done byte-by-byte rather than character-by-character.}
  }}
}
\value{
A data.frame with the columns \code{family}, giving the family name of the
matched font, and \code{repository} giving the repository it was found in.
}
\description{
While it is often advisable to visit the webpage for a font repository when
looking for a font, in order to see examples etc, \code{search_web_fonts()}
provide a quick lookup based on family name in the repositories supported by
systemfonts (currently \href{https://fonts.google.com}{Google Fonts} and
\href{https://www.fontsquirrel.com}{Font Squirrel} - \href{https://fonts.bunny.net/}{Bunny Fonts}
provide the same fonts as Google Fonts but doesn't have a search API). The
lookup is based on fuzzy matching provided by \code{\link[utils:adist]{utils::adist()}} and the
matching parameters can be controlled through \code{...}
}
\examples{
# Requires an internet connection

# search_web_fonts("Spectral")

}
