---
myst:
  html_meta:
    keywords: LaTeX, composition, annexes, index, multind
---

# Comment générer plusieurs index ?

Les capacités d'indexation usuelles de LaTeX (fournies par l'extension 
<ctanpkg:makeidx>) ne permettent d'obtenir qu'un seul index 
dans votre document. Cependant, même des documents assez modestes 
peuvent être améliorés par la présence d'index pour des sujets distincts.


## Avec l'extension `index`

L'extension <ctanpkg:index> fournit un ensemble complet de fonctions 
d'indexation, y compris une commande `\newindex` qui permet la définition
de nouveaux styles d'index. La commande a pour syntaxe détaillée :

```{noedit}
\newindex{⟨étiquette⟩}{⟨extension1⟩}{⟨extension2⟩}{⟨titre⟩}
```

Ici`
- l'`⟨étiquette⟩` est à utiliser ensuite dans les commandes d'indexation 
pour les rattacher à l'index ;
- des noms d'extension `⟨extension1⟩` et `⟨extension2⟩` viendront 
  en remplacement des extensions de fichier IDX et IND ; 
- le `⟨titre⟩` sera donné à l'index lorsqu'il est finalement mis en forme. 

La commande `\newindex` peut également changer la référence présentée 
en index (par exemple, vous pouvez avoir un index d'artistes référencés 
par le numéro de figure où leur travail est présenté plutôt que 
par le numéro de page).

En utilisant cette extension pour créer un index d'auteur 
avec un index classique, il faudrait par exemple commencer par les commandes 
suivantes en préambule :

```{noedit}
\usepackage{index}
\makeindex
\newindex{aut}{adx}{and}{Index des auteurs}
```

Ceci charge l'extension, définit un index principal, puis définit 
un index d'auteur. Dans le corps du document, nous pourrons trouver 
des commandes telles que :

```{noedit}
\index[aut]{Anne O'Nyme}
(...)
\index{FAQ}
```

Ces commandes placent respectivement une entrée dans l'index des auteurs 
et une entrée dans l'index principal. Plus loin se trouveront deux commandes :

```{noedit}
\printindex
\printindex[aut]
```

Voici un exemple complet de ce code, avec son résultat.

```
%!TEX makeindex document
%!TEX makeindex document.adx -o document.and
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{index}

  \makeindex
  \newindex{aut}{adx}{and}{Index des auteurs}

\begin{document}
Cette introduction à la littérature\index{Littérature} imaginaire ne
pourra manquer d'évoquer \index[aut]{Anne O'Nyme} et \index[aut]{John Doe}.
\printindex
\printindex[aut]
\end{document}
```
`

En supposant que tout ceci soit dans un fichier `mondoc.tex`, 
après un nombre suffisant de compilations pour stabiliser les étiquettes, 
exécutez les commandes suivantes (ici, des commandes shell Unix 
mais le principe est le même quel que soit le système que vous utilisez) :

```bash
makeindex mondoc
makeindex mondoc.adx -o mondoc.and
```

Ensuite, recompilez le document avec LaTeX. Les commandes `makeindex` 
traitent `mondoc.idx` pour obtenir `mondoc.ind` (l'action par défaut) et 
`mondoc.adx` pour obtenir `mondoc.and`. Les fichiers `mondoc.idx` 
et `mondoc.and` seront appelés par les deux commandes `\printindex` 
dans `monfichier.tex`.


## Avec l'extension [splitidx](ctanpkg:splitindex)

L'extension [splitidx](ctanpkg:splitindex) peut fonctionner de la même manière 
que les autres : chargez-la avec l'option `split` et déclarez chaque index 
avec une commande `\newindex[⟨nom de l'index⟩]{⟨extension⟩}`.

Dans ce cas, [splitidx](ctanpkg:splitindex) générera un fichier 
qui portera le nom de votre fichier TEX avec l'`⟨extension⟩` pour recevoir 
les entrées d'index générées par des commandes telles que 
`\sindex[⟨raccourci⟩]{⟨élément⟩}`. Comme avec les autres extensions, 
cette méthode est limitée par le nombre total de fichiers de sortie de TeX.

Cependant, [splitidx](ctanpkg:splitindex) est également fourni 
avec un petit exécutable `splitindex` (disponible pour plusieurs systèmes 
d'exploitation). Si vous utilisez ce programme auxiliaire (et n'utilisez pas
`split`), il n'y a pas de limite au nombre d'index. En dehors de cette astuce, 
[splitidx](ctanpkg:splitindex) prend en charge les mêmes fonctionnalités 
que <ctanpkg:index>. Un exemple d'utilisation figure dans la documentation.


## Avec l'extension <ctanpkg:imakeidx>

L'extension <ctanpkg:imakeidx> dispose d'un large éventails de possibilités. 
Par exemple, elle peut exécuter un générateur d'index 
(avec la méthode détaillée à la question 
"[](/2_programmation/compilation/write18)") afin de simplifier la réalisation
d'un document.

Cette extension peut créer plusieurs index :

- de manière conventionnelle, comme le fait <ctanpkg:multind> ;
- ou de façon plus fine avec le script externe `splitindex` fourni 
  avec l'extension <ctanpkg:splitindex>.

Cette organisation permet un fonctionnement efficace avec un petit nombre 
d'index, tout en conservant la flexibilité d'autoriser un grand nombre d'index
sans toucher à la restriction du nombre de flux de sortie actifs.


## Avec la classe <ctanpkg:memoir>

La classe <ctanpkg:memoir> a sa propre fonctionnalité d'index multiples. 
Elle dispose aussi de ses propres options de disposition d'index, 
que d'autres extensions délèguent au fichier de style d'index utilisé 
par `makeindex`.


:::{todo} Ajouter des exemples
:::

:::{sources}
- [Multiple indexes](faquk:FAQ-multind)
:::