<?php

/*
 
 File: signup.php3
 $Author: mhardy $
 $Revision: 1.6 $
 $Date: 1999/04/14 19:15:58 $
 
 HORDE: Copyright 1999 Charles J. Hagenbuch <chuck@horde.org>
 
 You should have received a copy of the GNU Public
 License along with this package; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
*/

/* Send the browser back to the correct page */
function return_to_page() {
    global $this_client, $return_url;
    if (isset($return_url)) {
	if(! $this_client->lynx ) {
	    echo "<script language=\"JavaScript\">window.location=\"" . $return_url . "\"</script></body></html>";
	} else {
	    header("Location: " . $return_url);
	}
    } else {
	if(! $this_client->lynx ) {
	    echo "<script language=\"JavaScript\">window.location=\"login.php3\"</script></body></html>";
	} else {
	    header("Location: login.php3");
	}
    }
    exit;
}

$need_horde_db = 1;
$db_lib_loaded = 0;
require ('./lib/horde.lib');
require ('./config/defaults.php3');
require( './config/horde.php3' );

/* Html styles configuration */
require('./config/html.php3');
require('./config/mime.php3');
require('./config/lang.php3');

require ('./lib/mime.lib');

$language = select_lang();
require ("./locale/$language/signup.lang");
require ('./locale/local/signup.lang');
$help_file = 'signup.help';
require ("./locale/defines/$help_file");

$this_client = new WebClient;

error_reporting($default->error_level);
caching_headers();


/* array to translate string actions into the appropriate integer ID */
if ( ! $this_client->lynx ) {
    $actions[$lang->button_signup]          = SEND_MESSAGE;
    $actions[$lang->button_cancel_signup]        = NO_ACTION;
} else {
    $actions[ '[ ' . $lang->button_signup . ' ]']          = SEND_MESSAGE;
    $actions[ '[ ' . $lang->button_signup_cancel . ' ]']        = NO_ACTION;
}

require("$default->horde_include_dir/doctype.inc");

if (isset($actionID)) {
    /* translate non-int values into the correct int */
    if (strcspn($actionID, '0123456789')) { $actionID = $actions[$actionID]; }

    switch ($actionID) {

    case SEND_MESSAGE:

        if ($subject && $user1 && $user2 && $user3 && $pass1 && $pass2 && $email && $real_name ) { // need to check to make sure the other parts are there as well
            /* somehow need to verify email addresses */

            $mime = new mime_message;
            $mime->init($message);

            $text_part = new mime_part;
            $text_part->type = 'text';
            $text_part->subtype = 'plain';
            $text_part->contents = wrap_message("$message\n\nName: $real_name\nEmail: $email\n\nUsername: $user1, $user2, $user3\nPassword: $pass1, $pass2\n\n", 80, "\n");

            /* add footer to text_part */
            if ($default->append_trailer) {
                $config_trailer = "\n" . implode(@file('./config/trailer.txt'),
'');
                $config_trailer = set_env_in_string($config_trailer);
                $text_part->contents .= $config_trailer;
            }

            $mime->add_begin_part($text_part);

            $msg = $mime->generate();
	    
	    $from = 'imp-signup@localhost';
	    $barefrom = 'imp-signup@localhost';

            $hdrs  = "Errors-To: $barefrom\n";
            $hdrs .= "Reply-To: $from\n";
            $hdrs .= $mime->header();

            $hdrs .= 'X-Mailer: Horde/PHP3 ' . HORDE_LIB_VERSION;
            $hdrs .= "\n";


            $to = $default->signup_email;

            if (mailfrom($to, $from, $barefrom, $subject, $hdrs, $msg)) {

                /* we succeeded. print success message, load mailbox, and quit */
                status($lang->status_send_success);
		return_to_page();
            }
        } else {

            /* something wasn't quite right. strange */
            $ACTION_TEXT = $lang->imp_signup;
            status($lang->alert);
        }
        break;

    case NO_ACTION:
    default:
        return_to_page();
        break;

    }
} else { $ACTION_TEXT = $lang->signup; }
if (!isset($status_sent)) { status($lang->signup); }
$title = $lang->signup;
$sidebar = false;
require("$default->horde_include_dir/generic-header.inc");

$from = 'imp-signup@localhost';
$barefrom = 'imp-signup@localhost';
if (!isset($msg)) { $msg = ''; }
if (!isset($subject)) { $subject = ''; }


   require("$default->horde_include_dir/signup/signup.inc");
   require("$default->horde_include_dir/generic-footer.inc");
?>
