<?php

/*

 File: imp.php3

 Horde: Copyright 1999 Charles J. Hagenbuch  <chuck@horde.org>

 You should have received a copy of the GNU Public
 License along with this package; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.

 */

$horde_configured         = false;
$horde_configured         = file_exists( './config/defaults.php3' );
$horde_lib_configured     = file_exists( './lib/horde.lib');
$horde_configurable       = (is_readable( './setup.php3') &&
			     is_writeable( './config/defaults.php3'));


if ($horde_configured && $horde_lib_configured && ! $horde_configurable) {
    /* Bring in the horde library for the WebClient class */
    if (!defined("HORDE_LIB")) include ('./lib/horde.lib');
    
    /* Detect that browser */
    $this_client = new WebClient;
    
    if ($this_client->frames && ! $this_client->lynx) {
	
	/* Frames mode */
	    require( './templates/index/imp_frames.inc');
	
    } else if ( $this_client->lynx ) {
	include( './imp.php3' );
    } else {
	
	/* Ooo what browser is this? */
	include( './templates/index/unknown_browser.inc' );
	
    }
    
} else if ( $horde_configurable ) {
    /* IMP is web congigurable */
    include( './templates/index/horde_configurable.inc' );
    
} else if ( ! $horde_configured ) {
    
    /* IMP Isn't configured */
    include( './templates/index/horde_notconfigured.inc' );
    
} else if ( ! $horde_lib_configured ) {
    
    /* IMP's libraries are not present */
    include( './templates/index/horde_lib_notconfigured.inc' );
    
}

?>
