#!/bin/bash
#
#  File: horde-co.sh
#  $Author: mhardy $
#  $Revision: 1.2.2.2 $
#  $Date: 1999/05/25 04:33:42 $
#
#  This script performs a checkout from the horde CVS tree at horde.org
#
#  YOU WILL NEED TO EDIT THESE TO FIT YOUR ENVIRONMENT

# FIXME - would be nice if these were command line options
export CVSROOT="/home/mhardy/OSS-Intranet/RSYNC"          # The path to your CVSROOT
export HORDE_DIR="/home/mhardy/OSS-Intranet/horde"        # Where you want Horde rooted
export RSYNC="/usr/bin/rsync"                           # The path to your rsync binary
export CVSCOMMAND="/usr/bin/cvs"                        # The path to your cvs binary


export MODULE_LIST="imp nag gollem kronolith troll webshop hordeweb"
export COMMA_MODULES="imp,nag,gollem,kronolith,troll,webshop,hordeweb"


#  NOTHING ELSE SHOULD NEED TO BE EDITED BELOW THIS LINE

# FIXME Would be very nice if the arguments were checked, etc., etc
#  Test for all arguments present
MYNAME=`basename $0`
if [ $# -lt 3 ] ; then
    /bin/echo "Usage: $MYNAME --with-modules=[module[, module]\*] --type=[checkout|update] --label=[""|[label]]" 1>&2
    exit 2
fi


if (echo "$2" | grep -c "checkout" -) then
    export CVS_ARGS="-q checkout"
    export CVS_ACTION="Checking out"
else
    export CVS_ARGS="-q update"
    export CVS_ACTION="Updating"
fi

export LABEL=$3

export CWD=`pwd`
export RSYNC_ARGS="-az --delete"
export RSYNC_DIR="cvs.horde.org::horde-cvs/"

# Sync up our repository with the main repository

echo
echo "***************************"
echo "Rsyncing with $RSYNC_DIR..."
echo "***************************"
echo

$RSYNC $RSYNC_ARGS $RSYNC_DIR $CVSROOT

# Checkout the main Horde module
cd `dirname $HORDE_DIR`

echo
echo "*********************************"
echo "$CVS_ACTION main Horde module..."
echo "*********************************"
echo

$CVSCOMMAND $CVS_ARGS horde
cd $HORDE_DIR

# Check out each of the other modules specified
for MODULE in $MODULE_LIST; do
    if (echo "$1" | grep -c "$MODULE" - ) then

	echo 
	echo "*****************************"
      	echo "$CVS_ACTION $MODULE..."
	echo "*****************************";
	echo
	
	$CVSCOMMAND $CVS_ARGS $MODULE
    fi
done

# Put the user back where they came from
cd $CWD;
