<?php
/*
buildlib.php3
-----------------------------------------------------------------------
      Copyright 1999 Jason "ZeroDiVide" Orcutt
-----------------------------------------------------------------------
      Port of the buildlib.pl program to php3
*/
Function add_horde_module( $module_name, $comment, $config_file, $params = '' ) {
   global $HORDE_MODULE, $HORDE_MODULE_NEEDED;
   global $HORDE_MODULE_PARAMS, $HORDE_MODULE_COMMENT;
   $HORDE_MODULE[ $module_name ]            = $config_file;
   $HORDE_MODULE_NEEDED[ $module_name ]     = 0;
   $HORDE_MODULE_PARAMS[ $module_name ]     = $params;
   $HORDE_MODULE_COMMENT[ $module_name ]    = $comment;
}

Function add_locale_module( $module_name, $comment, $config_file, $params = '' ) {
   global $LOCAL_MODULES, $LOCAL_MODULES_NEEDED;
   global $LOCAL_MODULE_PARAMS, $LOCAL_MODULE_COMMENT;
   $LOCAL_MODULE[ $module_name ]            = $config_file;
   $LOCAL_MODULE_NEEDED[ $module_name ]     = 0;
   $LOCAL_MODULE_PARAMS[ $module_name ]     = $params;
   $LOCAL_MODULE_COMMENT[ $module_name ]    = $comment;
}

Function load_horde_module( $module_name ) {
   global $CORE_BASE, $INSTALLED_BASE_DIR ; 
   global $HORDE_MODULE, $HORDE_MODULE_NEEDED;
   global $HORDE_MODULE_PARAMS, $HORDE_MODULE_COMMENT;
   global $LOCAL_MODULES, $LOCAL_MODULES_NEEDED;
   global $LOCAL_MODULE_PARAMS, $LOCAL_MODULE_COMMENT;

   if ( $CORE_BASE ) {
   include( $CORE_BASE . '/config/' . $HORDE_MODULE[ $module_name ] );
   } else {
   include( './config/' . $HORDE_MODULE[ $module_name ] );
   }

}

Function load_locale_module( $module_name ) {
   global $CORE_BASE, $INSTALLED_BASE_DIR ; 
   global $HORDE_MODULE, $HORDE_MODULE_NEEDED;
   global $HORDE_MODULE_PARAMS, $HORDE_MODULE_COMMENT;
   global $LOCAL_MODULES, $LOCAL_MODULES_NEEDED;
   global $LOCAL_MODULE_PARAMS, $LOCAL_MODULE_COMMENT;

   
   if ( $CORE_BASE ) {
   include( $CORE_BASE . '/config/' . $LOCAL_MODULE[ $module_name ] );
   } else {
   include( './config/' . $LOCAL_MODULE[ $module_name ] );
   }

}

Function init_needs_file() {
   /* Clear out all needed file pointers */
   global $FILE_NEEDED, $FILE_COMMENTS;
   reset($FILE_NEEDED);
   reset($FILE_COMMENTS);
   while( list( $file, $comment ) = each( $FILE_COMMENTS ) ) {
      $FILE_NEEDED[ $file ] = 0;
   }
   $INIT_ORDER = Array();
}

Function need_file( $file_name, $comment ) {
   global $FILE_COMMENTS, $FILE_NEEDED;
   $FILE_COMMENTS[ $file_name ]        = $comment;
   $FILE_NEEDED[ $file_name ]          = 1;
}

Function a_set_default( $this_value, $def_value ) {
   if ( $this_value != '' ) {
      return $this_value;
   } else {
      return $def_value;
   }
}

Function build_lib( $file_name, $code_base_dir ) {

   $file_output    =     '';

   if ( !  ereg( '(.*)\.sql', $file_name, $regs ) ) {
   $file_output   .=    '<?php ' . "\n\n";
   }

   echo( "<br><br><b>Building : " . $file_name . "</b><br>\n" );
   
   echo( "\n<ul><b>Includes :</b>\n" );
   $file_output   .= build_ext_file( "inc", $code_base_dir );
   echo( "</ul>\n" );
  
   echo( "\n<ul><b>Defines :</b>\n" );
   $file_output   .= build_ext_file( "def", $code_base_dir );
   echo( "</ul>\n" );

   echo( "\n<ul><b>Objects :</b>\n" );
   $file_output   .= build_ext_file( "object", $code_base_dir );
   echo( "</ul>\n" );

   echo( "\n<ul><b>Functions :</b>\n" );
   $file_output   .= build_ext_file( "func", $code_base_dir );
   echo( "</ul>\n" );

   echo( "\n<ul><b>Init :</b>\n" );
   $file_output   .= build_ext_file( "init", $code_base_dir );
   echo( "</ul>\n" );

   echo( "\n<ul><b>Sql  :</b>\n" );
   $file_output   .= build_ext_file( "sql", $code_base_dir );
   echo( "</ul>\n" );

   if ( !  ereg( '(.*)\.sql', $file_name, $regs ) ) {
   $file_output   .=    "\n\n" . '?>';
   }

   if ( $fh = fopen( $file_name, 'w' ) ) {
      fwrite( $fh, $file_output, strlen( $file_output ) );
      fclose( $fh );
      echo( '<b>File written : ' . $file_name . '</b>' );
   } else {
      echo( '<B>FAILED TO WRITE FILE!!!!!</B>' );
   }

   return $file_output;

}

Function build_ext_file( $ext_to_process, $code_base_dir ) {
   global $FILE_COMMENTS, $FILE_NEEDED;
   global $inc, $def, $func, $obj, $init;

   $output = '';
   echo( '<ul>' );
   reset( $FILE_COMMENTS );
   while( list( $file_name, $comment ) = each( $FILE_COMMENTS ) ) {
      if ( ereg( '(.*)\.' . $ext_to_process, $file_name, $regs ) && $FILE_NEEDED[ $file_name ] == 1 ) {
         if ( ! ereg( '\/', $file_name, $regs )) {
            /* Prevent pathed ones from being processed */
            switch( $ext_to_process ) {
               case 'inc':
                  $base_dir = $code_base_dir . '/' . $inc; break;
               case 'def':
                  $base_dir = $code_base_dir . '/' . $def; break;
               case 'func':
                  $base_dir = $code_base_dir . '/' . $func; break;
               case 'object':
                  $base_dir = $code_base_dir . '/' . $obj; 
                  if ( ereg( 'Html(.*)\.' . $ext_to_process, $file_name, $regs ) ) {
                     $base_dir .= 'Html/';
                  }
               break;
               case 'init':
                 $base_dir = $code_base_dir . '/' . $init; break;

            }

         }

      /*
      echo( 'BASE DIR   : ' . $base_dir ); 
      echo( 'FILE MATCH : ' . $file_name );
      */
      $output .= add_file( $base_dir . $file_name, $FILE_COMMENTS[ $file_name ] );
      }
   }
   echo( '</ul>' );
   /* echo( '<br>' . $output ); */
   return $output;
}

Function add_file( $filename, $comment ) {
   echo( "<li>Adding file : $filename\n" );
   $output = '';
   if ( $comment != "" ) {
    $output .=
         '/*' . "\n" . 
         $comment . '      :  ' . $filename . "\n" . 
         '*/' . "\n";
   }
   $temp_arr = file( $filename );
   for( $i = 0; $i < count( $temp_arr ) ; $i++ ) {
      $output .= $temp_arr[ $i ] ;
   }
   if ( $comment != "" ) {
   $output .= '/* ' . 'EOF      :  ' . $filename . ' */' . "\n\n\n";
   }
   return $output;
}


/* Configuration and initialization */
$LIBS_BUILT               = Array();

$HORDE_MODULE             = Array();
$HORDE_MODULE_NEEDED      = Array();
$HORDE_MODULE_PARAMS      = Array();
$HORDE_MODULE_COMMENT     = Array();

$LOCAL_MODULE            = Array();
$LOCAL_MODULE_NEEDED     = Array();
$LOCAL_MODULE_PARAMS     = Array();
$LOCAL_MODULE_COMMENT    = Array();

$FILE_COMMENTS            = Array();
$FILE_NEEDED              = Array();
$INIT_ORDER               = Array();

$SCAN_MODS                = Array( 'core', 'imp', 'nag', 'local' );

$MODULE_LOCS              = Array();

$INSTALLED_BASE_DIR  = a_set_default( $INSTALLED_BASE_DIR, 
      '/home/zerodiv/projects/nag-pkg' );
$CORE_BASE           = a_set_default( $CORE_BASE,
      $INSTALLED_BASE_DIR . '/lib/src' );

$inc                 = 'includes/';
$def                 = 'defines/';
$func                = 'functions/';
$obj                 = 'objects/';
$init                = 'initialization/';

/* TESTING VAR 
$imp = 'needed';
*/

/* While testing nag use this code */
if ( is_dir( './nag' ) ) {
   $nag = 'needed';
   $db_driver = 'mysql';
}

if ( is_file( $INSTALLED_BASE_DIR . '/lib/src/config/buildopts.inc' ) ) {
   include( $INSTALLED_BASE_DIR . '/lib/src/config/buildopts.inc' );
}

/*
for( $i = 0 ; $i < count( $SCAN_MODS ) ; $i++ ) {
   if ( 
    is_file( $INSTALLED_BASE_DIR . $SCAN_MODS[ $i ] . '/lib/src/config.inc' ) ) {
   include( $INSTALLED_BASE_DIR . $SCAN_MODS[ $i ] . '/lib/src/config/buildopts.inc' );
   }
}
*/
/*
if ( $CORE_BASE ) {
   include( $CORE_BASE . '/config/buildopts.inc' );
} else {
   include( './config/buildopts.inc' );
}
*/

reset( $HORDE_MODULE );
while( list( $modules ) = each( $HORDE_MODULE ) ) {
   
   eval(
      'if ( $' . $modules  . ' != \'\' && $HORDE_MODULE_NEEDED[ \'' . $modules . '\' ] == 0 ) { ' .
         '  $HORDE_MODULE_NEEDED[ \'' . $modules. '\' ] = 1;' . "\n" .
      ' } ' 
      );
}

reset( $LOCAL_MODULE );
while( list( $modules ) = each( $LOCAL_MODULE ) ) {
   eval(
      'if ( $' . $modules  . ' != \'\' && $LOCAL_MODULE_NEEEDED[ \'' . $modules . '\' ] == 0 ) { ' .
         '  $LOCAL_MODULE_NEEDED[ \'' . $modules. '\' ] = 1;' . "\n" .
      ' } ' 
      );
}

echo( '<html><head><body>' . "\n" );
reset( $HORDE_MODULE );
while( list( $modules ) = each( $HORDE_MODULE ) ) {
   if ( $HORDE_MODULE_NEEDED[ $modules ] == 1 ) {
      /* We have a winer */
      $target_lib =
         $INSTALLED_BASE_DIR . '/' . $modules . '/lib/src/config/' .
         $HORDE_MODULE[ $modules ];
      if ( is_file( $target_lib ) ) {
            include( $target_lib );
      }
   }
}

reset( $LOCAL_MODULE );
while( list( $modules ) = each( $LOCAL_MODULE ) ) {
   if ( $LOCAL_MODULE_NEEDED[ $modules ] == 1 ) {
      /* We have a winer */
      include( $LOCAL_MODULE[ $modules ] );
   }
}

echo( '</body></html>' );


/* 
-- DEBUG CODE FOR VERIFING THE FILES / COMMENTS --
while( list( $file, $comment ) = each( $FILE_COMMENTS ) ) {
   echo( 'FILE : ' . $file . ' - ' . $comment . "<br>\n" );
}
*/


?>
