#!/usr/bin/perl
# buildlib.pl
#
local( %FILE_COMMENTS );
local( %FILE_NEEDED );
local( @INIT_ORDER );
local( $inc, $def, $func, $obj, $init );

$inc  = 'includes/';
$def  = 'defines/';
$func = 'functions/';
$obj  = 'objects/';
$init = 'initialization/';

$VALID_OPT = 0;

# Init all of the files as not-needed
init_needs_file();

local ( $NEED_NAG, $NEED_IMP, $NEED_TROLL );
$NEED_NAG          = 0;
$NEED_IMP          = 0;
$NEED_TROLL        = 0;

# Database configuration stuff

# Dummy driver is used if none other is specified
#$NEED_V1_DBDUMMY   = 1;
#$NEED_V2_DBDUMMY   = 1;

# Flags to turn on / off database options
$NEED_MYSQL        = 0;             # Mysql database
$NEED_INFORMIX     = 0;             # Informix database
$NEED_ORACLE       = 0;             # Oracle database
$NEED_POSTGRES     = 0;             # Postgres database

$NEED_V1_DB        = 0;             # Version 1 of the database
$NEED_V2_DB        = 0;             # Version 2 of the database

#
$TARGET_DIR        = '../';
$NEED_USAGE        = 0;
$NEED_SESSION      = 0;

for( $i = 0; $i <= $#ARGV; $i++ ) {
   # Modules 
   if ( valid_arg( $ARGV[ $i ],  '--imp',             \$NEED_IMP ) )          { next; }
   if ( valid_arg( $ARGV[ $i ],  '--nag',             \$NEED_NAG ) )          { next; }
   if ( valid_arg( $ARGV[ $i ],  '--troll',           \$NEED_TROLL ) )        { next; }

   # Database options
   if ( valid_arg( $ARGV[ $i ],  '--with-v1',         \$NEED_V1_DB ) )        { next; }
   if ( valid_arg( $ARGV[ $i ],  '--with-v2',         \$NEED_V2_DB ) )        { next; }
   if ( valid_arg( $ARGV[ $i ],  '--with-mysql',      \$NEED_MYSQL ) )        { next; }
   if ( valid_arg( $ARGV[ $i ],  '--with-informix',   \$NEED_INFORMIX ) )     { next; }
   if ( valid_arg( $ARGV[ $i ],  '--with-oracle',     \$NEED_ORACLE ) )       { next; }
   if ( valid_arg( $ARGV[ $i ],  '--with-postgres',   \$NEED_POSTGRES ) )     { next; }
   if ( valid_arg( $ARGV[ $i ],  '--with-session',    \$NEED_SESSION ) )      { next; }

   # Override option defaults
   if ( valid_arg( $ARGV[ $i ],  '--target-dir',      \$TARGET_DIR ) )        { next; }

   # Help options
   if ( valid_arg( $ARGV[ $i ],  '-help',             \$NEED_USAGE ) )        { next; }
   if ( valid_arg( $ARGV[ $i ],  '--help',            \$NEED_USAGE ) )        { next; }

   # UNKNOWN ARG :
   print "Please check your arguments : " . $ARGV[ $i ] . " is not a valid option.\n";
   print_usage();
   exit();

}

# Function      : valid_arg
# Purpose       : Validate an argument to the program.
# Args          :
#        ( value to check against )
#        ( text option for flag )
#        ( variable to set true / false based upon flag )
sub valid_arg {
   local $val        = shift;
   local $option     = shift;
   local $var        = shift;
   local $option_no;
   $option_no     = $option . '=no';
   $option_equal  = $option . '=(.*)';

   if ( $val =~ /$option_no/i ) {
      $$var = 0;
      $VALID_OPT = 1;
      return 1;
   }
   if ( $val =~ /$option_equal/i ) {
      $$var = $1;
      $VALID_OPT = 1;
      return 1;
   }
   if ( $val =~ /$option/i ) {
      $$var = 1;
      $VALID_OPT = 1;
      return 1;
   }
   return 0;
}

if ( $NEED_USAGE || ! $VALID_OPT ) {
   print_usage();
   exit();
}
### -- Build Process -- ###

# Build horde.lib
init_needs_file();
$horde_lib_name = $TARGET_DIR . "/horde.lib";

build_horde_lib();

build_lib();

init_needs_file();
$horde_lib_name = $TARGET_DIR . "/mime.lib";
build_mime_lib();
build_lib();


# Build the individual client modules

## -- NAG -- ##
if ( $NEED_NAG ) { build_nag_lib(); }

## -- IMP -- ##
if ( $NEED_IMP ) { build_imp_lib(); }

## -- TROLL -- ##
if ( $NEED_TROLL ) { build_troll_lib(); }

sub init_needs_file {
   foreach $file( keys %FILE_COMMENTS ) {
      $FILE_NEEDED{ $file } = 0;
   }
   @INIT_ORDER = ();
}

sub need_file {
   local( $file_name, $comment ) = @_;
   $FILE_COMMENTS{ $file_name } = $comment;
   $FILE_NEEDED{ $file_name } = 1;
}

#### - Different needs functions -> used in the lib functions to setup need this type relationships - ####
sub needs_horde_cookies {
   need_file(     'HordeCookies.object',              'HordeCookies Object' );
}

sub needs_horde_session {
   need_file(     'HordeSession.object',              'HordeSession Object' );
}

sub needs_horde_help {
   need_file( 'HordeHelp.object',                     'HordeHelp Object' );
}

sub needs_horde_copyright {
   need_file( 'HordeCopyright.inc',                 '' );
}

sub needs_horde_html {
   need_file( 'HtmlDocument.object',                  'HtmlDocument Object' );
   need_file( 'HtmlBold.object',                      'HtmlBold Object' );
   need_file( 'HtmlTable.object',                     'HtmlTable Object' );
   need_file( 'HtmlTableCell.object',                 'HtmlTableCell Object' );
   need_file( 'HtmlTableRow.object',                  'HtmlTableRow Object' );
   need_file( 'HtmlFont.object',                      'HtmlFont Object' );
}

sub needs_horde_objects {
   need_file( 'HordeAdminPrivlage.object',            'HordeAdminPrivlage Object' );
   need_file( 'HordeConfigForm.object',               'HordeConfigForm Object' );
   need_file( 'HordeGrant.object',                    'HordeGrant Object' );
   need_file( 'HordeDataGrant.object',                'HordeDataGrant Object' );
   need_file( 'HordeImapServer.object',               'HordeImapServer Object' );
   need_file( 'HordeUser.object',                     'HordeUser Object' );
   need_file( 'HordeGroup.object',                    'HordeGroup Object' );
   need_file( 'HordeLocaleLang.object',               'HordeLocaleLang Object' );
   need_file( 'HordeDefaults.object',                 'HordeDefaults Object');
   need_file( 'InitHelp.init',                        'Init Horde Help' );
   need_file( 'InitHordeDefaults.init',         'Init HordeDefaults object' );

}

sub needs_horde_misc {
    need_file( 'wrap_message.func',                 'Message wrapping function.' );
    need_file( 'textwrap.func',                     'textwrap function' );
    need_file( 'set_env_in_string.func',            'set env in a string');
    need_file( 'mailfrom.func',                     'interface to send mail');
    need_file( 'status.func',                       'status function' );
    need_file( 'include_lynx_menu.func',            'include_lynx_menu' );
    need_file( 'caching_headers.func',           'Cache Control Commands' );
}

sub needs_horde_language {

   need_file( 'select_lang.func',                  'select_lang function' );    
   need_file( 'mytrim.func',                       'mytrim function' );
   need_file( 'valid_lang.func',                   'valid_lang function' );
   need_file( 'wrap_message.func',            'Message wrapping function.' );
   need_file( 'textwrap.func',                'textwrap function' );

}

sub needs_horde_lib_version {
   need_file( 'HordeLibVersion.def',                  'HordeLibrary Version' );
}

sub needs_browser_match {
   need_file( 'WebClient.object',                     'WebClient Object' );
}

sub needs_horde_global_defs {
   need_file( 'GlobalDefines.def',                 '' );
}

sub needs_horde_db_defs {
   need_file( 'HordeDb.def',                       'Horde Database defines' );
}

sub needs_horde_actions_defs {
   need_file( 'HordeActions.def',                  'Horde - Form Action Defines' );
}

sub build_horde_lib {

   needs_horde_copyright();
   needs_horde_lib_version();
   needs_horde_html();
   needs_horde_objects();
   needs_horde_cookies();
   needs_horde_session();
   needs_horde_help();
   needs_browser_match();

   needs_horde_global_defs();
   needs_horde_db_defs();
   needs_horde_actions_defs();
    
   needs_horde_misc();
   needs_horde_language();

}

sub build_mime_lib {
   needs_horde_copyright();
   need_file( 'mime_part.object',                  'mime_part     - MimeLib: Copyright 1998 Patrick C. Audley paudley@blackcat.ca' );
   need_file( 'mime_message.object',               'mime_message  - MimeLib: Copyright 1998 Patrick C. Audley paudley@blackcat.ca' );
}


sub build_nag_lib {
}

sub build_troll_lib {
}

sub build_imp_lib {
}


##### --- #####
sub build_lib {

   print "Building : $horde_lib_name\n";
	open( HORDE_LIB, "> $horde_lib_name" )
   	|| die "ERROR : Could not open horde lib for writing.\nEXITING\nERROR : $!\n";

	print HORDE_LIB "<?php\n\n";
   print "\n\tIncludes :\n";
   build_ext_file( HORDE_LIB, "inc" );
   print "\n\tDefines :\n";
   build_ext_file( HORDE_LIB, "def" );
   print "\n\tObjects :\n";
   build_ext_file( HORDE_LIB, "object" );
   print "\n\tFunctions :\n";
   build_ext_file( HORDE_LIB, "func" );
   print "\n\tInit :\n";
   build_ext_file( HORDE_LIB, "init" );
   print "\n\tSql  :\n";
   build_ext_file( HORDE_LIB, "sql" );

   print "\n";
	print HORDE_LIB "?>\n";
	close( HORDE_LIB );
}

sub build_ext_file {
   local( *OUT_FH, $ext_to_process )  = @_;
   if ( $ext_to_process ne "init" ) {
	   foreach $file_key ( sort keys %FILE_COMMENTS ) {
   	   ( @temp_data ) = split( /\./, $file_key );
	      $file_ext = $temp_data[ ( @temp_data - 1) ];
  	 	   $base_dir = '';
         if ( $file_ext ne $ext_to_process ) {     next; }
         if ( $FILE_NEEDED{ $file_key } != 1 ) {   next; }
  		   if ( $file_ext eq "inc"    ) {   $base_dir = $inc;  }
   	   if ( $file_ext eq "def"    ) {   $base_dir = $def;  }
   	   if ( $file_ext eq "func"   ) {   $base_dir = $func; }
   	   if ( $file_ext eq "object" ) {   $base_dir = $obj;  }
         if ( $file_ext eq "init" )   {   $base_dir = $init; }
         if ( $file_ext eq "object" && $file_key =~ /Html/ ) { 
            $base_dir .= "Html/";
         }
         if ( $file_key =~ /\// ) { # It's already got a path in it 
            $base_dir = '';
         };
   	   add_file( OUT_FH, $base_dir . $file_key, $FILE_COMMENTS{ $file_key } );
	   }

   } else {
	   foreach $file_key ( sort keys %FILE_COMMENTS ) {
   	   ( @temp_data ) = split( /\./, $file_key );
	      $file_ext = $temp_data[ ( @temp_data - 1) ];
  	 	   $base_dir = '';
         if ( $file_ext ne $ext_to_process ) {     next; }
         if ( $FILE_NEEDED{ $file_key } != 1 ) {   next; }
         if ( $file_ext eq "init" )   {   $base_dir = $init; }
   	   add_file( OUT_FH, $base_dir . $file_key, $FILE_COMMENTS{ $file_key } );
      }

   }
}

sub add_file {
   local( *OUT_FH, $filename, $comment ) = @_;
   print "\tAdding file : $filename\n";

   if ( $comment ne "" ) {
   print OUT_FH <<"FILE_COMMENT";
/*
$comment      : $filename
*/
FILE_COMMENT
   }

   open( IN_FH, $filename ) || warn "WARNING : Unable to open : $filename\nERROR : $!\n";
   while( <IN_FH> ) { print OUT_FH $_; }
   close( IN_FH );   

   print OUT_FH <<"EOF";
/*      EOF - $filename       */



EOF

}

sub print_usage {
   print <<"USAGE"

buildlib.pl : Horde Library build program.

   This program builds a horde.lib and a client library for each
   module that is provided as a command line option to this program.
   So if you wanted to build a library that was inclusive for nag
   and imp you would run :
      ./buildlib.pl --imp --nag

   Another example would be :
      ./buildlib.pl --imp --with-mysql --nag

   Available modules :
      --imp
      --nag
      --troll
      

   Available option flags :
      Database flags -

         --with-v1[=no]

            Turns on/off the v1 database functions. Needed for
            compatibility with pre v2 imp versions.

         --with-v2[=no]

            Turns on/off the v2 database functions.

         --with-mysql[=no]
         --with-informix[=no]
         --with-oracle[=no]
         --with-postgres[=no]

            Turns on/off the support for that database.

         --with-session[=no]

            Turns on/off support for the databased session support.

      Output flags -         

         --target-dir=[ Output directory ]  

            Changes the output directory for the libraries.
      
      Help flags -

         -help
         --help


USAGE
}
